var self,svr;

var LiquorControl = require('../../liquorControl');
module.exports = class Az200 extends LiquorControl{
	constructor(cfg,parent){
		super(cfg,parent);
		self = this;
		this.port = require('../../../communication/serial');
		this.port._init(cfg, this);
		self.constants.keys = ['i','s','u','p'];
	}

	manage(){
		var restart = false;
		if(self.port.status == 'started'){
			svr.stop();
			restart = true;
		}
		super.manage(restart);
	}

	destroy(){
	
	}
	read(input){
		var out = {},
			raw	= '',
			key = null;
		for(let s=0,sL=input.length;s<sL;s++){
			if(self.constants.keys.indexOf(input[s]) != -1){
				if(raw.length){
					switch (key){
						case 'i':
							out.plu = raw;
						break;
						case 's':
							out.portion = raw;
						break;
					}
				}
				raw = '';
				key = self.constants.keys[self.constants.keys.indexOf(input[s])];
			}else
				raw+=input[s];
		}
		if(raw.length){
			switch (key){
				case 'i':
					out.plu = raw;
				break;
				case 's':
					out.portion = raw;
				break;
			}
		}
		super.read(out,self.port.write);
	}
};