var IP = require(__dirname + '/ip.js'),
	ping = require('ping'),
	queueProc = require(__dirname + '/queueproc.js')
queueProc._init({
	getParentStack: function () { return false; }, tryCatch: function (cbk) {
		try { cbk(); } catch (er) {
			process.send({ action: 'error', error: err });
		}
	}
});


//list all IPs from subnet, then ping all of them to force arp discovery
var start = function (cidr) {
	process.send({ action: 'starting', data: cidr });

	try {
		let _maxHosts = 5000;
		let _ipData = IP.cidrSubnet(cidr);
		let _ips = [_ipData.firstAddress], up = [], _curIp = '' + _ipData.firstAddress;
		let _success = 0, _fail = 0;
		var _start = new Date().getTime();
		//process.send({ action: 'startingInfo', data: _ipData });
		queueProc.init('autoPingNetwork', 5);
		let _doPing = function (i, n) {
			try {
				ping.sys.probe(i, function (isAlive, error) {
					if (isAlive && !error) {
						_success++;
						if (up.indexOf(i) == -1) up.push(i);
					} else {
						_fail++;
						if (up.indexOf(i) != -1) up.splice(up.indexOf(i), 1);
					}

					if (_ips.length == _maxHosts) return false;
					if (_success + _fail == _maxHosts) return false;
					if (_curIp != _ipData.lastAddress) {
						_shift();
					}
					if (_ips.length > 800) setTimeout(n, 500);
					else if (_ips.length > 500) setTimeout(n, 400);
					else if (_ips.length > 300) setTimeout(n, 300);
					else
						n();
				}, { timeout: 1 });
			} catch (er) {
				process.send({ action: 'error', ip: i, error: er.message });
				console.error(i, er.message);
				n();
			}
		};
		process.send({ action: 'started', data: _ipData });
		queueProc.add('autoPingNetwork', _ipData.firstAddress, _doPing);
		//console.log('START ' + _ipData.firstAddress)
		//console.log('END ' + _ipData.lastAddress)
		var _shift = function () {
			_curIpParts = _curIp.split('.');
			_curIpParts[3]++;
			if (_curIpParts[3] == 255) {
				_curIpParts[2]++;
				_curIpParts[3] = 1;
			}
			if (_curIpParts[2] == 255) {
				_curIpParts[2] = 1;
				_curIpParts[1]++;
			}
			_curIp = _curIpParts.join('.');

			_ips.push(_curIpParts);
			//console.log(_curIp, _ips.length)
			queueProc.add('autoPingNetwork', _curIp, _doPing);
			if (_ips.length == _maxHosts) return false;
		};
		for (let a = 0; a < 50; a++) {
			if (_curIp != _ipData.lastAddress) _shift();
		}
		//process.send({ action: 'log', data: 'Scanning for ' + _ips.length + ' ips' })
		queueProc.onQueueEmpty('autoPingNetwork', function () {
			var ttl = new Date().getTime() - _start;
			//console.log('All hosts pings done, ' + _success + ' success, ' + _fail + ' failed in ' + ttl + ' seconds')
			process.send({ action: 'completed', success: _success, failed: _fail, runtime: ttl, up: up });
			setTimeout(function () {
				process.exit(0);
			}, 500);
		})
	} catch (er) {
		//console.error(er)
		process.send({ action: 'error', error: err.message });
		setTimeout(function () {
			process.exit(1);
		}, 500);
	}
}
process.on('message', function (msg) {
	//process.send({ action: 'log', data: msg })
	switch (msg.action) {
		case 'start':
			start(msg.cidr);


			break;
	}
});
setTimeout(function () {
	process.send({ action: 'ready' })
}, 300);