var microtime;
try {
	microtime = require('microtime');
} catch (er) {
	microtime = {
		now: function () {
			return new Date().getTime() * 1000;
		}
	}
}
var crypto = require('crypto'),
	xtend = require(__dirname + '/cloneextend.js'),

	uuid = require('uuid'),
	jose = require('node-jose'),
	hydra = require('hydration'),
	C = {
		_alg: 'aes-256-cbc',
		hash: function (string, alg) {
			return crypto.createHash(alg || 'sha256').update(string).digest('hex');
		},
		helpers: {
			byteArraytoHex: function (byteArray) { //C.helpers.byteArraytoHex
				return Array.prototype.map.call(byteArray, function (byte) {
					return ('0' + (byte & 0xFF).toString(16)).slice(-2);
				}).join('');
			},
			hexToByteArray(hexString) { //C.helpers.hexToByteArray
				var result = [];
				for (var i = 0; i < hexString.length; i += 2) {
					result.push(parseInt(hexString.substr(i, 2), 16));
				}
				return result;
			}
		},
		jose: {
			createKey: function (type, size, props, cback) {
				if (typeof props == 'function' && !cback) {
					cback = props;
					props = {};
				}
				props = xtend.extend({
					alg: 'A256GCM',
					use: 'enc'
				}, props || {});
				jose.JWK.createKey(type || "oct", size || 256, props).
					then(function (result) {
						cback(result)
					});
			}
		},
		jwe: async function (jwk) {
			const key = await jose.JWK.asKey(jwk)
			async function encrypt(value) {
				const dehydratedData = hydra.dehydrate({ value })
				const cipher = await jose.JWE.createEncrypt({ format: 'compact' }, key).final(
					JSON.stringify(dehydratedData),
					'utf8'
				)
				return cipher
			}
			async function decrypt(cipher) {
				const { value } = await jose.JWE.createDecrypt(key.keystore)
					.decrypt(cipher)
					.then(res => res.payload.toString())
					.then(payload => hydra.hydrate(JSON.parse(payload)))
				return value
			}
			return {
				encrypt,
				decrypt
			}
		},
		decrypt: function (encrypted, pass) {
			var decipher = crypto.createDecipher(C._alg, pass);
			return decipher.update(encrypted) + decipher.final();
		},
		encrypt: function (text, pass) { // C.encrypt
			var cipher = crypto.createCipher(C._alg, pass);
			return Buffer.concat([cipher.update(Buffer.from(text)), cipher.final()]);
		},
		decryptIV: function (encrypted, pass, iv) {
			var decipher = crypto.createDecipheriv(C._alg, pass, Buffer.from(iv, 'base64'));
			return decipher.update(encrypted) + decipher.final();
		},
		encryptIV: function (text, pass, iv) { // C.encrypt
			var cipher = crypto.createCipheriv(C._alg, Buffer.from(pass), iv);
			return Buffer.concat([cipher.update(text), cipher.final()]);
		},
		AES_PK: {
			decrypt: function (data, privKey) { // C.AES_PK.decrypt
				if (typeof data != 'string' || data.indexOf('AES:') !== 0)
					return data;
				let d = JSON.parse(data.replace('AES:', ''));
				if (d.plainKey)
					console.log('Received Data', d);
				let _key = Buffer.from(d.key, 'base64');
				if (d.plainKey)
					console.log('Raw pass', _key.toString());
				let _k;
				//try {
				_k = crypto.privateDecrypt(privKey, _key).toString("utf8");
				//} catch (er) {
				//	if (er.message.indexOf('data too large') != -1)
				//		_k = crypto.privateDecrypt({
				//			key: privKey,
				//			padding: crypto.constants.RSA_NO_PADDING
				//		}, _key).toString("utf8");
				//	//	try {
				//	//		_k = crypto.privateDecrypt(privKey, _key.toString("utf8")).toString("utf8");
				//	//	} catch (er) {
				//	//		_k = crypto.privateDecrypt(privKey, Buffer.from(_key.toString(), 'base64')).toString("utf8");
				//	//	}
				//}
				let _rawPlainKey;
				if (d.plainKey) {
					_rawPlainKey = Buffer.from(d.plainKey, 'base64').toString('utf8')
					console.log('Decrypted pass', _k, 'vs', _rawPlainKey, _rawPlainKey == _k ? 'MATCH' : 'NO MATCH')
				}
				try {
					return d.iv ? C.decryptIV(Buffer.from(d.value, 'base64'), _k, d.iv) : C.decrypt(Buffer.from(d.value, 'base64'), _k);
				} catch (er) {
					let _keyIsBase64 = false;
					try {
						if (atob(_k)) {
							_keyIsBase64 = Buffer.from(_k, 'base64').toString('utf8')
							console.log('key looks like base64', _k, '=>', _keyIsBase64)
							//if (_keyIsBase64) _k = _keyIsBase64;
						}
					} catch (er) {

					}
					if (_keyIsBase64) {
						if (_rawPlainKey) console.log('base64 decoded Decrypted pass', _keyIsBase64, 'vs', _rawPlainKey, _rawPlainKey == _keyIsBase64 ? 'MATCH' : 'NO MATCH')
						return d.iv ? C.decryptIV(Buffer.from(d.value, 'base64'), _keyIsBase64, d.iv) : C.decrypt(Buffer.from(d.value, 'base64'), _k);
					}
					throw er;
				}
			},
			encrypt: function (data, pubKey, useIV) { // C.AES_PK.encrypt
				if (typeof useIV == 'undefined' || useIV == true) useIV = 16;
				try {
					let
						iv = crypto.randomBytes(useIV),
						pass_str = crypto.createHash('sha256').
							update(microtime.now() + '.' + uuid.v1()).
							digest('base64').substr(0, 32),
						pass_enc = crypto.publicEncrypt(pubKey, Buffer.from(pass_str)).toString("base64");
					let
						_d = typeof data == 'object' ? JSON.stringify(data) : data,
						_e = C.encryptIV(_d, pass_str, iv);
					return 'AES:' + JSON.stringify({
						"iv": iv ? iv.toString('base64') : null,
						//"plainKey": pass_str, //for private key debug purposes only!!
						"key": pass_enc,
						"value": _e.toString("base64")
					});
				}
				catch (er) {
					if (er.message.indexOf('Invalid IV length') != -1) {
						if (useIV != 0) {
							if (useIV == 32) useIV = 0;
							if (useIV == 8) useIV = 32;
							if (useIV == 16) useIV = 8;
							return C.AES_PK.encrypt(data, pubKey, useIV);
						}
					}
					console.error(er.message, er)
					return null;
				}
			}
		}
	};
module.exports = C;