/*
 * Determine whether a given string is a valid UnicodePropertyValueExpression.
 */

"use strict";

module.exports = function validate(sequence) {
  var equalSignIndex = sequence.indexOf("=");

  if (equalSignIndex === -1) {
    return sequence in names.binary || sequence in values.general;
  }

  var name = sequence.substr(0, equalSignIndex);
  var value = sequence.substr(equalSignIndex + 1);

  if (name === "General_Category" || name === "gc") {
    return value in values.general;
  } if (name === "Script" || name === "sc" || name === "Script_Extensions" || name === "scx") {
    return value in values.script;
  }

  return false;
};


var names = {
  nonBinary: Object.create(null),
  binary: Object.create(null)
};
var values = {
  general: Object.create(null),
  script: Object.create(null)
};

var nb = names.nonBinary;
nb.General_Category = true;
nb.gc = true;
nb.Script = true;
nb.sc = true;
nb.Script_Extensions = true;
nb.scx = true;

var b = names.binary;
b.ASCII = true;
b.ASCII_Hex_Digit = true;
b.AHex = true;
b.Alphabetic = true;
b.Alpha = true;
b.Any = true;
b.Assigned = true;
b.Bidi_Control = true;
b.Bidi_C = true;
b.Bidi_Mirrored = true;
b.Bidi_M = true;
b.Case_Ignorable = true;
b.CI = true;
b.Cased = true;
b.Changes_When_Casefolded = true;
b.CWCF = true;
b.Changes_When_Casemapped = true;
b.CWCM = true;
b.Changes_When_Lowercased = true;
b.CWL = true;
b.Changes_When_NFKC_Casefolded = true;
b.CWKCF = true;
b.Changes_When_Titlecased = true;
b.CWT = true;
b.Changes_When_Uppercased = true;
b.CWU = true;
b.Dash = true;
b.Default_Ignorable_Code_Point = true;
b.DI = true;
b.Deprecated = true;
b.Dep = true;
b.Diacritic = true;
b.Dia = true;
b.Emoji = true;
b.Emoji_Component = true;
b.EComp = true;
b.Emoji_Modifier = true;
b.EMod = true;
b.Emoji_Modifier_Base = true;
b.EBase = true;
b.Emoji_Presentation = true;
b.EPres = true;
b.Extended_Pictographic = true;
b.ExtPict = true;
b.Extender = true;
b.Ext = true;
b.Grapheme_Base = true;
b.Gr_Base = true;
b.Grapheme_Extend = true;
b.Gr_Ext = true;
b.Hex_Digit = true;
b.Hex = true;
b.IDS_Binary_Operator = true;
b.IDSB = true;
b.IDS_Trinary_Operator = true;
b.IDST = true;
b.ID_Continue = true;
b.IDC = true;
b.ID_Start = true;
b.IDS = true;
b.Ideographic = true;
b.Ideo = true;
b.Join_Control = true;
b.Join_C = true;
b.Logical_Order_Exception = true;
b.LOE = true;
b.Lowercase = true;
b.Lower = true;
b.Math = true;
b.Noncharacter_Code_Point = true;
b.NChar = true;
b.Pattern_Syntax = true;
b.Pat_Syn = true;
b.Pattern_White_Space = true;
b.Pat_WS = true;
b.Quotation_Mark = true;
b.QMark = true;
b.Radical = true;
b.Regional_Indicator = true;
b.RI = true;
b.Sentence_Terminal = true;
b.STerm = true;
b.Soft_Dotted = true;
b.SD = true;
b.Terminal_Punctuation = true;
b.Term = true;
b.Unified_Ideograph = true;
b.UIdeo = true;
b.Uppercase = true;
b.Upper = true;
b.Variation_Selector = true;
b.VS = true;
b.White_Space = true;
b.space = true;
b.XID_Continue = true;
b.XIDC = true;
b.XID_Start = true;
b.XIDS = true;

var g = values.general;
g.Cased_Letter = true;
g.LC = true;
g.Close_Punctuation = true;
g.Pe = true;
g.Connector_Punctuation = true;
g.Pc = true;
g.Control = true;
g.Cc = true;
g.cntrl = true;
g.Currency_Symbol = true;
g.Sc = true;
g.Dash_Punctuation = true;
g.Pd = true;
g.Decimal_Number = true;
g.Nd = true;
g.digit = true;
g.Enclosing_Mark = true;
g.Me = true;
g.Final_Punctuation = true;
g.Pf = true;
g.Format = true;
g.Cf = true;
g.Initial_Punctuation = true;
g.Pi = true;
g.Letter = true;
g.L = true;
g.Letter_Number = true;
g.Nl = true;
g.Line_Separator = true;
g.Zl = true;
g.Lowercase_Letter = true;
g.Ll = true;
g.Mark = true;
g.M = true;
g.Combining_Mark = true;
g.Math_Symbol = true;
g.Sm = true;
g.Modifier_Letter = true;
g.Lm = true;
g.Modifier_Symbol = true;
g.Sk = true;
g.Nonspacing_Mark = true;
g.Mn = true;
g.Number = true;
g.N = true;
g.Open_Punctuation = true;
g.Ps = true;
g.Other = true;
g.C = true;
g.Other_Letter = true;
g.Lo = true;
g.Other_Number = true;
g.No = true;
g.Other_Punctuation = true;
g.Po = true;
g.Other_Symbol = true;
g.So = true;
g.Paragraph_Separator = true;
g.Zp = true;
g.Private_Use = true;
g.Co = true;
g.Punctuation = true;
g.P = true;
g.punct = true;
g.Separator = true;
g.Z = true;
g.Space_Separator = true;
g.Zs = true;
g.Spacing_Mark = true;
g.Mc = true;
g.Surrogate = true;
g.Cs = true;
g.Symbol = true;
g.S = true;
g.Titlecase_Letter = true;
g.Lt = true;
g.Unassigned = true;
g.Cn = true;
g.Uppercase_Letter = true;
g.Lu = true;

var s = values.script;
s.Adlam = true;
s.Adlm = true;
s.Ahom = true;
s.Anatolian_Hieroglyphs = true;
s.Hluw = true;
s.Arabic = true;
s.Arab = true;
s.Armenian = true;
s.Armn = true;
s.Avestan = true;
s.Avst = true;
s.Balinese = true;
s.Bali = true;
s.Bamum = true;
s.Bamu = true;
s.Bassa_Vah = true;
s.Bass = true;
s.Batak = true;
s.Batk = true;
s.Bengali = true;
s.Beng = true;
s.Bhaiksuki = true;
s.Bhks = true;
s.Bopomofo = true;
s.Bopo = true;
s.Brahmi = true;
s.Brah = true;
s.Braille = true;
s.Brai = true;
s.Buginese = true;
s.Bugi = true;
s.Buhid = true;
s.Buhd = true;
s.Canadian_Aboriginal = true;
s.Cans = true;
s.Carian = true;
s.Cari = true;
s.Caucasian_Albanian = true;
s.Aghb = true;
s.Chakma = true;
s.Cakm = true;
s.Cham = true;
s.Chorasmian = true;
s.Chrs = true;
s.Cherokee = true;
s.Cher = true;
s.Common = true;
s.Zyyy = true;
s.Coptic = true;
s.Copt = true;
s.Qaac = true;
s.Cuneiform = true;
s.Xsux = true;
s.Cypriot = true;
s.Cprt = true;
s.Cyrillic = true;
s.Cyrl = true;
s.Deseret = true;
s.Dsrt = true;
s.Devanagari = true;
s.Deva = true;
s.Dives_Akuru = true;
s.Diak = true;
s.Dogra = true;
s.Dogr = true;
s.Duployan = true;
s.Dupl = true;
s.Egyptian_Hieroglyphs = true;
s.Egyp = true;
s.Elbasan = true;
s.Elba = true;
s.Elymaic = true;
s.Elym = true;
s.Ethiopic = true;
s.Ethi = true;
s.Georgian = true;
s.Geor = true;
s.Glagolitic = true;
s.Glag = true;
s.Gothic = true;
s.Goth = true;
s.Grantha = true;
s.Gran = true;
s.Greek = true;
s.Grek = true;
s.Gujarati = true;
s.Gujr = true;
s.Gunjala_Gondi = true;
s.Gong = true;
s.Gurmukhi = true;
s.Guru = true;
s.Han = true;
s.Hani = true;
s.Hangul = true;
s.Hang = true;
s.Hanifi_Rohingya = true;
s.Rohg = true;
s.Hanunoo = true;
s.Hano = true;
s.Hatran = true;
s.Hatr = true;
s.Hebrew = true;
s.Hebr = true;
s.Hiragana = true;
s.Hira = true;
s.Imperial_Aramaic = true;
s.Armi = true;
s.Inherited = true;
s.Zinh = true;
s.Qaai = true;
s.Inscriptional_Pahlavi = true;
s.Phli = true;
s.Inscriptional_Parthian = true;
s.Prti = true;
s.Javanese = true;
s.Java = true;
s.Kaithi = true;
s.Kthi = true;
s.Kannada = true;
s.Knda = true;
s.Katakana = true;
s.Kana = true;
s.Kayah_Li = true;
s.Kali = true;
s.Kharoshthi = true;
s.Khar = true;
s.Khitan_Small_Script = true;
s.Kits = true;
s.Khmer = true;
s.Khmr = true;
s.Khojki = true;
s.Khoj = true;
s.Khudawadi = true;
s.Sind = true;
s.Lao = true;
s.Laoo = true;
s.Latin = true;
s.Latn = true;
s.Lepcha = true;
s.Lepc = true;
s.Limbu = true;
s.Limb = true;
s.Linear_A = true;
s.Lina = true;
s.Linear_B = true;
s.Linb = true;
s.Lisu = true;
s.Lycian = true;
s.Lyci = true;
s.Lydian = true;
s.Lydi = true;
s.Mahajani = true;
s.Mahj = true;
s.Makasar = true;
s.Maka = true;
s.Malayalam = true;
s.Mlym = true;
s.Mandaic = true;
s.Mand = true;
s.Manichaean = true;
s.Mani = true;
s.Marchen = true;
s.Marc = true;
s.Medefaidrin = true;
s.Medf = true;
s.Masaram_Gondi = true;
s.Gonm = true;
s.Meetei_Mayek = true;
s.Mtei = true;
s.Mende_Kikakui = true;
s.Mend = true;
s.Meroitic_Cursive = true;
s.Merc = true;
s.Meroitic_Hieroglyphs = true;
s.Mero = true;
s.Miao = true;
s.Plrd = true;
s.Modi = true;
s.Mongolian = true;
s.Mong = true;
s.Mro = true;
s.Mroo = true;
s.Multani = true;
s.Mult = true;
s.Myanmar = true;
s.Mymr = true;
s.Nabataean = true;
s.Nbat = true;
s.Nandinagari = true;
s.Nand = true;
s.New_Tai_Lue = true;
s.Talu = true;
s.Newa = true;
s.Nko = true;
s.Nkoo = true;
s.Nushu = true;
s.Nshu = true;
s.Nyiakeng_Puachue_Hmong = true;
s.Hmnp = true;
s.Ogham = true;
s.Ogam = true;
s.Ol_Chiki = true;
s.Olck = true;
s.Old_Hungarian = true;
s.Hung = true;
s.Old_Italic = true;
s.Ital = true;
s.Old_North_Arabian = true;
s.Narb = true;
s.Old_Permic = true;
s.Perm = true;
s.Old_Persian = true;
s.Xpeo = true;
s.Old_Sogdian = true;
s.Sogo = true;
s.Old_South_Arabian = true;
s.Sarb = true;
s.Old_Turkic = true;
s.Orkh = true;
s.Oriya = true;
s.Orya = true;
s.Osage = true;
s.Osge = true;
s.Osmanya = true;
s.Osma = true;
s.Pahawh_Hmong = true;
s.Hmng = true;
s.Palmyrene = true;
s.Palm = true;
s.Pau_Cin_Hau = true;
s.Pauc = true;
s.Phags_Pa = true;
s.Phag = true;
s.Phoenician = true;
s.Phnx = true;
s.Psalter_Pahlavi = true;
s.Phlp = true;
s.Rejang = true;
s.Rjng = true;
s.Runic = true;
s.Runr = true;
s.Samaritan = true;
s.Samr = true;
s.Saurashtra = true;
s.Saur = true;
s.Sharada = true;
s.Shrd = true;
s.Shavian = true;
s.Shaw = true;
s.Siddham = true;
s.Sidd = true;
s.SignWriting = true;
s.Sgnw = true;
s.Sinhala = true;
s.Sinh = true;
s.Sogdian = true;
s.Sogd = true;
s.Sora_Sompeng = true;
s.Sora = true;
s.Soyombo = true;
s.Soyo = true;
s.Sundanese = true;
s.Sund = true;
s.Syloti_Nagri = true;
s.Sylo = true;
s.Syriac = true;
s.Syrc = true;
s.Tagalog = true;
s.Tglg = true;
s.Tagbanwa = true;
s.Tagb = true;
s.Tai_Le = true;
s.Tale = true;
s.Tai_Tham = true;
s.Lana = true;
s.Tai_Viet = true;
s.Tavt = true;
s.Takri = true;
s.Takr = true;
s.Tamil = true;
s.Taml = true;
s.Tangut = true;
s.Tang = true;
s.Telugu = true;
s.Telu = true;
s.Thaana = true;
s.Thaa = true;
s.Thai = true;
s.Tibetan = true;
s.Tibt = true;
s.Tifinagh = true;
s.Tfng = true;
s.Tirhuta = true;
s.Tirh = true;
s.Ugaritic = true;
s.Ugar = true;
s.Vai = true;
s.Vaii = true;
s.Wancho = true;
s.Wcho = true;
s.Warang_Citi = true;
s.Wara = true;
s.Yezidi = true;
s.Yezi = true;
s.Yi = true;
s.Yiii = true;
s.Zanabazar_Square = true;
s.Zanb = true;
