var self, ip = {
	cfg: {},
	eft: null,
	socket: null,
	connected: false,
	_init: function (vars, parent) {
		self = this;
		const net = require('net');
		self.eft = parent;
		ip.socket = new net.Socket();
		ip.cfg = vars;
		ip.socket.on('data', ip.receive);
		ip.socket.on('end', ip.disconnect);
		ip.socket.on('close', ip.disconnect);
		ip.socket.on('timeout', () => {
			if (typeof self.eft.cback == 'function') {
				self.eft.cback({
					status: 'error',
					code: 'TIMEOUT'
				});
			}
			ip.disconnect();
		});
		ip.socket.on('error', (err) => {
			var oCode = err.code;
			switch (oCode) {
				case 'EALREADY':
				case 'EHOSTUNREACH':
					code = 'UNREACH';
					break;
				case 'ECONNREFUSED':
					code = 'REFUSED';
					break;
				case 'ECONNRESET':
				case 'ERR_STREAM_WRITE_AFTER_END':
					ip.disconnect();
					ip._init(vars, parent);
					return;
					code = 'UNKNOWN';
					break;
				case 'EPIPE':
				case 'ENOTCONN':
					ip.disconnect();
					code = 'UNKNOWN';
					break;
				default:
					code = 'UNKNOWN';
					console.warn('IP Socket to ' + ip.cfg.ip + ':' + ip.cfg.port + ' Unhandled error', oCode, err.code);
					break;
			}
			if (typeof self.eft.cback == 'function') {
				self.eft.cback({
					status: 'error',
					code: code
				});
			}
			setTimeout(function () { self.eft._busy = false; }, 1000);
			ip.disconnect();
		});
		ip.socket.setEncoding('latin1');
	},
	disconnect: function () {
		ip.connected = false;
		self.eft._busy = false;
		try { ip.socket.end() } catch (e) { }
		try { ip.socket.destroy() } catch (e) { }
	},
	setTimeout: (ttl) => {
		try {
			if (ip.connected)
				ip.socket.setTimeout(ttl);
		} catch (e) { console.error(e); }
	},
	receive: function (data) {
		if (ip.eft.cfg.prependLength)
			data = data.substr(2);
		ip.eft.receive(data);
	},
	send: function (message) {
		try {
			if (ip.eft.cfg.prependLength)
				message = (String.fromCharCode(message.length >> 8)) + (message.length > 255 ? '\xff' : String.fromCharCode(message.length % 256)) + message;
			if (!ip.connected)
				ip.socket.connect(ip.cfg.port, ip.cfg.ip, function () {
					ip.connected = true;
					ip.socket.write(message);
				});
			else {
				ip.socket.write(message);
			}
		} catch (e) { console.error(e); }
	}
};
module.exports = ip;