const net = require('net');
var self,svr;
class Server{
	constructor(cfg,parent){
		svr = this;
		svr._port = cfg.port;
		svr.status = 'closed';
		svr.parent = parent;
		svr.socket = null;
		svr.server = net.createServer((socket)=>{
			svr.socket = socket;
			socket.on('data',svr.read);
		});
		svr.server.maxConnections = 1;
	}
	start(){
		svr.server.listen(svr._port,() => {
			svr.status = 'started';
			console.log('LC, server Listening ',svr.server.address());
		});
	}

	stop(cback){
		console.log('LC, server closing, stopped listening');
		svr.status = 'closing';
		svr.server.close(()=>{
			svr.status = 'closed';
			console.log('LC, server all connection closed');
			if(typeof cback == 'function')
				cback();
		});
	}
	
	read(data){
		var socket = this;
		var stx,etx;
		if((stx = data.indexOf(self.constants.stx)) == -1 || (etx = data.indexOf(self.constants.etx)) == -1){
			socket.write(self.constants.nak);
			return;
		}
		var message = data.toString().substring(stx,etx+1);
		if(self.calculateLRC(message.substr(0,message.length-2)) != message[message.length-2]){
			socket.write(self.constants.nak);
			return;
		}
		super.read({
			plu		: message.substring(2,message.length-2),
			portion	: message.substr(1,1)
		},socket.write);
	}
}
var LiquorControl = require('../../liquorControl');
module.exports = class ControlPlus extends LiquorControl{
	constructor(cfg,parent){
		super(cfg,parent);
		self = this;

		self.server = new Server(cfg,self);
			svr.start();
	}

	manage(){
		var restart = false;
		if(svr.status == 'started'){
			svr.stop();
			restart = true;
		}
		super.manage(restart);
	}


	destroy(){
		if(svr.status == 'started'){
			svr.stop();
		}
	}
};