var self, app;
module.exports = class Dialog {
	constructor(parent) {
		self = this;
		if (parent) {
			this.eft = parent;
			this.pos = parent.pos;
			this.app = parent.pos.app;
			this.log = '';
			this.testing = false;
			app = this.app;
		}
	}

	initialize() {
		if (self.win) {
			app.pos.setToTop(false);
			self.win.setAlwaysOnTop(true);
			self.win.focus();

			return;
		}

		nw.Window.open(app._relativePath + 'libs/eftPayment/dialog/dialog.html', {
			width: 624,
			height: 525,
			title: self.app.parseLocales('eft_manager.title'),
			resizable: false
		}, function (win) {
			self.win = win;
			win.on('loaded', function () {

				app.pos.setToTop(false);
				win.setAlwaysOnTop(true);
				win.focus();
				if (self.app.cfg.env == 'prod')
					self.win.setAlwaysOnTop(true);
				// Set the locales
				let elems = win.window.document.getElementsByClassName('localized');
				for (let e = 0; e < elems.length; e++) {
					elems[e].innerHTML = self.app.parseLocales(elems[e].dataset.locale);
				}
				// Set event listners
				win.window.document.getElementById('eft_provider').onchange = function () {
					var model = win.window.document.getElementById('eft_model');
					model.innerHTML = '';
					let _v = win.window.document.getElementById('eft_provider').value;
					switch (_v) {
						case 'CHASE':
						case 'GLOBAL':
							model.innerHTML = '<option value="DESK5000">Desk/5000, Move/5000</option>';
							model.innerHTML += '<option value="VERIFONE">Verifone</option>';
							break;
						case 'MONERIS':

							break;
						case 'DESJARDINS':
							model.innerHTML = '<option value="iPP320">iPP320</option>';
							break;
					}
					if (self.eft.cfg.comm?.provider == _v && self.eft.cfg.comm?.model && self.eft.cfg.comm.model != 'NONE') {
						model.value = self.eft.cfg.comm.model;
						model.dispatchEvent(new Event('change'));
					}

				};
				win.window.document.getElementById('eft_mode').onchange = function () {
					var elems = win.window.document.getElementsByClassName('protocol-group');
					for (let e = 0; e < elems.length; e++)
						elems[e].style.display = 'none';
					win.window.document.getElementById(win.window.document.getElementById('eft_mode').value + '-group').style.removeProperty('display');
				};
				win.window.document.getElementById('eft_mode').dispatchEvent(new Event('change'));

				// Set the values
				var keys = Object.keys(self.eft.cfg.comm);
				for (let k of keys)
					try {
						win.window.document.getElementById('eft_' + k).value = self.eft.cfg.comm[k];
						win.window.document.getElementById('eft_' + k).dispatchEvent(new Event('change'));
					} catch (e) { }
				self.win.window.onTest = function () { self.validate(function () { self.test(); }); };
				self.win.window.onPair = function () { self.pair(); };
				self.win.window.onClose = function () {
					try { self.win.hide(); } catch (er) { }
					try { self.win.close(); } catch (er) { }
					try { self.win = null; } catch (er) { }
					app.pos.setToTop(true);
				};
				//self.win.window.isReady();
			}).on('closed', function () {

				app.pos.setToTop(true);
				try { self.win.hide(); } catch (er) { }
				try { self.win = null; } catch (er) { }
				self.eft.dialog = null;
			});
		});
	}
	pair() {

		var provider = self.win.window.document.getElementById('eft_provider').value;

		if (provider == 'NONE') {
			self.app.sessions.updateCfg({
				eft_device: {
					provider: 'NONE',
					model: '',
					mode: '',
					ip: '',
					port: '',
					comm: ''
				}
			}, function (data) {
				if (data.result == 'success') {
					self.log += self.app.parseLocales('eft_manager.statusses.config_saved') + '.';
					self.pos.initializeEFT();
				} else
					self.log += self.app.parseLocales('eft_manager.statusses.config_not_saved') + '.';
				self.win.window.document.getElementById('eft_logs').innerHTML = self.log;
				self.log = '';
			});
			return;
		}
		self.validate(function () {
			self.test(function (socket) {
				function save() {
					var eft = {
						provider: self.win.window.document.getElementById('eft_provider').value,
						model: self.win.window.document.getElementById('eft_model').value,
						mode: self.win.window.document.getElementById('eft_mode').value,
					};
					if (eft.mode == 'ip') {
						eft.ip = self.win.window.document.getElementById('eft_ip').value;
						eft.port = self.win.window.document.getElementById('eft_port').value;
						eft.com = '';
					} else {
						eft.ip = '';
						eft.port = '';
						eft.com = self.win.window.document.getElementById('eft_com').value;
					}
					self.eft.findDeviceByIP(eft.ip, function (mac) {
						if (mac) eft.macAddress = mac;
						self.app.sessions.updateCfg({
							eft_device: eft
						}, function (data) {
							if (data.result == 'success') {
								self.log += self.app.parseLocales('eft_manager.statusses.config_saved') + '.';
								self.pos.initializeEFT();
							} else
								self.log += self.app.parseLocales('eft_manager.statusses.config_not_saved') + '.';
							self.win.window.document.getElementById('eft_logs').innerHTML = self.log;
							self.log = '';
							self.testing = false;
						});
					});
				}
				switch (provider) {
					case 'CHASE':
					case 'GLOBAL':
						//JUST SAVE NOTHING TO DO
						save();
						break;
					case 'MONERIS':
						break;
					case 'DESJARDINS':
						//PAIR BEFORE SAVING (NO CONFIRMATION)
						self.eft.startOperation({ transType: 'Ping' }, function () { });
						save();
						break;
				}
				//try { socket.end(); } catch (er) { }
			});
		});
	}

	validate(success, error) {

		if (self.testing)
			return;
		self.testing = true;
		var port_field = self.win.window.document.getElementById('eft_port_field'),
			ip_field = self.win.window.document.getElementById('eft_ip_field'),
			valid = true;
		const PORT = 1 * self.win.window.document.getElementById('eft_port').value,
			IP = self.win.window.document.getElementById('eft_ip').value;

		if (!PORT || PORT < 0 || PORT > 65536) {
			port_field.classList.add('has-error');
			port_field.classList.remove('has-success');
			valid = false;
		} else {
			port_field.classList.remove('has-error');
			port_field.classList.add('has-success');
		}

		if (/^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/.test(IP)) {
			ip_field.classList.remove('has-error');
			ip_field.classList.add('has-success');
		} else {
			ip_field.classList.add('has-error');
			ip_field.classList.remove('has-success');
			valid = false;
		}
		var cback;
		if (valid) {
			self.log += self.app.parseLocales('eft_manager.statusses.valid_config');
			if (typeof success == 'function') {
				self.log += '...\n';
				cback = success;
			}
		} else {
			self.log += self.app.parseLocales('eft_manager.statusses.invalid_config');
			if (typeof error == 'function') {
				self.log += '...\n';
				cback = error;
			}
		}
		self.win.window.document.getElementById('eft_logs').innerHTML = self.log;
		if (typeof cback == 'function')
			cback();
		else {
			self.log = '';
			self.testing = false;
		}
	}

	test(success, error) {
		const net = require('net'),
			PORT = self.win.window.document.getElementById('eft_port').value,
			IP = self.win.window.document.getElementById('eft_ip').value;
		app.system.net.ping(IP, function (pingRes) {
			if (!pingRes || pingRes.result != 'success') {
				self.log += self.app.parseLocales('eft_manager.statusses.unreachable') + ' (' + pingRes.code + ')' + '.';
				self.win.window.document.getElementById('eft_logs').innerHTML = self.log;
				self.log = '';
				if (error) error();
				return;
			}
			var socket = new net.Socket();
			socket.on('error', function (err) {
				if (typeof err.errno == 'number' && err.code)
					err.errno = '' + err.code;
				if (err.errno == 'ECONNREFUSED')
					self.log += self.app.parseLocales('eft_manager.statusses.connection_refused') + '.';
				else
					self.log += self.app.parseLocales('eft_manager.statusses.unknown_error') + ' (' + err.errno + ')' + '.';

				self.win.window.document.getElementById('eft_logs').innerHTML = self.log;
				self.log = '';
				if (typeof error == 'function')
					error();
				else
					self.testing = false;
				try { socket.destroy(); } catch (er) { }
			});
			socket.on('connect', () => {
				self.log += self.app.parseLocales('eft_manager.statusses.connection_established');
				if (typeof success == 'function') {
					self.log += '...\n';
					self.win.window.document.getElementById('eft_logs').innerHTML = self.log;
					success(socket);
				} else {
					self.log += '.';
					self.win.window.document.getElementById('eft_logs').innerHTML = self.log;
					self.log = '';
					self.testing = false;
				}
				socket.end();
			});
			socket.connect(PORT, IP);
		});
	}
};