var self, EftPayments = require('../eftPayment');

module.exports = class GlobalJson extends EftPayments {
	constructor(cfg, parent) {
		super(cfg, parent);
		self = this;
		self.reqId = 0;
		self.response = '';
		self.constants = Object.assign(self.constants, {
			'TransStatus': {
				'Success': 'Approved',
			},
			'CustCardEntry': {
				'SWIPE': 'S', //Magnetic Stripe
				'INSERT': 'C', //Insert (Chip)
				'TAP': 'P', //Tap(Contactless)
				'MANUAL': 'M', //Manual Entry
				//'4': 'CS', //Chip Fallback Swipe
				//'5': 'CM',//Chip Fallback Manual
				'NONE': 'CNP', //No card
				'SCAN': 'SCN', //Scan (new method (?mobile?))
			},
		});
		super.provider = 'Global Payments';
		self._kA = null;
	}

	keepAlive() {
		var self = this;
		if (self._kA != null) {
			clearTimeout(self._kA);
			self.comm.setTimeout(0);
		}
		self._kA = setTimeout(function () {
			if (self.comm.connected) {
				console.warn('Global Payments keepAlive timeout, disconnect.')
				self._busy = false;
				self.comm.disconnect();
				if (typeof self.cback == 'function')
					self.cback({ status: 'error', code: 'TIMEOUT' });
			}
		}, 65000);
		//self.comm.setTimeout(65000);
	}


	startOperation(vars, cback) {
		if (this._busy) {
			cback({ status: 'Busy' });
			return;
		}
		this.response = '';
		this.reqId++;
		if (this.reqId > 100000) this.reqId = 1;
		super.startOperation(vars, cback);
	}

	receive(data) {
		var expr = new RegExp(`${this.constants['stx']}\n(.{0,})\n`, 'gms'),
			res = expr.exec(this.response + data)[0];
		if (res != null && res.indexOf('{') < res.lastIndexOf('}')) {
			res = res.substring(res.indexOf('{'), res.lastIndexOf('}') + 1);
			var json = {};
			try {
				json = JSON.parse(res);
			} catch (_) {
				this.response += data;
				return;
			}
			if (json['message'] == 'MSG') {
				this.send({ message: 'ACK' });
				this._busy = false;
				var out = {};
				if (json['data']['cmdResult']['result'] == 'Failed') {
					out['status'] = 'error';
					if (json['data']?.['cmdResult']?.['errorMessage'] != null)
						out['DisplayText'] = [
							[
								{ 'value': json['data']['cmdResult']['errorMessage'] }
							]
						];
					if (this.cback != null) this.cback(out);
					return;
				}

				switch (json['data']['response']) {
					case 'Sale':
					case 'Refund':
						var cardName = json['data']['data']['payment']['cardType'];
						out['TotalAmount'] = json['data']['data']['host']['totalAmount'] * 100;
						out['TipAmount'] = json['data']['data']['host']['tipAmount'] * 100;
						out['paymentDate'] = app._m.moment(json['data']['data']['host']['respDateTime'], 'MM/DD/YY hh:mm A');
						out['last4'] = json['data']['data']['payment']['maskedPan'].substring(12);
						out['CustCardType'] = cardName[0].toUpperCase() + cardName.substring(1).toLowerCase();
						out['Reference'] = json['data']['data']['host']['referenceNumber'];
						out['Auth'] = json['data']['data']['host']['approvalCode'];
						out['CustCardEntry'] = this.constants['CustCardEntry'][json['data']['data']['payment']['cardAcquisition']];
						if (json['data']['response'] == 'Sale') {
							out['transType'] = 'Purchase';
						} else {
							out['transType'] = json['data']['response'];
						}
						break;
				}
				this.comm.disconnect();
				if (this.cback != null) {
					this.cback({
						'status': this.constants['TransStatus'][json['data']['cmdResult']['result']],
						'fields': out,
						'formatted': true
					});
				}
			}
			if (json['message'] == 'BUSY') {
				clearTimeout(self._kA);
				self._kA = null;
				self._busy = false;
				self.comm.disconnect();
				this.cback({ status: 'Busy' });
			}
		} else {
			this.response += data;
		}
	}


	send(vars, cback) {
		var message = vars.message ?? 'MSG',
			data = {};
		if (vars['data'] != null) data['data'] = vars['data'];
		switch (vars['transType']) {
			case 'Purchase':
				data['command'] = 'Sale';
				data['data'] = {};
				data['data']['transaction'] = {
					"baseAmount": (vars['fields']['ECRTransAmount'] / 100).toFixed(2),
					"disableTax": 1,
					"disableTip": 0,
				};
				break;
			case 'Refund':
				data['command'] = 'Refund';
				data['data'] = {};
				data['data']['transaction'] = {
					"totalAmount": (vars['fields']['ECRTransAmount'] / 100).toFixed(2),
				};

				break;
			case 'GetAppInfo':
				data['command'] = 'GetAppInfo';
		}
		data['EcrId'] = app.system.id;//settings.deviceId; //TODO get deviceID 
		data['requestId'] = this.reqId;
		var out = `${this.constants['stx']}\n{
			"message": "${message}",
			"data": ${JSON.stringify(data)}
		}\n${this.constants['etx']}\n`;

		if (typeof cback == 'function')
			this.cback = cback;
		this.comm.send(out);
		this.keepAlive();
	}
}