function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

// Generated by CoffeeScript 2.4.1
// Import
var exec, extractOptsAndCallback, filterByInterface, getMac, isMac, isWindows, macRegex, zeroRegex;

var _require = require('child_process');

exec = _require.exec;
extractOptsAndCallback = require('extract-opts'); // Prepare

isWindows = process.platform.indexOf('win') === 0;
macRegex = /(?:[a-z0-9]{2}[:\-]){5}[a-z0-9]{2}/ig;
zeroRegex = /(?:[0]{2}[:\-]){5}[0]{2}/; // Filter By Interface
// filterByInterface(iface, str)

filterByInterface = function filterByInterface(iface, str) {
  var i, len, line, lines, match, padding, result;
  iface = new RegExp("".concat(iface, "[:\\s]"));
  lines = str.split(/\r?\n/g);
  result = '';
  padding = null;

  for (i = 0, len = lines.length; i < len; i++) {
    line = lines[i];

    if (result.length === 0) {
      if (iface.test(line)) {
        result += line;
      }

      continue;
    } else if (padding === null) {
      match = /^(\s+)/.exec(line);

      if (match) {
        result += "\n".concat(line);
        padding = new RegExp("^".concat(match[1]));
        continue;
      }
    } else {
      match = padding.exec(line);

      if (match) {
        result += "\n".concat(line);
        continue;
      }
    }

    break;
  }

  return result;
}; // Get Mac
// next(err,macAddress)


getMac = function getMac(opts, next) {
  var command, data, extractMac, iface; // Prepare

  var _extractOptsAndCallba = extractOptsAndCallback(opts, next);

  var _extractOptsAndCallba2 = _slicedToArray(_extractOptsAndCallba, 2);

  opts = _extractOptsAndCallba2[0];
  next = _extractOptsAndCallba2[1];
  var _opts = opts;
  data = _opts.data;
  iface = _opts.iface;

  if (data == null) {
    data = null;
  }

  if (iface == null) {
    iface = null;
  } // Command


  command = isWindows ? "%SystemRoot%/System32/getmac.exe" : "/sbin/ifconfig -a || /sbin/ip link"; // Extract Mac

  extractMac = function extractMac(data, next) {
    var err, isZero, macAddress, match, result;

    if (iface) {
      // Prepare
      data = filterByInterface(iface, data);
    }

    result = null; // Find a valid mac address

    while (match = macRegex.exec(data)) {
      macAddress = match[0];
      isZero = zeroRegex.test(macAddress);

      if (isZero === false) {
        if (result == null) {
          result = macAddress;
        }
      }
    } // We have no mac address so return an error


    if (result === null) {
      err = new Error('could not determine the mac address from:\n' + data);
      return next(err);
    } // Forward with result


    return next(null, result);
  }; // If we already have data go straight to extracting the mac


  if (data) {
    return extractMac(data, next);
  } else {
    // Otherwise fetch the data first
    return exec(command, function (err, stdout, stderr) {
      if (err) {
        // Exit if error
        return next(err);
      } // Otherwise forward


      return extractMac(stdout, next);
    });
  }
}; // Is Mac


isMac = function isMac(macAddress) {
  var ref;
  return ((ref = String(macAddress).match(macRegex)) != null ? ref.length : void 0) === 1;
}; // Export


module.exports = {
  macRegex: macRegex,
  getMac: getMac,
  isMac: isMac
};