var app, _notifs = {}, _margin = 10, _marginBottom = 10, nt = {
	init: function (parent, cback) {
		app = parent;
		if (cback) cback();
		if (app.cfg.platform == 'osx64') _marginBottom = 90;
	},
	hasActive: function () {

		if (_notifs && !app.isEmptyObject(_notifs)) {
			let _n = Object.keys(_notifs);
			return _n.length ? true : false;
		}
		return false;
	},
	show: function (vars) { //app.pos.notifications.show=function (vars) {
		let id;
		try {
			id = app.system.uuid.get();
		} catch (er) {
			setTimeout(function () {
				app.pos.notifications.show(vars);
			}, 500);
			return;
		}

		let file = app._m.path.resolve('libs/pos/notifications/notif.html').replace(app._appPath, '').replace(app.baseDir, '');//app._m.path.resolve(__dirname + '/notif.html')
		if (!vars.icon) vars.icon = '../../../AzimutPOS.png';
		if (!vars.width) vars.width = 400;
		if (!vars.height) vars.height = 170;
		if (!vars.buttons || !vars.buttons.length) vars.buttons = [];
		if (typeof vars.timeout == 'undefined') vars.timeout = 15;
		vars.closeTimer = null;
		vars.setProgressBar = function (state) {
			try {
				if (vars.win?.window?.setProgressBar) vars.win.window.setProgressBar(state);
			} catch (er) { if (er.message.indexOf('No window with id') == -1) console.error('Error setting notification progress bar', er.message, state); }
			vars.show();
		};
		vars.setMessage = function (message) {
			try {
				vars.win.window.setMessage(message);
			} catch (er) { }
			vars.show();
		}
		vars.show = function () {
			try {
				vars.win.show();
			} catch (er) { }
		};
		vars.remove = function () {
			vars.preventClose = false;
			vars.win.window.dismiss();
		}
		_notifs[id] = vars;
		//if (vars.closeBtn || !vars.buttons.length) vars.buttons.push({ action: 'dismiss', label: app.parseLocales('common.close') });
		if (app.isSDK) console.log('load notification', file)
		nw.Window.open(file, {
			title: vars.title,
			show: false,
			position: 'right',
			width: vars.width,
			height: 30,
			transparent: true,
			show_in_taskbar: false,
			frame: false,
		}, function (win) {
			if (win) {
				_notifs[id].openTime = new Date().getTime();
				win.setShowInTaskbar(false);
				_notifs[id].win = win;
				win.moveTo(screen.availWidth - win.width - _margin, screen.height - win.height - _marginBottom);
				win.setAlwaysOnTop(true);
				win.show();
				win.focus();
				let _hasDismissed = false;
				win.on('blur', function () {
					if (vars.focusOnBlur) {
						setTimeout(function () { win.focus(); }, 500);
					}
					if (vars.dismissOnBlur)
						try { win.window.dismiss('dismiss'); } catch (er) { }
				});
				win.window.setHeight = function (h) {
					_notifs[id].height = h;
					win.height = h;
					win.resizeTo(win.width, h);
					nt.relocateAllNotifications();
					win.show();
				}
				win.window.dismiss = function (reason) {
					vars.preventClose = false;
					clearTimeout(vars.closeTimer);
					_hasDismissed = true;
					if (reason && vars.onDismiss) vars.onDismiss();
					try {
						win.hide();
					} catch (er) { }
					try {
						win.close(true);
					} catch (er) { }
					delete _notifs[id];
					nt.relocateAllNotifications();
				}
				win.window.buttonClicked = function (idx) {
					console.log('button #' + idx + ' clicked');
					if (idx == 'dismiss') {
						try { win.window.dismiss('dismiss'); } catch (er) { }
					}
					else if (vars.onClick) {
						vars.onClick(idx)
					}
					try { win.window.dismiss(); } catch (er) { }
				};
				win.on('loaded', function () {
					console.log('notification loaded')
					win.window.setNotification({
						closeBtn: vars.closeBtn,
						icon: vars.icon,
						title: vars.title,
						message: vars.message,
						buttons: vars.buttons
					})
					if (!vars.preventClose && vars.timeout > 0) {
						let _l = 1000 * vars.timeout;
						vars.closeTimer = setTimeout(function () {
							try { win.window.dismiss('timeout'); } catch (er) { }
						}, _l);
						try { vars.win.window.setCountdown(100, 0, _l) } catch (er) { console.error('Cannot set countdown on notification', er.message) }
					}
				});
				win.onExit = function () {
					if (vars.preventClose) {
						win.show();
						win.focus();
						return false;
					}
					if (!_hasDismissed) try { win.window.dismiss(); } catch (er) { }
				};
				win.on('close', function () {
					if (vars.preventClose) {
						win.show();
						win.focus();
						return false;
					}
					if (!_hasDismissed) try { win.window.dismiss(); } catch (er) { }
				});
			}
		});
		return _notifs[id];
	},
	relocateAllNotifications: function () {
		if (_notifs && !app.isEmptyObject(_notifs)) {
			let _n = Object.keys(_notifs).map(function (k) { return _notifs[k]; });
			_n.sort(function (a, b) {
				return a.openTime > b.openTime ? -1 : 1;
			})
			var
				y = 1 * screen.height;
			for (let i = 0; i < _n.length; i++) {
				try {
					let x = screen.availWidth - _n[i].width - _margin;
					y = y - _n[i].height - _marginBottom;
					_n[i].win.moveTo(x, y);
				} catch (er) { console.error(er, _n[i]) }
			}
		}
	},
	exit: function () {
		if (_notifs && !app.isEmptyObject(_notifs)) {
			let _n = Object.keys(_notifs);
			for (let i = 0; i < _n.length; i++) {
				try {
					_notifs[_n[i]].win.close(true);
				} catch (er) { }
			}
		}
	}
};
module.exports = nt;