const { WebSocket } = require('ws');
var
	_checkNetworkIPsTimer = null,
	_cbacks = {},
	_neighbors = {},
	_pingTimer = 10000,
	app,
	_kdss = {},
	//io = require(__dirname + '/node_modules/socket.io-client'),
	kds = {
		data: [],
		_init: function (_app, cback) {
			app = _app;
			if (cback) cback();
			setTimeout(() => {

				app.pos.tags.onChange((tags) => {
					//tags changed, send to KDS
				})
				setInterval(() => {
					//connect to kds
					if (app.pos.serverWS.status != 'online') return false;
					for (let i of (app.data.session.configs.kds ?? []).filter((a) => a.ip)) {
						if (!_kdss[i.id]) kds.connect(i);
					}
					//send KDS status to cloud
					//kds.emit({
					//	action: 'kdsStatus',
					//	data: kds.getStatus()
					//})
				}, 1000 * 10);

				setInterval(kds.checkIPAddresses, 1000 * 30);
			}, 5000)
		},
		getStatus: () => {
			return (app.data?.session?.configs?.kds ?? []).map((a) => {
				return {
					id: a.id,
					status: !a.ip ? 'invalid' : (_kdss[a.id]?.connected ? 'connected' : _kdss[a.id]?.lastError?.code),
					lastError: _kdss[a.id]?.lastError,
					ping: _kdss[a.id]?._lastPong,
					neighbors: _neighbors[a.id]
				}
			})
		},
		checkIPAddresses: async () => {

			if (_checkNetworkIPsTimer) return false;
			_checkNetworkIPsTimer = true;
			setTimeout(function () {
				_checkNetworkIPsTimer = false;
			}, 1000 * 30);
			var v = app.pathExists(app.system, 'net.arp._lastScan.values');
			if (v && !app.isEmptyObject(v)) {
				//find printers by macAddress, compare ip, update if needed
				for (let i of (app.data.session.configs.kds ?? [])?.filter((a) => a.macAddress)) {
					let [ip, port] = i.ip.split(':');
					if (v[i.macAddress] && v[i.macAddress] != ip) {
						//ip changed for mac address
						i.ip = '' + v[i.macAddress] + (port ? ':' + port : '');

						kds.internode.send({
							action: 'kdsIpUpdate',
							data: {
								id: i.id,
								ip: i.ip
							}
						});
						kds.emit({
							action: 'kdsIpUpdate',
							data: {
								id: i.id,
								ip: i.ip
							}
						});
						try {
							app.pos.serverWS.neighbors.kds.kdsIpUpdate({
								id: i.id,
								ip: i.ip
							});
						} catch (er) { }
					}
				}
			}
		},
		emit: (obj, cback) => {
			var out = {
				module: 'kds',
				action: obj.action || 'event',
				data: obj.data
			};
			app.pos.emit(out, cback);
		},
		routeEvent: (d, cback) => {
			//cloud events
			switch (d.action) {
				case 'kdsDeleted':
					app.data.session.configs.kds = app.data.session.configs.kds.filter((a) => a.id != d.data.id);
					try {
						_kdss[d.data.id].socket.close();
					} catch (er) { }
					break;
				case 'kdsUpdate':
					let _found = false;
					for (let i = 0; i < (app.data.session.configs.kds ?? []).length; i++) {
						if (app.data.session.configs.kds[i].id == d.data.id) {
							app.data.session.configs.kds[i] = d.data;
							_found = true;
							break;
						}
					}
					if (!_found) {
						app.data.session.configs.kds.push(d.data);
					}
					break;
				default:
					if (app.cfg.env == 'dev') console.warn('Unrouted pos.kds.' + d.action);
			}
		},
		internode: {
			send: (data) => {
				app.pos.neighbors.broadcast({
					module: 'pos',
					action: 'event',
					data: {
						module: 'kds',
						action: data.action,
						data: data.data
					}
				});
			}
		},
		routeInterNode(d) {
			if (app.pathExists(kds, d.module + '.routeInterNode')) {
				//d.data.socket = d.socket;
				//d.data.cback = d.cback;
				kds[d.module].routeInterNode(d);
				return;
			}
			switch (d.action) {
				case 'event':
					if (app.pathExists(kds, d.module + '.routeInterNode')) {
						d.data.socket = d.socket;
						d.data.cback = d.cback;
						kds[d.module].routeInterNode(d.data);
						return;
					}
					console.warn('module pos.' + d.module + ' has no internode routing (routeInterNode)')
					break;
				case 'sendToKDS':
					kds.sendData(d.data.id, d.data.data).then(d.cback);
					break;
				case 'kdsIpUpdate':
					_k = (app.data.session.configs.kds ?? [])?.filter((a) => a.id == d.data.id)?.[0];
					if (_k) _k.ip = d.data.ip;
					break;
				case 'kdsMACUpdate':
					_k = (app.data.session.configs.kds ?? [])?.filter((a) => a.id == d.data.id)?.[0];
					if (_k) _k.macAddress = d.data.macAddress;
					break;
				case 'kdsStatusUpdate':
					//console.log('Received kdsStatusUpdate from', d.socket.deviceUUID, d.data)
					if (!_neighbors[d.data.id]) _neighbors[d.data.id] = {};
					_neighbors[d.data.id][d.socket.deviceUUID] = { status: d.data.status, date: d.data.date || new Date().toISOString(), lastError: d.data.lastError }
					break;
				default:
					console.log('pos.kds.routeInterNode ' + d.module + '.' + d.action, d.data);
			}
		},
		sendOrder: async (o) => {
			let c = app.data.session.configs, _out = {};
			console.log('kds sendOrder', o)
			if (!o.seats)
				o.seats = [o.items];
			await Promise.all((app.data.session.configs.kds ?? []).filter((a) => a.ip).
				filter((a) => !a.configs?.tags?.length || o.seats.
					filter((b2) => b2.items.
						filter((b) => b?.item_id && (b?.tags?.length && b.tags.
							filter((c) => a.configs.tags.indexOf(c) != -1).length)).length).length).map((i) => new Promise(async (kdsRes) => {
								var out;
								if (false)//o.groupSeats)
									out = {
										orders: [{
											orderId: o.seats[0].sale_id,
											activity: o.seats[0].activity,
											invoiceNumber: o.seats[0].invoice_number,
											tableName: o.seats[0].table,
											seatNumber: '-',
											seats: []
										}]
									};
								else
									out = { orders: [] };
								out.sale_ids = o.seats.map((a) => a.sale_id);
								for (let s of o.seats) {

									let data = {
										orderId: s.sale_id,
										activity: s.activity,
										invoiceNumber: s.invoice_number,
										tableName: s.table,
										seatNumber: s.seat,
										items: s.items.map((a) => {

											let
												_sloc = {
													SIDE_LEFT: {
														en_CA: '<-- LEFT',
														es_ES: '<-- IZQUIERDO',
														fr_CA: '<-- GAUCHE'
													},
													SIDE_RIGHT: {
														en_CA: 'RIGHT -->',
														es_ES: 'DERECHO -->',
														fr_CA: 'DROITE -->'
													},

												},
												_extras = [];

											if (a.inclusions && !app.isEmptyObject(a.inclusions)) {
												let _sides = ['SIDE_FULL', 'SIDE_LEFT', 'SIDE_RIGHT'];
												for (let sn of _sides) {
													if (a.inclusions[sn] && a.inclusions[sn].length) {
														if (sn != 'SIDE_FULL') {
															_extras.push(_sloc[sn][i.configs.language || 'fr_CA']);
														}
														for (let inc of a.inclusions[sn]) {
															_extras.push((inc.quantity > 1 ? inc.quantity : ' ') + ' ' + inc.name);
														}
													}
												}
											}
											return {
												itemId: a.item_id,
												saleItemId: a.sale_item_id,
												name: a.name,
												quantity: a.quantity,
												tags: a.tags?.map((a) => {
													return {
														tagId: a
													}
												}) ?? [],
												extras: _extras,
												remarks: (a?.remarks ?? []).map((a) => a.trim())
											}
										})
									}
									if (false)//o.groupSeats)
										out.orders[0].seats.push(data);
									else
										out.orders.push(data);
								};
								let _timedOut = false, _connected = false;
								console.log('Connecting to kds', i);
								let _timeout = setTimeout(() => {
									if (_connected) return false;
									console.log('Timeout connecting to kds', i);
									_timedOut = true;
									_out[i.id] = { result: 'error', code: 'timeout' };
									if (i?.configs?.advanced?.save_trace_data) {
										//log raw sent data
										app.pos.doPOSRequest({
											method: 'POST',
											path: 'peripherals/save_trace_data',
											fields: {
												register: app.system.id,
												peripheral: {
													type: 'kds',
													id: i.id
												},
												data: {
													raw: o,
													sent: out,
													received: _out[i.id]
												}
											}
										});
									}
									kdsRes();
								}, 1000 * 10)
								await kds.connect(i);
								if (_timedOut) return false;
								_connected = true;
								clearTimeout(_timeout);
								console.log('send orderAdded', i.name, out)
								_out[i.id] = await kds.sendData(i.id, { action: 'orderAdded', data: out });

								if (i?.configs?.advanced?.save_trace_data) {
									//log raw sent data
									app.pos.doPOSRequest({
										method: 'POST',
										path: 'peripherals/save_trace_data',
										fields: {
											register: app.system.id,
											peripheral: {
												type: 'kds',
												id: i.id,
												data: i
											},
											data: {
												raw: o,
												sent: out,
												received: _out[i.id]
											}
										}
									});
								}
								kdsRes();
							})));
			return _out;
		},
		publicKeyChanged: () => {
			for (let i of Object.keys(_kdss))
				try { kds.sendData(i, { action: "publicKey", data: app.web.PKI.public64 }); } catch (er) { }
		},
		connect: async (i) => {
			return new Promise(async (resolve) => {
				_kdsInfo = app.data.session.configs.kds.filter((a) => a.id == i.id)?.[0];
				if (!_kdsInfo) return false;
				if (!i.macAddress) {
					let _exists = Object.keys(app.system?.net?.arp?._lastScan?.values ?? {}).filter((a) =>
						app.system?.net?.arp?._lastScan?.values[a] == i.ip || i.configs?.advanced?.alternateIps?.length && i.configs?.advanced?.alternateIps.indexOf(app.system?.net?.arp?._lastScan?.values[a]) != -1)?.[0]
					if (_exists) {
						i.macAddress = _exists;
						kds.internode.send({
							action: 'kdsMACUpdate',
							data: {
								id: i.id,
								macAddress: i.macAddress
							}
						});
						kds.emit({
							action: 'kdsMACUpdate',
							data: {
								id: i.id,
								macAddress: i.macAddress
							}
						});
						try {
							app.pos.serverWS.neighbors.kds.kdsMACUpdate({
								id: i.id,
								macAddress: i.macAddress
							});
						} catch (er) { }
					}
				}
				if (_kdss[i.id]) {
					if (_kdss[i.id].connected) {
						resolve();
						return;
					}
					_kdss[i.id].onConnected.push(resolve);
					return true;
				}
				let c = app.data.session.configs;
				let
					_kdsIps = [_kdsInfo.ip, app.system?.net?.arp?._lastScan?.values?.[_kdsInfo?.macAddress], ...(_kdsInfo?.configs?.advanced?.alternateIps || [])].filter((a) => a),
					_ip = 0,
					_tries = 0;
				//console.log('Connect to KDS', i)
				//open socket, send config
				let _doConnect = () => {
					if (app.status == 'shutdown') return false;
					_kdsInfo = app.data.session.configs.kds.filter((a) => a.id == i.id)?.[0];
					if (!_kdsInfo) return false;
					if (!_kdsIps[_ip]) _ip = 0;
					//console.log('Connecting to KDS', i.name + '@' + i.ip)
					let [ip, port] = _kdsIps[_ip].split(':');
					const ws = new WebSocket('ws://' + ip + ':' + (port || '11419'));
					if (!_kdss[i.id])
						_kdss[i.id] = {
							info: i,
							socket: ws,
							onConnected: [resolve]
						};
					if (_tries === 0 || _tries % 50 === 0) {
						kds.internode.send({
							action: 'kdsStatusUpdate',
							data: {
								id: i.id,
								date: new Date().toISOString(),
								status: 'connecting',
								lastError: _kdss[i.id]?.lastError
							}
						});
						kds.emit({
							action: 'kdsStatusUpdate',
							data: {
								id: i.id,
								date: new Date().toISOString(),
								status: 'connecting',
								ip: _kdsIps[_ip],
								lastError: _kdss[i.id]?.lastError
							}
						});
					}
					_kdss[i.id].currentIP = _kdsIps[_ip];
					_kdss[i.id]._lastPing = null;
					_kdss[i.id]._lastPong = null;
					_kdss[i.id].publicKey = null;
					_kdss[i.id]._missedPings = 0;
					_kdss[i.id].connected = false;
					_kdss[i.id].socket = ws;
					ws.on('error', (er) => {
						_kdss[i.id].lastError = {
							date: new Date().toISOString(),
							syscall: er.syscall,
							code: er.code,
							ip: '' + _kdsIps[_ip]
						}
						//if (['ECONNREFUSED', 'ETIMEDOUT', 'ECONNRESET'].indexOf(er.code) != -1) {
						_tries++;
						if (_tries == 10 && _kdsIps?.length > 1) {
							_tries = 0;
							_ip++;
						}
						//}
						if (['ECONNREFUSED', 'ETIMEDOUT', 'ECONNRESET'].indexOf(er.code) == -1)
							console.error('KDS', i.name, er.message)
					});
					ws.on('unexpected-response', (a, b) => {
						console.log('unexpected response from kds', i.name, a, b)
					})
					ws.on('open', function open() {
						//console.log('Connection opened.', i.name + '@' + i.ip)
						kds.sendData(i.id, { action: "publicKey", data: app.web.PKI.public64 });
						_kdss[i.id].pingTimer = setInterval(() => {
							if (!_kdss[i.id].connected) return false;
							if (_kdss[i.id]._lastPong && new Date(_kdss[i.id]._lastPong.time).getTime() < new Date().getTime() - _pingTimer) _kdss[i.id]._missedPings++;

							if (_kdss[i.id]._missedPings) {
								//console.log('send ping, _missedPings', _kdss[i.id]._missedPings)
								if (_kdss[i.id]._missedPings == 10) {
									try { ws.close(); } catch (er) { }
									clearInterval(_kdss[i.id].pingTimer)

									kds.emit({
										action: 'kdsPingUpdate',
										data: {
											id: i.id,
											date: new Date().toISOString(),
											ip: _kdss[i.id].currentIP,
											ttl: -1
										}
									});
									return;
								}
							}
							_kdss[i.id]._lastPing = new Date().getTime();
							//ws.ping('ping', true, function (err) {
							//	if (err)
							//		console.error('ping error', err)
							//});
							kds.sendData(i.id, { action: "ping" }, true);
						}, _pingTimer);
					});
					ws.on('upgrade', function (data) {
						//console.log('updgrade', data)
					})
					ws.on('close', function (er, er1) {
						//if (_kdss[i.id].connected)
						//	console.log('disconnected', er, er1?.toString(), 'Connected', (new Date().getTime() - _kdss[i.id].connected) / 1000);
						clearInterval(_kdss[i.id].pingTimer)
						_kdss[i.id].socket = null;
						try { ws.close(); } catch (er) { }
						try { ws.terminate(); } catch (er) { }
						setTimeout(_doConnect, 10000);
						if (_kdss[i.id].connected) {
							kds.internode.send({
								action: 'kdsStatusUpdate',
								data: {
									id: i.id,
									date: new Date().toISOString(),
									status: 'disconnected',
									ip: _kdss[i.id].currentIP,
									lastError: _kdss[i.id]?.lastError
								}
							});

							kds.emit({
								action: 'kdsStatusUpdate',
								data: {
									id: i.id,
									date: new Date().toISOString(),
									ip: _kdss[i.id].currentIP,
									status: 'disconnected',
									lastError: _kdss[i.id]?.lastError
								}
							});
						}
						_kdss[i.id].connected = false;
					});
					ws.on('pong', function () {
						_kdss[i.id]._missedPings = 0;
						_kdss[i.id]._lastPong = {
							time: new Date().toISOString(),
							ttl: new Date().getTime() - _kdss[i.id]._lastPing
						};
						//console.log('kds pong', _kdss[i.id].info.name, _kdss[i.id]._lastPong);
					});
					//ws.on('ping', function () {
					//	console.log('Received kds ping')
					//});

					ws.on('message', function message(data) {
						try {
							kds.routeKDSEvent(i.id, data)
						} catch (er) {
							console.error('kds route event error', er, data.toString())
							ws.send(JSON.stringify({
								action: 'error', data: er.message,
								time: new Date().toISOString(),
								register: app.system.id
							}))
						}
					});
				}
				_doConnect();
				//_socket.
				//	on('PUBLIC_KEY', function (d) {
				//		//if (sws.PKI.serverPublic)
				//		b4 = new Date().getTime();
				//		_socket._sessionInit = {
				//			sentDate: new Date().toISOString()
				//		};
				//		_kdss[i.id].PKI.serverPublic = Buffer.from(d, 'base64').toString();
				//		_socket.emit('PUBLIC_KEY', Buffer.from(app.web.PKI.public).toString('base64'), function (ack) {
				//			console.log(((new Date().getTime() - b4) / 1000), 'PUBLIC KEY RECEIVED');
				//
				//			//console.log('Connecting fo real')
				//			_socket.sendEncrypted = true;
				//
				//			_doConnect();
				//		});
				//	}).
			});
		},
		routeKDSEvent: (id, d) => {
			let _s = _kdss[id];
			//console.log(d.toString())
			d = app.JSON.parse(app.system.crypto.AES_PK.decrypt(d.toString(), app.web.PKI.private));
			if (d?.action == 'ping' || d == 'ping') { kds.sendData(id, { action: "pong" }); return; }
			if (d?.action == 'pong' || d == 'pong') {
				_s._missedPings = 0;
				_s._lastPong = {
					time: new Date().toISOString(),
					ttl: new Date().getTime() - _s._lastPing
				};
				if (!_s._lastReportedPing || _s._lastReportedPing < new Date().getTime() - 1000 * 60 * 2) {
					_s._lastReportedPing = new Date().getTime();
					kds.emit({
						action: 'kdsPingUpdate',
						data: {
							id: id,
							date: new Date().toISOString(),
							ip: _s.currentIP,
							ttl: _s._lastPong.ttl
						}
					});
				}
				//console.log('kds pong', _s.info.name, _s._lastPong);
				return;
			}
			if (typeof d == 'string' && d.trim() == 'connected') {
				//_s.connected = new Date().getTime();
				//kds.sendData(id, { action: 'config', data: { name: _s.info.name, id: _s.info.id, config: _s.info.configs, tags: app.pos.tags.data, kds: app.data.session.configs.kds } });
				return;
			}
			console.log('Received', id, d);
			switch (d?.action) {
				case 'publicKey':
					_s.publicKey = Buffer.from(d.data, 'base64').toString();
					_s.connected = new Date().getTime();
					kds.sendData(id, { action: 'config', data: { name: _s.info.name, id: _s.info.id, config: _s.info.configs, tags: app.pos.tags.data, kds: app.data.session.configs.kds } });
					kds.internode.send({
						action: 'kdsStatusUpdate',
						data: {
							id: id,
							date: new Date().toISOString(),
							ip: _s.currentIP,
							status: 'connected'
						}
					});
					kds.emit({
						action: 'kdsStatusUpdate',
						data: {
							id: id,
							date: new Date().toISOString(),
							ip: _s.currentIP,
							status: 'connected'
						}
					});
					break;
				case 'cback':
					_cbacks[d.cbackID](d.data);
					setTimeout(() => {
						delete _cbacks[d.cbackID];
					}, 1000);
					break;
			}
		},
		sendData: (id, data, noCback) => {
			return new Promise(async (resolve) => {
				if (!id) {
					let _out = {};
					app._m.async.each(Object.keys(_kdss), function (i, n) {
						kds.sendData(i, app._m.xtend.clone(data)).then((res) => {
							_out[i] = res;
							n();
						})
					}, function () {
						resolve(_out);
					})

					return;
				}

				let _s = _kdss[id];
				let cbackID = null, _timeouted = false, _timeout;
				if (!noCback) {
					cbackID = app.system.uuid.get();
					_cbacks[cbackID] = (res) => {
						if (_timeouted) return;
						clearTimeout(_timeout)
						resolve(res);
					}
					_timeout = setTimeout(() => {
						_timeouted = true;
						console.warn('KDS sendEvent timeouted', data.action);
						resolve({ result: 'timeout' })
					}, 1000 * 10);
				}

				let out = JSON.stringify({
					module: 'pos',
					action: data.action,
					data: data.data ?? '',
					time: new Date().toISOString(),
					register: app.system.id,
					cbackID: noCback ? null : cbackID
				});
				//if (data.action != 'ping')
				//	console.log('send', out)
				let _data = (_s.publicKey ? app.system.crypto.AES_PK.encrypt(out, _s.publicKey, true) : out).trim();
				//if (data.action != 'ping')
				//	console.log('encrypted', _data)
				_s.socket.send(_data);
				if (noCback) resolve();
			});
		},
		shutdown: () => {
			for (let i of Object.keys(_kdss))
				i?.socket?.close();

		}
	};
module.exports = kds;