/// <reference types="node" />
declare type WriteData = BaseMutableBuffer | string | Buffer | ArrayLike<number> | ArrayBuffer | SharedArrayBuffer;
export declare class BaseMutableBuffer {
    static Buffer: typeof Buffer;
    static readonly target: string;
    protected _initialSize: number;
    protected _blockSize: number;
    constructor(size?: number, blockSize?: number);
    protected _size: number;
    get size(): number;
    protected _buffer: Buffer;
    get buffer(): Buffer;
    get Buffer(): typeof Buffer;
    get nativeBuffer(): Buffer;
    static create(size?: number, blockSize?: number): BaseMutableBuffer;
    _ensure(size: number): void;
    capacity(): number;
    clear(): void;
    /**
     *
     * @param targetOrCreate The target buffer or creating or slice buffer.
     *    1. Buffer: The target buffer to render;
     *    2. true: Create new buffer and copy all cached data to it;
     *    3  false: Slice the cached data from internal buffer, The result cloud be be changed if current MutableBuffer has been reused.
     */
    render(targetOrCreate?: Buffer | boolean): Buffer;
    flush(targetOrCreate?: Buffer | boolean): Buffer;
    write(source: WriteData, encoding?: BufferEncoding): number;
    write(source: WriteData, ...args: any[]): number;
    writeCString(data?: string | Buffer, encoding?: BufferEncoding): number;
    writeChar(c: string): number;
    writeUIntLE(value: number, byteLength: number): number;
    writeUIntBE(value: number, byteLength: number): number;
    writeUInt8(value: number): number;
    writeUInt16LE(value: number): number;
    writeUInt16BE(value: number): number;
    writeUInt32LE(value: number): number;
    writeUInt32BE(value: number): number;
    writeIntLE(value: number, byteLength: number): number;
    writeIntBE(value: number, byteLength: number): number;
    writeInt8(value: number): number;
    writeInt16LE(value: number): number;
    writeInt16BE(value: number): number;
    writeInt32LE(value: number): number;
    writeInt32BE(value: number): number;
    writeFloatLE(value: number): number;
    writeFloatBE(value: number): number;
    writeDoubleLE(value: number): number;
    writeDoubleBE(value: number): number;
    trim(): number;
    trimLeft(): number;
    trimRight(): number;
}
export {};
