var app, self, Pos, Kiosk = class Kiosk {
	constructor(parent) {
		this.window_open_policies = require('./window_open_policies');
		this.window_navigate_policies = require('./window_navigate_policies');
		this.isRunning = false;
		this.keepRunningOnClose = false;
		self = this;
		self.windowState = 'closed';
		if (parent) {
			Pos = parent;
			app = parent.app;
		}
	}
	getKioskURL() {
		var kioskUrl = '' + Pos.url + 'index.php/kiosk?theme=' + self.KM.theme.id + '&secureToken=' + app.data.secureAccessToken;
		switch (self.KM.theme.id) {
			case 'custom':
				kioskUrl = 'https://kiosk.isp.tech-cl.com/' + app.data.session.configs.branch.id;
				break;
		}
		self.kioskUrl = '' + kioskUrl;
	}
	initialize(opts) {
		if (!opts) opts = {};
		if (!self.enabled()) return false;
		self.openOnTokenChange = false;
		if (!self.opts && !app.isEmptyObject(opts))
			self.opts = opts;

		if (self.win || self.isRunning) {

			if (self.isRunning)
				console.warn('Kiosk is already running...');
			self.isRunning = true;
			self.showWindow();
			return false;
		}
		self.KM = app.data.session.configs.kioskMode || {};
		self.getKioskURL();
		let _loadedToken = '' + app.data.secureAccessToken;
		//console.log('Opening ' + self.url)//http://10.1.0.5/tech-cl/kiosk_test/
		nw.Window.open(self.kioskUrl, {
			title: "AzimutPOS Kiosk",
			show: false,
			position: 'center',
			width: screen.availWidth,
			height: screen.availHeight,
			//frame: false,
		}, function (win) {
			console.log('kiosk Window opened')
			//console.logRaw(win)
			//try {
			self.isRunning = true;
			self.win = win;

			win.getRegisterConfig = function (cback) {
				cback(app.data.session.configs);
			};
			var _firstLoadDone = false, _firstLoad = function () {
				if (_firstLoadDone) return;
				_firstLoadDone = true;
				try {
					win.enterKioskMode();
				} catch (er) { }
				try {
					self.onReady();
				} catch (er) {
					console.error('Error with self.onReady();', er)
				}
				// Locale
				let locale = win.window.document.querySelector("html").className;
				localStorage.setItem("locale", locale);
				self.setWindowStatus('open');
			}
			win.on('loaded', function () {
				//let _l = win.window.location;
				//console.log('Kiosk Window page loaded', _l.pathname.split('index.php').pop());
				let _tokenChanged = _loadedToken != app.data.secureAccessToken;
				try {
					if (app.pathExists(win, 'window.document.body.innerText')) {
						let _j = app.JSON.parse(win.window.document.body.innerText);
						if (_j && _j.error) {

							console.log('window loaded error', _j)
							self.isRunning = false;
							win.close(true);
							self.win = null;
							if (_tokenChanged) self.initialize();
							else
								self.openOnTokenChange = true;
							return;
						}
					}
				} catch (er) {
					console.error(er);
				}
				_firstLoad();
			});
			let newPageLoadedTimer = null;
			let _pageLoadTimer = function () {

				newPageLoadedTimer = setTimeout(function () {
					try {

						if (app.pathExists(win, 'window.document.body.innerText')) {
							let _j = app.JSON.parse(win.window.document.body.innerText);
							if (_j && _j.error) {
								console.log('newPageLoadedTimer error', _j)
								self.isRunning = false;
								win.close(true);
								self.openOnTokenChange = true;
								self.win = null;
								return;
							}
						}
					} catch (er) {
						console.error(er);
					}
					console.log('show "page loading..."');
				}, 1000 * 5);
			}

			let _previousActivity = null, _lastActivity = null, _lastActivitySendTimer = null,
				_sendActivityUpdate = function (d) {
					if (d)
						Pos.emit({
							data: {
								module: 'kiosk',
								action: 'updateActivity',
								data: {
									id: d.id,
									update_date: d.update_date,
									time_on_page: d.time_on_page,
									ended: d.ended || 0
								}
							}
						});
				};
			win.recordActivity = function (d) {
				try {
					clearTimeout(newPageLoadedTimer);
				} catch (er) { }
				d.id = app.system.uuid.get();
				d.date = new Date().toISOString();
				if (_lastActivity && d.id != _lastActivity.id && _lastActivity.id) {
					//there's a new page, seal the cap on previous activity
					_previousActivity = app._m.xtend.clone(_lastActivity);
					_previousActivity.update_date = new Date().toISOString();
					_previousActivity.time_on_page = (new Date(_previousActivity.update_date).getTime() - new Date(_previousActivity.date).getTime()) / 1000;
					_previousActivity.ended = 1;
					_sendActivityUpdate(_previousActivity);
				}
				_lastActivity = d;
				Pos.emit({
					data: {
						module: 'kiosk',
						action: 'recordActivity',
						data: d
					}
				});
				return d.id;
			};
			win.updateActivity = function (d) {
				_lastActivity.update_date = new Date().toISOString();
				_lastActivity.time_on_page = (new Date(_lastActivity.update_date).getTime() - new Date(_lastActivity.date).getTime()) / 1000;
				if (d.ended) {
					//check for error
					_lastActivity.ended = 1;
					clearTimeout(_lastActivitySendTimer);
					_sendActivityUpdate(_lastActivity);
					_lastActivity = null;
					_lastActivitySendTimer = null;
					_pageLoadTimer();
				}
				if (_lastActivitySendTimer) return;
				//send max 1 update per 30 seconds
				_lastActivitySendTimer = setTimeout(function () {
					_sendActivityUpdate(_lastActivity);
					_lastActivitySendTimer = null;
				}, 1000 * 30);
			};

			win.getPOSData = function (vars, cback) {
				self.getPOSData(vars, cback);
			};

			win.getKioskConfig = function (cback) {
				cback({
					id: app.data.session.configs.branch.id,
					kiosk: {
						type: 'AzimutPOS',
						id: app.system.id,
						configs: self.KM
					}
				});
			};
			win.onExit = function () {
				console.log('Kiosk EXIT')
				self.isRunning = false;
				self.setWindowStatus('closed');
				win.hide();
			};
			win.on('new-win-policy', self.window_open_policies);
			win.on('navigation', function (n, u, p) {
				if (self.window_navigate_policies(n, u, p)) {
					console.log(n, u, p);
					_pageLoadTimer();
				}
			});
			let _checkForFocus = function () {
				if (app.status == 'shutdown') return false;
				if (app.pos.notifications.hasActive()) return false;
				if (self.isRunning) {
					if (app.pathExists(app.data, 'session.configs.window.alwaysOnTop') == '1')
						win.setAlwaysOnTop(true);
					if (app.pathExists(app.data.session, 'configs.kioskMode.prevent_close') == '1')
						win.focus();
				}
			};
			win.on('minimize', function () {
				win.hasFocus = false;
				//console.log('kiosk is minimized');
				_checkForFocus();
			});
			win.on('focus', function () {
				win.hasFocus = true;
				//console.log('kiosk has focus');
			});
			win.on('blur', function () {
				win.hasFocus = false;
				//console.log('kiosk is blured');
				_checkForFocus();
			});
			win.isCCProcessingEnabled = function () {
				var proc = app.pathExists(self.eft, 'cfg.comm.provider');
				return proc && proc != 'NONE';
			};

			win.startCCProcessing = function (vars, cback) {
				self.eft.startOperation(vars, function (data) {
					if (data.status == 'readyPrint') {
						//PRINTING
						var receipt = {};

						//TEMP printing error bypass //SHOULD NOTIFY PRINTING COPMPLETE
						self.eft.send({ transType: 'PingClose' });
					} else {
						var out = {};
						if (data && data.fields) {
							for (let f = 0, fL = data.fields.length; f < fL; f++)
								switch (data.fields[f].key) {
									case 'CustAccNbr':
										out.last4 = data.fields[f].value.substr(12);
										break;
									case 'TransStatus':
									case 'CustCardEntry':
									case 'CustCardType':
										out[data.fields[f].key] = data.fields[f].valueText;
										break;
									case 'Auth':
									case 'Reference':
									case 'EMVAID':
									case 'EMVTVR':
									case 'EMVTSI':
									case 'CVMResult':
									case 'transType':
									case 'EMVAppLabel':
									case 'TotalAmount':
									case 'DisplayText':
										out[data.fields[f].key] = data.fields[f].value;
										break;
									case 'TransAmount':
										out.TotalAmount = data.fields[f].value;
										break;
									case 'TipAmount':
										out.TipAmount = data.fields[f].value;
										break;
									case 'CustomerReceipt':
									case 'MerchantReceipt':
										let lines = data.fields[f].value;
										if (1 * localStorage.getItem("default_printer_is_mev")) {
											let receipt = '';
											for (let l = 0, lL = lines.length; l < lL; l++) {
												let format = lines[l][0].key == 'TextFormat' ? lines[l][0].valueText : lines[l][1].valueText;
												let text = lines[l][0].key == 'TextLine' ? lines[l][0].value : lines[l][1].value;
												if (text.length) {
													switch (format) {
														case 'normal':
														default:
															receipt += '\x1b\x21\x00\x1d\x42\x00';
															break;
														case 'doubleHeight':
															receipt += '\x1b\x21\x10';
															break;
														case 'reversed':
															receipt += '\x1d\x42\x01';
															break;
														case 'doubleHeight|reversed':
															receipt += '\x1b\x21\x10\x1d\x42\x01';
															break;
													}
													receipt += text + '\n';
												} else
													receipt += '\n';
											}
											self.mev.print(self.mev.other(receipt + '\n\n\n\x1b\x6d'));
										} else {
											let receipt = '<style>.doubleHeight{transform:scaleY(2);-webkit-transform:scaleY(2);-moz-transform:scaleY(2);}.reversed{color:white;background-color:black;}p{text-align:center;width:100%;}</style>';
											for (let l = 0, lL = lines.length; l < lL; l++) {
												let format = lines[l][0].key == 'TextFormat' ? lines[l][0].valueText : lines[l][1].valueText;
												let text = lines[l][0].key == 'TextLine' ? lines[l][0].value : lines[l][1].value;
												if (text.length) {
													switch (format) {
														case 'normal':
														default:
															receipt += '<p>';
															break;
														case 'doubleHeight':
															receipt += '<p class="doubleHeight">';
															break;
														case 'reversed':
															receipt += '<p class="reversed">';
															break;
														case 'doubleHeight|reversed':
															receipt += '<p class="doubleHeight reversed">';
															break;
													}
													receipt += text + '</p>';
												} else
													receipt += '<br />';
											}
											nw.Window.open(app._relativePath + 'libs/printManager/printWindow/printWindow.html', {
												title: "EFTPrinting",
												show: false
											}, function (win) {
												win.on('loaded', function () {
													win.window.setContent(receipt, function () {
														win.window.nw.Window.get().print({
															"autoprint": true,
															"marginsType": 1,
															"headerFooterEnabled": false,
															"printer": localStorage.getItem("default_printer")
														});
														win.close();
													});
												});
											});
										}
										break;
									case 'Warnings':
										//console.log(data.fields[f].value);
										break;
								}
						}
						if (!out.TransStatus)
							out.TransStatus = data.status;
						cback(out);
					}
				});
			};
			win.coreFunction = function (d, cback) {

				app.web.emit({
					module: 'core',
					action: d.action || 'event',
					datas: d.datas
				}, function (res) {
					console.log('Core function', d.action, 'received', res);
					cback(res);
				});
			};
			win.on('close', function () {
				//console.log('Kiosk closed')
				//self.app.exit(0);
				self.isRunning = false;
				win.hide();
				if (app.status != 'shutdown' && app.pathExists(app.data.session, 'configs.kioskMode.prevent_close') == '1') {
					setTimeout(function () {

						self.initialize({
							onShowWindow: function () {
								self.getKioskURL();
								win.window.location.href = self.kioskUrl;
							}
						});
					}, 100);
					return;
				}
				self.setWindowStatus('closed');
				win.close(true);
				self.win = null;
			});
			//}
			//catch (er) {
			//	console.error('POS window events error', er)
			//}
		});
		return true;
	}
	secureTokenChanged() {
		//console.log('token changed')
		if (self.openOnTokenChange) {
			console.log('openOnTokenChange', self.initialize());
		}
		if (self.enabled() && self.isRunning && self.win) {
			try { self.win.window.APPFCTS.secureTokenChanged(app.data.secureAccessToken); } catch (er) { }
		}
	}
	enabled() {
		return app.pathExists(app.data.session, 'configs.kioskMode.enabled') == '1';
	}
	autoOpen() {
		if (self.enabled() && app.pathExists(app.data.session, 'configs.kioskMode.auto_open') == '1') {
			self.initialize();
		}
	}
	close() {
		if (self.win) {
			self.win.close(true);
		}
	}
	setWindowStatus(status) {
		if (self.windowState == status) return;
		self.windowState = '' + status;
		Pos.emit({
			data: {
				module: 'kiosk',
				action: 'windowStatus',
				data: status
			}
		});
	}
	showWindow() {
		self.win.show();
		self.win.focus();
		self.setWindowStatus('open');
		self.win.setAlwaysOnTop(true);
		if (self.opts && self.opts.onShowWindow) self.opts.onShowWindow();
	}
	hideWindow() {
		if (self.win) {
			self.win.hide();
			self.setWindowStatus('close');
		}
	}
	getPOSData(vars, cback) {
		app.system.request.GET(Pos.url + 'index.php/kiosk/' + vars.action + '/' + (vars.id || '') + '?secureToken=' + app.data.secureAccessToken, { json: true, options: { maxTries: 1 } }, function (e, r, b) {
			if (e) {
				console.error('kiosk/' + vars.action + '/' + (vars.id || '') + '', e.message, e.code, b)
				//res = 'error';
				//stat[order] = { status: 'error', message: e.message, code: e.code };
				cback({
					result: 'error',
					code: e.code,
					message: e.message
				});
				return;
			}
			cback(b);

		});

	}
	routeEvent(d) {

		switch (d.action) {
			case 'setAlwaysOnTop':
				self.win.setAlwaysOnTop(d.data == '1' ? true : false);
				break;
			case 'screenShot':
				console.log('Doing screenshot', d.data)
				if (self.isRunning) {
					self.win.capturePage(function (image) {
						console.log('captured screenshot', image)
						// do something with the base64string
						//sendToServer
						d.data.image = image;
						Pos.emit({
							data: {
								module: 'kiosk',
								action: 'screenShot',
								data: d.data
							}
						});
					}, { format: 'jpeg', datatype: 'datauri' });
				}
				break;
		}
	}
	onReady() {
		self.showWindow();
		//setTimeout(self.processOrders,5000);
	}

	appReady() {
		this.win.show();
	}

};
module.exports = Kiosk;