let
	CP = require('child_process'),
	crypto = require('crypto'),
	fs = require("fs-extra"),
	os = require('os');
process.send({ action: 'ready' });
let _doFile = (f) => {
	return new Promise((resolve) => {
		if (typeof f.cipher == 'undefined' || !f.cipher)
			f.cipher = 'sha1';
		let _fallBack = () => {
			var data = fs.readFileSync(f.path).toString();
			resolve(crypto.createHash(f.cipher).update(data).digest('hex'));
		}
		if (os.platform().indexOf('win') === 0) {
			CP.exec('Get-FileHash -Path "' + f.path + '" -Algorithm ' + f.cipher.toUpperCase() + ' | Select-Object Hash | Format-List', function (e, o, s) {
				if (e) console.log(e, o, s)
				if (o?.trim() && /hash[\s]+\:[\s]+([a-z0-9]+)/.test(o.trim().toLowerCase())) {
					let _d = o.trim().toLowerCase().split('\n').filter((a) => { return a?.indexOf('hash') != -1 });
					for (let d of _d) {
						let _m = d?.match(/hash[\s]+\:[\s]+([a-z0-9]+)/);
						if (_m?.[1]) {
							resolve(_m?.[1]?.trim());
							return;
						}
					}
				}
				CP.exec('certutil -hashfile "' + f.path + '" ' + f.cipher.toUpperCase(), function (e, o, s) {
					if (e) console.log(e, o, s)
					if (o?.trim() && o.indexOf('command completed successfully') != -1) {
						resolve(o?.trim().split('\n')[1].replace(/\s/g, ''));
						return;
					}
					_fallBack();
				});
			});
			return;
		}
		CP.exec(f.cipher + 'sum ' + f.path + " | awk -F ' ' '{print $1}'", function (e, o, s) {
			if (e) console.log(e, o, s)
			if (o?.trim()) {
				resolve(o?.trim());
				return;
			}
			CP.exec('openssl ' + f.cipher + ' ' + f.path + " | awk -F '= ' '{print $2}'", function (e, o, s) {
				if (e) console.log(e, o, s)
				if (o?.trim()) {
					resolve(o?.trim());
					return;
				}
				_fallBack();
			});
		})
	});
}
process.on('message', function (msg) {
	if (msg.action) {
		switch (msg.action) {
			case 'File':
				_doFile(msg).then((res) => {
					process.send({ action: 'completed', data: res });
					process.exit(0);
				})
				break;
			case 'String':
				if (typeof msg.cipher == 'undefined' || !msg.cipher)
					msg.cipher = 'sha1';
				try {
					process.send({ action: 'completed', data: msg.data ? crypto.createHash(msg.cipher).update(msg.data).digest('hex') : null });
				} catch (er) {
					console.error('Failed to hash string', er.message)
					fs.writeFile(msg.tmpFile, msg.data, function () {
						msg.path = msg.tmpFile;
						_doFile(msg).then((res) => {
							process.send({ action: 'completed', data: res });
							fs.unlink(msg.tmpFile, () => { process.exit(0); })

						})
					})
					return;
				}
				process.exit(0);
				break;
			default:
				console.log('message', msg);
		}
		return;
	}
	console.log('message', msg);
});