#!/bin/bash

SOURCE="${BASH_SOURCE[0]}"
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
  DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
  SOURCE="$(readlink "$SOURCE")"
  [[ $SOURCE != /* ]] && SOURCE="$DIR/$SOURCE" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
done
DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
DIR=${DIR/etc\/scripts\/update/}
cd $DIR

sleep 1
echo "`date`"
rm -Rf updater
rm -Rf libs
rm -Rf etc/scripts
rm -Rf package.nw
echo "STEP:UNZIP"
if [[ "$OSTYPE" == "darwin"* ]]; then
	cd /Applications
	rm AzimutPOS.app/Contents/Resources/app.nw/etc/urlOverride.txt
	unzip -o -q $DIR/updates/$1
	touch /Applications/AzimutPOS.app
	touch /Applications/AzimutPOS.app/Contents/Info.plist
	killall Dock
else
	unzip -o -q updates/$1
	find etc/scripts/ -name "*.sh" -exec chmod a+x {} \;
fi
echo "STEP:UNZIP_DONE"
sleep 2
echo "POS_UPDATE_DONE_NOW_RESTART"
exit 0