var app, prod = {
	init: function (parent, cback) {
		app = parent;
		try { prod.workstation = require('./workstation/workstation.js'); } catch (er) { console.error(er); }
		try { prod.workstation.init(parent); } catch (er) { console.error(er); }
		if (cback) cback();
	},
	routeEvent: function (d) {
		switch (d.action) {
			case 'event':
				try {
					let _data = app._m.xtend.clone(d.data);
					delete d.data;
					d = app._m.xtend.extend(d, _data);
					prod[d.module].routeEvent(d, cback);
				} catch (e) {
					console.warn('ERROR module POS.production.' + d.module + ' in app: ' + e.message);
				}
				break;
		}
	},
	serverwsEmit: function (d, cback) {
		app.pos.serverwsEmit({
			module: 'production',
			action: 'event',
			data: d
		}, cback);
	},
	emit: function (d, cback) {
		app.pos.emit({
			module: 'production',
			action: 'event',
			data: d
		}, cback);
	},
	exit: function () {
		prod.workstation.exit();
	}
};
module.exports = prod;