var app, self, _workers = {}, captureEvents = {};
module.exports = class camera {
	constructor(parent) {
		app = parent;
		self = this;
		self.feedStatus = {}
	}
	initialize(cback) {

		if (cback) cback();
		app.sessions.onConfigChange(function () {
			//config changed, start or stop worker

			if (app.pathExists(app, 'data.session.configs.advanced.security.camera.enabled') != '1') {
				//kill all
				for (_w of Object.keys(_workers)) {
					try { _workers[_w].send({ action: 'exit' }); } catch (er) { }
				}
				return false;
			}
			if (app.pathExists(app, 'data.session.configs.advanced.security.camera.feeds') && app.data.session.configs.advanced.security.camera.feeds.length) {
				app._m.async.eachSeries(app.data.session.configs.advanced.security.camera.feeds, function (f, n) {
					self._startWorker(f, function (enabled) {
						if (!enabled) {
							//destroy
							try { _workers[f.row].send({ action: 'exit' }); } catch (er) { }
						}
						//send new config
						try { _workers[f.row].send({ action: 'config', data: { cfg: app.cfg, camera: f } }); } catch (er) { }
						n();
					});
				}, function () {
					//if (onReady) onReady();
				})
			}
		})
	}
	setStatus(i, status, error) {
		let _changed = false, _lastDate = '';
		if (self.feedStatus[i] && self.feedStatus[i].status != '' + status) _changed = true;
		if (self.feedStatus[i] && self.feedStatus[i].updated) _lastDate = '' + self.feedStatus[i].updated;
		self.feedStatus[i] = {
			status: '' + status,
			updated: new Date().toISOString()
		}
		if (error) self.feedStatus[i].error = error;
		if (_changed) {
			//send to server

		}
	}
	startWorkers(onReady) {
		if (app.pathExists(app, 'data.session.configs.advanced.security.camera.enabled') != '1') {
			if (onReady) onReady();
			return false;
		}
		if (app.pathExists(app, 'data.session.configs.advanced.security.camera.feeds') && app.data.session.configs.advanced.security.camera.feeds.length) {
			app._m.async.eachSeries(app.data.session.configs.advanced.security.camera.feeds, function (f, n) {
				self._startWorker(f, n);
			}, function () {
				if (onReady) onReady();
			})
		}
	}
	_startWorker(f, onReady) {
		if (app.pathExists(app, 'data.session.configs.advanced.security.camera.enabled') != '1') {
			if (onReady) onReady(false);
			return false;
		}
		if (_workers[f.row] && _workers[f.row].workerIsReady) {
			if (app.pathExists(f, 'enabled') != '1' || app.pathExists(f, 'capture_on_login.enabled') != '1' && app.pathExists(f, 'capture_on_drawer.enabled') != '1') {
				//kill worker
				try { _workers[f.row].send({ action: 'exit' }); } catch (er) { }
				if (onReady) onReady(false);
				return false;
			}
			if (onReady) onReady(true);
			return true;
		}
		if (!_workers[f.row] && app.pathExists(f, 'enabled') == '1' && (app.pathExists(f, 'capture_on_login.enabled') == '1' || app.pathExists(f, 'capture_on_drawer.enabled') == '1')) {
			let url = f.url;
			self.setStatus(f.row, 'init');
			_workers[f.row] = app._m.childProcess.fork(__dirname + '/libs/capture.js');
			_workers[f.row].on('message', function (data) {
				data = app.JSON.parse(data);
				//console.log('Camera capture worker', data)
				//data=data.toString();
				switch (data.action) {
					case 'captureDebug':
						console.log('Security camera capture debug', f.row, data.data);
						break;
					case 'captureResult':
						captureEvents[data.data.id](data.data);
						setTimeout(function () {
							delete captureEvents[data.data.id];
						}, 1000 * 5);
						self.setStatus(f.row, 'running');
						break;
					case 'ready':
						//send config to child
						_workers[f.row].send({ action: 'config', data: { cfg: app.cfg, tmp_folder: app.tmp_folder, camera: f } });
						_workers[f.row].workerIsReady = true;

						self.setStatus(f.row, 'ready');
						if (onReady) onReady(true);
						break;
					case 'stream_stderr':
					case 'stream_error':
						let _msg = '';
						if (data.error) {
							_msg = data.error.message || data.error;
						}
						else if (data.data) {
							_msg = data.data;
						}

						if (_msg.code) {
							console.error(_msg.code, _msg)
							self.setStatus(f.row, 'error', _msg.code)
							return;
						}
						console.warn(data.action, data.data)
						break;
					case 'error':

						if (data.error && data.error.indexOf(url) != -1 && data.error.indexOf('Connection refused') != -1) {

							console.error(f.row, data.error)
							return;
						}
						console.warn('Security camera capture ERROR:', f.row, data.error);
						break;
					//default: console.log('GOT', data)
				}
			}).
				on('error', function (err) { console.error(f.row, err); }).
				on('exit', function (code, signal) {
					_workers[f.row].workerIsReady = false;
					self.setStatus(f.row, 'exit', signal)
					if (app.status != 'shutdown') {
						_workers[f.row] = null;
						self._startWorker(f);
					}
				});
			return true;
		}
		if (onReady) onReady(false)
		return false;
	}
	shutdown() {
		for (_w of Object.keys(_workers)) {
			try { _workers[_w].send({ action: 'exit' }); } catch (er) { }
		}

		try {
			let _modules = Object.keys(self);
			for (let i = 0; i < _modules.length; i++) {
				if (self[_modules[i]] && self[_modules[i]].shutdown)
					try { self[_modules[i]].shutdown(); } catch (er) { }
			}
		} catch (er) { }
	}
	capture(type, onFeedComplete, cback) {
		if (app.pathExists(app, 'data.session.configs.advanced.security.camera.enabled') != '1') {
			if (cback) cback(null);
			return false;
		}
		if (app.pathExists(app, 'data.session.configs.advanced.security.camera.feeds') && app.data.session.configs.advanced.security.camera.feeds.length) {
			let out = [];
			app._m.async.each(app.data.session.configs.advanced.security.camera.feeds, function (f, n) {
				if (app.pathExists(f, 'enabled') != '1' || app.pathExists(f, 'capture_on_' + type + '.enabled') != '1') {
					n();
					return;
				}
				self._startWorker(f, function (ready) {
					if (!ready) {
						n();
						return;
					}
					let id;
					do {
						id = app.system.uuid.get();
					} while (captureEvents[id]);
					captureEvents[id] = function (data) {
						//console.log(data);
						if (cback) out.push({ feed: f.row, images: data.images });
						if (onFeedComplete) onFeedComplete({ feed: f.row, images: data.images });
						n();
					};
					let imgsCnt = 1;
					imgsCnt += 1 * (app.pathExists(f, 'capture_on_' + type + '.images.before') || 0);
					imgsCnt += 1 * (app.pathExists(f, 'capture_on_' + type + '.images.after') || 0);
					_workers[f.row].send({ action: 'capture', data: { id: id, imgsCnt: imgsCnt, type: type } });
				});
			}, function () {
				if (cback) cback(out);
			})
			return;
		}
		if (cback) cback(null);
	}
};