#!/bin/bash
. /etc/environment

SOURCE="${BASH_SOURCE[0]}"
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
  DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
  SOURCE="$(readlink "$SOURCE")"
  [[ $SOURCE != /* ]] && SOURCE="$DIR/$SOURCE" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
done
DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"

IFACE=`lshw -class network | grep 'logical name:' | awk -F': ' '{print $2}' | head -n1`
MAC=`cat /sys/class/net/$IFACE/address`
MAC=${MAC//\:/}
MAC=${MAC^^}


CODE="$MAC"
if [ -f "~/AzimutPOS/var/cache/support_code" ];then
	CODE=`cat ~/AzimutPOS/var/cache/support_code | head -n 1 | xargs`
fi
while [ $# -gt 0 ]; do
  case "$1" in
    --code=*)
      CODE="${1#*=}"
      ;;
    *)
      printf "***************************\n"
      printf "* Error: Invalid argument.*\n"
      printf "***************************\n"
      exit 1
  esac
  shift
done
x11vnc -noxdamage -connect repeater://repeater.support.azimutpos.com:45500+ID:$CODE &
exit 0