var
	speedTest, app, _waitForBasic = [], isRunning = false, hasStarted = 0,
	diag = {
		initialized: false,
		initialize: function (parent, cback) {
			app = parent;
			diag.app = app;
			diag.initialized = true;
			try {
				speedTest = require('speedtest-net');

			} catch (er) {
				console.error('Could not load speedtest module', er)
			}
			let _result = { result: 'success', data: {} }
			diag.tasks.system.localNetwork(_result, function (basicData) {
				console.info('basic data diag', basicData)
				diag.basicData = basicData;

				if (['updating', 'shutdown'].indexOf(app.status) != -1) return;
				if (cback) cback();
				if (basicData.result == 'error') {
					//notify user
					diag.run();
					//or run diag screen
					return;
				}
				diag.tasks.system.dns(_result, function (nsRes) {
					if (['updating', 'shutdown'].indexOf(app.status) != -1) return;
					if (nsRes.rate < 50) {
						//diag.run();
						return;
					}
					diag.tasks.system.proxy(_result, function (proxRes) {
						if (['updating', 'shutdown'].indexOf(app.status) != -1) return;
						if (proxRes.result == 'error') {
							//diag.run();
							return;
						}
					});

				});
				if (_waitForBasic && _waitForBasic.length) {
					let _doCmd = function () {
						if (_waitForBasic && _waitForBasic.length) {
							try {
								_waitForBasic[0]();
							} catch (er) {
								console.error(er)
							}
							_waitForBasic.shift();
							process.nextTick(_doCmd);
						}
					};
					_doCmd();
				}
			});
			//diag.run();
			//diag.tasks.internet.speedtest();
		},
		waitForBasic: function (cback) {
			if (diag.basicData) {
				cback();
				return;
			}
			_waitForBasic.push(cback);
		},
		open: function (cback) {
			if (diag.win) {
				diag.win.show();
				if (cback) cback();
				return false;
			}
			if (isRunning) {
				console.warn('diag is already opened');
				return false;
			}
			if (['updating', 'shutdown'].indexOf(diag.app.status) != -1) return;
			isRunning = 1;
			//run diags and display,
			hasStarted = 0;
			//console.log('libs/diag/view/diag.html')
			nw.Window.open((diag.app._relativePath || (__dirname.indexOf('/source/') != -1 ? 'source/' : '') || '') + 'libs/diag/view/diag.html', {
				title: "Diag",
				frame: true,
				width: 800,
				height: 600
			}, function (win) {
				if (!win) {
					console.error('win not loaded')
					return;
				}
				diag.win = win;
				diag.app.pos.setToTop(false);
				win.setAlwaysOnTop(true);
				win.focus();
				win.setAlwaysOnTop(false);
				win.focus();

				win.window.message = function (d) {
					switch (d.action) {
						case 'run':
							diag.run();
							break;
						case 'runSpeedtest':
							diag.tasks.internet.speedtest.start();
							break;
					}
				};
				diag.win.on('loaded', function () {
					process.nextTick(function () {
						setTimeout(function () {
							if (cback) cback();
						}, 1000 * 2);
					});
				});
				win.on('close', function () {
					win.setAlwaysOnTop(false);
					win.hide();
					isRunning = false;
					//win.close();
					diag.app.pos.setToTop(true);
					diag.win = null;
				})
			});
		},
		routeEvent: function (d, cback) {
			switch (d.action) {
				case 'open':
					diag.open();
					break;
				case 'speedtest':
					diag.tasks.internet.speedtest.start(cback);
					break;
				case 'speedtestStarting':
					diag.tasks.internet.speedtest._isRunning = new Date().getTime();
					break;
				case 'speedtestCompleted':
					diag.tasks.internet.speedtest._lastResult = d.data;
					diag.tasks.internet.speedtest._isRunning = false;
					break;
			}
		},
		emit: function (d, cback) {
			app.web.emit({
				module: 'diag',
				action: d.action,
				data: d.data
			}, cback);
		},
		run: function () {
			diag.open(function () {
				if (hasStarted) {
					console.warn('diag is already running');
					return;
				}
				hasStarted = 1;
				let _result = {
					result: 'success',
					data: {}
				};
				if (diag.tasks.internet?.speedtest?._lastResult)
					app.diag.speedtest_report({ type: 'hasData', ...diag.tasks.internet.speedtest._lastResult });
				app._m.async.each([diag.tasks.system.init, diag.tasks.internet.init], function (f, n) {
					try {
						console.log(_result)
						f(_result, function () { n(); });
					}
					catch (er) {
						console.log('error', er.message || er);
						n();
					}
				}, function () {
					hasStarted = 0;
					console.log('DIAG ALL DONE', _result)
					//all done
				});
			});
			//system
			//check local network
			//check ping 8.8.8.8, 1.1.1.1, 1.0.0.1
			//check nslookup
			//check proxy
			//check public IP with https://api.ipify.org/

			//internet
			//check technopos api
			//is service connected? (socket)
			//socket ping
			//speedtest cli

			//technopos
			//check technopos answers

			//TPV
			//check tpv(s)

			//printers
			//check printers

			//devices
			//check neighborhood registers




		},
		dns_report: function (i, res) {
			if (diag.win && diag.win.window)
				diag.win.window.dns_report(i, res);
		},
		speedtest_report: function (res) {
			if (diag.win && diag.win.window)
				diag.win.window.speedtest_report(res);
		},
		efts: {
			set: function () { //app.diag.efts.set=()=>{
				let _efts = Object.keys(app.data?.session?.configs?.registers || {}).map((a) => {
					return {
						register: {
							id: a,
							name: app.data?.session?.configs?.registers[a].name
						},
						eft: app.data?.session?.configs?.registers[a]?.configs?.eft_device
					}
				}).filter((a) => a.eft.ip);

				//console.log('DOING printers.set')
				app._m.async.each(_efts, function (p, n) {
					try {

						setTimeout(() => {
							app.system.net.ping(p.eft.ip, function (pr) {
								if (diag?.win?.window) diag.win.window.updateEftField(p.register.id, 'status', pr.code || 'up')
								if (diag?.win?.window) diag.win.window.updateEftField(p.register.id, 'value', pr.ttl)
							});
						}, 500);
					} catch (er) { console.error('Error while parsing printer', er.message, p); }
					n();
				}, function () {
					try {
						if (diag?.win?.window) diag.win.window.setEftsTable(_efts);
					} catch (er) { console.error('Error setting diag.win.window.setEftsTable', er.message, _efts); }
				})
			},
			statusUpdate: function (d) { //diag.efts.statusUpdate= function (d) {
				//console.log('printer status update', d)

				if (diag?.win?.window && d.ipAddress) diag.win.window.updateEftField(d.id, 'ipAddress', d.ipAddress)
				if (diag?.win?.window && d.macAddress) diag.win.window.updateEftField(d.id, 'macAddress', d.macAddress)
				if (diag?.win?.window) diag.win.window.updateEftField(d.id, 'status', d.status)
				if (diag?.win?.window) diag.win.window.updateEftField(d.id, 'value', d.ttl)
			}
		},
		printers: {
			set: function () {
				let _p = app.pathExists(app, 'data.session.configs.printers');
				if (!_p || !_p.length) return;

				//console.log('DOING printers.set')
				var out = [];
				app._m.async.eachSeries(_p, function (p, n) {
					app.printManager.getPrinterStatus(p);
					try {
						if ([app.system.id, 'NETWORK'].indexOf(p.register) != -1 && p.deviceUri) {
							let _uri = p.deviceUri.match(/^(socket\:\/\/|)(\d{2,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/);
							//if (_uri[2]) {
							out.push({
								id: p.id,
								name: (app.pathExists(p, 'peripheralInfo.deviceName') || p.deviceName || p.name),
								macAddress: p?.latestStatus?.macAddress || p.macAddress || 'n/a',
								ipAddress: p?.latestStatus?.ipAddress || _uri?.[2] || 'n/a',
								status: p?.latestStatus?.status || app.pathExists(app.printManager, '_printerPingStatus.' + p.id + '.status') || '',
								ttl: p?.latestStatus?.ttl ?? app.pathExists(app.printManager, '_printerPingStatus.' + p.id + '.ttl') ?? '',
								paper: p?.paperStatus?.status
							});
							if (!p?.latestStatus?.ipAddress && _uri?.[2]) {
								//ping printer then update

								setTimeout(() => {
									app.system.net.ping(_uri[2], function (pr) {
										if (diag?.win?.window) diag.win.window.updatePrinterField(p.id, 'status', pr.code || 'up')
										if (diag?.win?.window) diag.win.window.updatePrinterField(p.id, 'value', pr.ttl)
									});
								}, 500);
							}
							//}
						}
					} catch (er) { console.error('Error while parsing printer', er.message, p); }
					n();
				}, function () {
					try {
						if (diag?.win?.window) diag.win.window.setPrintersTable(out);
					} catch (er) { console.error('Error setting diag.win.window.setPrintersTable', er.message, out); }

					try {
						app.printManager.checkNetworkPrintersIPAddresses();
					} catch (er) { console.error('Error running app.printManager.checkNetworkPrintersIPAddresses', er.message); }
				})
			},
			paperStatusUpdate: function (d) {
				if (!diag?.win?.window?.updatePrinterField) return false;
				console.log(d.id, d.paperStatus)
				diag.win.window.updatePrinterField(d.id, 'paper', d.paperStatus.status)
			},
			statusUpdate: function (d) { //diag.printers.statusUpdate= function (d) {
				//console.log('printer status update', d)
				if (!diag?.win?.window?.updatePrinterField) return false;
				if (d.ipAddress) diag.win.window.updatePrinterField(d.id, 'ipAddress', d.ipAddress)
				if (d.macAddress) diag.win.window.updatePrinterField(d.id, 'macAddress', d.macAddress)
				diag.win.window.updatePrinterField(d.id, 'status', d.status)
				diag.win.window.updatePrinterField(d.id, 'value', d.ttl)
			}
		},
		arp: {
			set: () => {
				let values = [];
				for (let i of Object.keys(app.system.net.arp._lastScan.values)) {
					let
						_ip = app.system.net.arp._lastScan.values[i],
						_p = (app.data?.session?.configs?.printers || []).filter((a) => a.macAddress == i || a.deviceUri && a.deviceUri.indexOf(_ip) != -1)?.[0],
						_reg = app.data?.session?.configs?.registers?.['REG-' + i.replace(/[^a-f0-9]/g, '').toUpperCase()];
					values.push({
						id: i.replace(/[^a-f0-9]/g, '').toUpperCase(),
						macAddress: i,
						ipAddress: _ip,
						type: _reg ? 'register' : (_p ? 'printer' : ''),
						name: _reg?.name || _p?.name || _p?.peripheralInfo?.devicename || '',
						ping: app.system._data._pingHosts[_ip]?.result == 'success' ? app.system._data._pingHosts[_ip].ttl : 'n/a'
					})
				}
				try {
					if (diag?.win?.window) diag.win.window.setARPTable({ date: app.system.net.arp._lastScan.date, values });
				} catch (er) { console.error('Error setting diag.win.window.setARPTable', er.message, app.system.net.arp._lastScan); }
			}
		},
		report: function (id, status, value) {
			//console.warn('DIAG REPORT', id, status, value);
			if (diag?.win?.window?.report)
				diag.win.window.report(id, status, value);
		},
		tasks: {
			system: {
				init: function (_result, done) {
					console.log('DOING system.init', _result.result)
					if (_result.result == 'error') {
						done();
						return;
					}
					_result.data.system = {};
					app._m.async.each([diag.tasks.system.localNetwork, diag.tasks.system.dns, diag.tasks.system.proxy], function (f, n) {
						try {
							f(_result, function () { process.nextTick(n); });
						}
						catch (er) {
							console.log('error', er.message)
						}
					}, function () {
						console.log('DONE system.init', _result.result)
						process.nextTick(function () {
							try { diag.printers.set(); } catch (er) { console.error('error in printers.set', er.message); }
							try { diag.efts.set(); } catch (er) { console.error('error in efts.set', er.message); }
							try { diag.arp.set(); } catch (er) { console.error('error in arp.set', er.message); }

							//all done
							process.nextTick(function () {
								done();
							});
						});
					});
				},
				localNetwork: function (_result, done) {
					//console.log('DOING system.localNetwork', _result.result)
					if (_result.result == 'error') {
						done();
						return;
					}
					var iface = null, gw = null, ifaceInfo = null, pingres = null, interfaces = null, result = {
						result: 'success'
					};

					//check we have a gateway
					//check we have an IP
					//check gateway answers
					let fcts = [
						function (n) {
							diag.report('system_gateway', 'inprogress', 'running...');
							try {
								let dg = require('default-gateway');
								dg.v4().then(function (g) {
									diag.report('system_gateway', g ? 'success' : 'error', g.gateway);
									if (!g) {
										result.result = 'error';
										n();
										return;
									}
									gw = '' + g.gateway;
									iface = g.interface;
									n();
								}).catch(function (err) {
									console.error('Get system gateway error: ' + err.message);
									result.result = 'error';
									diag.report('system_gateway', 'error', '' + err.message);
									n();
								});
							}
							catch (e) {
								diag.report('system_gateway', 'error', '' + e.message);
								result.result = 'error';
								n();
								return;
							}
						},
						function (n) {
							if (result.result == 'error') {
								n(); return;
							}
							diag.report('system_ipaddress', 'inprogress', 'running...');
							try {
								//app.system.net.getDefaultInterface().then((iface) => {
								let
									ni = app.system.net.getInterfaces();
								ifaceInfo = ni?.[iface];
								interfaces = Object.values(ni)
								if (ifaceInfo) {
									diag.report('system_ipaddress', 'success', ifaceInfo.cidr);
									n();
									return;
								}

								result.result = 'error';
								diag.report('system_ipaddress', 'error', 'Problem to get interface "' + iface + '" details');
								n();
								//})
								return;

							} catch (er) {
								console.error('os.networkInterfaces() error', er.message || er)
							}
							result.result = 'error';
							diag.report('system_ipaddress', 'error', 'Interface not found');
							n();
							//console.log(ni)
						},
						function (n) {
							if (result.result == 'error') {
								n(); return;
							}
							if (!gw) {
								diag.report('system_gateway_ping', 'error', 'gateway not found');
								result.result = 'error';
								n();
								return;
							}
							diag.report('system_gateway_ping', 'inprogress', 'running...');
							try {
								app.system.net.ping(gw, function (pr) {
									pingres = pr;
									//console.log(pingres)
									diag.report('system_gateway_ping', pingres.result, pingres.code || pingres.ttl);
									n();
								})
							} catch (er) {
								diag.report('system_gateway_ping', 'error', '');
								console.error(er);
								n();
							}
						}
					];
					app._m.async.eachSeries(fcts, function (f, n) {
						try {
							f(n);
						} catch (er) {
							console.error(er)
						}
					}, function () {
						_result.result = result.result;
						_result.data.system = {
							..._result.data.system,
							result: result.result,
							interface: iface,
							ipAddress: ifaceInfo ? ifaceInfo.address : null,
							cidr: ifaceInfo ? ifaceInfo.cidr : null,
							gateway: gw,
							gwPing: pingres,
							defaultRoute: app.system.vars.defaultRoute,
							interfaces: interfaces
						};
						console.info('DONE system.localNetwork', _result.result)
						process.nextTick(function () {
							done(_result.data.system);
						});
					});


				},
				dns: function (_result, done) {
					console.info('DOING system.dns', _result.result)

					if (_result.result == 'error') {
						done();
						return;
					}
					//check we have NS servers
					//check ns answers
					//nslookup google.ca
					diag.report('ns_results', 'inprogress', '');
					try {
						let dns = require('dns');
						let ns = dns.getServers(), out = {};
						let dns_svrs = [];
						for (let i = 0; i < ns.length; i++) {
							dns_svrs.push({
								index: i,
								type: 'local',
								address: ns[i]
							});
						}
						if (!dns_svrs.filter(function (a) { return a.address == '8.8.8.8' }).length)
							dns_svrs.push({
								index: dns_svrs.length,
								type: 'remote',
								address: '8.8.8.8'
							});
						if (!dns_svrs.filter(function (a) { return a.address == '1.1.1.1' }).length)
							dns_svrs.push({
								index: dns_svrs.length,
								type: 'remote',
								address: '1.1.1.1'
							});
						console.info('DNS SERVERS', dns_svrs)

						let _table = '<table class="table">' +
							'<tbody>';
						for (let i = 0; i < dns_svrs.length; i++) {
							_table += '<tr data-row="' + i + '" data-address="' + dns_svrs[i].address + '">' +
								'<td>' + dns_svrs[i].address + '</td>' +
								'<td class="dns_status">in progress</td>' +
								'<td class="dns_result"></td>' +
								'</tr>';
						}
						_table +=
							'</tbody>' +
							'</table>';
						diag.report('ns_results', 'inprogress', _table);
						let success = 0, error = 0;
						app._m.async.each(dns_svrs, function (s, n) {
							let _nsfcts = [
								function (nn) {
									try {
										app.system.net.ping(s.address, function (pr) {
											try {
												dns_svrs[s.index].pingres = pr;
											} catch (er) { console.error(er.message) }
											//diag.report('system_gateway_ping', pingres.result, pingres.code || pingres.ttl);
											nn();
										});
									} catch (er) { console.error('Error ping dns server ' + s.address, er.message) }
								},
								function (nn) {
									//console.log('ns resolve', s.address)
									try {
										app.system.net.dnsResolve({
											domain: 'google.ca',
											type: 'A',
											server: s.address
										}, function (r) {
											//console.log('ns resolved', s.address, r)
											if (s.type == 'local') {
												if (r.result == 'success') success++; else error++;
											}

											try {
												dns_svrs[s.index].result = r;
											} catch (er) { console.error(er.message) }
											//dns_svrs[s.index].result = r;
											nn();
										})
									} catch (er) { console.error('Error resolving google.ca on ' + s.address, er.message) }
								}
							];
							app._m.async.each(_nsfcts, function (f, nn) {
								f(nn);
							}, n);

						}, function () {
							let _rate = error ? (success ? (success / error) * 100 : 0) : 100;
							diag.dnsCheck = {
								result: _rate > 0 ? 'success' : 'error',
								rate: _rate,
								results: dns_svrs
							}
							for (let i = 0; i < dns_svrs.length; i++) {
								diag.dns_report(i, dns_svrs[i]);
							}
							console.info('DONE system.dns', _result.result)
							_result.result = '' + diag.dnsCheck.result;
							_result.data.system.dnsCheck = diag.dnsCheck;
							diag.report('ns_results', diag.dnsCheck.result, 'SKIP');
							//console.log('ns results', _rate, dns_svrs);
							if (done) done(diag.dnsCheck);
						})
					} catch (er) { console.error('DNS not available.', er.message || er) }

					//compare results
				},
				proxy: function (_result, done) {
					console.info('DOING system.proxy', _result.result)
					if (_result.result == 'error') {
						done();
						return;
					}
					//detect proxy,
					//test proxy
					//check public ip https://api.ipify.org/
					diag.report('proxy_results', 'inprogress', '...');
					try {
						const { getProxySettings, getAndTestProxySettings } = require("get-proxy-settings");
						getProxySettings().then(function (prox) {
							diag.proxy = prox;
							let prox_txt = '<b>No proxy set</b><br/>';
							if (prox && prox.https) {
								console.info(prox.https)
								prox_txt = 'Proxy address: <b>' + prox.https.protocol + '://' + prox.https.host + ':' + prox.https.port + '</b><br/>';
								//oh no!
							}
							let _ipTries = 0, _tryIp = function () {
								_ipTries++;
								app.system.request.GET('https://api.ipify.org/', { timeout: 1000 * 15, noRetry: 1 }, function (err, res, body) {
									if (err && err.code) {
										console.error(err.code, err.message)

										diag.report('proxy_results', 'error', prox_txt + err.code + ' ' + err.message);
										if (_ipTries < 5) {
											_tryIp();
											return;
										}
										//tam tam tammmm
										_result.result = 'error';
										_result.data.system.proxy = {
											address: prox_txt,
											error: err.code + ' ' + err.message
										};
										//console.log('DONE system.proxy', _result.result)
										done({
											result: 'error'
										})
										return;
									}
									diag.report('proxy_results', 'success', prox_txt + 'Public IP:' + body);

									_result.data.system.proxy = {
										address: prox_txt,
										ipAddress: body
									};
									console.info('DONE system.proxy', _result.result, body)
									done({
										result: 'success'
									})
								})
							};
							_tryIp();

						});
					} catch (er) { console.error('Cant process proxy settings', er.message || er) }
				}
			},
			internet: {
				init: function (_result, done) {
					console.info('DOING internet.init', _result.result)
					if (_result.result == 'error') {
						done();
						return;
					}
					_result.data.cloud = {};
					app._m.async.each([diag.tasks.internet.api, diag.tasks.internet.socket, diag.tasks.internet.posSocket], function (f, n) {
						try {
							f(_result, n);
						}
						catch (er) {
							console.error('error', er.message)
						}
						//diag.tasks.internet.speedtest.start();
					}, function () {
						console.info('DONE internet.init', _result.result)
						//all done
						done();
					});
				},
				api: function (_result, done) {
					console.info('DOING internet.api (cloud)', _result.result)
					if (_result.result == 'error') {
						done();
						return;
					}
					_result.data.cloud.api = {};
					diag.report('cloudapi_status', 'inprogress', '');
					let _start = new Date().getTime();
					app.system.request.GET(app.web.url + '/api/status', { options: { maxTries: 1 } }, function (e, r, data) {
						let _ttl = ((new Date().getTime() - _start) / 1000);
						if (e) {
							diag.report('cloudapi_status', 'error', e ? e.code + ': ' + e.message : data);
							_result.result = 'error';
							_result.data.cloud.api = {
								status: e ? e.code + ': ' + e.message : data,
								ttl: _ttl
							};
							done();
							return;
						}
						if (data && data.trim() == 'OK') {
							//service is OK
							_result.data.cloud.api = {
								status: data,
								ttl: _ttl
							};
							done()
							diag.report('cloudapi_status', 'success', data + ' in ' + _ttl + 's');
							return;
						}
					})
				},
				socket: function (_result, done) {
					console.info('DOING internet.socket (cloud)', _result.result)
					if (_result.result == 'error') {
						done();
						return;
					}
					_result.data.cloud.socket = {
						status: app.web.status,
						ttl: app.web.lastPing?.ttl
					};
					diag.report('cloudsocket_status', app.web.status ?? 'offline', (app.web.lastPing?.ttl ?? -1) + 's');
					done()
				},
				posSocket: function (_result, done) {
					console.info('DOING internet.posSocket (cloud)', _result.result)
					if (_result.result == 'error') {
						done();
						return;
					}
					_result.data.cloud.pos = {
						status: app.pos.serverWS.status,
						ttl: app.pos.serverWS?.lastPing?.ttl
					};
					diag.report('pos_status', app.pos.serverWS.status ?? 'offline', (app.pos.serverWS?.lastPing?.ttl ?? -1) + 's');
					done()
				},
				ping: function (_result, done) {

				},
				speedtest: {
					_lastResult: null,
					_whenDone: [],
					getServersList: async () => {
						return new Promise(async (resolve) => {
							//https://192.168.94.1/public_html/speedtest_servers.json
							app.system.request.GET('https://192.168.94.1/public_html/speedtest_servers.json', { noRetry: 1, timeout: 1000 * 5 }, function (e, r, b) {
								if (b) {
									b = app.system.JSON.parse(b);
									if (b?.date && b?.servers) {
										resolve(b);
										return;
									}
								}
								let out;
								try {
									out = app.system.JSON.parse(app._m.fs.readFileSync(__dirname + '/data/default_speedtest_servers.json'));
								} catch (er) { }
								resolve(out?.servers ? out : {
									servers: [{
										"url": "http://montreal2.speedtest.telus.com:8080/speedtest/upload.php",
										"lat": "45.5017",
										"lon": "-73.5673",
										"name": "Montréal, QC",
										"country": "Canada",
										"cc": "CA",
										"sponsor": "TELUS Mobility",
										"id": "24707",
										"host": "montreal2.speedtest.telus.com:8080",
										"ip": "206.162.134.23"
									},
									{
										"url": "http://mobilityooklalongueuil.srvr.bell.ca:8080/speedtest/upload.php",
										"lat": "45.5369",
										"lon": "-73.5107",
										"name": "Longueuil, QC",
										"country": "Canada",
										"cc": "CA",
										"sponsor": "Bell Mobility",
										"id": "52352",
										"host": "mobilityooklalongueuil.srvr.bell.ca:8080",
										"ip": "209.71.219.21"
									},
									{
										"url": "http://speedtest1.mtl.qc.convergia.ca:8080/speedtest/upload.php",
										"lat": "45.4500",
										"lon": "-73.8167",
										"name": "Pointe-Claire, QC",
										"country": "Canada",
										"cc": "CA",
										"sponsor": "Convergia Networks Inc",
										"id": "7015",
										"host": "speedtest1.mtl.qc.convergia.ca:8080",
										"ip": "192.81.84.14"
									},
									{
										"url": "http://wirelineooklalongueuilvirtual.srvr.bell.ca:8080/speedtest/upload.php",
										"lat": "45.5914",
										"lon": "-73.4364",
										"name": "Boucherville, QC",
										"country": "Canada",
										"cc": "CA",
										"sponsor": "Bell Canada",
										"id": "52028",
										"host": "wirelineooklalongueuilvirtual.srvr.bell.ca:8080",
										"ip": "209.71.219.69"
									}]
								})
							});
						});
					},
					start: async (options) => { //app.diag.tasks.internet.speedtest.start=async () => {
						return new Promise(async (resolve) => {
							let _sp = app.diag.tasks.internet.speedtest;
							if (_sp._isRunning && _sp._isRunning > new Date().getTime() - 1000 * 60 * 3) {
								//append to result queue
								_sp._whenDone.push(resolve);
								return false;
							}
							_sp._isRunning = new Date().getTime();
							let _lr = _sp._lastResult;
							if (_lr?.timestamp && _lr.timestamp.getTime() > new Date().getTime() - 1000 * 60 * 5) {
								console.warn('a speedtest has already been run in the last 5 minutes.');
								resolve(_lr);
								return;
							}
							console.info('running speedtest')
							app.pos.neighbors.broadcast({
								module: 'diag',
								action: 'speedtestStarting',
								data: {
									type: 'init'
								}
							});
							app.diag.emit({
								action: 'speedtest_starting'
							});

							try {
								let
									_servers = await app.diag.tasks.internet.speedtest.getServersList(),
									_serverId = _servers?.servers?.[app.system.randomInt(0, (_servers?.servers?.length || 1) - 1)]?.id || '24707';
								//console.log('Speedtest using', { servers: _servers?.servers, id: _serverId })
								let
									testResult = await speedTest({
										verbosity: 0,
										serverId: _serverId,
										acceptLicense: true,
										acceptGdpr: true,
										config: function (c) {
											console.log('got config', c)
										},
										progress: function (p) {
											_sp._isRunning = new Date().getTime();
											if (typeof p?.download?.bandwidth != 'undefined') p.download.humanSized = app.system.humanSize(p.download.bandwidth * 8) + '/s';
											if (typeof p?.upload?.bandwidth != 'undefined') p.upload.humanSized = app.system.humanSize(p.upload.bandwidth * 8) + '/s';
											app.diag.speedtest_report(p);
										},
										log: console.log,
										...options
									});

								if (typeof testResult?.download?.bandwidth != 'undefined') testResult.download.humanSized = app.system.humanSize(testResult.download.bandwidth * 8) + '/s';
								if (typeof testResult?.upload?.bandwidth != 'undefined') testResult.upload.humanSized = app.system.humanSize(testResult.upload.bandwidth * 8) + '/s';
								let
									_ds = app.system.humanSize(testResult?.download?.bandwidth * 8) + '/s',
									_us = app.system.humanSize(testResult?.upload?.bandwidth * 8) + '/s';
								console.info('speedtest has completed, down:', _ds, 'up:', _us)
								//console.log('RESULT', r)
								_sp._lastResult = testResult;
								_sp._isRunning = false;
								//send to olo
								app.diag.emit({
									action: 'speedtest_result',
									data: testResult
								});
								app.diag.speedtest_report({ type: 'report', ...testResult });
								//bcast to neighbors
								app.pos.neighbors.broadcast({
									module: 'diag',
									action: 'speedtestCompleted',
									data: testResult
								});

								//call whendone
								let _doDone = function () {
									if (_sp._whenDone.length) {
										try {
											_sp._whenDone[0](testResult);
										} catch (er) {

										}
										_sp._whenDone.shift();
										_doDone();
									}
								}
								_doDone();
								resolve(testResult);
							} catch (err) {
								console.log('Error launching speedtest: ' + err.message, err);
								app.diag.emit({
									action: 'speedtest_error',
									data: err.message
								});
								resolve({ result: 'error', message: err.message })
							}
						});
					}
				}
			}
		}
	};
module.exports = diag;