/**
 * Parses each row in the arp table into { name, ip, mac } on win32.
 */
module.exports = function parseRow(row, servers) {
	if (!row) return;
	var chunks = row.trim();
	if (!chunks) return;
	chunks = chunks.split(/\s+/g).filter(function (el) { return el.length > 1 })

	// Parse name.
	var ipAddress = chunks[0]
	// Only resolve external ips.
	if (!ipAddress || servers.indexOf(ipAddress) != -1) {
		return
	}
	//filter "invalid local ip address"
	if (ipAddress.split('.')[0] > 198) return;

	// Parse mac
	var macAddress = chunks[1].replace(/-/g, ':')
	// Ignore unresolved hosts.
	if (macAddress === '(incomplete)' || macAddress.length < 17 || macAddress == 'ff:ff:ff:ff:ff:ff') {
		return
	}

	return {
		name: '?', // unresolved
		ip: ipAddress,
		mac: macAddress
	}
}
