var app, self;
module.exports = class Splashscreen {
	constructor(parent) {
		//Setting splascScreen url
		if (parent) {
			app = parent;
		}
		this.url = (app._relativePath || (__dirname.indexOf('/source/') != -1 ? 'source/' : '') || '') + 'libs/splashscreen/splashscreen.html';
		self = this;
		self.timedOut = false;
		self._ready = false;
		self._data = {};
		self._step = 0;
		self._delay = 0;
		self._steps = 4;
	}
	initialize(cback) {
		nw.Window.open(self.url, {
			title: "AzimutPOS is starting",
			position: "center",
			frame: false,
			resizable: false,
			width: 635,
			height: 635
		}, function (win) {
			self.win = win;
			win.setPosition('center');
			self.win.on('loaded', function () {
				win.show();
				win.setPosition('center');
				self.setMessage('init', app.parseLocales('splash.startup_steps.init'));
				win.window.lang = app.locale.split('_')[0]
				try {
					cback();
				} catch (er) {
					console.error(er)
				}
				win.show();
				//wait for main thread to call step1

				win.on('focus', function () {
					win.hasFocus = true;
				});
				win.on('blur', function () {
					win.hasFocus = false;
				});
				win.window.message = function (d) {
					switch (d.action) {
						case 'runSystemDiag':
							app.diag.run();
							break;
						case 'checkForUpdates':
							app.system.update.check();
							break;
						case 'close':

							app.exit(0);
							break;
					}
				};
				win.window.openNetworkSettings = function () {
					if (app.cfg.platform.indexOf('win') === 0) {
						app._m.exec('msdt.exe -id NetworkDiagnosticsNetworkAdapter', () => { })
					}
					if (app.cfg.platform.indexOf('linux') === 0) {
						app._m.exec('nm-connection-editor', () => { })
					}
					if (app.cfg.platform.indexOf('osx') === 0) {
						app._m.exec('open /System/Library/PreferencePanes/Network.prefPane/', () => { })
					}
				};
				if (app.cfg.platform.indexOf('win') === 0)
					app._m.exec('tasklist /v /FO csv | find /i "Azimut"', function (e, r, s) {
						if (e) console.log('Error loading tasklist', e)
						if (r) {
							r = app._m.csv.parse(r, {}, function (err, data) {
								let _data = data?.filter((a) => { return a[8].indexOf('AzimutLauncher') != -1 })
								if (_data?.length) {
									for (let i of _data) {
										app._m.exec('taskkill /F /PID ' + i[1]);
									}
								}
								//console.log('process list', err, data, );
							});

						}
					})
			});

			self.win.on("closed", function () {
				clearInterval(self.splash_timeout);
			});
		});
	}
	step1() {
		var _channel = app.pathExists(app, 'data.session.configs.advanced.updates.channel');
		if (!_channel) _channel = '' + app.cfg.channel.split('/').pop();
		self.win.window.setVersion(app.cfg.version + ' (' + (_channel ? _channel + '/' : '') + app.cfg.platform + ')' + (process.versions["nw-flavor"] == 'sdk' ? ' SDK' : '') + ' ' + app._m.moment(app.cfg.buildDate).format('YYMMDD-HHmmss'));
		self.win.window.setBuildYear(app._m.moment(app.cfg.buildDate).format('YYYY'));
		self.setMessage('gathering_infos', app.parseLocales('splash.startup_steps.gathering_infos'));
		self.win.window.setProgress(5);
		//self.win.window.setMessage(app.parseLocales('splash.startup_steps.checking_updates'));
	}
	step2() {
		self.win.window.unsetMessage('init');
		self.win.window.setProgress(20);
		if (self._step == self._steps) {
			self._loaded = true;
		}
		self._data.screens = self.getScreens();
		self.win.window.setProgress(30);

		app.web.emit({
			volatile: 1,
			module: 'sessions',
			action: 'startup_sequence',
			data: {
				module: 'splashscreen',
				action: 'gathering_printers'
			},
			eventLoop: app.eventLoopLag._current,
			uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
			cpuInfo: app.system.vars.systemInfo.cpu
		});
		self.setMessage('gathering_printers', app.parseLocales('splash.startup_steps.gathering_printers'));
		self.win.window.unsetMessage('gathering_infos');
		let _printersLoaded = false;
		setTimeout(() => {
			if (_printersLoaded) return;
			_printersLoaded = true;
			self.step3();
			clearInterval(printerInterval);
		}, 1000 * 20);
		let printerInterval = setInterval(() => {
			if (_printersLoaded) {
				clearInterval(printerInterval)
				return;
			}
			self.setMessage('gathering_printers', app.parseLocales('splash.startup_steps.gathering_printers'));
		}, 1000)
		self.getPrinters().then((printers) => {
			self._data.printers = printers;
			if (self._step == self._steps) {
				self._loaded = true;
			}

			if (_printersLoaded) return;
			_printersLoaded = true;
			self.win.window.setProgress(50);
			self.step3();
			clearInterval(printerInterval)
		});
		self.setMessage('generating_rsa', app.parseLocales('splash.startup_steps.generating_rsa'));
		app.web.waitForKeys(() => {
			self.win.window.unsetMessage('generating_rsa');

		});
	}
	step3() {

		self.win.window.setProgress(70);
		self.win.window.unsetMessage('gathering_printers');
		self.initialized();
		app.web.emit({
			volatile: 1,
			module: 'sessions',
			action: 'startup_sequence',
			data: {
				module: 'splashscreen',
				action: 'generating_rsa'
			},
			eventLoop: app.eventLoopLag._current,
			uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
			cpuInfo: app.system.vars.systemInfo.cpu
		});
	}

	initialized() {
		self._data.macAddress = app.system._data.macAddress;
		app.utilities = self._data;
		clearInterval(self.splash_timeout);
		if (self.isInitialized) {
			console.error('ALREADY INITIATED')
			return;
		}
		self.isInitialized = true;

		let _configLoaded = false, _loadedFromCache = false, _loadFromCacheTimer = setTimeout(function () {
			if (_configLoaded) return false;
			console.warn('splashscreen config _loadFromCacheTimer');
			app.localConfig.get(function (data) {
				if (data) {
					console.warn('Session from cloud timed out, using last saved config');
					//if (app.pathExists(app.data.session, 'licence.mode')) return;
					_loadedFromCache = true;
					app.data.session = data;
					_parseConfigAndRun();
					//if (app.data.session.result == 'success') {
					//	_startPOS();
					//}
				}
			});
		}, 1000 * 30),
			_licenceIsOnHold = () => {
				console.warn('LICENCE IS ON HOLD.')
				app.splashscreen.win.window.setOnHold({ message: app.parseLocales('splash.licence.onHold.message') });
				app.web.emit({
					volatile: 1,
					module: 'sessions',
					action: 'startup_sequence',
					data: {
						module: 'splashscreen',
						action: 'licence_warning',
						message: 'licence is on hold.'
					},
					eventLoop: app.eventLoopLag._current,
					uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
					cpuInfo: app.system.vars.systemInfo.cpu
				});
			},
			_startPOS = function () {
				clearTimeout(_loadFromCacheTimer);
				console.log('splashscreen _startPOS called')
				self.unsetMessage('activationWizard');
				let _daysLeft = app.data?.session?.licence?.daysLeft ?? 9999;
				if (app.pathExists(app.data.session, 'licence.mode') == 'trial') {
					setTimeout(function () {
						console.log('splashscreen _startPOS calling app.startPOS with config');//, app.data.session.configs)
						app.startPOS(app.data.session.configs);
					}, 3 * 1000);

					if (app.pathExists(app.data.session, 'licence.daysLeft'))
						_daysLeft = '<br/>' + app.data.session.licence.daysLeft + ' ' + app.parseLocales('splash.licence.trial.days_left');
					self.setMessage('licence_trial', app.parseLocales('splash.licence.trial.label') + _daysLeft);
					console.log('splashscreen _startPOS is trial', app.data.session.licence.daysLeft, ' days left');
					app.web.emit({
						volatile: 1,
						module: 'sessions',
						action: 'startup_sequence',
						data: {
							module: 'splashscreen',
							action: 'licence_warning',
							message: 'Licence is trial, ' + app.data.session.licence.daysLeft + ' days left'
						},
						eventLoop: app.eventLoopLag._current,
						uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
						cpuInfo: app.system.vars.systemInfo.cpu
					});
					return;
				}
				//if (app.pathExists(app.data.session, 'licence.overdue')) {
				//	try {
				//		let _expdate = app._m.moment(app.data.session.licence.onHoldDate + 'T06:00:00.000Z').tz(app.data.session.configs.location.timezone || 'America/New_York').startOf('day').add(-1, 'days').endOf('day');
				//		_daysLeft = _expdate.diff(app._m.moment().tz(app.data.session.configs.location.timezone || 'America/New_York').startOf('day'), 'days');
				//	} catch (er) { console.error(er.message + ' while calculating overdue days') }
				//
				//}
				if (app.pathExists(app.data.session, 'licence.onHold') || app.pathExists(app.data.session, 'licence.overdue') && !_daysLeft) {

					console.warn('LICENCE IS ON HOLD.')
					return;
				}
				if (app.pathExists(app.data.session, 'licence.overdue') && _daysLeft <= 10) {

					console.warn('LICENCE IS OVERDUE, ' + _daysLeft + ' days left.')
					let _message = app.parseLocales('splash.licence.overdue.message') + '<br/><br/>' + _daysLeft + ' ' + app.parseLocales('splash.licence.trial.days_left');
					app.splashscreen.win.window.setOverdue({ message: _message, daysLeft: _daysLeft }, function () {

						app.startPOS(app.data.session.configs);
					});

					app.web.emit({
						volatile: 1,
						module: 'sessions',
						action: 'startup_sequence',
						data: {
							module: 'splashscreen',
							action: 'licence_warning',
							message: 'Account is overdue, ' + _daysLeft + ' days left'
						},
						eventLoop: app.eventLoopLag._current,
						uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
						cpuInfo: app.system.vars.systemInfo.cpu
					});
					return;
				}
				//return;
				console.log('splashscreen _startPOS calling app.startPOS with config')
				//app.data.session.configs
				app.startPOS(app.data.session.configs);
			},
			_parseConfigAndRun = function () {
				_configLoaded = true;
				clearTimeout(_loadFromCacheTimer);
				//init pos.neighbors
				//app.pos.neighbors.initialize();
				if (app.data.session.result == 'wizard') {
					console.log('splashscreen doWhenInit show wizard')
					app.splashscreen.showWizard(app.data.session.code);
				} else if (app.data.session.result == 'success') {
					self.unsetMessage('activationWizard');
					console.log('splashscreen doWhenInit success, call _startPOS')
					//sessions.socketIndexes[d.socket.id]
					//return;
					_startPOS();
				} else if (app.data.session.result == 'error') {
					self.unsetMessage('activationWizard');
					_configLoaded = false;
					console.log('splashscreen doWhenInit ERROR', app.data.session)
					if (app.data.session?.licence?.onHold)
						_licenceIsOnHold();
					else
						app.splashscreen.showError(app.data.session.code);
				}
				app.printManager.checkNetworkPrintersIPAddresses();
			};
		app.sessions.doWhenInit(function () {
			clearTimeout(_loadFromCacheTimer);
			console.log('splashscreen doWhenInit')
			if (_loadedFromCache) return;
			_parseConfigAndRun();

		});
		if (!app.sessions.initSent) {
			app.sessions.init();
		}
		app.sessions.onLicenceChange(function () {
			console.log('licence changed, _parseConfigAndRun')
			_parseConfigAndRun();
		})

	}

	appReady() {
		this.win.close();
	}

	getMACs(cback) {
		const macs = app._m.os.networkInterfaces();
		console.log(macs);
		console.log(Object.keys(macs));
		Object.keys(macs).map(function (key) {
			console.log(key)
		});
		var addr = '';
		// For each interface
		Object.keys(macs).map(function (key) {

			// For each address
			macs[key].forEach(function (element) {
				let mac = element.mac;
				if (mac != "00:00:00:00:00:00") {
					addr = mac;
					return false;
				}
				if (addr != '')
					return false;
			});
		});

		cback(addr.replace(/:/g, '').toUpperCase());
	}

	async getPrinters() { //app.splashscreen.getPrinters=async()=>{
		return new Promise(async (resolve) => {

			var v = app.pathExists(app.system, 'net.arp._lastScan.values') || {};
			try {
				let _skips = ['ToFile', 'PDF', 'Fax', 'OneNote', 'Fax', 'Foxit Phantom', 'Microsoft XPS', 'AnyDesk'],
					_fileData = { date: new Date().toISOString(), detected: [] };

				let _cupsUris = {};
				if (app.cfg.platform == 'linux64') {
					await new Promise((res) => {
						app._m.exec("lpstat -t", function (e, o, w) {
							if (o) {
								let lines = o.trim().split('\n').filter((a) => a.indexOf('device for ') === 0).map((a) => {
									let _parts = a.trim().match(/device for ([a-zA-Z0-9\-_\@\.]+)\: ([a-zA-Z0-9\-_\@\.\:\/]+)$/)
									return _parts ? { device: _parts[1], uri: _parts[2] } : null;
								}).filter((a) => a)
								for (let i of lines) {
									_cupsUris[i.device] = i.uri;
								}
								//console.log('_cupsUris', _cupsUris)
							}
							res();
						})
					})
				}
				app.splashscreen.win.getPrinters(async (printers) => {
					let out = [];
					_fileData.detected = printers;
					app.splashscreen._data._detected_printers = printers;
					for (let p of printers) {
						//console.log(p);
						if (app.pathExists(p, 'printerOptions.cups-browsed') == 'true') {
							p.skipped = 'cups-browsed';
							continue;
						}
						if (app.pathExists(p, 'printerOptions.printer-is-temporary') == 'true') {
							p.skipped = 'printer-is-temporary';
							continue;
						}
						let _skipped = _skips.filter((a) => {
							return p.deviceName == a || p.deviceName.indexOf(a) != -1 ||
								app.pathExists(p, 'printerOptions.printer-make-and-model') && p.printerOptions['printer-make-and-model'].indexOf(a) != -1;
						})
						if (_skipped?.length) {
							p.skipped = _skipped;
							continue;
						}
						if (app.pathExists(p, 'printerOptions.device-uri') == 'cups-pdf:/') {
							p.skipped = 'cups-pdf:/';
							continue;
						}
						if (app.pathExists(p, 'printerOptions.device-uri') && _cupsUris[p.deviceName] && p.printerOptions['device-uri'] != _cupsUris[p.deviceName] && _cupsUris[p.deviceName].indexOf(p.printerOptions['device-uri']) != -1) {
							console.log(p.printerOptions['device-uri'], '=>', _cupsUris[p.deviceName])
							p.printerOptions['device-uri'] = '' + _cupsUris[p.deviceName];
						}
						let _uri = null;
						for (let i = 0; i < app.printManager.deviceUriRegexes.length; i++) {
							if (app.printManager.deviceUriRegexes[i].test(p.printerOptions['device-uri'])) {
								_uri = app.printManager.deviceUriRegexes[i].exec(p.printerOptions['device-uri']);
								break;
							}
						}
						if (_uri && _uri[2]) {
							let _match = Object.keys(v).filter((a) => a == _uri[2])?.[0];
							if (_match) {
								p.macAddress = _match;
								console.log('found mac address', p)
							}
						}


						let [id] = await Promise.all([
							new Promise(async (resHash) => {
								let
									_timedOut = false,
									hashTimer = setTimeout(async () => {
										if (p.id) return;
										_timedOut = true;
										console.warn('Hashing name of printer timed out', p);
										resHash();
									}, 1000 * 15)

								app.hash.String(app.system.id + p.deviceName.replace(/[^0-9a-zA-Z\-_]/, '_').replace(/_+/g, '_'), function (id) {
									p.id = id;
									if (_timedOut) return;
									out.push(p);
									resHash();

									clearTimeout(hashTimer);
								});
							})
						]);
					}
					resolve(out);
					app._m.fs.writeFile(app.cacheDir + 'local_printers.json', JSON.stringify({ date: new Date().toISOString(), printers: out }, undefined, 4), function () { })
					app._m.fs.writeFile(app.cacheDir + 'detected_local_printers.json', JSON.stringify(_fileData, undefined, 4), function () { })
				});
			} catch (er) { console.error('cannot get printers', er) }
		});
	}

	getScreens() {
		var screens = nw?.Screen?.screens || [];
		screens.sort(function (a, b) {
			return a.bounds.x - b.bounds.x;
		});
		return screens;
	}

	showError(code) {
		try { self.win.window.showError(app.parseLocales('splash.session_error_codes.' + code)); } catch (er) { }

		app.web.emit({
			volatile: 1,
			module: 'sessions',
			action: 'startup_sequence',
			data: {
				module: 'splashscreen',
				action: 'error_code',
				message: code
			},
			eventLoop: app.eventLoopLag._current,
			uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
			cpuInfo: app.system.vars.systemInfo.cpu
		});
	}
	setMessage(id, message) {
		try {
			self.win.window.setMessage(id,
				app.parseLocales('splash.session_error_codes.' + message) ||
				app.parseLocales('splash.session_error_codes.' + id) ||
				message || id);
		} catch (er) { console.error({ id, message }, er) }
	}
	unsetMessage(id) {
		try { self.win.window.unsetMessage(id); } catch (er) { }
	}

	showWizard(code) {
		try { self.win.window.showWizard(app.parseLocales('splash.activation_code'), code, app.parseLocales('splash.activation_loginto')); } catch (er) { }
	}
};