@echo off
setlocal
SET mypath=%~dp0
SET mypath=%mypath:~0,-1%

set arg2=%1
CALL SET "scripts=%%mypath:\restart=%%"
CALL SET "azimutpos=%%mypath:\etc\scripts\restart=%%"

cd "%azimutpos%"
set SESSIONNAME=AzimutRestart
rem Instance Set
set instance=%SESSIONNAME% %DATE% %TIME% %RANDOM%
%SAY% "Instance: %instance%"
title %instance%
for /f "usebackq tokens=2" %%a in (`tasklist /FO list /FI "SESSIONNAME eq %SESSIONNAME%" /FI "WINDOWTITLE eq %instance%" ^| find /i "PID:"`) do set PID=%%a

set LOGFILE="logs\restart.log"
set "SAY=echo %date% %time%"
call :LOG > %LOGFILE%
:LOG
%SAY% "cwd %azimutpos%"
%SAY% "Restarting AzimutPOS..."
%SAY% "Wait for processes to terminate"
CALL "etc\scripts\timeout.bat" 3
%SAY% "Killing remaining processes"
@taskkill /f /im TechnoPOS.exe >NUL 2>&1

for /f "skip=3 tokens=2 delims= " %%a in ('tasklist /fi "imagename eq AzimutPOS.exe"') do (
    if "%%a" neq "%PID%" (
        TASKKILL /PID %%a /f >NUL 2>&1
    )
)
CALL "etc\scripts\timeout.bat" 3

:WAITPOS
%SAY% "Killing remaining processes"
@taskkill /f /im TechnoPOS.exe >NUL 2>&1

for /f "skip=3 tokens=2 delims= " %%a in ('tasklist /fi "imagename eq AzimutPOS.exe"') do (
    if "%%a" neq "%PID%" (
        TASKKILL /PID %%a /f >NUL 2>&1
    )
)
CALL "etc\scripts\timeout.bat" 3
set STILLRUNNING=0
for /f "skip=3 tokens=2 delims= " %%a in ('tasklist /fi "imagename eq AzimutPOS.exe"') do (
    if "%%a" neq "%current_pid%" (
        set STILLRUNNING=1
    )
)
IF "%STILLRUNNING%" == "0" (
  GOTO CONTINUE
) ELSE (
  ECHO AzimutPOS is still running
  GOTO WAITPOS
)

:CONTINUE

%SAY% "All processes terminated, restart."
%SAY% "cd %azimutpos%"
cd "%azimutpos%"

CALL "etc\scripts\launcher\AzimutPOS.bat"
exit 0