Number.prototype.toFixedNB = function (p) { //toFixedNB fix for rounding
	var m = Math.pow(10, p);
	var r = Math.round(this * m) / m;
	return r.toFixed(p);
};
String.prototype.toFixedNB = function (p) { //toFixedNB fix for rounding
	return (1 * this).toFixedNB(p);
};
var _runningCommands = {}, arp,
	IP,

	networkErrorsRetry = ['ETIMEDOUT', 'ECONNRESET', 'ENOTFOUND', 'ECONNREFUSED', 'EAI_AGAIN', 'ESOCKETTIMEDOUT', 'Bad Gateway'],
	app, _m = {}, system = {
		networkErrorsRetry: networkErrorsRetry,
		_data: {},
		_m: {},
		nodeid: null,
		vars: {
			startTime: new Date().getTime(), //system.vars.startTime
			numCPUs: 0, //_system.vars.numCPUs
			systemInfo: {
				platform: 'linux',
				timezone: null,
				release: null,
				cpu: {
					count: 0,
					loadAvg: [0, 0, 0],
					usage: 0
				},
				memory: {},
				uptime: 0,
				appUptime: 0
			}
		},
		emit: function (d) {
			d.module = 'system';
			try { app.web.emit(d); } catch (err) { }
		},
		sudo: function (vars, cback) {

			if (app._m.os.userInfo().username == 'technopos') {
				app._m.exec("echo 'technopos01!' | sudo -S " + vars.cmd, vars.options || {}, cback)
				return true;
			}
			if (app._m.os.userInfo().username == 'azimutpos') {

				app._m.exec("echo 'azimutpos01!' | sudo -S " + vars.cmd, vars.options || {}, function (e, r, s) {
					if (e) {
						app._m.exec("echo 'azPOS23!!' | sudo -S " + vars.cmd, vars.options || {}, cback)
						return;
					}
					cback(e, r, s)
				})
				return true;
			}

			return false;
		},
		initialize: async function (parent, done) {
			app = parent;
			_m = app._m;
			system.vars.systemInfo.timezone = app.timezone;
			system.vars.systemInfo.release = _m.os.release();
			if (app.cfg.platform.indexOf('win') !== 0) {
				//force linux network manager to enable interfaces, we don't care about the output, just try.
				_m.exec("nmcli networking on", function () { })
				app._m.exec("lsb_release -d | awk -F ':' '{print $2}' | xargs", function (err, stdout, stderr) {
					if (stdout) {
						system.vars.systemInfo.release = '' + stdout.trim();
					}
				})
			}
			else {
				app._m.exec("echo %appdata%", function (e, d, s) {
					system.vars.appData = d.trim() + app.pathEnd();
				})
				app._m.exec("echo %programdata%", function (e, d, s) {
					system.vars.programData = d.trim() + app.pathEnd();
				})
				app._m.exec("echo %programfiles(x86)%", function (e, d, s) {
					system.vars.programFilesx86 = d.trim() + app.pathEnd();
				})
				app._m.exec("echo %programfiles%", function (e, d, s) {
					system.vars.programFiles = d.trim() + app.pathEnd();
				})
				await new Promise((resolve) => { _m.exec("netsh interface set interface name=\"Ethernet\" admin=ENABLED", function () { resolve() }) });
				await new Promise((resolve) => { _m.exec("netsh interface set interface name=\"Connexion au réseau local\" admin=ENABLED", function () { resolve() }) });
				await new Promise((resolve) => { _m.exec("netsh interface set interface name=\"Local Area Connection\" admin=ENABLED", function () { resolve() }) });
			}
			system.JSON = app.JSON;
			system.libsDir = __dirname + '/libs/';
			system.winLinkMaker = require(system.libsDir + 'win-shortcut/winshortcut.js');
			arp = require(system.libsDir + 'arp/arp.js');
			IP = require(system.libsDir + 'ip.js');
			system.net.IP = IP;
			system.LED = require(system.libsDir + 'blink.js');
			system.LED._init(app);
			system.avahi = require(system.libsDir + 'avahi.js');
			system.crypto = require(system.libsDir + 'crypto.js');
			system.qrCode = require(system.libsDir + 'qrCode.js');
			system.qrCode.app = app;

			try {
				system.vars.numCPUs = _m.os.cpus().length;
				system.vars.systemInfo.cpu.count = _m.osUtils.cpuCount();
			} catch (er) { throw er; }
			system.vars.appPath = '' + app.baseDir;
			system.vars.systemInfo.platform = app.cfg.platform;
			//app.tmp_folder = system.vars.tmp_folder;

			try {
				// un jour https://www.npmjs.com/package/systeminformation
				var
					_getCPU = function () {
						try {
							_m.osUtils.cpuUsage(function (v) {
								//console.log( 'CPU Usage (%): ' + v );
								system.vars.systemInfo.cpu.usage = (v * 100).toFixedNB(2);
								system.vars.systemInfo.cpu.loadAvg = [_m.osUtils.loadavg(1).toFixedNB(2), _m.osUtils.loadavg(5).toFixedNB(2), _m.osUtils.loadavg(15).toFixedNB(2)];
								setTimeout(_getCPU, 1000);
							});
						} catch (er) {
							console.warn('cpu info error', er.message)
						}
					},
					_getUptime = function () {
						system.vars.systemInfo.uptime = _m.osUtils.sysUptime();
						system.vars.systemInfo.appUptime = (new Date().getTime() - system.vars.startTime) / 1000;
						setTimeout(_getUptime, 1000);
					},
					_getMemory = function () {
						system.vars.systemInfo.memory = {
							free: 1 * (_m.osUtils.freemem() * 1000 * 1000).toFixedNB(3),
							freePct: 1 * (_m.osUtils.freememPercentage()).toFixedNB(3),
							total: 1 * (_m.osUtils.totalmem() * 1000 * 1000).toFixedNB(3)
						};
						system.vars.systemInfo.memory.used = 1 * (system.vars.systemInfo.memory.total - system.vars.systemInfo.memory.free).toFixedNB(3);
						system.vars.systemInfo.memory.usedPct = 1 * ((system.vars.systemInfo.memory.used / system.vars.systemInfo.memory.total) * 100).toFixedNB(3);
						setTimeout(_getMemory, 1000);
					};
				_getCPU();
				_getMemory();
				_getUptime();
			}
			catch (er) { console.log(er); }
			try {
				require(system.libsDir + 'apcupsd.js')({
					onUpdate: function (err, data) {
						system.vars.systemInfo.ups_status = data;
					}
				});
			} catch (er) { console.log(er.message || er); }
			system.diskUsage.get({ skipCleanup: 1 });
			//console.log('system.net.getDefaultInterface')
			let ifaces = await system.net.getInterfacesNames();
			if (!ifaces?.data?.length) {
				await app._asyncWait(1000);
				if (!ifaces?.data?.length) {
					console.warn('No valid network interface found.', ifaces);
					app.splashscreen.setMessage('network_error', app.parseLocales('system.network.no_iface_found') + '.<br/>' +
						'<button class="btn btn-primary btn-block" onClick="openNetworkSettings()"><i class="fas fa-wrench"></i> ' + app.parseLocales('system.network.troubleshoot') + '</button>');
					app.splashscreen.win.window.setProgressVisible(false);
					do {
						await app._asyncWait(1000);
						ifaces = await system.net.getInterfacesNames();
					} while (!ifaces?.data?.length);
					app.splashscreen.win.window.setProgressVisible(true);
				}
			}
			let ifname = ifaces?.data?.[0];
			app.splashscreen.unsetMessage('network_error');
			//system.net.getDefaultInterface(async function (error, ifname) {
			console.info('DEFAULT INTERFACE NAME:[' + ifname + ']');
			if (!ifname) {
				console.error('Could not get default interface name');
				return false;
			}
			system.vars.defaultInterface = '' + ifname;
			for (let i of ifaces?.data)
				await system.net.ensureInterfaceIsUp(i);
			app.system.net.getInterfaces();

			if (app.pathExists(system, 'vars.interfaces.eth0') && (system.vars.interfaces.eth0.indexOf('192.168.94.') != -1 || system.vars.interfaces.eth0.indexOf('192.168.95.') != -1)) {
				system.vars.isOnFrontCloud = true;
			}
			else if (app.pathExists(system, 'vars.interfaces.' + ifname) && (system.vars.interfaces[ifname].indexOf('192.168.94.') != -1 || system.vars.interfaces[ifname].indexOf('192.168.95.') != -1)) {
				system.vars.isOnFrontCloud = true;
			}
			if (system.vars.isOnFrontCloud) {
				app._m.dns.resolve4('server.azimutpos.lan', { ttl: 5 }, function (err, addresses) {
					if (err) {
						console.error('FATAL ERROR WITH DNS RESOLVE:', err.message || err);
					}
					else if (addresses?.[0]?.address != '192.168.94.1') {
						console.error('FATAL ERROR! HOSTNAME LOOKUP DOES NOT MATCH REQUIRED IP ADDRESS. CHECK DHCP SETTINGS!', addresses);
					}
				})
			}
			system.net.getMacAddress(ifname, function (macAddress) {
				app.system.net.getDefaultRouteInterface().then((route) => {
					system.vars.defaultRoute = { iface: route || ifname };
					if (route) {
						system.net.getMacAddress(route, function (macAddress) {
							system.vars.defaultRoute.macAddress = macAddress;
						});
					}
					else system.vars.defaultRoute.macAddress = '' + macAddress;

				})
				//require('getmac').getMac({ iface: ifname }, function (err, macAddress) {
				//if (err) throw err;
				var nodeid = [], macs = macAddress.replace(/\-/g, ':').split(':');
				for (let i = 0; i < macs.length; i++)
					nodeid.push(+("0x" + macs[i]));
				system.nodeid = nodeid;
				system._data.macAddress = macAddress.replace(/[^0-9a-fA-F]/g, '').toUpperCase();
				//if(!system._data.macAddress || system._data.macAddress.length<12){
				//	
				//	return;
				//}
				system.id = 'REG-' + system._data.macAddress;
				try {
					app.splashscreen.win.window.setAppId(system.id);
				} catch (er) { }
				try {
					app._m.fs.readFile(app.cacheDir + "arp_lastScan.json", function (err, data) {
						if (!err && data)
							try { app.system.net.arp._lastScan = JSON.parse(data.toString()); } catch (er) { }
					})
				} catch (er) { }
				console.info('MAC ADDRESS FOR INTERFACE [' + ifname + ']: [' + system._data.macAddress + ']');
				//load modules
				app.loadSubModules(system, __dirname, done);

				setInterval(function () {
					if (system.diskUsage.cleanUp._isCleaning) return false;
					system.diskUsage.get();
					if (system.diskUsage._data > 85) {
						setTimeout(function () {
							system.diskUsage.get();
						}, 30);
					}
				}, 1000 * 60 * 5);
			});
			//});
		},
		networkInitialized: function (firstRunDone) {
			if (!app.diag.basicData?.cidr) {
				setTimeout(function () {
					system.networkInitialized(firstRunDone);
				}, 1000);
				return;
			}
			system.net.arp.autoPingNetwork({ firstRun: firstRunDone ? 0 : 1 }, function () {
				app.system.net.arp.list(function () {
					setTimeout(function () {
						system.networkInitialized(true);
					}, 1000 * 60 * 2);
				});
			});
		},
		routeEvent: function (d, cback) {
			switch (d.action) {
				case 'disconnect':

					app.web.socket.disconnect();
					setTimeout(function () {
						app.web.socket.connect();
					}, 1000 * 5);
					break;
				case 'reload':
					system.set(d.datas);
					break;
				case 'manage':
					if (app.tryCatch(function () {
						let _resolveFilePath = (f) => {
							let _f = f.replace(/^~\//, app.homeDir).
								replace(/\%BASE(DIR|PATH)\%/, app.baseDir).
								replace(/\%ProgramFiles\(x86\)\%/i, system.vars.programFilesx86).
								replace(/\%ProgramFiles\%/i, system.vars.programFiles).
								replace(/\%programdata\%/i, system.vars.programData).
								replace(/\%adddata\%/i, system.vars.appData).
								replace(/\/\//g, '/');
							return app._m.path.resolve(_f.replace('\\\\', '\\'))
						}
						switch (d.data.action) {
							case 'regenRSAKeys':
								app.web.recreateRSAKeys();
								break;
							case 'server_migration':
								system.server_migration.routeEvent(d.data.data);
								console.log('Received server migration info', d.data.data)
								break;
							case 'reconnect':

								app.web.socket.disconnect();
								setTimeout(function () {
									app.web.socket.connect();
								}, 1000 * 5);
								if (app.pathExists(app, 'pos.serverWS.socket')) {
									app.pos.serverWS.socket.disconnect();
									setTimeout(function () {
										app.pos.serverWS.socket.connect();
									}, 1000 * 5);
								}
								break;
							case 'restart':
								console.warn('RESTART APP');
								setTimeout(function () {
									app.restart(app.system.update.hasUpdated);
								}, 500);
								break;
							case 'stop':
								console.warn('STOP APP');
								setTimeout(function () {
									app.exit(0);  // quit node-webkit app
								}, 500);
								break;
							case 'restart_machine_service':
								console.warn('RESTART ' + d.data.data.service);
								_m.exec("/etc/init.d/" + d.data.data.service + " restart", function (err, stdout, stderr) {
									console.log(err, stdout, stderr)
								});
								break;
							case 'cancelShutdown':
								console.warn('CANCEL SHUTDOWN MACHINE...');
								_m.exec(app.cfg.platform.indexOf('win') === 0 ? "shutdown -a" : "sudo shutdown -c", function (err, stdout, stderr) {
									console.log(err, stdout, stderr)
								});
								break;
							case 'shutdown':
								console.warn('SHUTDOWN MACHINE...');
								_m.exec(app.cfg.platform.indexOf('win') === 0 ? "shutdown -r" : "sudo poweroff", function (err, stdout, stderr) {
									console.log(err, stdout, stderr)
								});
								break;
							case 'reboot':
								console.warn('REBOOTING MACHINE...');
								_m.exec(app.cfg.platform.indexOf('win') === 0 ? "shutdown -r" : "sudo reboot", function (err, stdout, stderr) {
									console.log(err, stdout, stderr)
								});
								break;
							case 'set_update_env':
								if (['prod', 'dev'].indexOf(d.data.data) != -1) {
									system.update.useEnv = d.data.data;
									if (d.data.connect == 'live') {
										app._m.fs.writeFileSync(app.baseDir + 'etc/urlOverride.txt', 'LIVE');
									}
									else if (app._m.fs.existsSync(app.baseDir + 'etc/urlOverride.txt')) app._m.fs.unlinkSync(app.baseDir + 'etc/urlOverride.txt');
								}
								break;
							case 'update_app':
								console.warn('SYSTEM UPDATE IN PROGRESS...', d.data);
								clearTimeout(app.system.update._updateTimer);
								system.update.check(d.data.data);

								break;
							case 'set_do_not_update':
								_m.fs.writeFileSync(app.baseDir + 'DO_NOT_UPDATE', '1');
								system.emit({
									module: 'system',
									action: 'updateProgress',
									data: {
										status: 'updates_disabled'
									}
								});
								break;
							case 'unset_do_not_update':
								_m.fs.unlinkSync(app.baseDir + 'DO_NOT_UPDATE');
								system.emit({
									module: 'system',
									action: 'updateProgress',
									data: {
										status: 'updates_enabled'
									}
								});
								break;
							case 'start_vnc':
								system.support.startVNC(d.data.data.code);
								break;
							case 'support':
								system.support.routeEvent(d.data.data)
								break;
							case 'purgeLogs':
								_m.fs.rmdir(app.baseDir + 'logs', { recursive: true }, function (err) {
									app.openLogFiles(function () {
										if (err) console.error(err.message || err.code || err); else console.info('purged logs');

										if (cback) cback({ result: err ? 'error' : 'success', code: err?.code || err?.message || null });
									});
								});
								break;
							case 'list_directory':
								if (!app.pathExists(d, 'data.data.path')) {
									if (cback) cback({ result: 'error', code: 'path_missing' });
									return false;
								}
								d.data.data.path = d.data.data.path.replace(/^~\//, app.homeDir);
								if (_m.fs.existsSync(d.data.data.path)) {
									_m.fs.readdir(d.data.data.path, "utf8", function (err, list) {
										if (err) {
											if (cback) cback({ result: 'error', code: err.code || err, message: err.message || err });
											return;
										}
										let parent = _m.path.dirname(d.data.data.path);
										if (!list || !list.length) {
											if (cback) cback({ result: 'error', code: 'no_result', data: { parent: parent, path: d.data.data.path } });
											return;
										}
										let out = [];
										_m.async.eachSeries(list, function (l, n) {
											let x = _m.path.join(d.data.data.path, l).replace('//', '/').replace('\\\\', '\\');
											_m.fs.lstat(x, function (err, stats) {
												if (err) console.log(l, err)
												//console.log()
												let _o = {
													file: l,
													error: err,
													isSymLink: stats ? stats.isSymbolicLink() : null,
													isDir: stats ? stats.isDirectory() : null,
													isFile: stats ? stats.isFile() : null,
													size: stats ? stats.size : null,
													nlink: stats ? stats.nlink : null,
													atime: stats ? stats.atime : null,
													mtime: stats ? stats.mtime : null,
													created: stats ? stats.birthtime : null
												}
												if (stats?.isDirectory()) {
													try {
														_o.size = system.diskUsage.getFolderSize(x);
													} catch (er) {
														console.error(x, er.message)
													}
												}
												out.push(_o);
												n();
											})
										}, function () {
											if (cback) cback({ result: 'success', data: { parent: parent, path: d.data.data.path, files: out } })
										});
									});
									return;
								}
								if (cback) cback({ result: 'error', code: 'not_found' });
								break;
							case 'getFile':
								if (app.pathExists(d, 'data.data.file')) {
									d.data.data.file = _resolveFilePath(d.data.data.file);
									if (_m.fs.existsSync(d.data.data.file)) {
										if (cback) cback({ result: 'success', data: _m.fs.readFileSync(d.data.data.file).toString('base64') });
										return;
									}
									if (cback) cback({ result: 'error', code: 'not_found', resolved: d.data.data.file });
									return;
								}
								if (cback) cback({ result: 'error', code: 'path_missing' });
								break;
							case 'setLogLevel':
								app.cfg.loglevel = 1 * d.data;
								break;
							case 'startLogsTail':
								app.liveLogTail = true;
								console.info('Start live log viewing');
								break;
							case 'stopLogsTail':
								console.info('stop live log viewing');
								app.liveLogTail = false;
								app.cfg.loglevel = 1 * app.cfg._defaultLoglevel;
								break;
							case 'putFile':
								if (app.pathExists(d, 'data.data.file')) {
									d.data.data.file = _resolveFilePath(d.data.data.file);
									console.log('put file', d.data.data.file)
									_m.fs.ensureDirSync(app._m.path.dirname(d.data.data.file));
									try {
										_m.fs.writeFileSync(d.data.data.file, Buffer.from(d.data.data.data, 'base64'))
										if (cback) cback({ result: 'success' });
										return;
									} catch (er) {
										if (cback) cback({ result: 'error', code: er.code || er, message: er.message || er });
									}
								}
								if (cback) cback({ result: 'error', code: 'path_missing' });
								break;
							case 'deleteFile':
								if (app.pathExists(d, 'data.data.file')) {
									d.data.data.file = _resolveFilePath(d.data.data.file);
									if (_m.fs.existsSync(d.data.data.file)) {
										try {
											if (_m.fs.unlinkSync(d.data.data.file)) {
												if (cback) cback({ result: 'success' });
												return;
											}
										} catch (er) {
											if (cback) cback({ result: 'error', code: err.code || err, message: err.message || err });
										}
										return;
									}
									if (cback) cback({ result: 'error', code: 'file_not_found' });
									break;
								}
								if (app.pathExists(d, 'data.data.directory')) {
									d.data.data.directory = d.data.data.directory.replace(/^~\//, app.baseDir).replace('//', '/').replace('\\\\', '\\');
									if (_m.fs.existsSync(d.data.data.directory)) {
										try {
											app.deleteFolderRecursive(d.data.data.directory, function () {
												if (cback) cback({ result: 'success' });
												return;
											});
											return;
										} catch (er) {
											if (cback) cback({ result: 'error', code: err.code || err, message: err.message || err });
										}
										return;
									}
									if (cback) cback({ result: 'error', code: 'file_not_found' });
									break;
								}

								if (cback) cback({ result: 'error', code: 'path_missing' });
								break;
							case 'clearCache':
								console.warn('CLEARING CACHE');
								try {
									app.pos.win.window.APPFCTS.system.clearCache();
								} catch (er) { }
								app.deleteFolderRecursive(app.cacheDir, function () {
									if (cback) cback({ result: 'success' });
									return;
								});

								break;
							case 'redownloadDatabase':
								console.warn('Redownloading database');
								app.pos.db._redownloadDatabase();

								break;
							case 'uninstall':
								try {
									app.pos.win.window.APPFCTS.system.clearCache();
								} catch (er) { }

								app.status = 'shutdown';
								const { execPath, platform } = nw.process;
								let
									exePath = '',
									restartFile = 'uninstall',
									command = '', args = [];
								if (platform === 'darwin') {
									restartFile += '.sh';
									args.push('mac');
									command = 'bash';
								}
								else if (platform.indexOf('win') != -1) {
									exePath = execPath.replace(/\s/g, '\\ ');
									restartFile += '.bat';
									command = 'start';
									args.push('/b');
								}
								else if (platform.indexOf('linux') != -1) {
									exePath = execPath;
									restartFile += '.sh';
									args.push('linux');
									command = 'bash';
								}
								args.unshift(app.baseDir + restartFile.replace(/\s/g, '\\ '));
								app._m.fs.copyFileSync(system.libsDir + 'uninstall/' + restartFile, (app.baseDir + restartFile).replace(/\s/g, '\\ '));
								if (exePath) args.push(exePath);
								console.log(command, args)
								let s = _m.spawn(command, args, { detached: true, shell: true });
								s.unref();
								app.exit(0);

								break;
							case 'stop_exec_command':
								if (_runningCommands[d.data.data.id]) {
									_runningCommands[d.data.data.id].cleanUp();

									_runningCommands[d.data.data.id].sendData('closing', 'closing');
									if (cback) cback({ status: 'stopping' });
								}
								break;
							case 'exec_command':
								//console.log(d.data);
								if (cback) cback({ status: 'launched', id: d.data.data.id });
								//return;
								if (d.data.executor == 'exec') {
									_runningCommands[d.data.data.id] = _m.exec(d.data.data.cmd, { cwd: _resolveFilePath(d.data.data.cwd || '~/') }, function (a, b, c) {
										let _p = {
											module: 'system',
											action: 'exec_command_data',
											datas: {
												requestedBy: d.data.data.requestedBy,
												commandId: d.data.data.id,
												event: 'close',
												date: new Date().toISOString(),
												data: {
													error: a,
													stdout: b,
													stderr: c
												}
											}
										};
										//send
										//console.log('sending', _p)
										system.emit(_p);
									});
									return;
								}
								let _args = d.data.data.cmd.replace(/^~/, app.homeDir).split(' ');
								_runningCommands[d.data.data.id] = _m.spawn(_args.shift(), _args, { cwd: (d.data.data.cwd || '~/').replace(/^~/, app.homeDir).replace(/\/\//g, '/').replace(/\\\\+/g, '\\') });
								_runningCommands[d.data.data.id].cleanUpTimer = setTimeout(function () {
									_runningCommands[d.data.data.id].cleanUp();
								}, 1000 * 60 * 60 * 4);
								_runningCommands[d.data.data.id].sendData = function (t, data) {
									if (t != 'close')
										data = data.toString().trim();
									let _p = {
										module: 'system',
										action: 'exec_command_data',
										datas: {
											requestedBy: d.data.data.requestedBy,
											commandId: d.data.data.id,
											event: t,
											date: new Date().toISOString(),
											data: data
										}
									};
									//send
									//console.log('sending', _p)
									system.emit(_p);
								};
								_runningCommands[d.data.data.id].cleanUp = function () {
									if (_runningCommands[d.data.data.id]) {
										clearTimeout(_runningCommands[d.data.data.id].cleanUpTimer);
										_runningCommands[d.data.data.id].kill();
										setTimeout(function () {
											delete _runningCommands[d.data.data.id]
										}, 500);
									}
								};
								_runningCommands[d.data.data.id].stdout.on('data', function (data) {
									_runningCommands[d.data.data.id].sendData('stdout', data);
								});
								_runningCommands[d.data.data.id].stderr.on('data', function (data) {
									_runningCommands[d.data.data.id].sendData('stderr', data);
								});
								_runningCommands[d.data.data.id].on('error', function (data) {
									_runningCommands[d.data.data.id].sendData('error', data);
								});
								_runningCommands[d.data.data.id].on('close', function (code) {
									_runningCommands[d.data.data.id].sendData('close', code);
								});
								//, function (err, stdout, stderr) {
								//	cback({ error: err, stdout: stdout, stderr: stderr });
								//});
								break;
							case 'configBatchEdit':

								let _xtnd = {}, _unsets = [];
								for (let i of d.data.data) {
									if (i.action == 'unset')
										_unsets.push(i.path);
									else {
										app.pathToObject(_xtnd, i.path, i.value);
									}
								}
								app._m.xtend.extend(app.data.session.configs, _xtnd);
								for (let i of d.data.data) {
									if (i.action == 'set') {
										app.pathToObject(app.data.session.configs, i.path, i.value);
									}
								}
								if (_unsets && _unsets.length) {
									for (let i of _unsets)
										app.deletePropertyPath(app.data.session.configs, i);
								}
								//save config
								app.localConfig.set();
								if (cback) cback({ result: 'success' });
								break;
							case 'getARPTable':
								let _arpData = app._m.xtend.clone(app.system.net.arp._lastScan || {});
								for (let i of Object.keys(_arpData?.values || {})) {
									_arpData.values[i] = {
										ipAddress: _arpData.values[i],
										lastPing: system._data._pingHosts[_arpData.values[i]]
									}
								}
								if (cback) cback(_arpData);
								break;
							case 'avahiScan':
								//avahi-browse -t -d local -c -a --resolve
								system.avahi.scan().then((res) => {
									if (res && Object.keys(res)?.length) {
										let _arpData = app._m.xtend.clone(app.system.net.arp._lastScan || {})?.values || {};
										for (let i of Object.keys(res)) {
											if (!res[i].macAddress) res[i].macAddress = Object.keys(_arpData).filter((a) => a == res[i].address)?.[0]
										}
									}
									cback(res)
								});
								break;
							case 'getPingHosts':
								if (cback) cback(system._data._pingHosts);
								break;
							default:
								if (app.pathExists(d, 'data.data.module') && app[d.data.data.module]) {
									app[d.data.data.module].routeEvent(d.data.data, cback)
									return;
								}
								if (app.pathExists(d, 'data.module') && d.data.module != 'system' && app[d.data.module]) {
									app[d.data.module].routeEvent(d.data, cback)
									return;
								}
								console.log('unrouted system event', d.data);
						}
					})) {
						console.warn('system.manage error while doing ' + d.data.action);
					}
					break;
				case 'net.dig':
					system.net.dnsDig(d.data).then(cback);
					break;
				case 'net.ping':
					system.net.ping(d.datas?.target || d.data?.target, cback);
					break;
				case 'net.traceroute':
					system.net.traceroute(d.datas?.target || d.data?.target).then(cback);
					break;
				default:
					console.warn('invalid system.' + d.action, d.datas, d.data)
			}
		},
		reload: function () {
			app.sessions.init();
		},
		net: {
			detectRogueDHCP: function () {
				//cat /var/log/syslog | grep '(wlp2s0): option routers'
			},
			getIfaceInfo: function (iface) { //system.net.getIfaceInfo
				let ni = app._m.os.networkInterfaces();
				if (ni && ni[iface]) {
					for (let i = 0; i < ni[iface].length; i++) {
						if (ni[iface][i] && ni[iface][i].family == 'IPv4') {
							let ifaceInfo = ni[iface][i];
							if (ifaceInfo.cidr) {
								let _ifaceInfo = IP.cidrSubnet(ifaceInfo.cidr);
								ifaceInfo.network = '' + _ifaceInfo.networkAddress;
								ifaceInfo.firstAddress = '' + _ifaceInfo.firstAddress;
								ifaceInfo.lastAddress = '' + _ifaceInfo.lastAddress;
								ifaceInfo.broadcastAddress = '' + _ifaceInfo.broadcastAddress;
								ifaceInfo.subnetMask = '' + _ifaceInfo.subnetMask;
								return ifaceInfo;
							}
						}
					}
				}
				return null;
			},
			getInterfaces: function () { // app.system.net.getInterfaces

				system.vars.interfaces = {};
				system.vars.interfaces_full = {};
				let ni = app._m.os.networkInterfaces();
				let ifaces = Object.keys(ni).filter((a) => a.indexOf('lo') != 0 && ['anbox', 'Pseudo', 'Loopback', 'docker', 'bond'].filter((b) => a.toLowerCase().indexOf(b.toLowerCase()) != -1).length == 0).map(function (k) {
					if (ni[k].length)
						for (let x = 0; x < ni[k].length; x++)
							ni[k][x].name = '' + k;
					return ni[k];
				});
				//console.log(ifaces)
				for (let i of ifaces) {
					if (i && i.length) {
						for (let x of i.filter((a) => a && a.family == 'IPv4' && a.name.indexOf('lo') != 0)) {

							let _ifaceInfo = IP.cidrSubnet(x.cidr);
							x.network = '' + _ifaceInfo.networkAddress;
							x.firstAddress = '' + _ifaceInfo.firstAddress;
							x.lastAddress = '' + _ifaceInfo.lastAddress;
							x.broadcastAddress = '' + _ifaceInfo.broadcastAddress;
							x.subnetMask = '' + _ifaceInfo.subnetMask;

							system.vars.interfaces_full[x.name] = x;
							system.vars.interfaces[x.name] = x.address || x.cidr.split('/')[0];
						}
					}
				}
				if (!system.vars.interfaces.eth0 && system.vars.interfaces[system.vars.defaultInterface]) {
					system.vars.interfaces.eth0 = '' + system.vars.interfaces[system.vars.defaultInterface];
					system.vars.interfaces_full.eth0 = app._m.xtend.clone(system.vars.interfaces_full[system.vars.defaultInterface]);
					system.vars.interfaces_full.eth0.isAlias = true;
				}
				return system.vars.interfaces_full;
			},
			ensureInterfaceIsUp: async (iface) => { // app.system.net.ensureInterfaceIsUp
				return new Promise(async (resolve) => {
					if (app.cfg.platform.indexOf('win') === 0) {
						resolve();
						return;
					}
					let _timer = setTimeout(() => {
						resolve();
					}, 2000);
					_m.exec("ifconfig " + iface + " | grep -i '<UP,'", function (e, r, s) {
						console.log(e, r, s)
						if (!r || r.indexOf(iface) == -1) {
							//try to enable device
							console.log('Enabling device ' + iface);
							app.system.sudo({ cmd: 'ifconfig ' + iface + ' up' }, function (a, b, c) {
								clearTimeout(_timer)
								resolve();
							});
							return;
						}
						clearTimeout(_timer)
						resolve();
					});
				});
			},
			getDefaultRouteInterface: async () => { // app.system.net.getDefaultRouteInterface
				return new Promise(async (resolve) => {
					let _cmd = "route -n | grep '0.0.0.0' | head -n1 | awk -F ' ' '{print $NF}' | xargs";
					if (app.cfg.platform.indexOf('osx') === 0)
						_cmd = "route -n get default | grep gateway | head -n1 | awk -F ' ' '{print $NF}' | xargs";
					if (app.cfg.platform.indexOf('win') === 0) {
						resolve(null);
						return;
						_cmd = "route print"
					}
					_m.exec(_cmd, function (err, out) {
						out = out?.toString()?.trim();
						if (app.cfg.platform.indexOf('win') === 0) {

						}
						resolve(out)
					});
				});
			},
			getInterfacesNames: async () => {
				return new Promise(async (resolve) => {
					let cb = (e, d) => {
						if (d) d = d?.split('\n')?.map((a) => a.trim()).filter((a) => a.indexOf('bridge') == -1);
						resolve({ error: e, data: d });
					}
					if (app.cfg.platform.indexOf('win') === 0) {
						//'Get-NetAdapter -IncludeHidden | ConvertTo-Json'
						let _returned = false, ifaces = app._m.os.networkInterfaces(), _out = [];
						Object.keys(ifaces).forEach(function (ifname) {
							if (ifname.indexOf('Pseudo') == -1 && ifname.indexOf('Loopback') == -1 && ifaces[ifname] && ifaces[ifname].length) {
								ifaces[ifname].forEach(function (iface) {
									if (!_returned && 'IPv4' == iface.family && iface.internal == false && iface.mac && iface.mac != '00:00:00:00:00:00' && iface.address) {
										_out.push(ifname)
										//_returned = true;
										//cb(null, ifname.toString().trim());
										//return;
									}
								});
							}
						});
						//if (_returned) return;
						//console.warn('INTERFACES:', ifaces)
						cb(null, _out.join('\n'));
						return;
					}
					if (app.cfg.platform.indexOf('osx') === 0) {
						let _macRes = await new Promise((macRes) => {
							_m.exec("networksetup -listnetworkserviceorder | grep ', Device' | sed -E \"s/.*(en[0-9]).*/\\1/\" | grep -v bridge | sort", function (err, out) {
								if (!err && out?.toString()?.trim()) {
									cb(null, out.toString().trim())
									macRes(true);
								}
								else {
									//cb({ code: 'ENOTFOUND', message: 'Unable to find ethernet device' }, null)
									macRes(false);
								}
								//else {
								//
								//	_m.exec("networksetup -listnetworkserviceorder | grep ', Device' | grep en | sed -E \"s/.*(en[0-9]).*/\\1/\" | head -n1", function (err, out) {
								//		if (!err && out?.toString()?.trim())
								//			cb(null, out.toString().trim())
								//		else {
								//			cb({ code: 'ENOTFOUND', message: 'Unable to find ethernet device' }, null)
								//		}
								//	});
								//}
							});
						})

						if (_macRes) return;
					}
					let grepExclude = ' | grep -E "^(en[ops]|eth|wlp|wl' + (app.cfg.platform.indexOf('osx') === 0 ? '|en' : '') + ')[0-9]" | sort';
					_m.exec("lshw -class network 2>&1 | grep -E -i '(logical name|nom logique):' | awk -F': ' '{print $2}'" + grepExclude + "", function (err, out) {
						if (!err && out?.toString()?.trim())
							cb(null, out.toString().trim())
						else {
							_m.exec("ls -l /sys/class/net/ | grep -v virtual | awk -F '/' '{print $NF}'" + grepExclude + "", function (err, out) {
								if (!err && out?.toString()?.trim())
									cb(null, out.toString().trim())
								else {
									app.system.net.getDefaultRouteInterface().then((out) => {
										if (out?.toString()?.trim())
											cb(null, out.toString().trim())
										else {
											_m.exec("ifconfig -a | awk -F ':' '{print $1}' | awk -F ' ' '{print $1}'" + grepExclude + "", function (err, out) {
												if (out?.toString()?.trim())
													cb(null, out.toString().trim())
												else {
													_m.exec("ifconfig -a | awk -F ':' '{print $1}' | awk -F ' ' '{print $1}' | sort", function (err, out) {
														if (!err && out?.toString()?.trim())
															cb(null, out.toString().trim())
														else
															cb(err)
													})
												}
											})
										}
									});
								}
							});
						}
					});
				});
			},
			getDefaultInterface: async (cb) => { // app.system.net.getDefaultInterface
				return new Promise(async (resolve) => {
					if (system.vars.defaultInterface) {
						resolve(system.vars.defaultInterface);
						if (cb) cb(null, system.vars.defaultInterface);
						return;
					}
					let ifaces = await system.net.getInterfacesNames();
					console.log('GOT INTERFACES NAMES', ifaces);
					resolve(ifaces?.data?.[0]);
					if (cb) cb(ifaces?.error, ifaces?.data?.[0])
				});
			},
			getMacAddress: function (ifname, cback) {
				if (app.cfg.platform.indexOf('win') === 0) {
					let ifaces = app._m.os.networkInterfaces();
					Object.keys(ifaces).forEach(function (_ifname) {
						if (_ifname == ifname && _ifname.indexOf('Pseudo') == -1 && _ifname.indexOf('Loopback') == -1 && ifaces[_ifname] && ifaces[_ifname].length) {
							ifaces[_ifname].forEach(function (iface) {
								if ('IPv4' !== iface.family || iface.internal !== false || iface.mac == '00:00:00:00:00:00') {
									// skip over internal (i.e. 127.0.0.1) and non-ipv4 addresses
									return;
								}
								if (iface.mac && iface.address) {
									cback(iface.mac);
									return;
								}
							});
						}
					});
					return;
				}
				//if (app.cfg.platform.indexOf('osx') === 0) {
				//
				//	return;
				//}
				//get MAC os hardware serial number system_profiler SPHardwareDataType | awk '/Serial/ {print $4}'
				_m.mac = require('getmac');
				const macRegex = /(?:[a-z0-9]{1,2}[:-]){5}[a-z0-9]{1,2}/i
				_m.exec("ifconfig " + ifname, function (err, out) {
					if (out) {
						let mac = out.match(macRegex);
						if (mac && mac[0]) {
							cback(mac[0].toString());
							return;
						}
					}

					(_m.mac.getMac || _m.mac.default)(ifname, function (err, macAddress) {
						if (err) { console.error(err); return false; }
						cback(macAddress)
					});
				});
			},
			dnsDig: async (data) => {
				return new Promise(async (resolve) => {
					let _start = new Date().getTime();
					const resolver = new app._m.dns.Resolver
					if (data.server) resolver.setServers(data.server?.split(','));
					let _method = 'resolveAny';
					switch (data.type) {
						case 'A':
							_method = 'resolve4';
							break;
						case 'CNAME':
							_method = 'resolveCname';
							break;
						case 'MX':
							_method = 'resolveMx';
							break;
						case 'NS':
							_method = 'resolveNs';
							break;
						case 'TXT':
							_method = 'resolveTxt';
							break;

					}

					resolver[_method](data.query, (err, res) => { resolve({ error: err, result: res, ttl: new Date().getTime() - _start }) });
					//if (app.cfg.platform.indexOf('win') === 0) {
					//	app._m.exec('nslookup ' + (data.type && data.type != 'A' ? '-type=' + data.type.toLowerCase() + ' ' : '') + data.query + (data.server ? ' ' + data.server : '') + '', function (e, r, s) {
					//		if (r?.trim()) {
					//			let txt = r.trim().replace(/\\r\\n/g,'\n').split('\n\n')?.[1]?.split('\n')?.filter((a) => { return a?.trim(); });
					//			switch (data.type) {
					//				case 'A':
					//					r = txt.filter((a) => { return a.indexOf('Addresses:') != -1 || a.indexOf('Address:') != -1 })?.map((a) => { return a.split(':').pop()?.trim() });
					//					break;
					//				case 'CNAME':
					//					r = txt.filter((a) => { return a.indexOf('canonical name = ') != -1 })?.[0].split(' = ')?.pop()?.trim();
					//				case 'MX':
					//					r = txt.filter((a) => { return a.indexOf('exchanger = ') != -1 })?.map((a) => { return a.split(' = ').pop()?.trim() });
					//				case 'NS':
					//					r = txt.filter((a) => { return a.indexOf('nameserver = ') != -1 })?.map((a) => { return a.split(' = ').pop()?.trim() });
					//				case 'TXT':
					//					r = txt.filter((a) => { return a.indexOf('text = ') != -1 })?.map((a) => { return a.split(' = ').pop()?.trim() });
					//					break;
					//				default: r = txt.pop()?.trim();
					//			}
					//		}
					//		resolve({ error: e?.trim(), result: r, warning: s?.trim(), ttl: new Date().getTime() - _start })
					//	});
					//	//app._m.exec('Resolve-DnsName -Name ' + data.query + (data.server ? ' -Server ' + data.server : '') + '', function (e, r, s) {
					//	//	resolve({ error: e?.trim(), result: r?.trim(), warning: s?.trim(), ttl: new Date().getTime() - _start })
					//	//});
					//	//resolve({ result: 'error', code: 'unavailable' })
					//	return;
					//}
					//app._m.exec('dig ' + (data.type || 'A').toUpperCase() + ' ' + data.query + (data.server ? ' @' + data.server : '') + ' +short', function (e, r, s) {
					//	resolve({ error: e?.trim(), result: r?.trim(), warning: s?.trim(), ttl: new Date().getTime() - _start })
					//});
				});
			},
			dnsResolve: function (data, cback) { //app.system.net.dnsResolve
				if (!_m.ndns) return false;
				var
					start = Date.now(),
					out = [],
					address = '',
					errored = false,
					req = _m.ndns.Request({
						question: _m.ndns.Question({
							name: data.domain,
							type: data.type,
						}),
						server: data.server == 'default' ? undefined : ({
							address: data.server || '1.1.1.1',
							port: data.port || 53,
							type: data.proto || 'udp'
						}),
						timeout: data.timeout || 1000
					});
				req.on('timeout', function () {
					errored = true;
					var delta = (Date.now()) - start;
					cback({ result: 'error', code: 'timeout', delta: delta.toString() });
				});
				req.on('message', function (err, answer) {
					answer.answer.forEach(function (a) {
						if (data.type == 'A' && a.address && !address)
							address = '' + a.address;
						out.push(a);
					});
				});
				req.on('end', function () {
					if (errored)
						return;
					var delta = (Date.now()) - start;
					cback({ result: 'success', data: out, address: address, delta: delta.toString() });
				});
				req.send();
			},
			arp: {
				_lastScan: {
					date: '',
					values: null
				},
				autoPingNetwork: function (opts, cback) { //system.net.arp.autoPingNetwork
					//app.diag.basicData.cidr
					//console.log('autoping', app.diag.basicData.cidr)
					let _ci = '', _s = app.diag.basicData.cidr.split('/');
					_ci = '' + _s[0];
					if (_s[1] < 24) { //opts && opts.firstRun && 
						_ci += '/24';
					}
					if (_ci.indexOf('/') == -1)
						_ci += '/' + _s[1];
					//console.log('autoping', _ci)

					var cp = app._m.childProcess.fork(system.libsDir + 'autoPingNet.js');
					cp.on('message', function (data) {
						data = app.JSON.parse(data);
						//console.log(data)
						//data=data.toString();
						switch (data.action) {
							case 'log':
								console.log(data.data);
								break;
							case 'started':
								//console.log(data);
								break;
							case 'ready':
								//console.log('sending start with cidr:' + _ci)
								cp.send({ action: 'start', cidr: _ci });
								break;
							case 'completed':
								if (cback) cback(data)
								if (data?.up) {
									for (let i of Object.keys(data.up)) {
										if (!system._data?._pingHosts) system._data._pingHosts = {};
										if (!data.up[i].date) data.up[i].date = new Date().toISOString();
										system._data._pingHosts[i] = data.up[i];
										try {
											if (app.diag?.win?.window) app.diag.win.window.updateARPField(i, 'ping', data.up[i].ttl);
										} catch (er) { }
									}
								}
								//console.log('autoping network completed', data)
								break;
							case 'error':
								console.error('autoPingNetwork ERROR:', data.error);
								break;
							//default: console.log('GOT', data)
						}
					}).
						on('error', function (err) { console.error(err); }).
						on('exit', function (code, signal) {
							if (code != 0) {
								console.error('autoPingNetwork EXIT CODE:', code, signal);

								if (signal == 'SIGSEGV') {
									setTimeout(function () {
										system.net.arp.autoPingNetwork(opts, cback)
									}, 1000);
								}
							}
						});
				},
				get: function (ip, cback) {
					arp.getMAC(ip, cback);
				},
				list: function (cb) { // app.system.net.arp.list
					arp.listALL(function (err, data) {
						var out = {};
						if (!err) {
							for (let i = 0; i < data.length; i++) {
								out[data[i].mac] = data[i].ip;
							}
							app.system.net.arp._lastScan.date = new Date().toISOString();
							if (!app.system.net.arp._lastScan.values || JSON.stringify(app.system.net.arp._lastScan.values) != JSON.stringify(out)) {
								app.system.net.arp._lastScan.values = out;
								app.system.net.arp._lastScan.lastChanged = new Date().toISOString();
							}
							try {
								app._m.fs.writeFile(app.cacheDir + "arp_lastScan.json", JSON.stringifyAligned(app.system.net.arp._lastScan), function () { })
							} catch (er) { }
							if (app.pathExists(app, 'data.session.configs.printers'))
								app.printManager.checkNetworkPrintersIPAddresses();
							try { app.pos.eft.manageIPChange(); } catch (er) { }
							try {
								if (app.diag?.arp?.set) app.diag.arp.set();
							} catch (er) { console.error('Error setting diag.win.window.setARPTable', er.message, app.system.net.arp._lastScan); }
						}
						if (cb) cb(err, out);
					});
				},
				scan: function (iface, cb) {

				}
			},
			ping: async function (target, cback, cfg) {
				if (!cfg) cfg = {};
				var
					parent = app.getParentStack(),
					start = new Date().getTime(),
					cbacked = false,
					out = {
						date: new Date().toISOString(),
						result: 'error',
						code: '',
						ttl: 0
					};
				try {
					if (!/^(([0-9]{1,3}\.){3}([0-9]{1,3}))$/.test(target))
						resolveRes = await new Promise((resolve) => {
							_m.dns.reverse(target, function (err, hname) {
								try {
									if (hname) {
										out.hostname = hname[0] + '';
									}
								}
								catch (er) {

								}
								resolve({ err, hname })
							});
						})
					try {
						if (cbacked) return;
						start = new Date().getTime();
						_m.ping.sys.probe(target, function (isAlive, error) {
							if (cbacked) return;

							try {
								if (!isAlive && !error) error = 'unreachable';
								if (error) {
									//console.log (target + ": " + error.toString ());
									out.code = error.toString();
								}
								else {
									out.result = 'success';
									//console.log (target + ": Alive");
								}
								out.ttl = (new Date().getTime() - start) / 1000;
								cbacked = 1;
								if (!system._data?._pingHosts) system._data._pingHosts = {};
								system._data._pingHosts[target] = out;
								try {
									cback(out);
								}
								catch (er) {
									console.error(parent, er.stack, er.message, target, isAlive, error)
								}

								try {
									if (app.diag?.win?.window) app.diag.win.window.updateARPField(target, 'ping', out.result == 'success' ? out.ttl : out.code);
								} catch (er) { }
							}
							catch (er) {
								console.error(er.message, target)
							}
						}, cfg);
					}
					catch (er) {
						console.error(er.message, target)
					}
				} catch (e) {
					out.code = 'invalid_address';
					cback(out);
				}
			},
			traceroute: function (target) { // app.system.net.traceroute
				return new Promise(async (resolve) => {
					var start = new Date().getTime();
					var res = {
						target: target,
						result: 'error',
						date: new Date().toISOString(),
						hops: [],
						destination: ''
					};
					if (!target || target == 'null') {
						console.warn('Invalid trace target "' + target + '"');
						resolve(res);
						return;
					}
					var fcts = [
						function (next) {
							system.net.ping(target, function (pingres) {
								res.ping = pingres;
								next();
							});
						},
						/*function (next) {
							(async () => {
								var Traceroute = require(system.libsDir + 'traceroute.js');
								var tracer = await new Traceroute({ target: target });
								res.runtime = new Date().getTime() - start;
								res.destination = tracer.destination;
								res.hops = tracer.hops;
								next();

							})();
						},*/
						function (next) {
							try {
								var Traceroute = require('nodejs-traceroute');
								var tracer = new Traceroute();
								tracer
									//.on('pid',function(pid){
									//	//console.log('pid:',pid);
									//})
									.on('destination', function (destination) {
										res.destination = '' + destination;
										//console.log('destination:',destination);
									})
									.on('hop', function (hop) {
										//console.log('hop:',JSON.stringify(hop));
										res.hops.push(hop);
									})
									.on('close', function (code) {
										//console.log('close: code',code);
										if (code === 0)
											res.result = 'success';
										if (res.hops && res.hops.length && res.hops[res.hops.length - 1].rttl == '*')
											res.result = 'timeout';
										res.runtime = new Date().getTime() - start;
										var ips = {};
										for (let i of res.hops.filter((a) => { return a?.ip?.trim() && a?.ip != '*' && a?.ip != 'Request timed out.' && a.ip.length > 7; })) {
											ips[i.ip] = '';
										}
										_m.async.each(Object.keys(ips), function (hop, nextHop) {
											if (!hop?.trim() || hop == '*' || /^(([0-9]{1,3}\.){3}([0-9]{1,3}))$/.test(hop)) {
												//console.log('Traceroute skip hop', hop)
												nextHop();
												return;
											}
											try {
												_m.dns.reverse(hop, function (err, hname) {
													if (hname?.[0])
														ips[hop] = hname[0];
													//console.log(hop.ip,'resolve to',hname[0])
													nextHop();
												});
												return;
											} catch (er) {
												console.error('dns.reverse on "' + hop + '" from "' + target + '" failed with ' + er.message)
											}
											nextHop();
										}, function () {
											for (var i = 0; i < res.hops.length; i++) {
												res.hops[i].hostname = '' + ips[res.hops[i].ip];
											}
											next();
										});
									});
								tracer.trace(target);
							} catch (ex) {
								console.log(ex?.message || ex, typeof target, target);
							}
						}
					];
					_m.async.each(fcts, function (f, next) {
						f(next);
					}, function () {
						resolve(res);
					});
				});
			}
		},
		sendSystemInfo: {
			_timer: null,
			init: function () {
				clearTimeout(system.sendSystemInfo._timer);
				if (app.web.status == 'online') {
					system.vars.systemInfo.diskUsage = 1 * system.diskUsage._data;
					system.emit({
						module: 'system',
						action: 'systemInfo',
						data: system.vars.systemInfo
					});
				}
				system.sendSystemInfo._timer = setTimeout(system.sendSystemInfo.init, 1000 * 60 * 5);
			}
		},
		pkill: async (name, opts) => {
			return new Promise(async (resolve) => {
				if (app.cfg.platform.indexOf('win') === 0) {
					app._m.exec('taskkill /f /im ' + name + ' /t', opts?.options || {}, function () {
						resolve();
					});
					return;
				}
				app._m.exec((opts.sudo ? "echo '" + app._m.os.userInfo().username + "01!' | sudo -S " : '') + 'pkill ' + name, opts?.options || {}, function () {
					resolve();
				});
			})
		},
		stopProcessesByGrep: function (name, options, cback) {
			if (typeof options == 'function') {
				cback = options;
				options = {}
			}

			app._m.exec('ps aux | grep ' + name + ' | grep -v color', function (err, stdout, stderr) {
				var list = [];
				if (stdout) {
					list = stdout.split('\n');
					for (let i = 0; i < list.length; i++) {
						//if(list[i].indexOf('modules/logrotate/rotator-child.js')!=-1){
						app._m.exec('kill -9 ' + list[i].replace(/\s+/g, ' ').split(' ')[1], function () { });
						//}
					}
				}
				if (cback) cback(list);
			});
		},
		diskUsage: {
			_data: null,
			getFolderSize: function (f) { //system.diskUsage.getFolderSize=function(f){
				let
					_cwd = '' + f,
					_cmd = 'du -sb . 2>&1 | grep -v  \'^du:\'';
				if (app.cfg.platform.indexOf('darwin') === 0)
					_cmd = 'du -sk . 2>&1 | grep -v  \'^du:\'';
				if (app.cfg.platform.indexOf('win') === 0) {
					_cwd = '' + app.baseDir + 'vendors\\sysInternals\\';
					_cmd = 'du.exe -nobanner -accepteula -q -c "' + f + '"';
				}
				console.log('CWD', _cwd)
				console.log('CMD', _cmd)
				let _o = app._m.execSync(_cmd, { shell: true, cwd: _cwd }).toString();
				let processOutput = {
					// windows
					win32: function (stdout) {
						// query stats indexes from the end since path can contain commas as well
						const stats = stdout.split('\n')[1].split(',');
						const bytes = +stats.slice(-2)[0];
						return bytes;
					},
					// macos
					darwin: function (stdout) {
						const match = /^(\d+)/.exec(stdout);
						const bytes = Number(match[1]) * 1024;
						return bytes;
					},
					// any linux
					linux: function (stdout) {
						const match = /^(\d+)/.exec(stdout);
						const bytes = Number(match[1]);
						return bytes;
					},
				};
				return processOutput[app.cfg.platform.indexOf('win') === 0 ? 'win32' : process.platform](_o);
			},
			get: function (opts, cback) {
				if (!cback && typeof opts == 'function') {
					cback = opts;
					opts = {};
				}
				if (!opts) opts = {};
				try {
					//console.log('Get disk usage')
					let
						_prev = 1 * (system.diskUsage._data || 0),
						_start = new Date().getTime(),
						_c = 'df -h --output=pcent ' + app.baseDir + ' | grep -v Uti | grep -v Use | xargs';
					if (app.cfg.platform.indexOf('win') === 0) {

						_c = 'fsutil volume diskfree C:';
						_m.exec(_c, function (err, stdout, stderr) {
							stdout = stdout.trim().replace('\r\n', '\n').split('\n');
							var out = [];
							for (let i = 0; i < stdout.length; i++) {
								out.push(stdout[i].split(':').pop().trim().split('(')[0].trim());
							}
							system.diskUsage._data = parseInt(100 - (out[2] / out[1]) * 100);
							if (_prev != system.diskUsage._data) system.diskUsage.send();
							if (!opts.skipCleanup) system.diskUsage.cleanUp.check();
							//console.log('Got disk usage in ' + ((new Date().getTime() - _start) / 1000) + ' seconds')
							if (cback) cback();
						});
						return;
					}
					_m.exec(_c, function (err, stdout, stderr) {
						system.diskUsage._data = parseInt(stdout.replace('%', '').trim());
						if (_prev != system.diskUsage._data) {
							//console.log(_prev, '!=', system.diskUsage._data);
							system.diskUsage.send();
						}
						if (!opts.skipCleanup) system.diskUsage.cleanUp.check();
						if (cback) cback();
					});


					return;
				}
				catch (e) {
					console.log(e);
					if (cback) cback();
				}
			},
			send: function () {

				app.web.emit({
					volatile: 1,
					module: 'sessions',
					action: 'updateDiskUsage',
					data: system.diskUsage._data
				});
			},
			cleanUp: {
				test: { //app.system.diskUsage.cleanUp.test={
					_stopped: false,
					stop: function () {
						app.system.diskUsage.cleanUp.test._stopped = true;
						app.system.diskUsage.cleanUp.test._exec.kill();
					},
					run: function () { //app.system.diskUsage.cleanUp.test.run=function(){
						app.system.diskUsage.cleanUp.test._stopped = false;
						//for n in {1..2000}; do     dd if=/dev/urandom of=file$( printf %03d "$n" ).bin bs=128 count=$(( RANDOM * 1024 )); done
						let _i = 0, _doFile = function () {
							if (app.system.diskUsage.cleanUp.test._stopped) return;
							if (app.system.diskUsage._data > 95) {
								setTimeout(_doFile, 5 * 1000);
								return;
							}
							try { app._m.fs.ensureDirSync('/home/' + app._m.os.userInfo().username + "/diskCleanerTest"); } catch (er) { }
							let
								_fn = "diskCleanerTest/file" + _i + ".bin",
								_fp = '/home/' + app._m.os.userInfo().username + "/",
								_s = app.system.randomInt(5, 2 * 1024) + "M";
							if (app._m.fs.existsSync(_fp + _fn)) {
								_i++;
								_doFile();
								return;
							}

							console.log('Create disk cleaner ' + _s + ' test file', _fn)
							app.system.diskUsage.cleanUp.test._exec = app._m.exec("fallocate -l " + _s + " " + _fp + _fn, function () {
								_i++;
								app.system.diskUsage.get(function () {
									setTimeout(function () {
										_doFile();
									}, 1000);
								});
							})
						};
						_doFile();
					}
				},
				_isCleaning: false,
				_notif: null,
				check: function () {
					let pct = system.diskUsage._data;
					if (app.pathExists(app.data, 'session.configs.advanced.disk.cleaner.autoClean.enabled') == '1' && pct >= 95) {
						if (app.cfg.platform.indexOf('win') !== 0 && (!system.diskUsage.cleanUp._notif || system.diskUsage.cleanUp._notif.type == 'notice')) {

							if (system.diskUsage.cleanUp._notif?.type == 'notice' && system.diskUsage.cleanUp?._notif?.win) {
								try { system.diskUsage.cleanUp._notif.win.remove(); } catch (er) { }
								system.diskUsage.cleanUp._notif = null;
							}
							system.diskUsage.cleanUp._notif = {
								type: 'warn', win: app.pos.notifications.show({
									preventClose: 1,
									focusOnBlur: !app.isSDK,
									icon: {
										type: 'html',
										html: '<i class="fa-solid fa-triangle-exclamation"></i>'
									},
									title: app.parseLocales('system.disk.cleaningInProgress.title'),
									message: app.parseLocales('system.disk.cleaningInProgress.message'),
									closeBtn: 0
								})
							};
						}
						system.diskUsage.cleanUp.exec(function () {
							if (system.diskUsage.cleanUp?._notif?.win) try { system.diskUsage.cleanUp._notif.win.remove(); } catch (er) { }
							system.diskUsage.cleanUp._notif = null;
						});
						return;
					}
					if (pct >= 90) {
						//show a warning
						if (!system.diskUsage.cleanUp._notif) system.diskUsage.cleanUp._notif = {
							type: 'notice', win: app.pos.notifications.show({
								preventClose: 1,
								focusOnBlur: !app.isSDK,
								icon: {
									type: 'html',
									html: '<i class="fa-solid fa-triangle-exclamation"></i>'
								},
								title: app.parseLocales('system.disk.lowDiskSpace.title'),
								message: app.parseLocales('system.disk.lowDiskSpace.message'),
								closeBtn: 1
							})
						};
						return;
					}
					if (system.diskUsage.cleanUp?._notif?.win) try { system.diskUsage.cleanUp._notif.win.remove(); } catch (er) { }
				},
				exec: function (cback) {//app.system.diskUsage.cleanUp.exec=function (cback) {
					if (system.diskUsage.cleanUp._isCleaning) return false;
					if (app.pathExists(app.data, 'session.configs.advanced.disk.cleaner.autoClean.enabled') != '1') {
						if (cback) cback();
						return false;
					}
					//try emptying trash first
					let _trshCmd =
					{
						cmd: 'rm -rf *',
						opts: {
							shell: true,
							cwd: app.homeDir + '.local/share/Trash/'
						}
					}
						;
					if (app.cfg.platform.indexOf('win') === 0) {
						_trshCmd =
						{
							cmd: 'rd /s /q \$Recycle.bin',
							opts: {
								shell: true,
								cwd: 'C:\\'
							}
						}
							;
					}
					app.system.diskUsage.cleanUp._isCleaning = true;

					app._m.exec(_trshCmd.cmd, _trshCmd.opts, function (a, b, c) {
						//console.log(_trshCmd.cmd, a, b, c)
						if (app.cfg.platform.indexOf('win') === 0) {
							app.system.diskUsage.cleanUp._isCleaning = false;
							//http://windows-powershell-scripts.blogspot.com/2009/08/unix-linux-find-equivalent-in.html
							if (cback) cback();
							return;
						}
						app.system.diskUsage.cleanUp._isCleaning = true;

						app.system.diskUsage.get(function () {
							if (system.diskUsage._data <= 85) {

								system.diskUsage.cleanUp._isCleaning = false;
								if (cback) cback();
								return;
							}
							let
								_i = setInterval(function () {
									if (!system.diskUsage.cleanUp._isCleaning) { clearInterval(_i); return; }
									system.diskUsage.get({ skipCleanup: 1 });
								}, 1000),
								_mixes = [
									[150, [1000, 800, 600, 400, 200, 100, 50]],
									[120, [1000, 800, 600, 400, 200, 100, 50]],
									[90, [1000, 800, 600, 400, 200, 100, 50]],
									[60, [1000, 800, 600, 400, 200, 100, 50]],
									[30, [1000, 800, 600, 400, 200, 100, 50]],
									[15, [1000, 800, 600, 400, 200, 100, 50]],
									[5, [1000, 800, 600, 400, 200, 100, 50, 20, 10, 5]],
									[3, [1000, 800, 600, 400, 200, 100, 50, 20, 10, 5]],
									[2, [1000, 800, 600, 400, 200, 100, 50, 20, 10, 5]],
									[1, [1000, 800, 600, 400, 200, 100, 50, 20, 10, 5]],
									[0, [1000, 800, 600, 400, 200, 100, 50, 20, 10, 5, 3, 2]],
								];
							app._m.async.eachSeries(_mixes, function (_m, nm) {
								if (system.diskUsage._data <= 85) {
									system.diskUsage.cleanUp._isCleaning = false;
									nm();
									clearInterval(_i);
									return;
								}
								app._m.async.eachSeries(_m[1], function (_t, nt) {
									if (system.diskUsage._data <= 85) {
										system.diskUsage.cleanUp._isCleaning = false;
										nt();
										clearInterval(_i);
										return;
									}
									system.diskUsage.cleanUp._isCleaning = true;
									let cmd = "find ~/ -not -path \"*/.thunderbird/*\" -not -path \"*/AzimutPOS/*\" -type f" +
										(_m[0] ? " -atime +" + _m[0] : '') + " -size +" + _t + "M -printf '%p\\n' | sort -zk 1n";
									app._m.exec(cmd, function (err, stdout, stderr) {
										if (err) console.error(err);
										if (stdout) {
											let _out = stdout.replace(/\0/g, '').replace(/\r/g, '').split('\n').filter(function (a) { return a && a.trim(); });
											app._m.async.eachSeries(_out, function (i, nf) {
												if (!i) { nf(); return; }
												app.system.diskUsage.get(function () {
													if (system.diskUsage._data > 85) {
														if (app.isSDK) console.log('Deleting file', i);
														try { app._m.childProcess.exec("rm -f '" + i + "'", function () { nf(); }); } catch (er) { nf(); }
													}
													else {
														console.log('Disk cleaned down to 85%.');
														//hide notifications
														clearInterval(_i);
														system.diskUsage.cleanUp._isCleaning = false;
														if (cback) cback();
														return;
													}
												});
											}, function () {
												nt();
											});
											return;
										}
										nt();
									})
								}, function () {
									nm();
								});

							}, function () {
								system.diskUsage.cleanUp._isCleaning = false;
								clearInterval(_i);
								if (cback) cback();
							})
						});
					})

				}
			}
		},
		unzip: function (vars, cback) {
			let szip;
			if (app.cfg.platform.indexOf('win') === 0) {
				let
					_args = ['x', '-y', '' + vars.zip_in + '', '-o' + vars.cwd];
				console.log('7za', _args)
				szip = app._m.spawn(app.baseDir + '\\vendors\\SevenZip\\7za.exe', _args, { cwd: vars.cwd });
			}
			else
				szip = app._m.spawn('unzip', ['-q', vars.zip_in], { cwd: vars.cwd })
			szip.stdout.on('data', (data) => {
				console.log('UNZIP', data.toString());
			});

			szip.stderr.on('data', (data) => {
				console.log('UNZIP stderr', data.toString());
			});

			szip.on('exit', (code) => {
				console.log(`szip exited with code ${code}`);
				cback();
			});
			return;
		},
		request: {
			_exec: function (params, cback) {

				var noRetry = app.pathExists(params, 'noRetry') || params?.options?.noRetry ? 1 : 0;
				delete params.noRetry;
				let options = app._m.xtend.clone(params.options || {});
				delete params.options;
				var _randUA = params.randomUA ? true : false;
				try {
					if (_randUA && !_m.randomUA) _m.randomUA = require('random-useragent');
				} catch (er) { }
				delete params.randomUA;

				var noCache = app.pathExists(params, 'noCache') ? 1 : 0;
				delete params.noCache;
				if (noCache) {
					params.headers['Cache-Control'] = 'no-cache';
				}
				//todo: CA is cloud, each server it's certificate
				//each device it's certificate too so it can securely authenticate and sign requests
				//params.ca: [],
				let
					cnt = 0,
					time = _m.microtime.now(),
					date = new Date().toISOString(),
					req = _m.xtend.extend({
						headers: {
							'User-Agent': _randUA && _m.randomUA ? _m.randomUA.getRandom() : app.cfg.userAgent + '/' + app.cfg.version,
							'Accept': 'application/json'
						},
						followAllRedirects: true,
						rejectUnauthorized: false,
						timeout: 20 * 1000
					}, params || {}),
					globalstart = new Date().getTime(),
					_body = null,
					_doReq = function () {
						var
							isNetError = false,
							thisCount = 1 * cnt,
							runtime = 0,
							totalRuntime = 0,
							_return = null,
							_headers = '',
							start = new Date().getTime();
						if (app.tryCatch(function () {
							_m.request(req, function (er, res, body) {
								cnt++;
								let _statusCode = app.pathExists(er, 'code') || app.pathExists(er, 'statusCode') || app.pathExists(res, 'statusCode') || app.pathExists(er, 'message');
								//console.log(_statusCode, er, res, body)
								if (!_statusCode || _statusCode != 200) {
									var _isNetworkError = ([502, 503, 504].indexOf(_statusCode) || networkErrorsRetry.indexOf(_statusCode));
									if (!noRetry && _isNetworkError && (!options.maxTries || options.maxTries > cnt)) {
										var _incTime = 5000 + 100 * Math.pow(2, cnt),
											_maxWait = 1000 * 60 * 3;
										if (_incTime > _maxWait) _incTime = 1 * _maxWait;

										setTimeout(_doReq, _incTime);
										return;
									}
									cback({
										result: 'error',
										code: _statusCode,
										isNetError: _isNetworkError,
										message: app.pathExists(er, 'message') || app.pathExists(res, 'statusMessage') || ''
									}, res, body)
									return;
								}

								cback(er, res, body);
							});
						})) console.warn('url', req.method, req.uri)
					};
				_doReq();
			},
			GET: function (uri, opts, cback) {
				return new Promise(async (resolve) => {
					let
						_return = (e, r, b) => {
							if (app.tryCatch(function () {
								if (cback) cback(e, r, b);
							})) {
								console.warn('From system.request.GET ' + uri);
							}
							resolve({ error: e, response: r, data: b });
						}
					if (!uri) {
						_return({ result: 'error', code: 400, errorCode: 'missing_uri', hint: 'URI is missing' }, null, null);
						return;
					}
					else if (typeof uri == 'object' && (uri.url || uri.uri)) {
						uri = '' + (uri.url || uri.uri);
					}
					if (typeof opts == 'function') {
						cback = opts;
						opts = null;
					}
					system.request._exec(_m.xtend.extend({
						method: 'GET',
						uri: uri,
						headers: {
							'Content-Type': 'application/json'
						}
					}, opts || {}), function (e, r, b) {
						_return(e, r, b)
					});
				});
			},
			POST: function (uri, fields, opts, cback) {
				return new Promise(async (resolve) => {
					let
						_noDefaultType = opts?.noDefaultType ? true : false,
						_return = (e, r, b) => {
							if (app.tryCatch(function () {
								if (cback) cback(e, r, b);
							})) {
								console.warn('From system.request.POST ' + uri);
							}
							resolve({ error: e, response: r, data: b });
						}
					if (!uri) {
						_return({ result: 'error', code: 400, errorCode: 'missing_uri', hint: 'URI is missing' }, null, null);
						return;
					}
					else if (typeof uri == 'object' && (uri.url || uri.uri)) {
						cback = opts;
						opts = fields;
						fields = uri;
						uri = '' + (uri.url || uri.uri);
					}
					if (!fields) {
						_return({ result: 'error', code: 400, errorCode: 'missing_fields', hint: 'Fields are missing' }, null, null);
						return;
					}
					if (typeof opts == 'function') {
						cback = opts;
						opts = null;
					}
					delete opts?.noDefaultType;
					var params = _m.xtend.extend({
						method: 'POST',
						uri: uri,
						headers: _noDefaultType ? {} : {
							'Content-Type': 'application/json'
						}
					}, opts || {});

					if (params.headers['Content-Type'] == 'text/plain' || typeof fields == 'string' && fields.indexOf('AES:{') === 0) {
						params.headers['Content-Type'] = 'text/plain';
						params.body = fields;
					}
					else if (params.headers['Content-Type'] == 'application/json')
						params.json = fields;
					else
						params.fields = fields;
					system.request._exec(params, function (e, r, b) {
						_return(e, r, b)
					});
				});
			},
			PUT: function (uri, fields, opts, cback) {
				if (!uri) {
					if (app.tryCatch(function () {
						cback({ result: 'error', code: 400, errorCode: 'missing_uri', hint: 'URI is missing' }, null, null);
					})) {
						//console.error('Error in cback GET ' + uri) 
					}
					return;
				}
				if (!fields) {
					if (app.tryCatch(function () {
						cback({ result: 'error', code: 400, errorCode: 'missing_fields', hint: 'Fields are missing' }, null, null);
					})) {
						//console.error('Error in cback GET ' + uri) 
					}
					return;
				}
				if (typeof opts == 'function') {
					cback = opts;
					opts = null;
				}
				var params = _m.xtend.extend({
					method: 'PUT',
					uri: uri,
					headers: {
						'Content-Type': 'application/json'
					}
				}, opts || {});

				if (params.headers['Content-Type'] == 'application/json')
					params.json = fields;
				else if (params.headers['Content-Type'] == 'text/plain')
					params.body = fields;
				else
					params.fields = fields;
				system.request._exec(params, function (e, r, b) {
					if (app.tryCatch(function () {
						cback(e, r, b)
					})) {
						//console.error('Error in cback GET ' + uri) 
					}
				});
			}
		},
		uuid: {
			_regexp: [
				'[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}'
			],
			get: function () {
				if (system.nodeid.length == 0)
					throw new Error("Can't get node id (macAddress) maybe setting a timeout of 100 could fix it...");
				return _m.uuid.v1({ node: system.nodeid });
			},
			list: function (str) {
				if (typeof str != 'string')
					str = JSON.stringify(str);
				str = str.toLowerCase();
				var out = [];
				for (var i = 0; i < system.uuid._regexp.length; i++) {
					var m = str.match(new RegExp(system.uuid._regexp[i], "g"));
					if (m && m.length)
						for (var x = 0; x < m.length; x++)
							if (out.indexOf(m[x]) == -1)
								out.push(m[x]);
				}
				return out;
			},
			validate: function (str) {
				if (!str)
					return false;
				str = str.toString().trim();
				if (str.length != 36)
					return false;
				for (var i = 0; i < system.uuid._regexp.length; i++) {
					var r = new RegExp("^" + system.uuid._regexp[i] + "$", "i");
					if (r.test(str))
						return true;
				}
				return false;
			}
		},
		randomInt: function (min, max) {
			return Math.floor(Math.random() * (max - min + 1)) + min;
		},

		humanSize: function (bytes, si) {
			si = ['bool', 'number'].indexOf(typeof si) != -1 && !si ? false : true;
			var thresh = si ? 1000 : 1024;
			if (Math.abs(bytes) < thresh) {
				return bytes + ' B';
			}
			var units = si ? ['kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'] : ['KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'];
			var u = -1;
			do {
				bytes /= thresh;
				++u;
			} while (Math.abs(bytes) >= thresh && u < units.length - 1);
			return bytes.toFixed(1) + ' ' + units[u];
		},
		Strings: {
			hex2bytes: function (str) { //core.Strings.hex2bytes
				var result = [];
				while (str.length >= 2) {
					result.push(parseInt(str.substring(0, 2), 16));
					str = str.substring(2, str.length);
				}
				return result;
			},
			getBytes: function (string) { //core.Strings.getBytes
				return new Buffer.byteLength(string, 'utf8');
			},
			matchAll: function (str, reg) { //regex tester https://regex101.com/#
				var out = [];
				while (match = reg.exec(str)) {
					out.push(match[1]);
				}
				return out;
			},
			sanitizeCSV: function (str) { // core.Strings.sanitizeCSV
				if (!str)
					return str;
				var reg = /,\"(([^"]+|)(")([^"]+|))\",/;
				var lines = str.split("\n");
				for (var l = 0; l < lines.length; l++) {
					var _m = lines[l].match(reg);
					if (_m && _m[1]) {
						//console.log('REPLACE',_m[1],'TO',_m[1].replace(/\"/g,'&quot;'));
						lines[l] = lines[l].replace(_m[1], _m[1].replace(/\"/g, '&quot;'));
					}
				}
				return lines.join("\n");
			},
			similarity: function (s1, s2) {
				var editDistance = function (as1, as2) {
					as1 = as1.toLowerCase();
					as2 = as2.toLowerCase();

					var costs = new Array();
					for (var i = 0; i <= as1.length; i++) {
						var lastValue = i;
						for (var j = 0; j <= as2.length; j++) {
							if (i == 0)
								costs[j] = j;
							else {
								if (j > 0) {
									var newValue = costs[j - 1];
									if (as1.charAt(i - 1) != as2.charAt(j - 1))
										newValue = Math.min(Math.min(newValue, lastValue),
											costs[j]) + 1;
									costs[j - 1] = lastValue;
									lastValue = newValue;
								}
							}
						}
						if (i > 0)
							costs[as2.length] = lastValue;
					}
					return costs[as2.length];
				};
				var longer = s1;
				var shorter = s2;
				if (s1.length < s2.length) {
					longer = s2;
					shorter = s1;
				}
				var longerLength = longer.length;
				if (longerLength == 0) {
					return 1.0;
				}
				return (longerLength - editDistance(longer, shorter)) / parseFloat(longerLength);
			},
			stripWhiteSpaces: function (s) { // core.Strings.stripWhiteSpaces()
				if (s == 'undefined') //if dat is a string and it's value is undefined
					return '';
				var f = system.Strings.stripWhiteSpaces;
				if (s == null || s == '' || _m.Type.is(s, Boolean) || _m.Type.is(s, Number)) // true/false || integers
					return s;
				if (_m.Type.is(s, String)) {
					return s.replace(/\s{2,}/g, ' ').trim();
				} else {
					if (_m.Type.is(s, Object) || typeof s == 'object')
						var out = {};
					else if (_m.Type.is(s, Array))
						var out = [];
					else return false;
					for (var i in s) {
						if (i && typeof s[i] != 'undefined' && typeof s[i] != 'function') { // if(i && typeof s[i]=='string' && s[i])
							try {
								out[i] = f(s[i]);
							}
							catch (e) {
								console.error(e, 'In function core.Strings.stripWhiteSpaces', 'typeof out:' + typeof out, 'typeof i: ' + typeof i, 'typeof s: ' + typeof s, _m.Type.is(s, Object));
							}
						}
					}
					return out;
				}
				return false;
			},
			zeroFill: function (number, width, cha) { // core.Strings.zeroFill
				if (!cha)
					cha = '0';
				if (!width) width = 2;
				width -= number.toString().length;
				if (width > 0)
					return new Array(width + (/\./.test(number) ? 2 : 1)).join(cha) + number;
				return number + ""; // always return a string
			}
		},
		password: {
			/**
			 * checkHash check that the given password (p) match the hash (h)
			 */
			checkHash: function (p, h) { //core.password.checkHash
				if (_m.bcrypt.compareSync(p, h))
					return true;
				return false;
			},
			generate: function (plength, wantSymbols) { // core.password.generate()
				var theSymbols = ["!", "$", "%", "&", "*", "(", ")", "-", "_", "=", "+", "[", "{", "]", "}", ";", ":", "@", "#", "~", "|", ",", "<", ".", ">", "?"], //Removed "\\", because backslash character can cause problems when passwords are stored.
					lengthOfPassword = (typeof plength != 'undefined' && plength) ? plength : 10,
					theLetters = "abcdefghkmnpqrstuvwxyz",
					StrongPasswordArray = [],
					capitalise,
					numberOfDigits,
					positionForNumeric,
					theNumber,
					numberOfSymbols,
					positionForSymbol,
					locationOfSymbolInArray,
					theSymbol;
				wantSymbols = (typeof wantSymbols != 'undefined') ? wantSymbols : true;

				for (let i = 0; i < lengthOfPassword; i++) {
					capitalise = Math.round(Math.random() * 1);
					if (capitalise === 0)
						StrongPasswordArray.push(theLetters.charAt(Math.floor(Math.random() * theLetters.length)).toUpperCase());
					else
						StrongPasswordArray.push(theLetters.charAt(Math.floor(Math.random() * theLetters.length)));
				}
				numberOfDigits = Math.round(Math.random() * Math.round(lengthOfPassword * 0.8)) + 1;
				for (let i = 0; i < numberOfDigits; i++) {
					positionForNumeric = Math.round(Math.random() * (lengthOfPassword - 1));
					theNumber = Math.round(Math.random() * 9);
					StrongPasswordArray[positionForNumeric] = theNumber;
				}
				if (wantSymbols) {
					numberOfSymbols = Math.round(Math.random() * Math.round(lengthOfPassword * 0.8)) + 1;
					for (let i = 0; i < numberOfSymbols; i++) {
						positionForSymbol = Math.round(Math.random() * (lengthOfPassword - 1));
						locationOfSymbolInArray = Math.round(Math.random() * (theSymbols.length - 1));
						theSymbol = theSymbols[locationOfSymbolInArray];
						StrongPasswordArray[positionForSymbol] = theSymbol;
					}
				}
				return StrongPasswordArray.join('');
			},
			hash: function (p, l) { //core.password.hash
				if (typeof l == 'undefined' || !l)
					l = 14;
				return _m.bcrypt.hashSync(p, l);
			}
		},
		shutdown: function () {
			try { app.system.diskUsage.cleanUp.test.stop(); } catch (er) { }
			try {
				let _modules = Object.keys(system);
				for (let i = 0; i < _modules.length; i++) {
					if (system[_modules[i]] && system[_modules[i]].shutdown)
						try { system[_modules[i]].shutdown(); } catch (er) { }
				}
			} catch (er) { }
		},
		server_migration: {
			routeEvent: (d) => {
				switch (d.action) {
					case 'completed':
						system.server_migration.completed();
						break;
					case 'started':
						system.server_migration.started();
						break;
					case 'progress':
						system.server_migration._currentProgress = 1 * d.data.progress;
						app.splashscreen.win.window.setProgress(d.data.progress);
						break;
				}
			},
			_progressIval: null,
			_currentProgress: 5,
			completed: () => {
				clearInterval(system.server_migration._progressIval);
				app.splashscreen.setMessage('server_migration', app.parseLocales('system.server_migration.completed'));
				app.splashscreen.win.window.setProgress(100);
				setTimeout(() => {
					app.restart();
				}, 1000 * 5)
			},
			started: () => {
				app.pos.keepRunningOnClose = true;
				app.pos.exit();
				app.splashscreen.initialize(function () {
					app.splashscreen.setMessage('server_migration', app.parseLocales('system.server_migration.started'));
					app.splashscreen.unsetMessage('init');
					app.splashscreen.unsetMessage('gathering_infos');
					app.splashscreen.win.window.setProgress(5);
					system.server_migration._progressIval = setInterval(() => {
						system.server_migration._currentProgress += 4;
						if (system.server_migration._currentProgress >= 100) system.server_migration._currentProgress = 100;
						app.splashscreen.win.window.setProgress(system.server_migration._currentProgress);
					}, 1000 * 13)

				})
			}
		}
	};
module.exports = system;