var _defaultDatePickerOptions = {
	debug: false
}
var register_loading = false, _loadingOverlayHomeBtnTimer = null;
if (typeof _onDocReady == 'undefined') _onDocReady = [];
function pe(o, p) {
	if (!p || !o)
		return false;
	p = p + '';
	var m = (p.indexOf('.') != -1) ? p.split(".") : [p];
	if (m.length > 1 && !m[0])
		m.shift();
	var cm = o;
	for (var i = 0; i < m.length; i++) {
		if (cm == null)
			return false;
		if (typeof cm[m[i]] !== 'undefined') //http://andrew.hedges.name/experiments/in/
			cm = cm[m[i]];
		else return false;
	}
	return cm;
}
var stringToRegex = (s, m) => (m = s.match(/^([\/~@;%#'])(.*?)\1([gimsuy]*)$/)) ? new RegExp(m[2], m[3].split('').filter((i, p, s) => s.indexOf(i) === p).join('')) : new RegExp(s);
function showLoadingOverlay(msg) {
	clearTimeout(_loadingOverlayHomeBtnTimer);
	console.log('Page is taking longer to load, show loading overlay...')
	$('.pageLoadingOverlay .loadingMessage').html(msg || '');
	_loadingOverlayHomeBtnTimer = setTimeout(() => {
		console.log('Loading took wayyyyy longer, may be had an error. show home btn')
		$('.pageLoadingOverlay .pageLoadingOverlayBtnWrapper').show();
	}, 1000 * 60);
	$('.pageLoadingOverlay').show();
	$('body').addClass('modal-open');
}
var
	_hashChanges = [],
	APPFCTS = {
		serverurl: '',
		onCryptoReady: () => {
			pwm._socket.connect()
		},
		vars: {
			namespace: 'webGui',
			ioOptions: {
				//namespace:'webGui',
				//path:document.location.href.split('')
			}
		},
		asyncTimeout: (ms) => {
			return new Promise(resolve => setTimeout(resolve, ms));
		},
		asyncWait: async (t, t1) => {
			return new Promise(async (resolve) => {
				if (typeof t == 'string') {
					if (pe(window, t)) {
						resolve();
						return;
					}
					//wait for window... to exists
					do {
						await APPFCTS.asyncWait(t1 || 200);
					} while (!pe(window, t))
					resolve();
					return;
				}
				setTimeout(resolve, t)
			});
		},
		_w: typeof nw != 'undefined' && pe(nw, 'Window.get') ? nw.Window.get() : null,
		isSet: function (fct) {
			return pe(APPFCTS._w, fct) || pe(APPFCTS._w, 'window.' + fct) || pe(window, fct) || false;
		},
		call: function (fct) {
			return pe(APPFCTS._w, fct) || pe(APPFCTS._w, 'window.' + fct) || pe(window, fct) || function () { throw 'Function "' + fct + '" not found'; };
		},
		set: function (k, v) {
			if (pe(APPFCTS._w, 'window')) APPFCTS._w.window[k] = v;
			else if (APPFCTS._w) APPFCTS._w[k] = v;
			else window[k] = v;
		},
		onDocumentReady: function (fct) {

			//if not on nw.js, load webcore and open socket
			//technoPOS_device

			if (APPFCTS._docIsReady) {
				try {
					fct();
				} catch (er) { console.error('Document ready', er); }
				return;
			}
			_onDocReady.push(fct);
		},
		block: function (vars) { // APPFCTS.block=function(vars){
			let e = vars.e || null;
			delete vars.e;
			if (!e) {
				if ($('.blockUI.blockMsg.blockPage').length) {
					$('.blockUI.blockMsg.blockPage').html(vars.message);
					if (vars.onBlock) vars.onBlock();
				}
				else
					$.blockUI($.extend(true, { baseZ: 99999999999999 }, vars));
			}
			else e.block($.extend(true, { baseZ: 99999999999999 }, vars));
		},
		core: {
			_call: async ({ fct, data = {}, options = {} }) => {
				return new Promise(async (resolve) => {
					//todo:handle retries
					let _timedout = false, _timeout = setTimeout(function () {
						if (_timedout) return false;
						_timedout = true;
						resolve(null);
					}, options?.timeout || 1000 * 30);
					let _return = (res) => {
						if (_timedout) return false;
						_timedout = true; //to prevent double cback
						clearTimeout(_timeout);
						try {
							resolve(res);
						} catch (err) { console.error(err); }
					}
					if (APPFCTS._w) {
						APPFCTS.call('coreFunction')({
							action: fct,
							datas: data
						}, _return)
						return;
					}
					if (APPFCTS.msgApi?.supported) {
						APPFCTS.msgApi.send({
							module: 'core',
							action: fct,
							datas: data
						}, _return)
						return;
					}
					APPFCTS.OLO.API('coreFunction/' + fct, data).then(_return);
				});
			},
			getTime: async (cback) => { //APPFCTS.core.getTime(console.log);
				let res = await APPFCTS.core._call({ fct: 'getTime', options: { timeout: 2000 } });
				try {
					if (cback) cback(res);
				} catch (err) { console.error(err); }
				return res;
			},
			addresses: {
				/**
				 * 
				 * @param {object} vars 
				 * 		@param {string} text typed address
				 * 		@param {object} metaData additionnal information to store to elastic history
				 * @param {function} cback 
				 * @returns 
				 */
				autocomplete: async (vars, cback) => {
					vars.brand = BRANCH_DATA.brand.id,
						vars.branch = BRANCH_ID;
					vars.location = BRANCH_DATA.address.lat + ',' + BRANCH_DATA.address.lng;
					vars.metaData = {
						technoPOS: $.extend(true, {
							employee: EMPLOYEE_PERSON_ID,
							register: REGISTER_ID
						}, pe(vars, 'metaData.technoPOS') || vars.metaData || {})
					}
					let res = await APPFCTS.core._call({
						fct: 'event', data: {
							module: 'geocoding',
							action: 'autocomplete',
							datas: vars
						}, options: { timeout: 2000, retries: 0 }
					});
					try {
						if (cback) cback(res?.results || res?.result || res);
					} catch (err) { console.error(err); }
					return res?.results || res?.result || res;
				},
				parse: async (a, cback) => {
					let vars = {
						formattedAddress: '' + a,
						brand: BRANCH_DATA.brand.id,
						branch: BRANCH_ID,
						metaData: {
							technoPOS: {
								employee: EMPLOYEE_PERSON_ID,
								register: REGISTER_ID
							}
						}
					}
					let res = await APPFCTS.core._call({
						fct: 'event', data: {
							module: 'geocoding',
							action: 'getPlace',
							datas: vars
						}
					});
					try {
						if (cback) cback(res);
					} catch (err) { console.error(err); }
					return res;
				}
			},
			mail: {
				syntax: function (email) {
					var re = /^[-!#$%&'*+\/0-9=?A-Z^_a-z{|}~](\.?[-!#$%&'*+/0-9=?A-Z^_a-z`{|}~])*@[a-zA-Z0-9](-?\.?[a-zA-Z0-9])*(\.[a-zA-Z](-?[a-zA-Z0-9])*)+$/i;
					if (re.test(email)) {
						var _email = email.split('@')[0];
						if (isNaN(1 * _email))
							return true;
					}
					return false;
				},
				checkDuplicate: async (ctrl, email, id) => {
					return await $.getJSON('index.php/' + ctrl + '/check_email_duplicate/' + ctrl + '/' + email + '/' + id)
					return false;
				},
				checkField: function (e) { //APPFCTS.core.mail.checkField
					return new Promise(async (resolve) => {
						//console.log('Please validate email against our intelligence database',e.val())

						//e is the field (jquery selector)
						//check syntax
						//check with cloud intelligence (database + disposable + banned + smtp validation)
						$('.form-field-email').removeClass('alert-danger text-danger');
						$('.form-field-email .field-status-message').html('');
						if (!e || !e.val()) {
							resolve({ result: 'error', code: 'empty' })
							return;
						}
						let _email = e.val().toLowerCase();
						if (_email != e.val()) e.val(_email);
						if (!APPFCTS.core.mail.syntax(_email)) {

							$('.form-field-email').addClass('alert-danger text-danger');
							let _message = [{
								en: 'Invalid syntax',
								fr: 'Syntaxe invalide'
							}[LOCALE]];
							$('.form-field-email .field-status-message').html(_message.join('<br/>'))
							resolve({ result: 'error', code: 'invalid_syntax' })
							return;
						}
						e.attr('disabled', 'disabled');
						$('.submit_button').attr('disabled', 'disabled');
						let res = await APPFCTS.core.mail.validate(_email);
						e.removeAttr('disabled');
						$('.submit_button').removeAttr('disabled');
						if (res) {
							console.log(res);
							let _message = [];
							if (res.result == 'invalid' && res?.mxCheck?.code != 'blocked') {
								$('.form-field-email').addClass('alert-danger text-danger');
								switch (res.code) {
									case 'domain_invalid':
										_message.push({
											en: 'The specified domain is invalid',
											fr: 'Le domaine spécifié est invalide'
										}[LOCALE]);
										break;
									case 'failed_verification':
										switch (res.mxCheck?.code) {
											case 'userUnknown':
												_message.push({
													en: 'Unknown account on the recipient\'s mail server.',
													fr: 'Compte inconnu sur le serveur du destinataire.'
												}[LOCALE]);
												break;
											default:
												_message.push({
													en: 'We were not able to perform valitation against recipient mail server.',
													fr: 'Nous n\'avons pas été en mesure d\'effectuer la vérification avec le serveur du destinataire.'
												}[LOCALE]);
										}
										break;
									default:
										if (pe(res, 'mxCheck.hardFail')) {

										}
										else if (pe(res, 'mxCheck.softFail')) {

										}
								}
								if (pe(res, 'mxCheck.message')) _message.push(pe(res, 'mxCheck.message'))
							}
							if (pe(res, 'mgres.did_you_mean')) {
								_message.push({
									en: 'Did you mean: "' + res.mgres.did_you_mean + '"?',
									fr: 'Vouliez-vous dire: "' + res.mgres.did_you_mean + '"?'
								}[LOCALE]);
							}
							$('.form-field-email .field-status-message').html(_message.join('<br/>'))
							resolve(res)
							return;
						}
						console.log('no result for emailCheck on', _email)
					});
				},
				validate: async (email, options, cback) => { //APPFCTS.core.mail.validate
					if (typeof options == 'function' && !cback) {
						cback = options;
						options = {};
					}

					let vars = {
						value: '' + email,
						options: $.extend(true, {
							checkmg: true
						}, options),
						brand: BRANCH_DATA.brand.id,
						branch: BRANCH_ID,
						metaData: {
							technoPOS: {
								employee: EMPLOYEE_PERSON_ID,
								register: REGISTER_ID
							}
						}
					}
					let res = await APPFCTS.core._call({ fct: 'emailCheck', data: vars });
					try {
						if (cback) cback(res);
					} catch (err) { console.error(err); }
					return res;
				}
			}
		},
		crypto: {
			ab2str: function (buf) { // APPFCTS.crypto.ab2str=function(buf){
				return String.fromCharCode.apply(null, new Uint8Array(buf));
			},
			sha1: function (message, cback) { // APPFCTS.crypto.sha1=function(message,cback){
				let msgUint8 = new TextEncoder().encode(message);                           // encode as (utf-8) Uint8Array
				crypto.subtle.digest('SHA-1', msgUint8).then(function (hashBuffer) {
					let hashArray = Array.from(new Uint8Array(hashBuffer));                     // convert buffer to byte array
					let hashHex = hashArray.map(b => b.toString(16).padStart(2, '0')).join(''); // convert bytes to hex string
					cback(hashHex);
				});

			},
			sha256: function (message, cback) { // APPFCTS.crypto.sha256=function(message,cback){
				let msgUint8 = new TextEncoder().encode(message);                           // encode as (utf-8) Uint8Array
				crypto.subtle.digest('SHA-256', msgUint8).then(function (hashBuffer) {
					let hashArray = Array.from(new Uint8Array(hashBuffer));                     // convert buffer to byte array
					let hashHex = hashArray.map(b => b.toString(16).padStart(2, '0')).join(''); // convert bytes to hex string
					cback(hashHex);
				});

			},
			sha512: function (message, cback) { // APPFCTS.crypto.sha512=function(message,cback){
				let msgUint8 = new TextEncoder().encode(message);                           // encode as (utf-8) Uint8Array
				crypto.subtle.digest('SHA-512', msgUint8).then(function (hashBuffer) {
					let hashArray = Array.from(new Uint8Array(hashBuffer));                     // convert buffer to byte array
					let hashHex = hashArray.map(b => b.toString(16).padStart(2, '0')).join(''); // convert bytes to hex string
					cback(hashHex);
				});

			},
			str2AB: function (str) { // APPFCTS.crypto.str2AB=function(str){
				var bytes = new Uint8Array(str.length);
				for (var iii = 0; iii < str.length; iii++) {
					bytes[iii] = str.charCodeAt(iii);
				}
				return bytes;
			}
		},
		signOut: () => {
			$.get('index.php/home/logout');
		},
		exit: function () {
			try { updateRegisterActivity('unload'); } catch (er) { }
			APPFCTS.signOut();
			if (APPFCTS._w) {
				APPFCTS.call('onExit')();
			}
			else if (navigator.app) {
				navigator.app.exitApp();
			} else if (navigator.device) {
				navigator.device.exitApp();
			}
		},
		accessCard: {
			locales: {
				cancel: {
					fr: 'Annuler',
					en: 'Cancel',
					es: ''
				},
				cardError: {
					confirmationMismatch: {
						fr: 'Les deux lectures ne concordent pas. Veuillez essayer de nouveau',
						en: 'The two readings doesn\'t match. Please try again'
					},
					exists: {
						fr: 'Cette carte à déjà été enregistrée.',
						en: 'This card has already been registered'
					},
					invalid: {
						fr: 'Les données de cette carte sont invalides. Veuillez essayer de nouveau.',
						en: 'This card data is invalid. Please try again.'
					}
				},
				close: {
					fr: 'Fermer',
					en: 'Close',
					es: ''
				},
				error: {
					fr: 'Cette carte ne peut être ajoutée',
					en: 'This card couldn\'t be registered',
					es: ''

				},
				registering: {
					fr: 'Enregistrement en cours, veuillez patienter',
					en: 'Registering your card, please wait',
					es: ''
				},
				registered: {
					fr: 'Votre carte a été enregistrée avec succès',
					en: 'Your card has been added successfully',
					es: ''
				},
				scanAgain: {
					fr: 'Présentez votre carte à nouveau au lecteur pour confirmer',
					en: 'Swipe or scan your card again to confirm',
				},
				scannow: {
					fr: 'Présentez votre carte au lecteur maintenant',
					en: 'Swipe or scan your new card now',
					es: ''
				},
				table: {
					name: {
						fr: 'Nom',
						en: 'Name'
					},
					delete: {
						btn: {
							fr: 'Supprimer cette carte',
							en: 'Delete this card',
							es: ''
						},
						title: {
							fr: 'Êtes-vous certain de vouloir supprimer cette carte',
							en: 'Are you sure you want to delete this card',
							es: ''
						}
					}
				},
				waitsync: {
					fr: 'Synchronisation des données en cours...',
					en: 'Data synchronization in progress',
					es: ''
				}
			},
			register: function (d, cback) {
				APPFCTS.block({ message: '<h1 class="text-center">' + APPFCTS.accessCard.locales.registering[LOCALE] + '...</h1>' });

				let _getHash = function () {
					if (!d.hash) {
						APPFCTS.crypto.sha512(d.value, function (val) {
							d.hash = val;
							_getHash();
						});
						return;
					}
					d.value = d.hash;
					delete d.hash;
					let _handle = function (res) {
						//console.log('activity record returned',res)

						if (res.result == 'insert') {
							APPFCTS.block({ message: '<h1 class="text-center">' + APPFCTS.accessCard.locales.registered[LOCALE] + '!</h1>' });
							//setTimeout(function(){$.unblockUI();},1000*3);
							//return;
						}
						else {
							APPFCTS.block({
								message: '<h1 class="text-center">' + APPFCTS.accessCard.locales.error[LOCALE] + '.<br/>' +
									'<button type="button" class="btn btn-default btnDismissCardError">' + APPFCTS.accessCard.locales.close[LOCALE] + '</button></h1>'
							});
							$('.btnDismissCardError').click(function () {
								$.unblockUI();
							})
						}
						cback(res);

					};
					if (APPFCTS._w) {
						APPFCTS.call('registerAccessCard')(d, _handle);
						return;
					}
					APPFCTS.msgApi.send({
						module: 'accessCard',
						action: 'register',
						data: d
					}, _handle)
				}
				_getHash();
			},
			routePOSEvent: function (d) {
				console.log('accessCard route pos event', d)
			}
		},
		activity: {
			employeeLoggedIn: function (data) {
				//employee_logged_in
				if (APPFCTS._w) {
					try {
						APPFCTS.call('employee_logged_in')(data)
					} catch (er) { }
					return;
				}

				APPFCTS.msgApi.send({
					module: 'activity',
					action: 'employee_logged_in',
					data: data
				})
			},
			routePOSEvent: function (d) {
				try {
					switch (d.action) {
						case 'unLockSession':
							if (typeof EMPLOYEE_PERSON_ID == 'undefined' || !EMPLOYEE_PERSON_ID) return false;
							$('body').removeClass('sessionLocked');
							APPFCTS.activity.timeout.init();
							try { updateRegisterActivity(); } catch (er) { }
							break;
						case 'lockSession':
							if (typeof EMPLOYEE_PERSON_ID == 'undefined' || !EMPLOYEE_PERSON_ID) return false;
							clearTimeout(APPFCTS.activity.timeout._t);
							APPFCTS.activity.timeout.lockSession({ forceLock: 1 });
							try { updateRegisterActivity(); } catch (er) { }
							break;
						case 'logOutUser':
							if (typeof EMPLOYEE_PERSON_ID == 'undefined' || !EMPLOYEE_PERSON_ID) return false;
							document.location.href = 'index.php/home/logout';
							break;
					}
				} catch (er) {
					console.error('Error in APPFCTS.activity.routePOSEvent', er, d);
				}
			},
			timeout: {
				_locked: false,
				_t: null,
				_getPolicy: () => {
					let
						_pol = {
							device: APPFCTS?.registerConfig?.advanced?.security?.policies?.session?.idleLock || {},
							location: LocationInfo?.configs?.advanced?.security?.policies?.session?.idleLock || {},
							group: BRANCH_DATA?.locationGroup?.configs?.advanced?.security?.policies?.session?.idleLock || {},
							brand: BRANCH_DATA?.settings?.advanced?.security?.policies?.session?.idleLock || {},
						},
						_doLocation = () => {
							switch (_pol.location?.enabled) {
								case 'enabled':
								case 'disabled':
									_pol.location.level = 'location';
									return _pol.location;
								case 'brand':
									_pol.brand.level = 'brand';
									return _pol.brand;
							}
							return _doGroup();
						},
						_doGroup = () => {
							switch (_pol.group?.enabled) {
								case 'enabled':
								case 'disabled':
									_pol.group.level = 'group';
									return _pol.group;
							}
							_pol.brand.level = 'brand';
							return _pol.brand;
						};
					switch (_pol.device?.enabled) {
						case 'enabled':
						case 'disabled':
							_pol.device.level = 'device';
							return _pol.device;
						case 'brand':
							_pol.brand.level = 'brand';
							return _pol.brand;
						case 'group':
							return _doGroup();
					}
					return _doLocation();

				},
				init: function () { //APPFCTS.activity.timeout.init=function(){
					if (typeof EMPLOYEE_PERSON_ID == 'undefined' || !EMPLOYEE_PERSON_ID) return false;
					if (REGISTER_ID == 'REG-TPOSADMIN') return false;
					let _policy = APPFCTS.activity.timeout._getPolicy();
					if (['1', 'enabled'].indexOf(_policy?.enabled) == -1) return;
					clearTimeout(APPFCTS.activity.timeout._t);
					if (APPFCTS.activity.timeout._sessionLocked) return false;
					APPFCTS.activity.timeout._sessionLocked = false;
					APPFCTS.activity.timeout._locked = false;
					var _t = 1 * (_policy.warmuptime || 30),
						_idlt = _policy.time || 0;
					if (_idlt && _policy.time_unit) {
						switch (_policy.time_unit) {
							case 'M':
								_idlt = _idlt * 60;
								break;
							case 'H':
								_idlt = _idlt * 60 * 60;
								break;
						}
					}
					if (!_idlt) _idlt = 1 * INACTIVITY_TIME_LOGOUT;
					APPFCTS.activity.timeout._t = setTimeout(function () {
						//hey there, your session is about to expire, do you want to continue?
						APPFCTS.activity.timeout.preLockTimer();
					}, 1000 * _idlt - _t * 1000);
				},
				preLockTimer: function () {
					if (APPFCTS.activity.timeout._sessionLocked) return false;
					if (typeof EMPLOYEE_PERSON_ID == 'undefined' || !EMPLOYEE_PERSON_ID) return false;
					let _policy = APPFCTS.activity.timeout._getPolicy();
					if (['1', 'enabled'].indexOf(_policy?.enabled) == -1) return;
					try { APPFCTS._w.window.focus() } catch (er) { }
					try { APPFCTS._w.focus() } catch (er) { }
					$('body').addClass('sessionLocked');
					var
						slw = $('#sessionTimedoutLockScreen .locked_wrapper');
					$('.session_preLock_timer', slw).show();
					$('.session_is_locked', slw).hide();

					slw.removeClass('passwordError passwordErrorMaxTriesReached');
					$('.employee_photo img', slw).show();
					$('.employee_photo .icon', slw).remove();


					var actionClicked = false;
					var _t = 1 * (_policy.warmuptime || 30);
					$('.session_preLock_timer .countDownSeconds', slw).html(_t);
					$({ sv: _t }).animate({ sv: 0 }, {
						duration: _t * 1000,
						easing: 'linear', // can be anything
						step: function () { // called on every step
							if (actionClicked) return false;
							// Update the element's text with rounded-up value:
							$('.session_preLock_timer .countDownSeconds', slw).html(Math.round(this.sv));
						},
						complete: function () {
							//lock session
							if (actionClicked) return false;
							APPFCTS.activity.timeout.lockSession();
						}
					});
					var plt = $('.session_preLock_timer', slw);
					$('.btnContinue', plt).unbind('click').click(function () {
						actionClicked = true;
						$('.session_preLock_timer', slw).hide();
						$('.session_is_locked', slw).hide();
						$('body').removeClass('sessionLocked');
					});
					$('.btnSignout', plt).unbind('click').click(function () {
						actionClicked = true;
						document.location.href = 'index.php/home/logout';
						$('body').removeClass('sessionLocked');
					});
				},
				lockSession: function (vars) {
					if (typeof EMPLOYEE_PERSON_ID == 'undefined' || !EMPLOYEE_PERSON_ID) return false;
					let _policy = APPFCTS.activity.timeout._getPolicy();
					if (['1', 'enabled'].indexOf(_policy?.enabled) == -1) return;
					if (!vars) vars = {};
					clearTimeout(APPFCTS.activity.timeout._t);
					if (!vars.forceLock && !PREVENT_SESSION_TIMEOUT && _policy.action != 'lock') {
						document.location.href = 'index.php/home/logout';
						return false;
					}
					try { APPFCTS._w.window.focus() } catch (er) { }
					try { APPFCTS._w.focus() } catch (er) { }
					$('body').addClass('sessionLocked');
					var slw = $('#sessionTimedoutLockScreen .locked_wrapper');
					APPFCTS.activity.timeout._sessionLocked = true;
					try { updateRegisterActivity(); } catch (er) { }
					slw.removeClass('passwordError passwordErrorMaxTriesReached');
					$('.employee_photo img', slw).show();
					$('.employee_photo .icon', slw).remove();
					$('.session_preLock_timer', slw).hide();
					$('.session_is_locked', slw).show();
					$('.locked_inner [name="unlock_sessison_password"]', slw).focus();
					try { slw.effect('shake'); } catch (er) { }
					//send info to console

					var
						_p = $('.locked_inner [name="unlock_sessison_password"]', slw),
						_normalClasses = 'ti-angle-right', _workingClasses = 'disabled ti-reload animated infinite rotateIn';
					$('.locked_inner [name="unlock_sessison_password"]', slw).unbind('keypress').keypress(function (e) {
						if ($(this).attr('disabled')) return false;
						slw.removeClass('passwordError');
						if (e.keyCode == 13) {
							_submit();
						}
					})

					_p.removeAttr('disabled').removeClass('disabled');
					$('.employee_enter_nip .btn', slw).removeAttr('disabled', 'disabled');
					$('.employee_enter_nip .icon', slw).removeClass(_workingClasses).addClass(_normalClasses);
					_p.val('');
					_p.focus();
					var _maxTries = 4, _tries = 0,
						_success = function () {
							$('body').removeClass('sessionLocked');

							APPFCTS.activity.timeout._sessionLocked = false;
							APPFCTS.activity.timeout._locked = false;
							try { updateRegisterActivity(); } catch (er) { }
						},
						_submit = function () {
							var
								_v = _p.val();
							if (_p.attr('disabled')) return false;
							_p.attr('disabled', 'disabled').addClass('disabled');
							$('.employee_enter_nip .btn', slw).attr('disabled', 'disabled');
							$('.employee_enter_nip .icon', slw).removeClass(_normalClasses).addClass(_workingClasses);
							APPFCTS.crypto.sha1(_v, function (h) {
								if (EMPLOYEE_INFO.password == h) {
									_success();
									return;
								}
								if (EMPLOYEE_INFO.password_nip == h) {
									_success();
									return;
								}
								_tries++;
								let _left = _maxTries - _tries;
								if (_left <= 0) {
									_left = 0;
									$('.employee_photo img', slw).hide();
									$('.employee_photo', slw).append('<i class="icon ti-lock"></i>');
									slw.addClass('passwordError passwordErrorMaxTriesReached');
									APPFCTS.activity.timeout._sessionLocked = true;
									APPFCTS.activity.timeout._locked = true;
									try { updateRegisterActivity(); } catch (er) { }
									return;
								}
								$('.passwordIsInvalid .triesLeft', slw).html(_left);
								slw.addClass('passwordError');
								try { slw.effect('shake'); } catch (er) { }
								_p.removeAttr('disabled').removeClass('disabled');
								$('.employee_enter_nip .btn', slw).removeAttr('disabled', 'disabled');
								$('.employee_enter_nip .icon', slw).removeClass(_workingClasses).addClass(_normalClasses);
								_p.val('');
								_p.focus();
							});
						};
				}
			},
			record: function (d, cback) {
				if (d.loadTime) d.loadTime = d.loadTime / 1000;
				if (APPFCTS._w) {
					cback(APPFCTS.call('recordActivity')(d));
					return;
				}
				APPFCTS.msgApi.send({
					module: 'activity',
					action: 'record',
					data: d
				}, function (res) {
					//console.log('activity record returned',res)
					cback(res);
				})
			},
			update: function (d) {
				if (APPFCTS._w) {
					APPFCTS.call('updateActivity')(d)
					return;
				}
				APPFCTS.msgApi.send({
					module: 'activity',
					action: 'update',
					data: d
				}, function (res) {
					//console.log('activity update returned',res)
				})
			}
		},
		avatar: {
			get: (name) => {
				//https://jsfiddle.net/piyushkmr/o1ryj82a/
				let saturation = 50, lightness = 30, range = 15;
				const getHashOfString = (str) => {
					let hash = 0;
					for (let i = 0; i < str.length; i++) {
						// tslint:disable-next-line: no-bitwise
						hash = str.charCodeAt(i) + ((hash << 5) - hash);
					}
					hash = Math.abs(hash);
					return hash;
				};

				const normalizeHash = (hash, min, max) => {
					return Math.floor((hash % (max - min)) + min);
				};

				const generateHSL = (name, saturationRange, lightnessRange) => {
					const hash = getHashOfString(name);
					const h = normalizeHash(hash, 0, 360);
					const s = normalizeHash(hash, saturationRange[0], saturationRange[1]);
					const l = normalizeHash(hash, lightnessRange[0], lightnessRange[1]);
					return [h, s, l];
				};

				const HSLtoString = (hsl) => {
					return `hsl(${hsl[0]}, ${hsl[1]}%, ${hsl[2]}%)`;
				};

				const generateColorHsl = (id, saturationRange, lightnessRange) => {
					return HSLtoString(generateHSL(id, saturationRange, lightnessRange));
				};

				const getInitials = () => {
					return name.first[0] + '' + (name.last?.[0] || '');
				}

				const getRange = (value, range) => {
					return [Math.max(0, value - range), Math.min(value + range, 100)];
				}
				const saturationRange = getRange(saturation, range);
				const lightnessRange = getRange(lightness, range);
				const color = generateColorHsl(name.first + name.last, saturationRange, lightnessRange);
				const initials = getInitials();
				return { color, initials }
			}
		},
		customerDisplay: {
			close: function () {
				APPFCTS.call('callModule')('pos.customerDisplay', { action: 'close' });
			},
			open: function () {
				try {
					APPFCTS.call('callModule')('pos.customerDisplay', { action: 'open' }, function (res) {
						console.log('open res', res);
					});
				}
				catch (er) {
					console.error('failed to open customer display the new way', er)
					window.open(SITE_URL + '/sales/customer_display/' + REGISTER_ID.replace(/REG\-/, '') + '?autoRefresh=1', 'customer_facing_display')
				}
			},
			update: () => {
				try {
					APPFCTS.call('callModule')('pos.customerDisplay', { action: 'update' }, function (res) {
						//console.log('open res',res);
					});
				}
				catch (er) {
				}
			}
		},
		kiosk: {
			_configs: null,
			getConfigs: function (cbk) {
				APPFCTS.call('getKioskConfigs')(function (kfc) {
					APPFCTS.kiosk._configs = kfc;
					try {
						if (cbk) cbk(kfc);
					} catch (er) { console.error(er.message); }
				})
			}
		},
		liquorControl: {
			canPour: function () {
				return false;
			},
			pourDrink: function (vars, cback) {
				if ((whitelist = $('#myModalDisableClose:visible .liquor-control-whitelist')).length) {
					if (whitelist.attr('data-product') == parseInt(vars.plu) && whitelist.attr('data-portion') == vars.portion)
						$.post('index.php/sales/drink_poured/' + vars.plu + '/' + vars.portion, function (res) {
							$('#myModalDisableClose').html(res);
							cback({ result: 'success' });
							$.get('index.php/sales/reload', function (response) {
								$('#register_container').html(response);
							});
						});
					else
						cback({ result: 'error' });
				} else {
					$.post('index.php/items/get_by_liquor_control_product_number/' + parseInt(vars.plu) + '/' + vars.portion, function (data) {
						if (data.result == 'success')
							$.post('index.php/sales/add', {
								item: data.item_id + '|FORCE_ITEM_ID|',
								quantity: 1,
								format_id: data.format_id,
								status: 'ready',
								actions: ['poured']
							}, function (response, res, req) {
								$('#register_container').html(response);
								if (typeof cback == 'function') {
									if (req.getResponseHeader('X-status') == 'success') {
										cback({ result: 'success' });
									} else
										cback({ result: 'error' });
								}
							});
						else
							cback({ result: 'error' });
					}, 'json');
				}
			}
		},
		neighbors: {
			status: null
		},
		objects: {
			flattenChilds: (c, field = 'children', arr = []) => {
				if (!c) return [];
				if (!arr) arr = [];
				if (c[field]) {
					for (let i of Object.values(c[field])) {
						arr.push(i);
						APPFCTS.objects.flattenChilds(i, field, arr);
					}
				}
				return arr;
			},
			flattenObject: function (ob, sep) { //APPFCTS.objects.flattenObject
				if (!sep) sep = '.';
				return Object.keys(ob).reduce(function (toReturn, k) {
					if (Object.prototype.toString.call(ob[k]) === '[object Date]')
						toReturn[k] = ob[k].toString();
					else if (Array.isArray(ob[k])) toReturn[k] = ob[k];
					else if ((typeof ob[k]) === 'object' && ob[k]) {
						var flatObject = APPFCTS.objects.flattenObject(ob[k], sep);
						Object.keys(flatObject).forEach(function (k2) {
							toReturn[k + sep + k2] = flatObject[k2];
						});
					}
					else
						toReturn[k] = ob[k];
					return toReturn;
				}, {});
			},
			populateForm(form, data, basename) { //APPFCTS.objects.populateForm
				if (typeof data == 'string') data = JSON.parse(data);
				for (const key in data) {
					if (!data.hasOwnProperty(key)) {
						continue;
					}
					let
						name = '' + key,
						value = data[key];
					if ('undefined' === typeof value) {
						value = '';
					}
					if (null === value) {
						value = '';
					}
					// handle array name attributes
					if (typeof (basename) !== "undefined") {
						name = basename + "[" + key + "]";
					}
					if (value.constructor === Array) {
						name += '[]';
					} else if (typeof value == "object") {
						APPFCTS.objects.populateForm(form, value, name);
						continue;
					}
					// only proceed if form has element with the given name attribute
					const element = form.elements.namedItem(name) || form.elements.namedItem(name.replace(/\]\[/g, '.').replace(/\]/g, '').replace(/\[/g, '.'));
					if (!element) {
						continue;
					}
					// set element value
					const type = element.type || element[0].type;
					switch (type) {
						default:
							element.value = value;
							break;
						case 'radio':
						case 'checkbox': {
							if (Array.isArray(element)) {
								const values = value.constructor === Array ? value : [value];
								for (let j = 0; j < element.length; j++) {
									element[j].checked = values.indexOf(element[j].value) > -1;
								}
							}
							else {
								element.checked = value == '1';
							}
						}
							break;
						case 'select-multiple': {
							const values = value.constructor === Array ? value : [value];
							for (let k = 0; k < element.options.length; k++) {
								element.options[k].selected = (values.indexOf(element.options[k].value) > -1);
							}
						}
							break;
						case 'select':
						case 'select-one':
							element.value = value.toString() || value;
							break;
						case 'date':
							element.value = new Date(value).toISOString().split('T')[0];
							break;
					}
					// fire change event on element
					const changeEvent = new Event('change', { bubbles: true });
					switch (type) {
						default:
							element.dispatchEvent(changeEvent);
							break;
						case 'radio':
						case 'checkbox':
							for (let j = 0; j < element.length; j++) {
								if (element[j].checked) {
									element[j].dispatchEvent(changeEvent);
								}
							}
							break;
					}
				}
			}
		},
		LED: {
			blink: function (color, pattern, ttl, colorAfter) {
				APPFCTS.call('callModule')('system.LED', { action: 'blink', data: { color: color, pattern: pattern, ttl: ttl, colorAfter: colorAfter } })
			},
			cycle: function (colors, fade, ttl, alternate) {
				APPFCTS.call('callModule')('system.LED', { action: 'cycle', data: { colors: colors, fade: fade, ttl: ttl, alternate: alternate } })
			},
			off: function (fade) {
				APPFCTS.call('callModule')('system.LED', { action: 'off', data: { fade: fade } })
			},
			solid: function (color, fade, ttl, colorAfter) {
				APPFCTS.call('callModule')('system.LED', { action: 'solid', data: { color: color, fade: fade, ttl: ttl, colorAfter: colorAfter } })
			}
		},
		NFC: {
			routeMsg: function (d, cback) {
				try {
					switch (d.action) {
						case 'scan':
							if (cback) cback('received');
							APPFCTS.crypto.sha512(d.data.serial, function (val) {
								if ($('#password_nip_card') && $('#password_nip_card').length) {
									$('#password_nip_card').val(val);
									$('#loginformpin').submit();
								}
								else if (typeof doEmployeeAddCardResult != 'undefined') {
									APPFCTS.accessCard.register({
										employee: EMPLOYEE_PERSON_ID,
										type: 'nfc',
										hash: val
									}, doEmployeeAddCardResult);
								}
							});
							break;

						default:
							console.log('GOT NFC FROM ANDROID', d);
							if (cback) cback('UNHANDLED');
					}
				} catch (er) {
					console.error('Error in APPFCTS.NFC.routeMsg', er, d);
				}
			}
		},
		printing: {
			defaultPrinterStatusMonitor: () => {

				$('li.receipt_printer_status').hide();
				if (typeof nw != 'undefined') {
					setTimeout(() => {
						var _doPrinterCheck = () => {
							var
								_receiptType = APPFCTS.registerConfig?.printer?.defaultSaleFormat,
								_defaultPrinter = APPFCTS.registerConfig?.printer?.[_receiptType],
								_p = APPFCTS.registerStatus?.printers?.filter((a) => a.id == _defaultPrinter)?.[0];
							_valid = false;
							//console.log('doPrinterCheck',{_receiptType,_defaultPrinter,_p})
							if (_defaultPrinter && ['ready', 'up'].indexOf(_p?.latestStatus?.status || _p?.peripheralInfo?.printerStatus || '') != -1) _valid = true;
							$('li.receipt_printer_status').show();
							$('li.receipt_printer_status .iconPrinterStatus').
								removeClass('fa-check text-success fa-warning text-danger').
								addClass(_valid ? 'fas fa-lg fa-check text-success' : 'fas fa-lg fa-warning text-danger');
						}
						if (APPFCTS.registerStatus && APPFCTS.registerStatus)
							_doPrinterCheck();
						APPFCTS.printing.onPrinterStatusChange((d) => {
							_doPrinterCheck();
						})
						APPFCTS.system.onStatusChange(() => {
							_doPrinterCheck();
						})
						APPFCTS.system.onConfigChange(() => {
							_doPrinterCheck();
						})
					}, 300);
				}
			},
			getDefaultPrinter: function (printer) {
				if (APPFCTS._w && typeof APPFCTS.call('getDefaultPrinter') == 'function')
					return APPFCTS.call('getDefaultPrinter')(printer);
			},
			getDefaultSaleFormat: function () {
				if (APPFCTS._w && typeof APPFCTS.call('getDefaultSaleFormat') == 'function')
					return APPFCTS.call('getDefaultSaleFormat')();
			},
			receipt: function (id, type, options) { //APPFCTS.printing.receipt=function(id,type,options){
				if (typeof nw != 'undefined')
					APPFCTS.call('printUrl')(SITE_URL + 'sales/receipt/' + id + '/classic?printOnly=true&configs.copies=1&invoiceType=' + type);
				else {
					let
						_w = window.open(SITE_URL + 'sales/receipt/' + id + '/classic?printOnly=true&configs.copies=1&invoiceType=' + type + '&PDF=1', 'printInvoice')
						;
					setTimeout(function () {
						_w.print();
					}, 500);
				}
			},
			_printerStatusChangeListners: [],
			onPrinterStatusChange: (fct) => { //APPFCTS.printing.onPrinterStatusChange
				APPFCTS.printing._printerStatusChangeListners.push(fct);
			},
			routePOSEvent: function (d) {
				//console.log('RECEIVED MESSAGE',d)
				if (d.module) {
					try {
						if (d.module == 'printing') {
							switch (d.action) {
								case 'printerStatusChanged':
									let _p = APPFCTS.registerStatus?.printers?.filter((a) => a.id == d.data.id)?.[0];
									if (_p) {
										_p.latestStatus = d.data;
										if (APPFCTS.printing._printerStatusChangeListners.length) {
											for (let i of APPFCTS.printing._printerStatusChangeListners) {
												try {
													i(d.data);
												} catch (er) { }
											}
										}
									}
									//APPFCTS.registerConfig=d.data;
									//console.warn('printer status changed',d.data)
									break;
							}
							return;
						}
					} catch (er) {
						console.error('Error in APPFCTS.system.routeMsg', er, d);
					}
				}
			},
		},
		openDrawer: function (vars, cback) { //vars.drawer= default | 0,1,2... (# of the drawer), vars.sale_id, vars.action
			if (APPFCTS._w) {
				APPFCTS.call('openDrawer')(vars, cback);
				return;
			}

		},
		OLO: {
			API: async (url, vars = {}) => {
				return APPFCTS.OLO.POST('/rest/v1/' + url, vars);
			},
			POST: async function (url, vars = {}) {
				return new Promise(async (resolve) => {
					fetch(
						//'https://'+(BRAND_ID=='49fa6590-49e7-11e6-a594-0401095f1801'?'store.legacy.azimutpos.com':('store'+
						//(SITE_URL.indexOf('.office.')!=-1?'.technopos.office.tech-cl.com':'.technopos.net')))+'/'+BRAND_ID+url,
						'https://store.legacy.azimutpos' + (SITE_URL.indexOf('.dev.') != -1 ? '.dev.46degresn.ca' : '.com') + '/' + BRAND_ID + url,
						{
							method: 'POST',
							mode: 'cors',
							headers: new Headers(
								{
									"Content-Type": "application/json",
									"X-REGISTER-AUTH": JSON.stringify({ id: REGISTER_ID, token: registerInfo?.secureToken }),
									"Accept": "application/json"
								}
							),
							body: JSON.stringify(vars)
						}
					)
						.then(res => res.json())
						.then(data => {
							resolve(data);
						}).catch(err => console.log(err))
				});
			}
		},
		orders: {
			getDeliveryFees: async (vars, cback) => {
				//if(APPFCTS._w)
				//	APPFCTS.call('getDeliveryFees')(vars,cback);
				vars.debug = 1;
				cback(await APPFCTS.OLO.API('getShippingFees', vars));
			},
			printAddition: function (ids) {
				if (ids && ids.length)
					ids.forEach(function (id) {
						if (APPFCTS._w)
							APPFCTS.call('printUrl')('index.php/sales/print_receipt/' + id + '/classic?printOnly=true');
						else {

							APPFCTS.msgApi.send({
								module: 'orders',
								action: 'printUrl',
								data: 'index.php/sales/print_receipt/' + id + '/classic?printOnly=true'
							})
						}
					});
			},
			process: function (sale_id, tags, skipCloud) {
				cback = skipCloud ? (res) => {
					console.log(res)
					if (res.result == 'success') {
						var processedItems = {}
						var orders = Object.values(res.orders)
						for (let o = 0; o < orders.length; o++)
							for (const [sale_id, items] of Object.entries(orders[o].processedItems)) {
								if (!processedItems[sale_id])
									processedItems[sale_id] = [];
								for (let i = 0; i < items.length; i++)
									if (!processedItems[sale_id].includes(items[i]))
										processedItems[sale_id].push(items[i]);
							}
						if (Object.keys(processedItems).length) {
							$.post('index.php/sales/process_sale_items', { processed_items: processedItems });
						}
					}
				} : null
				if (APPFCTS._w)
					APPFCTS.call('processOrder')(sale_id, cback, tags, skipCloud);
			}
		},
		print: function (options) {
			if (APPFCTS._w) {
				APPFCTS.call('printCustom')(options);
				return;
			}

			if (!APPFCTS.msgApi.send({
				module: 'orders',
				action: 'printUrl',
				data: 'index.php/sales/print_receipt/' + id + '/classic?printOnly=true'
			}))
				window.print();
		},

		qrCode: {
			encode: function (d, cback) {
				//basic usage:
				//d={
				//    element: $('jquery selector'),
				//    text:'https://your url.com',
				//    size:200,//or use width & height for specific
				//    level:'L|M|H|Q'
				//}

				//technoPOS standardized QR codes usage:
				//d={
				//    element: $('jquery selector'),
				//    data:{ //QR code data to be encoded
				//          type:'invoice', //invoice,product,device,container,production_lot, etc...
				//          id:'id of the entity', // uuid
				//          brand:'brand uuid', //if you want to specify the branch, recommended
				//          branch:'branch uuid',//if you want to specify the branch, could be useful
				//          //... anything that need to be included
				//    }
				//    size:200,//or use width & height for specific
				//    level:'L|M|H|Q'
				//}

				//documentation https://github.com/ushelp/EasyQRCodeJS#options
				// except for technoPOS, requires `data` as an object. data.type & data.id are mandatory
				if (!d.text && d.data && !d.data.type) throw new Error('You must specify data.type');
				if (!d.text && d.data && !d.data.id) throw new Error('You must specify data.id');
				var size = 1 * (d.size || d.width || d.height || 256);


				if (cback) {
					d.onRenderingEnd = function (a, b) {
						cback(b)
						$('#qrCodeGenericRenderingElement').remove();
					};
					if (!d.element) {
						$('#qrCodeGenericRenderingElement').remove();
						$('body').append('<div id="qrCodeGenericRenderingElement" class="hidden"></div>');
						d.element = $('#qrCodeGenericRenderingElement');
					}
				}
				d.element.html('');
				var qrcode = new QRCode(d.element[0], $.extend(true, d, {
					text: d.text || 'TPOS:' + btoa(JSON.stringify(d.data)),
					width: d.width || d.height || size,
					height: d.height || d.width || size,
					colorDark: "#" + (d.colorDark || '000'),
					colorLight: "#" + (d.colorLight || 'fff'),
					correctLevel: QRCode.CorrectLevel[d.level || 'H']
				}));
				return qrcode;
			},
			decode: function (data) {
				if (data && data.indexOf('TPOS:') === 0) {
					json = JSON.parse(atob(data.replace(/^TPOS\:/, '')));
					return json;
				}
				return data;
			}
		},
		weightScale: {
			_status: null,
			_last: null,
			_monitor: [],
			_onUpdate: [],
			_statusChanged: function (s) {
				//console.log('WeightScale status changed',s);
				if (APPFCTS.weightScale._status && new Date(APPFCTS.weightScale._status.date).getTime() > new Date(s.date).getTime()) return;

				APPFCTS.weightScale._status = s;
			},
			_updated: function (data) {
				if (APPFCTS.weightScale._last && new Date(APPFCTS.weightScale._last.date).getTime() > new Date(data.date).getTime()) return;
				APPFCTS.weightScale._last = data;
				setTimeout(APPFCTS.weightScale._notify, 1);
				if (APPFCTS.weightScale._monitor.length) {
					for (let i = 0; i < APPFCTS.weightScale._monitor.length; i++) {
						try {
							(function (x) {
								APPFCTS.weightScale._monitor[x]($.extend(true, {}, APPFCTS.weightScale._last), function () {
									//delete me
									APPFCTS.weightScale._monitor.splice(x, 1);
								});
							})(i);
						} catch (er) { console.error(er); }
					}
				}
			},
			_notify: function () {
				if (APPFCTS.weightScale._onUpdate.length) {
					try {
						APPFCTS.weightScale._onUpdate.shift()($.extend(true, {}, APPFCTS.weightScale._last));
					} catch (er) { console.error(er); }
					APPFCTS.weightScale._notify();
				}
			},
			enabled: function () {
				return pe(APPFCTS, 'registerConfig.weightScale.enabled') == '1' && pe(APPFCTS, 'registerConfig.weightScale.device') && pe(APPFCTS, 'weightScale._status');
			},
			monitor: function (fct) {
				APPFCTS.weightScale._monitor.push(fct);
			},
			neighbors: {
				_data: null,
				_monitor: {},
				_changed: function (id, type) {
					if (pe(APPFCTS.weightScale.neighbors, '_monitor.' + id + '.' + type)) {

						if (APPFCTS.weightScale.neighbors._monitor[id][type].length) {
							for (let i = 0; i < APPFCTS.weightScale.neighbors._monitor[id][type].length; i++) {
								try {
									(function (x) {
										APPFCTS.weightScale.neighbors._monitor[id][type][x]($.extend(true, {}, APPFCTS.weightScale.neighbors._data[id][type]), function () {
											//delete me
											APPFCTS.weightScale.neighbors._monitor[id][type].splice(x, 1);
										});
									})(i);
								} catch (er) { console.error(er); }
							}
						}
					}
				},
				monitor: function (id, type, fct) {
					if (!APPFCTS.weightScale.neighbors._monitor[id]) APPFCTS.weightScale.neighbors._monitor[id] = {};
					if (!APPFCTS.weightScale.neighbors._monitor[id][type]) APPFCTS.weightScale.neighbors._monitor[id][type] = [];
					APPFCTS.weightScale.neighbors._monitor[id][type].push(fct);

				}
			},
			onUpdate: function (fct) {
				APPFCTS.weightScale._onUpdate.push(fct);
			}
		},
		secureTokenChanged: function (t) {
			console.log('new secure token', t)

		},
		system: { //APPFCTS.system={
			getUUID: async (cback) => { //APPFCTS.system.getUUID
				return new Promise(async (resolve) => {
					let _return = (res) => {
						try {
							resolve(res);
						} catch (err) { console.error(err); }
						try {
							if (cback) resolve(res);
						} catch (err) { console.error(err); }
					}
					if (APPFCTS._w) {
						let _uuid = APPFCTS.call('uuid.get')();
						_return(_uuid);
					}
					if (APPFCTS.msgApi?.supported) {
						APPFCTS.msgApi.send({
							module: 'system',
							action: 'uuid.get',
							data: ''
						}, _return)
						return;
					}
					APPFCTS.OLO.API('coreFunction/getUUID').then(_return);
				});
			},
			_configChangeListners: [],
			onConfigChange: (fct) => { //APPFCTS.system.onConfigChange
				APPFCTS.system._configChangeListners.push(fct);
			},
			_configChanged: () => {
				if (APPFCTS.system._configChangeListners?.length) {
					for (let i of APPFCTS.system._configChangeListners) {
						try {
							i();
						} catch (e) {

						}
					}
				}
			},
			_statusChangeListners: [],
			onStatusChange: (fct) => { //APPFCTS.system.onStatusChange
				APPFCTS.system._statusChangeListners.push(fct);
			},
			_statusChanged: () => {
				if (APPFCTS.system._statusChangeListners?.length) {
					for (let i of APPFCTS.system._statusChangeListners) {
						try {
							i();
						} catch (e) {

						}
					}
				}
			},
			getRegisterConfig: function (cback) {
				//return new Promise(async (resolve)=>{
				if (APPFCTS._w) {
					APPFCTS.call('getRegisterConfig')(function (d) {
						APPFCTS.registerConfig = d;
						//resolve(d);
						if (cback) cback(d);
						APPFCTS.system._configChanged();
					});
					return;
				}
				APPFCTS.msgApi.send({
					module: 'system',
					action: 'getRegisterConfig',
					data: ''
				}, function (d) {
					APPFCTS.registerConfig = d;
					//resolve(d);
					if (cback) cback(d);
					APPFCTS.system._configChanged();
				})
				//});
			},
			getRegisterStatus: function (cback) {
				//return new Promise(async (resolve)=>{
				if (APPFCTS._w) {
					APPFCTS.call('getRegisterStatus')(function (d) {
						APPFCTS.registerStatus = d;
						//resolve(d);
						if (cback) cback(d);
						APPFCTS.system._statusChanged();
					});
					return;
				}
				//resolve(null);
				if (cback) cback(null);
				//});
			},
			clearCache: function () {
				window.nw.App.clearCache();

				// this one will cause significantly increase the
				// shutdown duration if run during app exit
				window.chrome.browsingData.remove({
					since: 0
				}, {
					appcache: true,
					cache: true,
					downloads: true,
					fileSystems: true,
					formData: true,
					history: true,
					indexedDB: true,
					localStorage: true,
					pluginData: true,
					passwords: true,
					serverBoundCertificates: true,
					serviceWorkers: true,
					webSQL: true
				});
				console.log('cache cleared');
			},
			routePOSEvent: function (d) {
				//console.log('RECEIVED MESSAGE',d)
				if (d.module) {
					try {
						if (d.module == 'system') {
							switch (d.action) {
								case 'setRegisterConfig':
									APPFCTS.registerConfig = d.data;
									APPFCTS.system._configChanged();
									break;
								case 'setRegisterStatus':
									APPFCTS.registerStatus = d.data;
									APPFCTS.system._statusChanged();
									break;
							}
							return;
						}
						if (APPFCTS[d.module] && APPFCTS[d.module].routePOSEvent) {
							try {
								APPFCTS[d.module].routePOSEvent(d);
							} catch (er) {
								console.error(er)
							}
						}
					} catch (er) {
						console.error('Error in APPFCTS.system.routeMsg', er, d);
					}
				}
			},
			registerConfigPartialUpdate: (d) => {
				registerInfo.configs = $.extend(true, registerInfo.configs, d);
				APPFCTS.registerConfig = $.extend(true, APPFCTS.registerConfig, d);
				//notify app backend

				return new Promise(async (resolve) => {
					APPFCTS.call('updateRegisterConfig')(d, function (res) {
						resolve(res);
					});
				});
			},
			socket: {
				event: (d) => {
					//console.log('Received socket event from server',d);
				}
			},
			routeEvent: (d) => {
				//console.log('Received system event from server',d);
			},
			onHashChange: (fct) => { // APPFCTS.system.onHashChange
				_hashChanges.push(fct);
			}
		},
		ui: {
			modal: function (vars) { //APPFCTS.ui.modal
				if (typeof vars.cls == 'undefined')
					vars.cls = '';
				if (typeof vars.attr == 'undefined')
					vars.attr = '';
				if (typeof vars.btns == 'undefined')
					vars.btns = '';
				if (typeof vars.title == 'undefined')
					vars.title = '';
				if (typeof vars.footer == 'undefined')
					vars.footer = true;
				if (typeof vars.close == 'undefined')
					vars.close = true;
				var out =
					'<div class="modal fade pwmModal ' + vars.cls + ' clearfix" id="' + vars.id + '"' + vars.attr + ' tabindex="-1" role="dialog" ' +
					'aria-labelledby="' + vars.id + 'Label" aria-hidden="true">' +
					'<div class="modal-dialog ' + (vars.centered ? 'modal-dialog-centered ' : '') + 'pwmModalDialog' + ((vars.size) ? ' modal-' + vars.size : '') + '" style="' + (vars.width ? 'width:' + vars.width + ';' : '') + '">' +
					'<div class="modal-content pwmModalContent clearfix">' +
					'<div class="modal-header pwmModalHeader">' +
					((vars.close) ? '<button type="button" class="close closeBtn" data-dismiss="modal" aria-hidden="true">&times;</button>' : '') +
					'<h3 class="modal-title" id="' + vars.id + 'Label">' + vars.title + '</h3>' +// pwm-lang="products.customize.modal.title"
					'</div>' +
					'<div class="modal-body pwmModalBody clearfix">' + vars.body + '</div>' +
					((vars.footer) ?
						'<div class="modal-footer pwmModalFooter clearfix">' +
						((vars.closeBtn) ?
							'<button type="button" class="btn btn-default closeBtn" data-dismiss="modal"' +
							((vars.closeBtn.attr) ?
								vars.closeBtn.attr : ''
							) + '>' +
							vars.closeBtn.label +
							'</button>' : ''
						) +
						vars.btns +
						'</div>' :
						''
					) +
					'</div>' +
					'</div>' +
					'</div>';
				if (vars.open) {
					if ($('#' + vars.id)?.length) $('#' + vars.id).replaceWith(out);
					else
						$('body').append(out);
					//setTimeout(()=>{
					$('#' + vars.id).modal('show');
					//},500);
					return;
				}
				return out;
			},
			block: (opts) => {

				if (opts?.target?.selector) opts.target = '' + opts.target.selector;
				let
					options = opts ? $.extend(true, {}, opts) : {},
					el = document.querySelector(options?.target || 'body'),
					_fui = {};
				el.classList.add('blockUIEnabled');
				if (options.target) _fui.selector = '' + options.target;
				if (options.message) _fui.text = '' + options.message;
				else {
					if (!options.lang) options.lang = LOCALE || 'en';
					_fui.text = '' + (options.lang.indexOf('fr') === 0 ? 'Chargement' : 'Loading');

				}
				FreezeUI(_fui)
				return {
					element: el,
					unBlock: () => {
						el.classList.remove('blockUIEnabled');
						UnFreezeUI(_fui.selector);
					},
					message: (msg) => {
						if (el && el.querySelector('.freeze-ui')) {
							el.querySelector('.freeze-ui').setAttribute('data-text', msg);
						}
					}
				}
			},
			serverEvents: {
				process: (d) => {
					//console.log('got server event',d)
					try {
						//crawl objects till end of line
						var _path = [d.module], _crawl = function (_obj) {
							if (_obj.data && _obj.data.module) {
								_path.push(_obj.data.module);
								return _crawl(_obj.data);
							}
							return _obj;
						}, _data = _crawl(d);
						_data.cback = d.cback;
						APPFCTS.ui.serverEvents._call(_path.join('.'), _data);
					} catch (e) { }
				},
				_subscribed: {},
				subscribe: function (path, fn) { //APPFCTS.ui.serverEvents.subscribe
					if (!APPFCTS.ui.serverEvents._subscribed[path])
						APPFCTS.ui.serverEvents._subscribed[path] = [];
					APPFCTS.ui.serverEvents._subscribed[path].push(fn);
				},
				unsubscribe: function (path, fn) { //APPFCTS.ui.serverEvents.unsubscribe
					if (APPFCTS.ui.serverEvents._subscribed[path])
						APPFCTS.ui.serverEvents._subscribed[path] = APPFCTS.ui.serverEvents._subscribed[path].filter(
							function (el) {
								if (el !== fn) {
									return el;
								}
							}
						);
				},
				_call: function (path, d) { //APPFCTS.ui.serverEvents._call
					try {
						if (d && d.action) {
							if (d.cback) d.datas.cback = d.cback;
							APPFCTS.ui.serverEvents._call(path + '.' + d.action, d.datas);
							return;
						}
					} catch (e) {
						console.error(e.message, 'while processing socket event subscribtion', path + '.' + d.action, e);
					}
					//console.log('APPFCTS.ui.serverEvents._call',path,d);
					if (!APPFCTS.ui.serverEvents._subscribed[path]) {
						console.log('no listner found for ' + path)
						return false;
					}
					for (var i = 0; i < APPFCTS.ui.serverEvents._subscribed[path].length; i++) {
						try {
							APPFCTS.ui.serverEvents._subscribed[path][i](d);
						}
						catch (e) {
							console.error(e.message, 'while processing socket event subscribtion', path, i, e);
						}
					}
					return true;
				}
			},
			routePOSEvent: function (d) {
				//trigger subscribed events
			}
		},
		weather: {
			_latest: null,
			setLatest: function (l) {
				APPFCTS.weather._latest = l;
			},
			get: function (opts, cback) { //APPFCTS.weather.get
				if (APPFCTS.weather._latest && APPFCTS.weather._latest.date) {
					let c = APPFCTS.weather._latest.date;
					if (c && new Date(c).getTime() > new Date().getTime() - 1000 * 60 * 40) {
						if (cback) cback(APPFCTS.weather._latest.result);
						return;
					}
				}
				var p = {
					location: typeof BRANCH_DATA != 'undefined' && pe(BRANCH_DATA, 'address.lat') && pe(BRANCH_DATA, 'address.lng') ? BRANCH_DATA.address.lat + ',' + BRANCH_DATA.address.lng : null,
					lang: '',
					user: typeof EMPLOYEE_PERSON_ID != 'undefined' ? EMPLOYEE_PERSON_ID : null
				};
				if (opts) $.extend(true, p, opts);
				if (APPFCTS._w) {
					APPFCTS.call('getWeather')(p, function (res) {
						APPFCTS.weather._latest = res;
						try {
							if (cback) cback(res?.result);
						} catch (err) { console.error(err); }
					})
					return;
				}

				APPFCTS.msgApi.send({
					module: 'weather',
					action: 'get',
					data: p
				}, function (res) {
					//console.log('got weather',res)
					APPFCTS.weather._latest = res;
					try {
						if (cback) cback(res?.result);
					} catch (err) { console.error(err); }
				})
			}
		},
		getParentStack: function () {
			return null;
		},
		tryCatch: function (c) {
			c();
		},
		queueProc: {
			_queues: {},
			test: function () {
				var todo = 20, done = 0;
				APPFCTS.queueProc.init('queueProcTEST', 3);
				var _fct = function (d, n) {
					done++;
					console.log(d);
					setTimeout(n, 500);
					if (done >= todo) {
						console.log('all done!')
					}
				};
				for (var i = 0; i < todo; i++) {
					APPFCTS.queueProc.add('queueProcTEST', 'I am number ' + i, _fct);
				}
				setTimeout(function () {
					for (var i = 0; i < todo; i++) {
						APPFCTS.queueProc.add('queueProcTEST', 'I am number ' + (todo + i), _fct);
					}
				}, 1000);
			},
			init: function (id, maxChan) {
				if (!APPFCTS.queueProc._queues[id])
					APPFCTS.queueProc._queues[id] = {
						processing: false,
						queue: [],
						channels: [],
						maxChan: maxChan || 1,
						onEmpty: []
					};
			},
			setMaxChan: function (id, maxChan) {
				if (!APPFCTS.queueProc._queues[id]) return false;
				APPFCTS.queueProc._queues[id].maxChan = maxChan || 1;
			},
			add: function (qid, data, fct) {
				var parent = APPFCTS.getParentStack();
				if (Array.isArray(data)) {
					for (var i = 0; i < data.length; i++)
						APPFCTS.queueProc._queues[qid].queue.push({ fct: fct, data: data[i], parent: parent });
				}
				else
					APPFCTS.queueProc._queues[qid].queue.push({ fct: fct, data: data, parent: parent });
				APPFCTS.queueProc._process(qid);
			},
			onQueueEmpty: function (id, cback) {
				APPFCTS.queueProc._queues[id].onEmpty.push(cback);
			},
			_runQueueEmpty: function (id) {
				if (APPFCTS.queueProc._queues[id].onEmpty && APPFCTS.queueProc._queues[id].onEmpty.length) {
					if (APPFCTS.tryCatch(function () {
						APPFCTS.queueProc._queues[id].onEmpty[0]();
					})) {
						console.warn('Queue ID ' + qid);
					}
					APPFCTS.queueProc._queues[id].onEmpty.shift();
					//process.nextTick(function(){
					APPFCTS.queueProc._runQueueEmpty(id);
					//});
					if (typeof process != 'undefined') process.nextTick(function () {
						APPFCTS.queueProc._runQueueEmpty(id);
					});
					else setTimeout(function () {
						APPFCTS.queueProc._runQueueEmpty(id);
					}, 1);
				}
			},
			_process: function (qid) {
				if (APPFCTS.queueProc._queues[qid].processing)
					return;
				APPFCTS.queueProc._queues[qid].processing = true;
				var _proc = function () {
					if (!APPFCTS.queueProc._queues[qid].queue.length) {
						APPFCTS.queueProc._queues[qid].processing = false;
						APPFCTS.queueProc._runQueueEmpty(qid);
						return;
					}
					var _f = APPFCTS.queueProc._queues[qid].queue[0];
					for (var i = 0; i < APPFCTS.queueProc._queues[qid].maxChan; i++) {
						if (!APPFCTS.queueProc._queues[qid].channels[i]) {
							//console.log(''+qid+', started channel #',i)
							//APPFCTS.queueProc._queues[qid].totalChans++;
							APPFCTS.queueProc._queues[qid].channels[i] = function (x, f) {
								if (APPFCTS.tryCatch(function () {
									f.fct(f.data, function () {
										//console.log(''+qid+', ended channel #',x)
										APPFCTS.queueProc._queues[qid].channels[x] = null;
										if (typeof process != 'undefined') process.nextTick(_proc);
										else setTimeout(_proc, 1);
									})
								})) {
									console.warn(_f.parent);
									//console.log('ERROR ON '+qid+', CHANNEL #'+x);
									APPFCTS.queueProc._queues[qid].channels[x] = null;
									if (typeof process != 'undefined') process.nextTick(_proc);
									else setTimeout(_proc, 1);
								}
							};
							APPFCTS.queueProc._queues[qid].channels[i](i, _f);
							APPFCTS.queueProc._queues[qid].queue.shift();
							if (typeof process != 'undefined') process.nextTick(_proc);
							else setTimeout(_proc, 1);
							return;
						}
					}
				};
				if (typeof process != 'undefined') process.nextTick(_proc);
				else setTimeout(_proc, 1);
			}
		},
		bookings: {
			getAgendomBundlePeriod: async (vars, cback) => {
				if (pe(licence, 'modules.agendom.enabled') != '1') {

					return false;
				}
				//console.log('getAgendomBundlePeriod',JSON.stringify(vars))
				if (APPFCTS._w)
					APPFCTS.call('getAgendomBundlePeriod')(vars, cback);
				else {
					cback(await APPFCTS.OLO.API('getAgendomBundlePeriod', vars));
				}
			}
		},
		urlParams: {},
		parseUrlParams: function (a) {

			let
				match,
				pl = /\+/g,                   // Regex for replacing addition symbol with a space
				search = /([^&=]+)=?([^&]*)/g,
				_json = function (s) {
					if (typeof s == 'string' && (s.indexOf('[') === 0 || s.indexOf('{') === 0))
						return JSON.parse(s);
					return s;
				}
			decode = function (s) { return decodeURIComponent(s.replace(pl, " ")); },
				query = (a || window.location.search).substring(1),
				_u = {};

			while (match = search.exec(query)) {
				let
					_k = decode(match[1]),
					_v = decode(match[2]);
				if (/\[\]$/.test(_k)) {
					_k = _k.replace(/\[\]$/, '');
					if (!_u[_k]) _u[_k] = [];
					_u[_k].push(_v);
				}
				else
					_u[_k] = _json(_v);
			}
			APPFCTS.urlParams = _u;
			return _u;
		},
	};
APPFCTS.parseUrlParams();
(() => {
	let oldPushState = history.pushState;
	history.pushState = function pushState() {
		let ret = oldPushState.apply(this, arguments);
		window.dispatchEvent(new Event('pushstate'));
		window.dispatchEvent(new Event('locationchange'));
		return ret;
	};

	let oldReplaceState = history.replaceState;
	history.replaceState = function replaceState() {
		let ret = oldReplaceState.apply(this, arguments);
		window.dispatchEvent(new Event('replacestate'));
		window.dispatchEvent(new Event('locationchange'));
		return ret;
	};

	window.addEventListener('popstate', () => {
		window.dispatchEvent(new Event('locationchange'));
	});
})();
let _locationChangedTimer;
window.addEventListener('locationchange', function () {
	clearTimeout(_locationChangedTimer);
	_locationChangedTimer = setTimeout(function () {
		for (let i of _hashChanges) {
			try {
				i(document.location.hash.replace('#!/', ''));
			} catch (er) {
				console.error('On hash change', er)
			}
		}
	}, 100);
});
class iFrameMessages {
	self;
	constructor(options) {
		//options = {
		//    
		//    ...options
		//}
		self = this;
		self._cbacks = {};
		self._target = options.target ? document.getElementById(options.target).contentWindow : window.top;
		window.addEventListener('message', function (data) {
			if (pe(data, 'data.isFromIframeMsg')) {
				if (pe(data, 'data.callback') && self._cbacks[data.data.callback]) {
					try {
						self._cbacks[data.data.callback](data.data.data);
					} catch (er) {
						console.error('Error from iFrame callback', er)
					}
					setTimeout(function () {
						delete self._cbacks[data.data.callback];
					}, 1000 * 30)
					return;
				}
				//console.log(data.data)
				if (pe(data, 'data.data.module') == 'TESTAPI') {
					self._target.postMessage({ isFromIframeMsg: true, callback: data.data.cbackid, data: { test_successfull: 1 } }, '*');
					return;
				}
				options.onMessage(data.data.data, data.data.cbackid ? function (res) {
					self._target.postMessage({ isFromIframeMsg: true, callback: data.data.cbackid, data: res }, '*');
				} : null);
			}
		});
		return {
			send: self.send,
			test: function (cback) {
				self.send({ module: 'TESTAPI' }, cback)
			}
		}
	}
	send(data, cback) {
		let _cbackid = cback ? crypto.randomUUID() : null;
		if (cback)
			self._cbacks[_cbackid] = cback;
		self._target.postMessage({ isFromIframeMsg: true, cbackid: _cbackid, data: data }, '*');

	}
};
APPFCTS.isInFrame = window.parent.location && window.location !== window.parent.location ? true : false;
APPFCTS.msgApi = !APPFCTS.isInFrame ? { supported: false, send: async (_, cback) => { if (cback) cback(null); return false; } } : new iFrameMessages({
	onMessage: function (arg, cback) {
		//var evt=arg.module+'.'+arg.action;
		console.log('APPFCTS.msgapi,route', arg)
		if (pe(APPFCTS, arg.module + '.routePOSEvent'))
			APPFCTS[arg.module].routePOSEvent(arg, cback);
		else {
			console.warn('POS, UNHANDLED PARENT EVENT', arg);
			if (cback) cback('UNHANDLED');
		}
	}
})

$(document).ready(function () {
	clearTimeout(_loadingOverlayHomeBtnTimer);
	$('.pageLoadingOverlay').hide();
	let _docIsReady = function () {
		$('.pageLoadingOverlay .pageLoadingOverlayBtnWrapper').hide();
		$('.pageLoadingOverlay .returnHomeBtn').on('click', function () {
			$('.pageLoadingOverlay .pageLoadingOverlayBtnWrapper').hide();
			console.log('return home')
			showLoadingOverlay({
				en: 'Loading home page, please wait.',
				fr: 'Chargement de la page d\'accueil, veuillez patienter.'
			}[LOCALE]);
			document.location.href = '' + BASE_URL;
			setTimeout(() => {
				clearTimeout(_beforeUnloadLoadingOverlayTimer);
			}, 1000);
		});
		$('.pageLoadingOverlay .reloadPageBtn').on('click', function () {
			$('.pageLoadingOverlay .pageLoadingOverlayBtnWrapper').hide();
			console.log('reloading page')
			showLoadingOverlay({
				en: 'Reloading page, please wait.',
				fr: 'Rechargement de la page en cours, veuillez patienter.'
			}[LOCALE]);
			document.location.reload();
			setTimeout(() => {
				clearTimeout(_beforeUnloadLoadingOverlayTimer);
			}, 1000);
		});

		APPFCTS._docIsReady = true;
		if (typeof _onDocReady != 'undefined' && _onDocReady && _onDocReady.length) {
			for (let i = 0; i < _onDocReady.length; i++) {
				try {
					_onDocReady[i]();
				} catch (er) { console.error('Document ready', er); }
			}
			_onDocReady = [];
		}
		//check licence overdue/onHold
		if (typeof licence != 'undefined' && (!licence.enabled || licence.onHold || licence.serviceTerminated || licence.overdue || licence.mode == 'demo' || licence.daysLeft > 0)) {
			if (!licence.enabled || licence.onHold || licence.serviceTerminated) {
				$('body').addClass('hasLicenceWarning');
				$('#licenceWarning').html(LOCALE == 'fr' ?
					'La licence pour ce compte est désactivée.' :
					'The licence for this account is disabled.')

				$('#licenceWarning').removeClass('hidden').show();
			}
			else if (licence.overdue && licence.daysLeft < 10) {
				$('body').addClass('hasLicenceWarning');
				$('#licenceWarning').html(LOCALE == 'fr' ?
					'Votre compte nécessite une attention immédiate. Veuillez accéder à votre compte dashboard.azimutpos.com pour éviter une suspension.' :
					'Your account requires immediate attention. Please log-in to your dashboard.azimutpos.com account to prevent suspension.')

				$('#licenceWarning').removeClass('hidden').show();
			}
			else if (licence.serviceTermination && licence.daysLeft < 10) {
				$('body').addClass('hasLicenceWarning');
				$('#licenceWarning').html(LOCALE == 'fr' ?
					'Votre service se terminera le ' + licence.serviceTermination + '. ' + licence.daysLeft + ' jours restant.' :
					'Your service will end on ' + licence.serviceTermination + '. ' + licence.daysLeft + ' days left.')
				$('#licenceWarning').removeClass('hidden').show();
			}
		}
	};
	if (!APPFCTS._w) {
		_docIsReady();
	}
	else {
		let _waitLoaded = function () {
			try {
				//if(APPFCTS.system.getUUID()){
				APPFCTS.system.getRegisterConfig(function () {
					_docIsReady();
				});
				APPFCTS.system.getRegisterStatus((r) => {
					if (r)
						setInterval(() => {
							APPFCTS.system.getRegisterStatus()
						}, 1000 * 10)
				});
				return;
				//}
				setTimeout(_waitLoaded, 100);
			} catch (er) {
				//console.error(er)
				setTimeout(_waitLoaded, 100);
				return;
			}
		};
		_waitLoaded();
	}

	setInterval(function () {
		if ($('.clock') && $('.clock').length)
			$('.clock').html(moment().format('hh:mm:ss a'));
	}, 300);
	try {
		if ($('.clock') && $('.clock').length)
			$('.clock').html(moment().format('hh:mm:ss a'));
	} catch (er) { }
});
var _beforeUnloadLoadingOverlayTimer = null;
$(window).on('beforeunload', function () {
	_beforeUnloadLoadingOverlayTimer = setTimeout(function () {
		showLoadingOverlay('');
		_beforeUnloadLoadingOverlayTimer = setTimeout(function () {
			showLoadingOverlay({
				en: 'The requested page is taking longer to load than normal.<br/>We apologize for the inconvenience.',
				fr: 'La page demandée prend plus de temps à charger qu\'a la normale.<br/>Nous nous excusons des désagréments.'
			}[LOCALE]);
		}, 1000 * 5);
	}, 1000 * 3);
});
pwm = APPFCTS;