var Discover, D, app, self, _discovered = {}, connectedToNodes = {}, _sockets = {}, _emitCbacks = {}, _emitAcks = {}, _pings = {}, _masterNode = null,
	_sendQueueProcessing = {}, _sendQueue = {}, _doNotConnect = [], _traces = {}, _socketTraceInterval = {};
module.exports = class neighbors {
	constructor(parent) {
		app = parent;
		self = this;
		self.namespace = 'tpos_neighboring_p2p';
		this.locks = new (require(__dirname + "/modules/locks/locks.js"))(app);

		setInterval(function () {
			if (app.pathExists(app, 'data.session.result') == 'success') {
				self.initSockets();
			}
		}, 1000 * 60 * 15);

	}
	_masterNode() {
		return '' + _masterNode;
	}
	initialize(cback) {
		if (!app.web.initialized || !app.web.PKI || !app.web.PKI.private) {
			setTimeout(function () {
				self.initialize(cback);
			}, 100);
			return;
		}
		//start socket
		//advertise

		self.bindIO();
		Discover = require('node-discover');
		self.dcfg = { port: app.web.port + 1, weight: 1 * app.system.vars.numCPUs }
		if (app._m.fs.existsSync('/media/technopos/service')) {
			self.dcfg.weight = self.dcfg.weight * 2;
			//is frontcloud, use bond0 address

		}
		//if (app.pathExists(app, 'data.session.configs.registers') && !app.isEmptyObject(app.data.session.configs.registers)) {
		//	self.dcfg.unicast = [];
		//	let _r = Object.keys(app.data.session.configs.registers);
		//	for (let i = 0; i < _r.length; i++) {
		//		let _reg = app.data.session.configs.registers[_r[i]];
		//		self.dcfg.unicast.push(app.pathExists(_reg, 'network.ipAddress') || _reg.ipAddress);
		//	}
		//}
		D = Discover(self.dcfg);
		D.on("promotion", function () {
			/* 
				* Launch things this master process should do.
				* 
				* For example:
				*	- Monitior your redis servers and handle failover by issuing slaveof
				*    commands then notify other node instances to use the new master
				*	- Make sure there are a certain number of nodes in the cluster and 
				*    launch new ones if there are not enough
				*	- whatever
				* 
				*/

			console.log("I was promoted to a master.");
			_masterNode = '' + app.system.id;
		});

		D.on("demotion", function () {
			/*
				* End all master specific functions or whatever you might like. 
				*
				*/

			//console.log("I was demoted from being a master.");
		});

		D.on("added", function (obj) {
			let _s = obj.advertisement;
			if (_s && _s.channel == self.namespace && _s.id && _s.id.indexOf('REG-') === 0) {
				console.log("A new node has been added.", _s);
				_discovered[_s.id] = _s;
				if (_masterNode == app.system.id && app.pathExists(app.data, 'session.configs.registers')) {
					//node discovered
					let keys = Object.keys(app.data.session.configs.registers);
					if (keys.length > 0 && keys.indexOf(_s.id) == -1) {
						console.log('Node discovered and not in my registers list', _s)
					}
				}
				app.pos.neighbors.connectToNode(_s.id);
			}
		});

		D.on("removed", function (obj) {
			let _s = obj.advertisement;
			if (_s && _s.channel == self.namespace && _s.id && _s.id.indexOf('REG-') === 0) {
				console.log("A node has been removed.", _s);
				delete _discovered[_s.id];
				//flush socket
			}
		});

		D.on("master", function (obj) {
			/*
				* A new master process has been selected
				* 
				* Things we might want to do:
				* 	- Review what the new master is advertising use its services
				*	- Kill all connections to the old master
				*/

			let _s = obj.advertisement;
			if (_s && _s.channel == self.namespace && _s.id && _s.id.indexOf('REG-') === 0) {
				console.log("A new master is in control (you are a slave my friend)", obj.advertisement);
				_masterNode = '' + _s.id;
			}
		});
		D.advertise({
			channel: self.namespace,
			hostname: os.hostname(),
			id: app.system.id,
			interfaces: app.system.vars.interfaces
		});
	}
	registerRemoved(id) {
		//disconnect and purge
		try {
			if (_sockets[id]) _sockets[id].disconnect();
		} catch (er) { }
		try {
			if (connectedToNodes[id]) connectedToNodes[id].disconnect();
		} catch (er) { }
	}
	initSockets() {
		if (app.status == 'shutdown') return;
		if (app.pathExists(app.data, 'session.configs.registers')) {
			let keys = Object.keys(app.data.session.configs.registers).filter(function (a) { return a != app.system.id; });
			for (let i = 0; i < keys.length; i++) {
				self.connectToNode(keys[i]);
			}
		}
	}
	bindIO() {
		if (app.status == 'shutdown') return;
		if (self.io) return;
		if (!app.web.io) {
			setTimeout(self.bindIO, 100);
			return;
		}
		let _connection = function (socket) {
			if (app.status == 'shutdown') return;
			//console.log('new connection', socket.id)
			socket.sendEncrypted = false;
			socket.decryptErrors = 0;
			socket.debugEvents = false;
			socket.ipAddress = app.getIPFromSocket(socket);
			let
				appType = 'register',
				useIV = false,
				_deviceUUID = '',
				_onConnect = function (d, ack, cback) {
					if (app.status == 'shutdown') return;
					try {
						d = app.JSON.parse(app.system.crypto.AES_PK.decrypt(d, app.web.PKI.private));
					}
					catch (er) {
						if (socket.decryptErrors > 1)
							console.error(er.message, d)
						socket.decryptErrors++;
						if (ack) ack('resend', er.message);
						return;
					}
					if (typeof d == 'string')
						d = app.JSON.parse(d);
					//console.log('device connected', d)
					//update public key for device d.macAddress
					if (typeof d.appType == 'undefined' || !d.appType)
						d.appType = '' + appType;
					appType = '' + d.appType;
					if (d.useIV) useIV = true;
					if (useIV) socket.useIV = true;
					_deviceUUID = '' + (d.uuid || 'REG-' + d.macAddress);

					d.deviceUUID = '' + _deviceUUID;
					socket.deviceUUID = '' + _deviceUUID;
					socket.decryptErrors = 0;
					socket.socketType = 'clients';
					if ((!ack || typeof ack != 'function') && d.ackID) ack = function (a, b) {
						if (socket.debugEvents) console.log('devices.routeEvent eventACK', socket.deviceUUID, d.module, d.action, a);
						socket.emit('eventACK', { ackID: d.ackID, ack: a, ackData: b });
					}
					if (d.askingFor && d.askingFor != app.system.id) {
						if (ack) ack('id_mismatch', app.system.id);
						return false;
					}
					let r = app.pathExists(app.data, 'session.configs.registers.' + _deviceUUID);
					if (!r) {
						if (ack && !app.pathExists(app.data, 'session.configs.registers')) {
							setTimeout(function () {
								ack('resend');
							}, 1000 * 15);
							return false;
						}
						if (ack) ack('declined');
						if (cback && typeof cback == 'function') cback('declined');
						//console.warn('REGISTER UNKNOWN', node);
						return false;
					}
					socket.cidr = app.pathExists(d, 'network.cidr');

					let _mac = app.regIDtoMAC(_deviceUUID);
					if (app.pathExists(app.system.net.arp, '_lastScan.values.' + _mac) && app.system.net.arp._lastScan.values[_mac] != (d.network?.cidr?.split('/')?.[0] || socket.ipAddress)) {
						//ip mismatch

						app.pathToObject(r, 'network.ipAddress', '' + app.system.net.arp._lastScan.values[_mac]);
					}
					else if (!app.pathExists(r, 'network.ipAddress') || socket.ipAddress != app.pathExists(r, 'network.ipAddress')) {
						app.pathToObject(r, 'network.ipAddress', '' + r.network.ipAddress);
					}
					socket.statusData = d.statusData
					socket.sendAllowed = 1;
					socket.connectedDate = new Date().toISOString();
					//console.log('Allowed to send to client', _deviceUUID);
					if (_sockets[_deviceUUID]) {
						console.warn('socket exists for', _deviceUUID)
						_sockets[_deviceUUID].disconnect();
						setTimeout(function () {
							delete _sockets[_deviceUUID];
							_sockets[_deviceUUID] = socket;

						}, 500);
					}
					else _sockets[_deviceUUID] = socket;
					if (ack) ack('allowed');
					if (_doNotConnect.indexOf(_deviceUUID) != -1) _doNotConnect.splice(_doNotConnect.indexOf(_deviceUUID), 1);
					self.processSendQueue(_deviceUUID);
					if (cback && typeof cback == 'function') {
						//send my current pings and statuses
						cback(self.getstatusData());
					}
					setTimeout(function () {
						app.pos.weightScale.sendDataToNeighbor(_deviceUUID);
						if (_masterNode == app.system.id) {
							if (!app.pathExists(connectedToNodes, _deviceUUID + '.connected')) {
								//i'm master, send this client the list of printers
								self.broadCastPrintersIPs(socket);
							}
							self.locks.sendCurrentLocks(_deviceUUID);
						}
						self.connectToNode(_deviceUUID, { noNewConect: 1, alternateIpAddress: socket.ipAddress });
						self.broadcastStatusData();
						self.updateGUI();
						try { app.pos.db.transactions.processOutgoing(_deviceUUID); } catch (e) { console.error(e.message) }
						//broadcast my neighboring data
						self.send(_deviceUUID, { module: 'hello', action: 'hello' }, function (res) {

						}, function (ack) {

						})
					}, 1000);

				};
			_socketTraceInterval[socket.ipAddress] = setInterval(() => {
				self.traceRoute(socket);
			}, 1000 * 60 * 5);
			self.traceRoute(socket);
			socket.useIV = false;
			socket.sendAllowed = 0;
			//console.log('device CONNECTED',socket.id)
			socket.emit('PUBLIC_KEY', app.web.PKI.public64);
			socket.
				on('PUBLIC_KEY', function (d, ack) {
					//console.log('received public key from', _deviceUUID)
					socket.publicKey = Buffer.from(d, 'base64').toString();
					//console.log(d);
					//console.log(socket.publicKey)
					socket.sendEncrypted = true;
					socket.emit('PUBLIC_KEY_RECEIVED', '1');
					if (ack) ack('received');
				}).
				on('eventACK', function (d) {
					if (_emitAcks[d.ackID])
						_emitAcks[d.ackID](d.ack, d.ackData);
				}).
				on('eventCBACK', function (d) {
					if (_emitCbacks[d.cbackID])
						_emitCbacks[d.cbackID](d);
				}).
				on('app.connect', _onConnect).
				on('device.connect', _onConnect).
				on('message', function (d, ack, cback) {
					app.tryCatch(function () {
						self.routeEvent(socket, d, ack, cback);
					});
				}).
				on('disconnect', function () {
					if (typeof socket == 'undefined')
						return;
					delete _sockets[_deviceUUID];
					self.broadcastStatusData();
					self.updateGUI();
				});
		};
		self.io = app.web.io.of('/' + self.namespace)
			.on('connection', _connection);
	}
	broadcast(data) {
		let s = self.getstatusData({ connectedIdsOnly: 1 });
		//send to all clients and remotes
		if (s && s.neighbors && s.neighbors.ids && s.neighbors.ids.length) {
			let ids = s.neighbors.ids.slice(0);
			if (data.filterIds && data.filterIds.length) {
				ids = ids.filter(function (a) { return data.filterIds.indexOf(a) != -1; });
			}
			if (data.excludeIds && data.excludeIds.length) {
				ids = ids.filter(function (a) { return data.excludeIds.indexOf(a) == -1; });
			}
			delete data.filterIds;
			delete data.excludeIds;
			if (data.allSockets) {
				delete data.allSockets;
				//send to clients
				let _clients = Object.keys(s.neighbors.clients);
				for (let i = 0; i < _clients.length; i++) {
					if (_sockets[_clients[i]] && ids.indexOf(_clients[i]) != -1) self.send(_sockets[_clients[i]], data);
				}

				//send to remotes (server)
				let _remotes = Object.keys(s.neighbors.remotes);
				for (let i = 0; i < _remotes.length; i++) {
					if (connectedToNodes[_remotes[i]] && ids.indexOf(_remotes[i]) != -1) self.send(connectedToNodes[_remotes[i]], data);
				}
				return;
			}

			//send to clients, on only one available socket
			for (let i = 0; i < ids.length; i++) {
				try {
					self.send(ids[i], data);
				} catch (er) { }
			}
		}
	}
	broadCastPrintersIPs(s) { //app.pos.neighbors.broadCastPrintersIPs=function(s){
		let _p = app.printManager.getPrinters({ networkOnly: 1, noStatus: 1 });
		let out = [];
		if (_p && _p.length) {
			for (let i = 0; i < _p.length; i++) {
				out.push({
					id: _p[i].id,
					deviceUri: _p[i].deviceUri,
					macAddress: _p[i].macAddress
				});
			}
			if (out.length) {
				self.send(s, { module: 'printManager', action: 'setPrintersNetworkInfo', data: { source: app.system.id, printers: out } })
			}
		}
	}
	broadcastStatusData() {
		let s = self.getstatusData();
		self.broadcast({ module: 'status', action: 'updateStatusData', data: s });
		self.broadcast({ module: 'printManager', action: 'set_neighbors_printers_status', data: app.printManager._printerPingStatus });
	}
	disconnected() {

	}
	connectToNode(node, options) {
		if (app.status == 'shutdown' || node == app.system.id) return;

		if (!app.web.initialized || !app.web.PKI || !app.web.PKI.private) {
			setTimeout(function () {
				self.connectToNode(node, options);
			}, 500);
			return;
		}

		if (!options) options = {};

		let r = app.pathExists(app.data, 'session.configs.registers.' + node);
		if (!r) {
			console.warn('NEIGHBOR UNKNOWN', node);
			return false;
		}
		if (_doNotConnect.indexOf(node) != -1) {
			console.warn('Won\'t connect to ' + node + '.')
			return false;
		}
		//check for arp table if register has changed ip

		let getIP = function () {
			let _ip = app.pathExists(r, 'network.ipAddress');
			let _mac = app.regIDtoMAC(node);
			if (app.pathExists(app.system.net.arp, '_lastScan.values.' + _mac) && app.system.net.arp._lastScan.values[_mac] != _ip) {
				//ip mismatch
				_ip = '' + app.system.net.arp._lastScan.values[_mac];
				app.pathToObject(r, 'network.ipAddress', '' + app.system.net.arp._lastScan.values[_mac]);
			}
			return _ip;
		}
		let
			_useIp = 0,
			ips = [options.useIP, options?.alternateIpAddress, getIP(), ...(r.ipAddresses || [])].filter((a) => a);
		//try local ip for 3 seconds, if no answer, socketize request
		//get local ip address
		if (!ips?.length) {
			//look for more
			console.warn('NEIGHBOR AS NO IP ADDRESS', node);
			return false;
		}
		if (connectedToNodes[node]) {
			return false;
		}
		let _doIP = () => {
			let ip = ips[_useIp];
			if (!ip) {
				ip = ips[0];
				_useIp = 0;
			}
			//console.log('Connect to', node, ip)
			//if (!r.online) return false;
			//console.info('connecting to', 'http://' + ip + ':' + app.web.port + '/' + self.namespace)

			connectedToNodes[node] = app.io('http://' + ip + ':' + app.web.port + '/' + self.namespace, {
				//path: '/' + self.namespace,
				autoConnect: false,
				reconnectionDelay: 1000,
				reconnectionDelayMax: 30000,
				//transports: ['websocket', 'polling'],
				allowUpgrades: true
			});
			let _invalidNamespaceErrors = 0;
			var socket = connectedToNodes[node];
			socket.socketType = 'remotes';
			socket.debugEvents = false;
			let pingReset = null;
			socket.ipAddress = ip;
			socket.deviceUUID = '' + node;
			socket.cidr = r.network?.cidr;
			socket.sendAllowed = 0;
			if (!_socketTraceInterval[ip])
				_socketTraceInterval[ip] = setInterval(() => {
					self.traceRoute(socket);
				}, 1000 * 60 * 5);
			socket.
				on('PUBLIC_KEY', function (d) {
					socket.publicKey = Buffer.from(d, 'base64').toString();
					//console.log('RECEIVED PUBLIC KEY FROM', node + '@' + ip, socket.publicKey)
					//if (!app.web.PKI || !app.web.PKI.public) {
					//	console.error('NO PUBLIC KEY CREATED!');
					//	return;
					//}
					//console.log('SEND PUBLIC', app.web.PKI.public64)
					socket.emit('PUBLIC_KEY', app.web.PKI.public64, function (ack) {

						//console.log('Connecting fo real')
						socket.sendEncrypted = true;
						let _retried = 0, _sendConnect = function () {
							if (app.status == 'shutdown') return;
							let ackID = app.system.uuid.get();
							if (_emitAcks[ackID]) {
								do {
									ackID = app.system.uuid.get();
								} while (_emitAcks[ackID]);
							}

							let ackTimeoutWarn = null, ackFired = false;
							_emitAcks[ackID] = function (ack, ackData) {
								//console.log(ack, ackData)
								if (ackFired) return false;
								ackFired = true;
								setTimeout(function () {
									delete _emitAcks[ackID];
								}, 1000 * 5);
								//console.log('ack')
								try { clearTimeout(ackTimeoutWarn); } catch (er) { }
								if (ack == 'id_mismatch') {
									console.error('Node ID mismatch, retry with arp table value', ackData, 'should be', node)
									return false;
								}
								if (ack == 'resend') {
									_retried++;
									process.nextTick(_sendConnect);
								}
								if (ack == 'declined') {
									if (!socket.declinedAttempt) socket.declinedAttempt = 0;
									socket.declinedAttempt++;
									if (socket.declinedAttempt == 25) {
										console.error('Too much declined device.connect attempts to', node);
										_doNotConnect.push(node)
										return false;
									}
									setTimeout(_sendConnect, 1000 * (5 + (socket.declinedAttempt || 1)));
								}
								//console.info('device.connect ack', ack)
								if (ack == 'allowed') {
									//console.info('Allowed to send to master', node)
									socket.sendAllowed = 1;
									socket.declinedAttempt = 0;
									if (_doNotConnect.indexOf(node) != -1) _doNotConnect.splice(_doNotConnect.indexOf(node), 1);
								} else {
									console.warn('interPOS.device.connect to:', node, 'Received ack', ack)
								}

								//broadcast my neighboring data

								//if (ack == 'received')
								//	self.processSendQueue();
								//if (ack == 'received' || ack == 'allowed')
							};
							let s = self.getstatusData();
							socket.emit('device.connect', app.system.crypto.AES_PK.encrypt({
								askingFor: '' + node,
								ackID: ackID,
								useIV: true,
								macAddress: app.system._data.macAddress,
								network: {
									cidr: app.pathExists(app, 'diag.basicData.cidr')
								},
								uuid: app.system.id,
								hostname: os.hostname(),
								version: app.cfg.version,
								platform: app.cfg.platform,
								appType: 'register',
								statusData: s
							}, socket.publicKey, true), _emitAcks[ackID], function (res) {
								if (app.status == 'shutdown') return;
								//console.log(res)
								if (res && res.myID && res.myID != node) {
									console.error('Node ID mismatch, retry with arp table value', res.myID, 'should be', node)
									return false;
								}
								//server's neighbors and printers
								socket.sendAllowed = 1;
								socket.connectedDate = new Date().toISOString();
								self.processSendQueue(node);
								socket.statusData = res;
								if (_masterNode == app.system.id && !app.pathExists(_sockets, node + '.connected')) {
									//i'm master, send this client the list of printers
									self.broadCastPrintersIPs(socket);
								}
								self.broadcastStatusData();
								try { app.pos.db.transactions.processOutgoing(node); } catch (e) { console.error(e.message) }
								self.updateGUI();
							});
						};
						_sendConnect();
						//self.connected();
					});
				}).
				on('connect', function () {
					console.log('Connected to', node);
					self.traceRoute(socket);
				}).

				on('pong', () => {
					//console.log('PONG')
				}).
				on('ping', () => {
					self.ping(socket);
					//console.log('PING', pingRes)
					clearTimeout(pingReset);
					pingReset = setTimeout(function () {
						console.warn('Ping timed out, reconnect');
						socket.disconnect();
						setTimeout(function () {
							socket.connect()
						}, 1000);
					}, 1000 * 60);
				}).
				on('message', function (d, ack, cback) {
					app.tryCatch(function () {
						self.routeEvent(socket, d, ack, cback);
					});
				}).

				on('eventACK', function (d) {
					d = app.JSON.parse(app.system.crypto.AES_PK.decrypt(d, app.web.PKI.private));
					if (_emitAcks[d.ackID])
						_emitAcks[d.ackID](d.ack, d.ackData);
				}).
				on('eventCBACK', function (d) {
					d = app.JSON.parse(app.system.crypto.AES_PK.decrypt(d, app.web.PKI.private));
					if (_emitCbacks[d.cbackID])
						_emitCbacks[d.cbackID](d);
				}).
				on('disconnect', function () {
					socket.sendAllowed = 0;
					//self.disconnected()
					clearInterval(_socketTraceInterval[ip])
					delete _socketTraceInterval[ip];
					self.broadcastStatusData();
					self.updateGUI();
				}).
				on('connect_error', function (err) {
					let _msg = err?.message || err
					//console.error('connect_error', node, ip, _msg)
					//if(_msg=='xhr poll error') return;//
					_useIp++;
					setTimeout(() => {
						_doIP(true);
					}, 5000);
					socket.disconnect();
				}).
				on('error', function (err) {
					////if can't connect to the node, check if ip changed by the mac address
					////app.pathExists(r, 'network.ipAddress')
					//if (ip != getIP()) {
					//	//destroy and retry
					//	_useIp++;
					//	_doIP(true);
					//	//self.connectToNode(node);
					//}
					//else if (options.alternateIpAddress) {
					//	self.connectToNode(node, { useIP: options.alternateIpAddress, noNewConect: 1 });
					//}
					if ((err.message || err) == 'Invalid namespace') {
						_invalidNamespaceErrors++;
						setTimeout(function () {
							if (app.status == 'shutdown') return;
							socket.connect();
						}, 1000 * (_invalidNamespaceErrors > 120 ? 120 : _invalidNamespaceErrors));
					}
					else _invalidNamespaceErrors = 0;
					console.error(node, err.message || err);
				});
			socket.connect();
		}
		_doIP();
		//socket.connect();
	}
	getAlternateRoute(node) {
		//list closest nodes to get the better alternate route

		let found = [], s = self.getstatusData({ getStatusData: 1 });
		//send to all clients and remotes
		if (s && s.neighbors && s.neighbors.ids && s.neighbors.ids.length) {
			//send to clients
			let _clients = Object.keys(s.neighbors.clients).filter(function (a) { return s.neighbors.clients[a].canSend; });
			_clients = _clients.concat(Object.keys(s.neighbors.remotes).filter(function (a) { return s.neighbors.remotes[a].canSend; }));
			for (let i of _clients) {
				let
					_r = app.pathExists(_sockets, i + '.statusData.neighbors.remotes.' + node),
					_c = app.pathExists(_sockets, i + '.statusData.neighbors.clients.' + node),
					_lp = [_r?.lastPing, _c?.lastPing].filter((a) => { return a?.date; }).sort((a, b) => { return a.date < b.date ? -1 : 1; })[0],
					_lt = [_r?.lastTrace, _c?.lastTrace].filter((a) => { return a?.date; }).sort((a, b) => { return a.date < b.date ? -1 : 1; })[0];
				found.push({ device: i, date: _lp?.date, ttl: _lp?.ttl || 999, hops: _lt?.hops || 999 })
			}
		}
		if (found && found.length) {
			found = found.filter(function (a) { return new Date(a.date).getTime() > new Date().getTime() - 1000 * 60 * 10 }).sort(function (a, b) {
				if (a.hops < b.hops) return -1;
				return a.ttl < b.ttl ? -1 : 1;
			});
			let ids = [], out = [];
			for (let i = 0; i < found.length; i++) {
				if (ids.indexOf(found[i].device) == -1) {
					ids.push(found[i].device)
					out.push(found[i]);
				}
			}
			if (out.length) {
				//out = out.sort(function (a, b) { return a.ttl < b.ttl ? -1 : 1; });
				console.log('found alternate routes', out)
				return out;
			}
		}
		return null;
	}
	getstatusData(vars) {
		return {
			date: new Date().toISOString(),
			printersStatus: app.printManager._printerPingStatus,
			weightScale: app.pos.weightScale.getStatus(),
			neighbors: self.getNeighbors(vars),
			kdsStatus: app.pos.kds.getStatus()
		};
	}
	getNeighbors(vars) {
		if (!vars) vars = {};
		let out = {
			ids: [],
			clients: {},
			remotes: {}
		};
		if (vars.getRawSockets) return _sockets;
		if (_sockets && !app.isEmptyObject(_sockets)) {
			let _s = Object.keys(_sockets);
			for (let i of _s) {
				out.clients[i] = {
					connected: _sockets[i].connectedDate,
					hasPK: _sockets[i].publicKey ? true : false,
					canSend: _sockets[i].sendAllowed || false,
					sendEncrypted: _sockets[i].sendEncrypted || false,
					ipAddress: _sockets[i].ipAddress,
					network: { cidr: _sockets[i].cidr },
					lastPing: _pings[i] || {},
					lastTrace: _traces[i] || {}
				};
				if (!vars.connectedIdsOnly || vars.connectedIdsOnly && _sockets[i].sendAllowed)
					out.ids.push(i);
				if (vars.getStatusData)
					out.clients[i].statusData = _sockets[i].statusData;
			}
		}
		if (connectedToNodes && !app.isEmptyObject(connectedToNodes)) {
			let _c = Object.keys(connectedToNodes);
			for (let i of _c) {
				out.remotes[i] = {
					connected: connectedToNodes[i].connectedDate,
					canSend: connectedToNodes[i].sendAllowed || false,
					sendEncrypted: connectedToNodes[i].sendEncrypted || false,
					hasPK: connectedToNodes[i].publicKey ? true : false,
					ipAddress: connectedToNodes[i].ipAddress,
					network: { cidr: connectedToNodes[i].cidr },
					lastPing: _pings[i] || {},
					lastTrace: _traces[i] || {}
				};
				if (!vars.connectedIdsOnly || vars.connectedIdsOnly && connectedToNodes[i].sendAllowed)
					if (out.ids.indexOf(i) == -1) out.ids.push(i);
				if (vars.getStatusData)
					out.remotes[i].statusData = connectedToNodes[i].statusData;
			}
		}
		return out;
	}
	neighborIsConnected(id) {
		return _sockets[id] && _sockets[id].connected || connectedToNodes[id] && connectedToNodes[id].connected;
	}
	ping(s) {
		let _start = new Date().getTime(), data = {
			date: new Date().toISOString(),
			ttl: -1
		};
		self.send(s, { module: 'ping', action: 'ping' }, null, async function (ack) {
			data.ttl = (new Date().getTime() - _start) / 1000;
			_pings[s.deviceUUID] = data;
			//let tr=await app.system.net.traceroute(s.ip)
			let _s = self.getstatusData();
			//send to all clients and remotes
			if (_s && _s.neighbors && _s.neighbors.ids && _s.neighbors.ids.length) {
				//send to clients
				for (let i = 0; i < _s.neighbors.ids.length; i++) {
					self.send(_s.neighbors.ids[i], { module: 'status', action: 'updateLastPing', data: { device: s.deviceUUID, date: data.date, ttl: data.ttl } });
				}
			}
		})
	}
	async traceRoute(s) {
		if (!s.ipAddress || s.ipAddress == 'null') return null;
		let _trace = await app.system.net.traceroute(s.ipAddress),
			_data = { date: _trace.date, ttl: _trace?.ping?.ttl, hops: _trace?.hops?.length || 1 };
		_traces[s.deviceUUID] = _data;
		let _s = self.getstatusData();
		//send to all clients and remotes
		if (_s && _s.neighbors && _s.neighbors.ids && _s.neighbors.ids.length) {
			//send to clients
			for (let i = 0; i < _s.neighbors.ids.length; i++) {
				self.send(_s.neighbors.ids[i], { module: 'status', action: 'updateLastTrace', data: { device: s.deviceUUID, ..._data } });
			}
		}
		return _traces[s.deviceUUID];
	}
	processSendQueue(n) {
		if (_sendQueueProcessing[n] || !_sendQueue[n] || !_sendQueue[n].length) {
			return;
		}
		_sendQueueProcessing[n] = true;
		//console.log('sendQueue', sws._sendQueue.length);
		let _q = _sendQueue[n][0];
		if (!_q) {
			_sendQueueProcessing[n] = false;
			return;
		}
		if (!self.send(n, _q.data, _q.cback, function (ack) {
			if (_q.onAck) _q.onAck(ack);
			if (ack == 'received') {
				_sendQueue[n].shift();
				self.processSendQueue(n);
			}
		})) {
			_sendQueueProcessing[n] = false;
			return false;
		}
	}
	routeEvent(socket, d, ack, cback) {
		//socket.debugEvents = true;
		try {
			d = app.JSON.parse(app.system.crypto.AES_PK.decrypt(d, app.web.PKI.private));
		}
		catch (er) {
			if (socket.decryptErrors > 1)
				console.error(er.message, d)
			socket.decryptErrors++;
			if (ack) ack('resend', er.message);
			return;
		}
		if (typeof d == 'string')
			d = app.JSON.parse(d);
		//console.log('_routeEvent', typeof ack, typeof cback, d)
		//if (typeof ack == 'object') console.warn(ack);
		if (socket.debugEvents) console.log('devices.routeEvent', socket.deviceUUID, d.module, d.action);
		if ((!ack || typeof ack != 'function') && d.ackID) ack = function (a, b) {
			if (socket.debugEvents) console.log('devices.routeEvent eventACK', socket.deviceUUID, d.module, d.action, a);
			socket.emit('eventACK', { ackID: d.ackID, ack: a, ackData: b });
		}
		if (ack) ack('received');
		if (cback && typeof cback == 'function') d.cback = function (data) { cback(socket.sendEncrypted ? app.system.crypto.AES_PK.encrypt(data, socket.publicKey, true) : data) };
		//if (cback && typeof cback == 'function') d.cback = cback;
		//d.deviceUUID = '' + _deviceUUID;
		socket.decryptErrors = 0;
		d.event = 'message';
		d.socket = socket;

		//if (d.useIV) useIV = true;
		//if (useIV) socket.useIV = true;


		switch (d.module) {
			case 'locks':

				self.locks.routeEvent(d);
				break;
			case 'disconnect_me':
				socket.disconnect();
				break;
			case 'relayMessage':
				let start = new Date().getTime();
				self.send(d.target, d.data, function (res) {
					d.cback({
						device: app.system.id,
						relayed: new Date().toISOString(),
						ttl: (new Date().getTime() - start) / 1000,
						data: res
					});
				});
				break;
			case 'diag':
				app.diag.routeEvent(d);
				break;
			case 'printManager':
				//console.log('Received printManager data from neighbor', d.originNode, d.action, d.data)
				app.printManager.routeEvent(d);
				break;
			case 'weightScale':
				app.pos.weightScale.routeEvent(d);
				break;
			case 'ping':
				//do nothing
				break;
			case 'status':
				switch (d.action) {
					case 'updateStatusData':
						d.socket.statusData = d.data;
						break;
					case 'updateLastTrace':

						let _lastTraceData = { date: d.data.date, ttl: d.data.ttl, hops: d.data.hops };
						//console.log('SET last ping', socket.deviceUUID, d.data)
						if (app.pathExists(_sockets, socket.deviceUUID + '.statusData.neighbors.clients.' + d.data.device))
							_sockets[socket.deviceUUID].statusData.neighbors.clients[d.data.device].lastTrace = _lastTraceData;
						if (app.pathExists(_sockets, socket.deviceUUID + '.statusData.neighbors.remotes.' + d.data.device))
							_sockets[socket.deviceUUID].statusData.neighbors.remotes[d.data.device].lastTrace = _lastTraceData;

						if (app.pathExists(connectedToNodes, socket.deviceUUID + '.statusData.neighbors.clients.' + d.data.device))
							connectedToNodes[socket.deviceUUID].statusData.neighbors.clients[d.data.device].lastTrace = _lastTraceData;
						if (app.pathExists(connectedToNodes, socket.deviceUUID + '.statusData.neighbors.remotes.' + d.data.device))
							connectedToNodes[socket.deviceUUID].statusData.neighbors.remotes[d.data.device].lastTrace = _lastTraceData;
						//d.socket.lastPing = {d.data;
						break;
					case 'updateLastPing':
						let _lastPingData = { date: d.data.date, ttl: d.data.ttl };
						//console.log('SET last ping', socket.deviceUUID, d.data)
						if (app.pathExists(_sockets, socket.deviceUUID + '.statusData.neighbors.clients.' + d.data.device))
							_sockets[socket.deviceUUID].statusData.neighbors.clients[d.data.device].lastPing = _lastPingData;
						if (app.pathExists(_sockets, socket.deviceUUID + '.statusData.neighbors.remotes.' + d.data.device))
							_sockets[socket.deviceUUID].statusData.neighbors.remotes[d.data.device].lastPing = _lastPingData;

						if (app.pathExists(connectedToNodes, socket.deviceUUID + '.statusData.neighbors.clients.' + d.data.device))
							connectedToNodes[socket.deviceUUID].statusData.neighbors.clients[d.data.device].lastPing = _lastPingData;
						if (app.pathExists(connectedToNodes, socket.deviceUUID + '.statusData.neighbors.remotes.' + d.data.device))
							connectedToNodes[socket.deviceUUID].statusData.neighbors.remotes[d.data.device].lastPing = _lastPingData;
						//d.socket.lastPing = {d.data;
						break;
				}
				break;
			case 'hello':
				d.cback('hey there! My name is ' + os.hostname());
				break;
			case 'vote':
				d.cback(self._doVote(d.data));
				break;
			case 'pos':
				d.data.socket = d.socket;
				d.data.cback = d.cback;
				app.pos.routeInterNode(d.data);
				break;
			case 'kds':
				//d.data.socket = d.socket;
				//d.data.cback = d.cback;
				app.pos.kds.routeInterNode(d);

				break;
			case 'workstation':
				//console.warn('sending to WkS');
				app.pos.production.workstation.routeInterNode(d);
				break;
			default:
				console.log('ROUTE FROM INTER APP SOCKET', d.module, d.action)
		}
	}
	send(node, data, cback, onAck) { //app.pos.neighbors.send=function(node,data,cback,onAck){
		let _s = null, _eventID = app.system.uuid.get(), _timedOut = false, _timeout = data.timeout ? setTimeout(() => {
			if (_sendQueue[node]?.length) _sendQueue[node] = _sendQueue[node].filter((a) => a.eventID != _eventID);
			_timedOut = true;
			cback({
				result: 'error',
				code: 'timeout'
			});
		}, 1000 * data.timeout) : null;
		delete data.timeout;
		if (typeof node != 'string' && node.deviceUUID) {
			_s = node;
			_s.sendAllowed = 1;
			node = '' + _s.deviceUUID;
		}
		if ((!_s || !_s.sendAllowed || !_s.connected) && _sockets[node]) {
			//console.info('FROM _sockets')
			_s = _sockets[node];
			if (_s && _s.connected && !connectedToNodes[node]) self.connectToNode(node);
		}
		if ((!_s || !_s.sendAllowed || !_s.connected) && connectedToNodes[node]) {
			//console.info('FROM connectedToNodes')
			_s = connectedToNodes[node];
		}
		let noRelay = ['hello.*', 'ping.*', 'disconnect_me.*', 'status.*', 'printManager.printerStatusUpdate', 'printManager.set_neighbors_printers_status'];
		if (!_s && noRelay.indexOf(data.module + '.*') == -1 && noRelay.indexOf(data.module + '.' + data.action) == -1) {
			let _alt = self.getAlternateRoute(node);
			if (_alt && _alt.length) {
				//list of alternate routes
				for (let i = 0; i < _alt.length; i++) {
					if (self.send(_alt[i].device, { module: 'relayMessage', target: node, data: data }, function (res) {
						console.log('Message has been relayed by', res.device, res);
						if (_timedOut) return false;
						clearTimeout(_timeout)
						if (cback) cback(res.data);
					}))
						return true;
				}
			}
			console.warn('interPOS.send to:', node, 'unable to communicate, no socket found.')
			if (!_sendQueue[node]) _sendQueue[node] = [];
			_sendQueue[node].push({
				eventID: _eventID,
				data: data,
				cback: cback,
				onAck: onAck
			});
			return false;
		}
		if (!_s || !_s.connected || _s.disconnected) {
			if (noRelay.indexOf(data.module + '.*') == -1 && noRelay.indexOf(data.module + '.' + data.action) == -1) {
				if (!_sendQueue[node]) _sendQueue[node] = [];
				_sendQueue[node].push({
					eventID: _eventID,
					data: data,
					cback: cback,
					onAck: onAck
				});
				return true;
			}
			return false;
		}
		if (_s) {
			if (!_s.sendAllowed) {
				console.warn('interPOS.send to:', node, 'sending is not allowed.', data.module, data.action, typeof _sockets[node], typeof connectedToNodes[node])
				return false;
			}
			if (cback) {
				data.cbackID = app.system.uuid.get();
				if (_emitCbacks[data.cbackID]) {
					do {
						data.cbackID = app.system.uuid.get();
					} while (_emitCbacks[data.cbackID]);
				}
				_emitCbacks[data.cbackID] = function (d, ack) {
					try {
						if (!ackFired && _emitAcks[data.ackID]) {
							_emitAcks[data.ackID]('received');
						}
					} catch (er) { }
					try {
						d = app.system.JSON.parse(app.system.crypto.AES_PK.decrypt(d, app.web.PKI.private));
					}
					catch (er) {
						console.error('interPOS.send to:', node, er.message, d)
						if (ack) ack('resend');
						return;
					}
					try {
						_emitAcks[datas.ackID]('received');
					} catch (er) { }
					//console.log('RECEIVED PARSED', d)
					app.tryCatch(function () {
						cback(d);
					});
					if (ack) ack('received');
					try { clearTimeout(ackTimeoutWarn); } catch (er) { }
					setTimeout(function () {
						delete _emitCbacks[data.cbackID];
					}, 1000 * 5);
				};
			}
			if (!data.originNode) data.originNode = '' + app.system.id;
			data.sendingNode = '' + app.system.id;
			data.ackID = app.system.uuid.get();
			if (_emitAcks[data.ackID]) {
				do {
					data.ackID = app.system.uuid.get();
				} while (_emitAcks[data.ackID]);
			}

			let ackTimeoutWarn = null, ackFired = false;
			_emitAcks[data.ackID] = function (ack) {
				if (ackFired) return false;
				ackFired = true;
				if (_timedOut) return false;
				//console.log('ack')
				try { clearTimeout(ackTimeoutWarn); } catch (er) { }
				if (ack != 'received')
					console.warn('interPOS.send to:', node, 'Received ack for svr.event', data.module + ':' + data.action, ack)
				if (ack == 'resend') {
					_retried++;
					process.nextTick(_doSend);
				}
				clearTimeout(_timeout)
				if (ack == 'received')
					setTimeout(function () {
						delete _emitAcks[data.ackID];
					}, 1000 * 5);
				if (onAck) {
					app.tryCatch(function () {
						onAck(ack);
					});
				}
			};
			try {
				var _retried = 0, _doSend = function () {
					if (_timedOut) return false;
					if (!_s) {
						if (_sockets[node]) {
							_s = _sockets[node];
						}
						else if (connectedToNodes[node]) {
							_s = connectedToNodes[node];
						}
					}
					if (!_s || !_s.emit) {
						console.warn('interPOS.send to:', node, 'cant send data, no socket', data)
						setTimeout(function () {
							if (_timedOut) return false;
							_doSend();
						}, 500);
						return;
					}
					ackTimeoutWarn = setTimeout(function () {
						console.warn('interPOS.send' + (_s.sendEncrypted ? 'Encrypted' : '') + ' to:', node, 'Not received an ack in 20s', typeof _emitAcks[data.ackID]);
					}, 1000 * 20)
					if (_retried < 5 && _s.sendEncrypted && _s.publicKey) {
						_s.emit('message', app.system.crypto.AES_PK.encrypt(data, _s.publicKey, true), _emitAcks[data.ackID], cback ? _emitCbacks[data.cbackID] : undefined);
					}
					else {
						_s.emit('message', data, _emitAcks[data.ackID], cback ? _emitCbacks[data.cbackID] : undefined);
					}
				};
				_doSend();
				return true;
			}
			catch (e) {
				console.error('interPOS.send to:', node, e.message);
			}
		}
		return false;
	}
	publicKeyChanged() {

		let ids = [], s = self.getstatusData({ connectedIdsOnly: 1 });
		//send to all clients and remotes
		if (s && s.neighbors && s.neighbors.ids && s.neighbors.ids.length) {
			ids = s.neighbors.ids.slice(0);
			let _clients = Object.keys(s.neighbors.clients);
			for (let i = 0; i < _clients.length; i++) {
				if (_sockets[_clients[i]] && ids.indexOf(_clients[i]) != -1) ids.push(_clients[i]);
			}

			//send to remotes (server)
			let _remotes = Object.keys(s.neighbors.remotes);
			for (let i = 0; i < _remotes.length; i++) {
				if (connectedToNodes[_remotes[i]] && ids.indexOf(_remotes[i]) != -1) ids.push(_remotes[i]);
			}
			return;
		}

		//send to clients, on only one available socket
		for (let i of ids) {
			try {
				let _s = _sockets[i] || connectedToNodes[i];
				_s.emit('PUBLIC_KEY', app.web.PKI.public64);
			} catch (er) { }
		}
	}
	shutdown() {
		try { D.demote(); } catch (er) { }
		try { D.stop(); } catch (er) { }
		//disconnect everything
		self.broadcast({ module: 'disconnect_me', allSockets: 1 });
		setTimeout(function () {
			let s = self.getstatusData();
			//send to all clients and remotes
			if (s && s.neighbors && s.neighbors.ids && s.neighbors.ids.length) {
				//if (data.allSockets) {
				//send to clients
				let _clients = Object.keys(s.neighbors.clients);
				for (let i = 0; i < _clients.length; i++) {
					if (_sockets[_clients[i]]) try { _sockets[_clients[i]].disconnect(); } catch (e) { }
				}

				//send to remotes (server)
				let _remotes = Object.keys(s.neighbors.remotes);
				for (let i = 0; i < _remotes.length; i++) {
					if (connectedToNodes[_remotes[i]]) try { connectedToNodes[_remotes[i]].disconnect(); } catch (e) { }
				}
				//return;
				//}
			}
		}, 500);
	}
	updateGUI(_win) {
		if (!app.system?.id) {
			console.warn('neighbors.updateGUI failed to get system id');
			return false;
		}
		try {
			let _window = (_win || app.pos.win);
			if (app.pathExists(_window, 'window.APPFCTS.neighbors')) {
				let _s = self.getNeighbors({ connectedIdsOnly: 1 });
				let _status = {
					date: new Date().toISOString(),
					connected: _s.ids.length,
					expected: Object.keys(app.data.session.configs.registers).filter(function (a) { return a != app.system?.id; }).length,
					quorum: 0,
					nodes: _s.ids
				};
				if (_status.expected == 0) _status.quorum = 1;
				else {
					_status.quorum = 1 * (_status.connected / _status.expected).toFixed(1);
				}
				_window.window.APPFCTS.neighbors.status = _status;
				if (!_win) {
					try {
						app.pos.production.workstation.win.window.APPFCTS.neighbors.status = _status;
					} catch (er) { }
				}
			}
		} catch (er) { console.error(er.message) }
	}
	_doVote(d) {
		let _votes = [];
		for (let i = 0; i <= (app.pathExists(d, 'options.iterations') || 10); i++) {
			_votes[i] = app.system.randomInt(0, d.nb || d);
		}
		return { votes: _votes };
	}
	vote(values, options, cback) {
		if (typeof options == 'function') {
			cback = options;
			options = {};
		}
		let _start = new Date().getTime(),
			_nodes = self.getNeighbors({ connectedIdsOnly: 1 }).ids,
			_votes = {},
			out = {
				quorum: false,
				runtime: 0,
				answers: 0,
				total_votes: 0,
				result: []
			};
		let _myVote = self._doVote({ nb: values.length, options: options });
		if (_myVote && _myVote.votes && _myVote.votes.length) {
			out.answers++;
			for (let i = 0; i < _myVote.votes.length; i++) {
				if (!_votes[_myVote.votes[i]]) _votes[_myVote.votes[i]] = { i: _myVote.votes[i], cnt: 0 };
				out.total_votes++;
				_votes[_myVote.votes[i]].cnt++;
			}
		}
		app._m.async.each(_nodes, function (node, n) {
			self.send(node, { module: 'vote', data: { nb: values.length, options: options } }, function (ans) {
				if (ans && typeof ans.votes != 'undefined' && ans.votes) {
					out.answers++;
					for (let i = 0; i < ans.votes.length; i++) {
						if (!_votes[ans.votes[i]]) _votes[ans.votes[i]] = { i: ans.votes[i], cnt: 0 };
						out.total_votes++;
						_votes[ans.votes[i]].cnt++;
					}
				}
				n();
			}, function (ack) {

			})
		}, function () {
			if (app.pathExists(app.data, 'session.configs.registers')) {
				let keys = Object.keys(app.data.session.configs.registers);
				out.participation = (keys.length / out.answers)
				out.quorum = out.participation > 0.51;
			}
			out.runtime = (new Date().getTime() - _start) / 1000;
			let _r = Object.keys(_votes).map(function (k) { return _votes[k]; }).sort(function (a, b) {
				return a.cnt > b.cnt ? -1 : 1;
			});
			for (let i = 0; i < _r.length; i++) {
				out.result.push(values[_r[i].i]);
			}
			cback(out);
		})
	}
};