//apt install libpcsclite-dev
var app, self, _cardsInsertListners = [], _cards = {}, _readers = {}, _reader = '';
module.exports = class smartcards {
	constructor(parent) {
		app = parent;
		self = this;
	}
	initialize(cback) {

		if (cback) cback();
		app.sessions.onConfigChange(function () {

		})
		//load scanners(devices)
		try {
			let s = app._m.spawn('pcsc_scan', ['-n', '-q']);
			s.stdout.on('data', function (l) {
				let
					_str = l.toString('utf8').trim().split('\n'),
					date = new Date().toISOString();
				for (let i of _str.filter((a) => /Reader \d+\: /.test(a) || a.indexOf('ATR: ') != -1 || a.indexOf('Card state: ') != -1).map((a) => a.trim().replace(/[^\x20-\x7E]/g, '').replace(/\[\d+m/g, ''))) {
					if (/Reader \d+\: /.test(i)) {
						_reader = i.split(':').pop().trim()
						if (!_readers[_reader]) _readers[_reader] = {};
						_readers[_reader].date = date;
						//console.log('Got reader', _reader)
					}
					if (i.indexOf('Card state: ') != -1) {
						let _s = i.split(':').pop().split(',')[0].trim();
						_readers[_reader].state = _s;
						//console.log('State:', _s)
						if (_s == 'Card removed') {
							//check card for disconnect event (logout user)
							try {
								let _c = _cards[_readers[_reader].card];
								if (_c?.onRemove) _c?.onRemove({ card: _readers[_reader].card, type: _c.type })
							} catch (er) { console.log('onRemoveError', er) }
							delete _cards[_readers[_reader].card];
						}
					}
					if (i.indexOf('ATR: ') != -1) {
						let
							_card = i.split(':').pop().trim().replace(/ /g, '');
						//console.log('CARD FOUND', _card)
						_readers[_reader].card = _card;
						_cards[_card] = { reader: _reader, date }
						for (let x of _cardsInsertListners) {
							try { x({ reader: _reader, card: _card, date }) } catch (er) { console.log('ListnerError', er) }
						}
					}
				}
			});
			s.stderr.on('data', function (l) { console.log(l.toString().trim()) });
			s.on('error', () => { })
		} catch (er) { }
	}
	isSmartCardAuthenticated() {
		return Object.values(_cards).filter((a) => a.type == 'employee')?.length
	}
	onCardRemoved(id, fn) {
		_cards[id].onRemove = fn;
	}
	onCardInserted(fn) {
		_cardsInsertListners.push(fn)
	}
	setCardType(id, type) {
		_cards[id].type = type;
	}
};
