var cp = require('child_process');

module.exports = {
	scan: scan
}

function scan() {
	return new Promise((resolve) => {
		var CMD = "avahi-browse -a -r -t";
		var res = {};
		var item = {};
		cp.exec(CMD, function (err, stdout, stderr) {
			if (err) {
				resolve(res);
				return;
			}
			data = stdout.split('\n');
			var i, size, match, name, key, value, txtParts, txtMatch, txtValue;
			name = '';
			for (i = 0, size = data.length - 1; i < size; i++) {
				if (!data[i].match(/^=/)) {
					match = data[i].match(/^\s*([^\s]*)\s*=\s*\[([^]*)]/);
					if (match && match.length > 2) {
						key = match[1];
						value = match[2];
						if (key == 'hostname') {
							name = value.toLowerCase();
						} else if (key == 'txt') {
							if (value.length > 2) {
								value = value.substr(1, value.length - 2);
								txtParts = value.split('" "');
								txtValue = {};
								for (var txtPart in txtParts) {
									txtMatch = txtParts[txtPart].match(/([^=]*)=(.*)/);
									if (txtMatch && txtMatch.length > 2) {
										txtValue[txtMatch[1]] = txtMatch[2];
									}
									if (txtMatch && txtValue[txtMatch[1]].match(/^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$/)) {
										item.macAddress = '' + txtValue[txtMatch[1]];
									}
								}
								if (!item.macAddress && txtValue.id && txtValue.id.match(/^([0-9A-Fa-f]{12})$/))
									item.macAddress = '' + txtValue.id;
								if (!item.macAddress && txtValue.bs && txtValue.bs.match(/^([0-9A-Fa-f]{12})$/))
									item.macAddress = '' + txtValue.bs;
								item.name = txtValue.manufacturer || txtValue.md || txtValue.ty || txtValue.n;
								if (txtValue.fn && txtValue.md == 'Chromecast') item.name += ': ' + txtValue.fn
								item[key] = txtValue;
							}
						} else {
							item[key] = value;
						}
					}
				}
				else if (name !== '') {
					res[name] = item;
					item = {};
					name = '';
				}
			}
			res[name] = item;
			res = JSON.parse(JSON.stringify(res));
			resolve(res);
		});
	})
}