var
	app,
	_hosts = {
		dev: 'svrs.legacy.azimutpos.dev.46degresn.ca',
		prod: 'svrs.legacy.azimutpos.com'
	},
	self, _shortcuts = {}, pos = class Pos {
		//this._cfg is set from sessions set
		constructor(parent) {
			self = this;
			self.window_open_policies = require('./window_open_policies');
			self.window_open_policies.app = parent;
			self.window_open_policies.pos = this;
			self.window_navigate_policies = require('./window_navigate_policies');
			self.isRunning = false;
			self.keepRunningOnClose = false;
			self._lastActivity = null;
			self.socketUrl = null;
			self.windowState = 'closed';
			if (parent) {
				self.app = parent;
				app = parent;
			}
			try { self.load_weather(this); } catch (er) { console.error(er); }
			try { self.security = new (require('./security/security.js'))(parent); } catch (er) { console.error(er); }
			try { self.kiosk = new (require('./kiosk/kiosk.js'))(self); } catch (er) { console.error(er); }
			try { self.serverWS = require('./serverWS/serverWS.js'); } catch (er) { console.error(er); }
			try { self.mevWeb = require('./mevWeb/mevWeb.js'); } catch (er) { console.error(er); }
			try { self.tags = require('./tags/tags.js'); } catch (er) { console.error(er); }
			try { self.kds = require('./kds/kds.js'); } catch (er) { console.error(er); }
			try { self.customerDisplay = require('./customerDisplay/customerDisplay.js'); } catch (er) { console.error(er); }
			try { self.weightScale = require('./weightScale/weightScale.js'); } catch (er) { console.error(er); }
			try { self.notifications = require('./notifications/notifications.js'); } catch (er) { console.error(er); }
			try { self.production = require('./production/production.js'); } catch (er) { console.error(er); }
			try { let _db = require('./database/database.js'); self.db = new _db(self); self.database = self.db; } catch (er) { console.error(er); }
			try { self.weightScale.init(app); } catch (er) { console.error(er); }
			try { self.security.initialize(); } catch (er) { console.error(er); }
			try { self.serverWS.init(self); } catch (er) { console.error(er); }
			try { self.tags._init(app); } catch (er) { console.error(er); }
			try { self.kds._init(app); } catch (er) { console.error(er); }
			try { self.mevWeb.init(app); } catch (er) { console.error(er); }
			try { self.customerDisplay.init(self); } catch (er) { console.error(er); }
			try { self.notifications.init(parent); } catch (er) { console.error(er); }
			try { self.production.init(parent); } catch (er) { console.error(er); }
			self.lastActivity = null;
			//to know if an employee is logged in, "app.pos.lastActivity.employee_id"


			try {
				self.neighbors = new (require(__dirname + "/neighbors/neighbors.js"))(parent);
			} catch (er) {
				console.error('LOADING NEIGHBORS MODULE', er.message)
			}
			self.listenShortcut('F12', function () {
				if (self?.win?.hasFocus || app?.splashscreen?.win?.hasFocus) {
					app.diag.run();
				}
			});
			self.listenShortcut('F11', function () {
				if (self?.win?.isLoaded && self?.win?.hasFocus) {
					if (self.win.isFullscreen) {
						self.win.fullScreenOverride = false;
						//leave full screen
						//console.log('F11 leave full screen')
						self.win.leaveKioskMode();
						self.win.leaveFullscreen();
					}
					else {
						self.win.fullScreenOverride = true;
						//console.log('F11 enter full screen')
						self.win.enterFullscreen();
						self.win.enterKioskMode();
					}
				}
			});
			let _helpWindow;
			self.listenShortcut('F1', function () {
				self.setToTop(false);
				if (_helpWindow) _helpWindow.focus();
				else {
					let _options = {
						icon: 'AzimutPOS.png',
						title: "AzimutPOS Wiki",
						show: true,
						position: 'center',
						width: Math.round(screen.availWidth * 0.80),
						height: Math.round(screen.availHeight * 0.80),
						min_width: 800,
						min_height: 700,
						frame: true,
					};
					nw.Window.open('https://wiki.azimutpos.com/login', _options, function (win) {
						_helpWindow = win;
						win.on('close', function () {
							win.hide();
							self.setToTop(true);
						})
					});
				}
			})

		}
		listenShortcut(key, cback) {
			var option = {
				key: key,
				active: function () {
					_shortcuts[key]()
				},
				failed: function (msg) {

				}
			};
			// Create a shortcut with |option|.
			var shortcut = new nw.Shortcut(option);
			// Register global desktop shortcut, which can work without focus.
			nw.App.registerGlobalHotKey(shortcut);
			_shortcuts[key] = cback;
		}
		registerRemoved(id) {
			//disconnect and purge
			try {
				let _modules = Object.keys(self);
				for (let i = 0; i < _modules.length; i++) {
					if (self[_modules[i]] && self[_modules[i]].registerRemoved)
						try { self[_modules[i]].registerRemoved(id); } catch (er) { }
				}
			} catch (er) { }
		}
		shutdown() {
			pos.db.close();
			try {
				let _modules = Object.keys(self);
				for (let i = 0; i < _modules.length; i++) {
					if (self[_modules[i]] && self[_modules[i]].shutdown)
						try { self[_modules[i]].shutdown(); } catch (er) { }
				}
			} catch (er) { }
			self.exit();
		}
		async checkLocalUrl(cbk) {
			return new Promise(async (resolve) => {
				console.info('checkLocalUrl', self._cfg.server)
				//console.log('MY IP', app.system.vars.interfaces.eth0)
				self.url = 'https://' + _hosts[self._cfg.server.env || 'prod'] + '/' + self._cfg.server.server + '/' + self._cfg.branch.id + '/' + app.system.id + '/';
				let localUrl = self._cfg.branch.id + '.azimutpos.lan';
				//self._cfg.server.type = 'frontcloud';
				if (!self._cfg.server?.type || self._cfg.server.type == 'frontcloud' && app.pathExists(app.data, 'session.configs.advanced.frontcloud.bypass') != '1') {
					if (!app.system.vars.isOnFrontCloud) {
						await new Promise(async (rsv) => {
							app._m.dns.resolve4('server.azimutpos.lan', { ttl: 5 }, function (err, addresses) {
								if (addresses?.[0]?.address == '192.168.94.1') {
									app.system.vars.isOnFrontCloud = true;
								}
								rsv();
							});
						});
					}
					if (app.system.vars.isOnFrontCloud) {
						localUrl = 'https://' + localUrl + '/' + app.system.id + '/';
						if (app.system.vars.interfaces.eth0 == '192.168.94.1') {
							self.url = '' + localUrl;
							resolve();
							if (cbk) cbk();
							return;
						}
						//we are on frontcloud network
						self.url = '' + localUrl;
						resolve();
						if (cbk) cbk();
						return;
					}
					//check if we are on the same subnet as tpos server, but outside it's scope
					try {
						let _v = app.system.net.arp?._lastScan?.values?.[self._cfg.server.status.wan.mac];
						//console.log('server is private?', app.system.net.IP.isPrivate(self._cfg.server.status.wan.address))
						if (!self.skipServerSameLan) {
							let _serverLocalAddress = null;
							if (self._cfg.server?.staticIP) {
								localUrl = 'https://' + self._cfg.server?.staticIP.split('/')[0] + ':9443/' + self._cfg.server.server + '/' + self._cfg.branch.id + '/' + app.system.id + '/';
								_pingRes = await app.system.request.GET(localUrl + 'index.php?ping=1', { timeout: 5000, options: { maxTries: 1, noRetry: 1 } });
								console.log(_pingRes);
								if (_pingRes?.data && _pingRes.data.trim() == 'PONG') {
									_serverLocalAddress = '' + self._cfg.server?.staticIP.split('/')[0];
									self.url = '' + localUrl;
								}
							}
							if (!_serverLocalAddress && self._cfg.server?.status?.wan?.cidr && app.system.net.IP.isPrivate(self._cfg.server.status.wan.address)) {
								if (app._m.IPrangeCheck.inRange(app.system.vars.interfaces.eth0, self._cfg.server.status.wan.cidr)) {
									console.info('in same range than server');
									if (_v && _v != self._cfg.server.status.wan.address) {
										console.warn('Server IP address changed from', '' + self._cfg.server.status.wan.address, 'to', '' + _v);
										self._cfg.server.status.wan.address = '' + _v;
									}
									_serverLocalAddress = '' + self._cfg.server.status.wan.address;

									localUrl = 'https://' + _serverLocalAddress + ':9443/' + self._cfg.server.server + '/' + self._cfg.branch.id + '/' + app.system.id + '/';

									self.url = '' + localUrl;
									self.serverIsSameLan = true;
									//watch for ip changes
									setInterval(() => {
										if (app.status == 'shutdown') return false;
										_v = app.system.net.arp?._lastScan?.values?.[self._cfg.server.status.wan.mac];
										if (_v && _v != _serverLocalAddress) {
											console.warn('Server IP address changed from', _serverLocalAddress, 'to', _v);
											self._cfg.server.status.wan.address = '' + _v;
											localUrl = 'https://' + self._cfg.server.status.wan.address + ':9443/' + self._cfg.server.server + '/' + self._cfg.branch.id + '/' + app.system.id + '/';
											self.url = '' + localUrl;
										}
									}, 1000 * 60);
								}
								else {
									//not on same lan but server is accessible through a vlan
									console.log('we are not on same subnet as server')
									await new Promise(async (rsv) => {

										localUrl = 'https://' + self._cfg.server.status.wan.address + ':9443/' + self._cfg.server.server + '/' + self._cfg.branch.id + '/' + app.system.id + '/';
										//check if the server is accessible
										app.system.request.GET(localUrl + 'index.php?ping=1', { timeout: 5000, options: { maxTries: 1, noRetry: 1 } }, (e, r, b) => {
											//console.log(localUrl + '/index.php?ping=1', '"' + b + '"')
											if (b && b.trim() == 'PONG') {
												self.serverIsSameLan = true;

												self.url = '' + localUrl;
											}
											rsv();
										});
									});
								}
							}
						}
					} catch (er) {
						console.warn('unable to check if in same range than server', er)
					}
				}
				resolve();
				if (cbk) cbk();
			});
		}
		exit() {
			self.isRunning = false;
			try { self.win.window.APPFCTS.signOut(); } catch (er) { console.error(er) }
			try {
				app.pos.notifications.exit();
			} catch (er) {
			}
			try {
				self.hideWindow();
			} catch (er) {
			}
			try {
				self.customerDisplay.close();
			} catch (er) {
			}

			try {
				self.window_open_policies.closeWindows();
			} catch (er) {
				console.warn('Error closing opened windows', er.message)
			}
			try {
				if (self?.win?.close) self.win.close();
			} catch (er) {
				console.warn('Error closing pos window', er.message)
			}
		}
		async initialize() {
			if (['restarting', 'updating'].indexOf(app.status) != -1) return;
			if (self.isInitializing) return;
			self.isInitializing = true;
			if (self.isRunning) {
				//console.warn('POS is already running...');
				try {
					self.weightScale.connect();
				} catch (er) {
					console.error('Error connecting to scale', er.message)
				}
				app.splashscreen.win.hide();

				if (self._cfg.device_type == 'workstation') {
					self.production.workstation.start();
				}
				else {
					self.kiosk.autoOpen();
					if (!app.isSDK && app.pathExists(app.data, 'session.configs.window.alwaysOnTop') == '1') self.showWindow();
				}

				return;
			}
			app.web.emit({
				volatile: 1,
				module: 'pos',
				action: 'recordActivity',
				data: {
					id: app.system.uuid.get(),
					action: 'splashscreen',
					date: new Date().toISOString(),
					url: 'Initialize POS'
				},
				eventLoop: app.eventLoopLag._current,
				uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
				cpuInfo: app.system.vars.systemInfo.cpu
			});
			//type == onSite || cloud
			self._cfg = app.data.session.configs;
			if (['restarting', 'updating'].indexOf(app.status) != -1) return;
			await self.db.open();

			app.pos.neighbors.initialize();

			app.web.emit({
				volatile: 1,
				module: 'sessions',
				action: 'startup_sequence',
				data: {
					module: 'pos',
					action: 'get_server_url'
				},
				//eventLoop: app.eventLoopLag._current,
				//uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
				//cpuInfo: app.system.vars.systemInfo.cpu
			});
			self.checkLocalUrl(function () {
				//console.log('LOCAL URL', self.url)
				if (['restarting', 'updating'].indexOf(app.status) != -1) return;
				try {
					app.splashscreen.win.window.setProgress(90);
					app.splashscreen.setMessage('connecting_tpos_server', app.parseLocales('splash.startup_steps.connecting_tpos_server'));
				} catch (er) {

				}

				app.web.emit({
					volatile: 1,
					module: 'sessions',
					action: 'startup_sequence',
					data: {
						module: 'pos',
						action: 'pos_socket_connect'
					},
					//eventLoop: app.eventLoopLag._current,
					//uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
					//cpuInfo: app.system.vars.systemInfo.cpu
				});
				self.serverWS.connect(function () {
					app.web.emit({
						volatile: 1,
						module: 'sessions',
						action: 'startup_sequence',
						data: {
							module: 'pos',
							action: 'pos_socket_connected'
						},
						//eventLoop: app.eventLoopLag._current,
						//uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
						//cpuInfo: app.system.vars.systemInfo.cpu
					});

					if (['restarting', 'updating'].indexOf(app.status) != -1) return;
					app.web.emit({
						volatile: 1,
						module: 'sessions',
						action: 'startup_sequence',
						data: {
							module: 'pos',
							action: 'launch_pos'
						},
						//eventLoop: app.eventLoopLag._current,
						//uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
						//cpuInfo: app.system.vars.systemInfo.cpu
					});
					app.splashscreen.unsetMessage('connecting_tpos_server');
					try {
						app.splashscreen.win.window.setProgress(95);
						app.splashscreen.setMessage('launching_pos', app.parseLocales('splash.startup_steps.launching_pos'));
					} catch (er) {

					}
					try {
						self.security.camera.startWorkers();
					} catch (er) { console.error(er) }

					try {
						self.initializeEFT();
					} catch (er) {
						console.error('Error init EFT', er.message)
					}
					try {
						self.initializeLiquorControl();
					} catch (er) {
						console.error('Error init LC', er.message);
					}
					try {
						self.mev = new (require('../mev/mev'))(self);
					} catch (er) {
						console.error('Error loading MEV', er.message)
					}
					try {
						self.weightScale.connect();
					} catch (er) {
						console.error('Error connecting to scale', er.message)
					}
					if (self.win) {
						self.isInitializing = false;
						//console.log('POS already runnin')
						app.web.emit({
							volatile: 1,
							module: 'sessions',
							action: 'startup_sequence',
							data: {
								module: 'pos',
								action: 'pos_is_running'
							},
							eventLoop: app.eventLoopLag._current,
							uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
							cpuInfo: app.system.vars.systemInfo.cpu
						});
						self.isRunning = true;
						self.win.show();
						if (app.pathExists(app.data, 'session.configs.window.alwaysOnTop') == '1')
							setToTop(true);
						self.kiosk.autoOpen();
						return;
					}

					try {
						self.weather.init();
					} catch (er) {
						console.error('Error loading weather module', er.message)
					}

					//console.log('Opening ' + self.url)
					let _options = {
						icon: 'AzimutPOS.png',
						title: "AzimutPOS",
						show: false,
						position: 'center',
						width: screen.availWidth,
						height: screen.availHeight,
						min_width: screen.availWidth < 1024 ? screen.availWidth : 1024,
						min_height: screen.availHeight < 768 ? screen.availHeight : 768,
						//frame: false,
					};
					if (app.pathExists(app.data, 'session.configs.window.fullScreen') != '1') {
						//_options.frame = true;
						//_options.resizable = true;
					}

					self.doPOSRequest({
						path: 'register_area/ping'
					});
					setInterval(() => {
						self.doPOSRequest({
							path: 'register_area/ping'
						});
					}, 1000 * 60 * 3)
					nw.Window.open(self.url + 'index.php/home/logout', _options, function (win) {
						//console.log('POS Window opened', win)
						//console.logRaw(win)
						//try {
						self.isRunning = true;
						for (let i of app.data.session.configs.kds ?? []) {
							self.kds.connect(i);
						}
						self.win = win;
						let _winObj = win.window;
						//setInterval(function () {
						//	if (app.isSDK && !self.win.fullScreenOverride && app.pathExists(app.data, 'session.configs.window.fullScreen') != '1') {
						//		self.setToTop(false);
						//	}
						//}, 1000);

						try {
							chrome.privacy.services.passwordSavingEnabled.get({}, function (details) {
								if (details.levelOfControl === 'controllable_by_this_extension') {
									chrome.privacy.services.passwordSavingEnabled.set({ value: false }, function () { });
								}
							});
						} catch (er) { }
						var _firstLoadDone = false, _firstLoad = function () {
							if (_firstLoadDone) return;
							_firstLoadDone = true;
							if (self._cfg.device_type == 'workstation') {
								self.production.workstation.start();
							}
							else if (self._cfg.device_type == 'accessControl') {
								self.security.accessControl.start();
							}
							else {
								//try {
								//	win.enterKioskMode();
								//} catch (er) { }
								self.setToTop(true);

								app.tryCatch(function () {
									self.kiosk.autoOpen();
								});

								self.setWindowStatus('open');
								win.hasFocus = true;
								self.sendFocusInfo();
								app.web.emit({
									volatile: 1,
									module: 'sessions',
									action: 'startup_sequence',
									data: {
										module: 'pos',
										action: 'pos_up_and_running'
									},
									eventLoop: app.eventLoopLag._current,
									uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
									cpuInfo: app.system.vars.systemInfo.cpu
								});
								try {
									app.splashscreen.win.close();
								} catch (er) { }
							}

							try {
								self.onReady();
							} catch (er) {
								console.error('Error with self.onReady();', er)
							}
							// Locale
							let locale = win.window.document.querySelector("html").className;
							localStorage.setItem("locale", locale);
						}

						let _previousActivity = null, _lastActivitySendTimer = null,
							_sendActivityUpdate = function (d) {
								if (d)
									app.web.emit({
										module: 'pos',
										action: 'updateActivity',
										data: {
											id: d.id,
											update_date: d.update_date,
											time_on_page: d.time_on_page,
											ended: d.ended || 0,
											locked: d.locked
										},
										eventLoop: app.eventLoopLag._current,
										uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
										cpuInfo: app.system.vars.systemInfo.cpu
									});
							};
						let _checkForFocus = function () {
							if (app.status == 'shutdown') return false;
							setTimeout(function () {
								if (_winObj.selectPrinterWindow) {
									//select printer window is running
									return;
								}

								if (self._cfg.device_type == 'workstation') {
									return false;
								}
								if (self._cfg.device_type == 'accessControl') {
									return false;
								}
								if (app.pathExists(self, 'kiosk.win.hasFocus')) {
									//console.log('kiosk has the focus, do not focus POS');
									return;
								}
								if (app.pathExists(app.data, 'session.configs.window.alwaysOnTop') == '1') {
									if (app.pos.notifications.hasActive()) return false;
									if (app.pathExists(self, 'kiosk.isRunning')) {
										//console.log('kiosk is running, do not focus POS');
										try {
											self.kiosk.win.show();
										} catch (er) { }
										try {
											self.kiosk.win.focus();
										} catch (er) { }
										return;
									}
									win.setAlwaysOnTop(true);
									win.focus();
								}
								//if (app.pathExists(app.data.session, 'configs.kioskMode.prevent_close') == '1')
							}, 200);
						};
						let _registerWindowFunctions = function () {
							app.tryCatch(function () { self.weather.bind(_winObj); });
							_winObj.getRegisterConfig = function (cback) {
								app.data.session.configs.hardware = {
									screens: app.utilities.screens
								};
								cback(app._m.xtend.clone(app.data.session.configs));
								try { app.pos.neighbors.updateGUI(); } catch (er) { }
								try { app.pos.weightScale.getData(); } catch (er) { }
								if (!_winObj.APPFCTS.db) {
									_winObj.uuid = app.system.uuid;
									_winObj.APPFCTS.db = self.db;
								}
							};
							_winObj.updateRegisterConfig = function (data, cback) {
								app.sessions.updateCfg(app._m.xtend.clone(data), cback);
							};
							_winObj.getRegisterStatus = function (cback) {
								cback({
									version: app.cfg.version,
									cloud: { status: app.web.status, node: app.web?.socket?.master },
									server: { status: self.serverWS.status },
									kds: self.kds.getStatus(),
									printers: app.printManager.getPrinters({})
								});
							};
							_winObj.fullScreen = function (_set) {
								if (_set) win.enterFullscreen();
								else win.leaveFullscreen();
							};
							_winObj.recordActivity = function (d) {
								try {
									clearTimeout(newPageLoadedTimer);
								} catch (er) { }
								if (!d.id) d.id = app.system.uuid.get();
								d.date = new Date().toISOString();
								if (self._lastActivity && d.id != self._lastActivity.id && self._lastActivity.id) {
									//there's a new page, seal the cap on previous activity
									_previousActivity = app._m.xtend.clone(self._lastActivity);
									_previousActivity.update_date = new Date().toISOString();
									_previousActivity.time_on_page = (new Date(_previousActivity.update_date).getTime() - new Date(_previousActivity.date).getTime()) / 1000;
									_previousActivity.ended = 1;
									_sendActivityUpdate(_previousActivity);
								}
								self._lastActivity = d;
								self.lastActivity = d;
								app.web.emit({
									module: 'pos',
									action: 'recordActivity',
									data: d,
									eventLoop: app.eventLoopLag._current,
									uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
									cpuInfo: app.system.vars.systemInfo.cpu
								});
								return d.id;
							};
							_winObj.updateActivity = function (d) {
								self._lastActivity.update_date = new Date().toISOString();
								self._lastActivity.time_on_page = (new Date(self._lastActivity.update_date).getTime() - new Date(self._lastActivity.date).getTime()) / 1000;
								if (d.ended) {
									self._lastActivity.ended = 1;
									clearTimeout(_lastActivitySendTimer);
									_sendActivityUpdate(self._lastActivity);
									self._lastActivity = null;
									_lastActivitySendTimer = null;
								}
								let _wasLocked = app.pathExists(self._lastActivity, 'locked.session') || app.pathExists(self._lastActivity, 'locked.register');
								if (app.pathExists(d, 'locked.session') || app.pathExists(d, 'locked.register') || _wasLocked) {
									clearTimeout(_lastActivitySendTimer);
									if (d.locked) self._lastActivity.locked = d.locked;
									_sendActivityUpdate(self._lastActivity);
									return;
								}
								if (_lastActivitySendTimer) return;
								//send max 1 update per 30 seconds
								_lastActivitySendTimer = setTimeout(function () {
									_sendActivityUpdate(self._lastActivity);
									_lastActivitySendTimer = null;
								}, 1000 * 30);
							};
							_winObj.employee_logged_in = function (data) {
								//data.method, data.employee, data.result

								data.date = new Date().toISOString();
								data.id = app.system.uuid.get();
								self.serverWS.emit({
									module: 'POS',
									action: 'employeeLogin',
									data: data
								}, function () {

								});
								self.security.camera.capture('login', function (_data) {
									//per feed
									if (_data) {
										self.serverWS.emit({
											module: 'POS',
											action: 'camera_images_by_action',
											data: {
												id: data.id,
												feed: _data.feed,
												type: 'login',
												images: _data.images
											}
										}, function () {
											console.log('camera_images_by_action feed ' + _data.feed + ' cbacked')
										});
									}
								})
							}
							_winObj.smartcard_set_type = function (d) {
								self.security.smartcards.setCardType(d.id, d.type)
							}
							_winObj.onExit = function () {
								console.log('POS EXIT')
								self.isRunning = false;
								self.setWindowStatus('closed');
								win.hide();
								if (!self.keepRunningOnClose)
									self.app.exit(0);
							};
							_winObj.coreFunction = function (d, cback) {
								app.web.emit({
									module: 'core',
									action: d.action || 'event',
									datas: d.datas
								}, function (res) {
									cback(res);
								});
							};
							_winObj.callModule = function (module, data, cback) {
								//console.log('callModule', module, data)
								let _mod = app.pathExists(app, module + '.routeGUIaction')
								if (_mod) {
									_mod(data, cback);
									return;
								}
								console.log('callModule unknown', module, data)
								if (cback) cback({ result: 'error', error: 'module_unavailable' })
							};

							_winObj.printContent = function () {
								app.tryCatch(function () {
									var printer = app.printManager.getDefaultPrinter('receipt');
									win.window.print({
										"autoprint": true,
										"marginsType": 1,
										"headerFooterEnabled": false,
										"printer": printer.deviceUri
									});
								});
							};
							_winObj.getAvailablePrinters = function () {
								let
									printers = app.printManager.getPrinters({}).filter((a) => !a.deleted),
									printersList = {},
									registers = app.pos._cfg.registers;
								for (let p of printers)
									if (registers[p.register]) {
										if (!printersList[p.register])
											printersList[p.register] = [];
										printersList[p.register].push({
											id: p.id,
											name: app.pathExists(p, 'peripheralInfo.printerName') || p.name,
											is_mev: p.configs?.is_mev,
											pageSize: p.configs?.pageSize,
											type: p.configs?.printerType,
											data: p
										});
									} else if (p.register == 'NETWORK') {
										if (!printersList.NETWORK)
											printersList.NETWORK = [];
										printersList.NETWORK.push({
											id: p.id,
											name: app.pathExists(p, 'peripheralInfo.printerName') || p.name,
											is_mev: p.configs?.is_mev,
											pageSize: p.configs?.pageSize,
											type: p.configs?.printerType,
											data: p
										});
									}
								return printersList;
							}

							app.tryCatch(function () {
								_winObj.getDefaultSaleFormat = function () {
									return self.getDefaultSaleFormat();
								};
							});

							app.tryCatch(function () {
								_winObj.getDefaultPrinter = function (printer) {
									return app.pathExists(app, 'data.session.configs.printer.' + printer) || 'none';
								};
							});

							app.tryCatch(function () {
								_winObj.showKioskWindow = function () {
									self.kiosk.initialize();
								};
							});
							app.tryCatch(function () {
								_winObj.registerAccessCard = function (d, cback) {
									//console.log('registerAccessCard', d, typeof cback)
									app.web.emit({
										module: 'pos',
										action: 'registerAccessCard',
										data: d
									}, cback);
								};
							});
							app.tryCatch(function () {
								_winObj.openDrawer = function (x, cback) {
									if (typeof x == 'number') x = { drawer: 1 * x };
									self.openDrawer(x, cback);
								};
							});
							_winObj.selectPrinterWindow = null;
							_winObj.select_printer = function () {
								app.tryCatch(function () {
									nw.Window.open(app._relativePath + "libs/printManager/managePrinterDialog/managePrinterDialog.html", {
										width: 770,
									}, function (win_printers) {
										_winObj.selectPrinterWindow = win_printers;
										win_printers.on('close', function () {
											win_printers.hide();
											self.setToTop(true);
										})
										win_printers.on('loaded', function () {
											self.setToTop(false);
											win_printers.setAlwaysOnTop(true);
											win_printers.focus();
											var $ = win_printers.window.jQuery;
											let printers = self.app.printManager.getPrinters({});
											var printersList = {};
											var override = $.extend({
												receipt: {
													mev: ''
												}
											}, app.pathExists(app.pos._cfg, 'printers_override') || {});

											var registers = app.pos._cfg.registers;
											for (let p = 0, pL = printers.length; p < pL; p++)
												if (registers[printers[p].register]) {
													if (!printersList[printers[p].register])
														printersList[printers[p].register] = [];
													printersList[printers[p].register].push({
														id: printers[p].id,
														name: app.pathExists(printers[p], 'peripheralInfo.printerName') || printers[p].name,
														is_mev: printers[p].configs && printers[p].configs.is_mev
													});
												} else if (printers[p].register == 'NETWORK') {
													if (!printersList.NETWORK)
														printersList.NETWORK = [];
													printersList.NETWORK.push({
														id: printers[p].id,
														name: app.pathExists(printers[p], 'peripheralInfo.printerName') || printers[p].name,
														is_mev: printers[p].configs && printers[p].configs.is_mev
													});
												}
											var np = false;
											for (let p in printersList) {
												var group = $('<optgroup class="localized">');
												if (p == app.system.id)
													group.attr('data-locale', 'printer_manager.printer_locale');
												else if (p == 'NETWORK')
													group.attr('data-locale', 'printer_manager.printer_network');
												else
													group.attr('data-locale', 'printer_manager.printer_on').attr('data-replace-1', registers[p].name);

												for (let i = 0, iL = printersList[p].length; i < iL; i++) {
													var text = printersList[p][i].name || app.pathExists(printersList[p][i], 'peripheralInfo.printerName'),
														append = [];
													if (printersList[p][i] && parseInt(printersList[p][i].is_mev ?? 0))
														append.push('MEV');
													if (append.length)
														text += ' (' + append.join(', ') + ')';
													var option = $('<option>').attr('value', printersList[p][i].id).attr('data-mev', parseInt(printersList[p][i].is_mev ?? 0) == 1 ? 'yes' : 'no').html(text);
													//if (printersList[p][i].selected)
													//	option.attr('selected', 'selected');
													group.append(option);
												}
												if (p == 'NETWORK')
													np = group;
												else
													$('.selectPrinter')[(p == app.system.id ? 'prepend' : 'append')](group);
											}
											if (np)
												$('.selectPrinter').append(np);

											$('.selectPrinter').prepend('<option value="" disabled selected class="localized" data-locale="printer_manager.select">');
											$('.receiptIsMev').val(override?.receipt?.mev || '')
											// Set the locales
											let elems = $('.localized,[data-locale]');

											elems.each(function () {
												var locale = self.app.parseLocales($(this).attr('data-locale'));
												if ($(this).attr('data-replace-1'))
													locale = locale.replace('%1', $(this).attr('data-replace-1'));
												switch ($(this).prop('tagName').toLowerCase()) {
													case 'optgroup':
														$(this).attr('label', locale);
														break;
													default:
														$(this).html(locale);
												}
											});

											$('.receiptIsMev').on('change', function () {
												console.log('Receipt is mev changed')
												if (!app.pathExists(app.pos._cfg, 'printers_override'))
													app.pos._cfg.printers_override = {};
												if (!app.pathExists(app.pos._cfg, 'printers_override.receipt'))
													app.pos._cfg.printers_override.receipt = {};
												app.pos._cfg.printers_override.receipt.mev = $(this).val();
												app.sessions.updateCfg({ printers_override: { receipt: { mev: $(this).val() } } });
											});
											$('.selectPrinter').on('change', function () {
												let t = $(this).attr('data-printer')
												if (t == 'receipt') {
													var locale = 'common.' + $('option:selected').attr('data-mev');
													$('.receiptIsMev .defaultOption').append(self.app.parseLocales(locale));
												}
												if (!app.pathExists(app.pos._cfg, 'printer'))
													app.pos._cfg.printer = {};
												app.pos._cfg.printer[t] = $(this).val();
												var out = {};
												out[t] = $(this).val();
												app.sessions.updateCfg({ printer: out });
											});
											$('.selectPrinter').each(function () {
												let i = $(this).attr('data-printer')
												if (app.pathExists(app.pos._cfg, 'printer.' + i)) {
													$('.selectPrinter[data-printer="' + i + '"]').val(app.pos._cfg.printer[i]);
													if (i == 'receipt') {
														var locale = 'common.' + $('option:selected').attr('data-mev');
														$('.receiptIsMev .defaultOption').append(' ' + self.app.parseLocales(locale));
													}
												}
											})
										});
									});
								}, console.log);
							};
							_winObj.printPDF = function (data, cback) {

								//let _drawerInfo = {
								//	drawer: _argv.openDrawer || (content.open_drawer ? 'default' : null),
								//	sale_id: _argv.sale_id,
								//	action: 'sale'
								//},
								//	data = {
								//		printer: app.pathExists(printer, 'id') || null,
								//		configs: _argv.configs,
								//		data: content.data,
								//		type: app.pathExists(printer, 'configs.genericText') == '1' ? 'raw' : 'pdf',
								//		openDrawer: _drawerInfo.drawer ? _drawerInfo : false
								//	};
								//if (app.pathExists(printer, 'configs.is_mev') == 1) {
								//	data.type = 'mev';
								//	data.formatted = true;
								//}
								//else if (app.pathExists(printer, 'configs.genericText') == '1') {
								//	//send cut
								//	data.cut = true;
								//}
								//if (app.isSDK) {
								//	console.info('PRINTING DATA', data)
								//}
								app.printManager.print(data, cback);
							}
							_winObj.printCustom = function (opts, cback) {
							};
							_winObj.printUrl = function (url, cback) {
								console.info('PRINT URL', url.split('/index.php')[1])
								app.printManager.printUrl(url).then(cback);
								return;
							};
							_winObj.saveToFile = (vars, cback) => {
								let _fPath = app._m.path.resolve(vars.file.replace(/^\~/, app.homeDir));
								console.info('saveToFile', _fPath)
								app._m.fs.writeFile(_fPath, Buffer.from(vars.data, 'base64'), function (e) {
									cback({ result: e ? 'error' : 'success', error: e, path: _fPath });
								});
							}
							_winObj.manage_eft = function () {
								if (app.data?.session?.configs?.eft_device?.enabled != '0')
									self.eft.manage();
							};
							_winObj.manage_liquor_control = function () {
								self.liquorControl.manage();
							};
							_winObj.getEFTStatus = function () {
								if (app.data?.session?.configs?.eft_device?.enabled != '0')
									_winObj.updateEFTNotification(self.eft?.pingStatus?.current || 'disabled');
								else _winObj.updateEFTNotification('disabled');
							};
							_winObj.eft = {
								fireFeature: (feature, handler) => {
									self.eft?.[feature]?.(handler);
								},
								getFeatures: self.eft?.features
							};

							_winObj.isCCProcessingEnabled = function () {
								if (app.data?.session?.configs?.eft_device?.enabled == '0') return false;
								var proc = app.pathExists(self.eft, 'cfg.comm.provider');
								return proc && proc != 'NONE';
							};
							_winObj.closeTerminalBatch = function (vars, cback) {
								self.eft.startOperation({ 'transType': 'BatchClose' }, cback);
							}

							_winObj.startCCProcessing = function (vars, cback) {
								if (app.data?.session?.configs?.eft_device?.enabled == '0') {
									cback(out);
									return false;
								}
								self.eft.startOperation(vars, function (data) {
									if (data.status == 'readyPrint') {
										//PRINTING
										var receipt = {};

										//TEMP printing error bypass //SHOULD NOTIFY PRINTING COPMPLETE
										self.eft.send({ transType: 'PingClose' });
									} else {
										var out = {};
										if (data && data.fields) {
											if (data.formatted) {
												out = data.fields
											} else {
												for (let f = 0, fL = data.fields.length; f < fL; f++)
													switch (data.fields[f].key) {
														case 'CustAccNbr':
															out.last4 = data.fields[f].value.substr(12);
															break;
														case 'TransStatus':
														case 'CustCardEntry':
														case 'CustCardType':
															out[data.fields[f].key] = data.fields[f].valueText;
															break;
														case 'Auth':
														case 'Reference':
														case 'EMVAID':
														case 'EMVTVR':
														case 'EMVTSI':
														case 'CVMResult':
														case 'transType':
														case 'EMVAppLabel':
														case 'TotalAmount':
														case 'DisplayText':
															out[data.fields[f].key] = data.fields[f].value;
															break;
														case 'TransAmount':
															out.TotalAmount = data.fields[f].value;
															break;
														case 'TipAmount':
															out.TipAmount = data.fields[f].value;
															break;
														case 'CustomerReceipt':
														case 'MerchantReceipt':
															let lines = data.fields[f].value;
															if (1 * localStorage.getItem("default_printer_is_mev")) {
																let receipt = '';
																for (let l = 0, lL = lines.length; l < lL; l++) {
																	let format = lines[l][0].key == 'TextFormat' ? lines[l][0].valueText : lines[l][1].valueText;
																	let text = lines[l][0].key == 'TextLine' ? lines[l][0].value : lines[l][1].value;
																	if (text.length) {
																		switch (format) {
																			case 'normal':
																			default:
																				receipt += '\x1b\x21\x00\x1d\x42\x00';
																				break;
																			case 'doubleHeight':
																				receipt += '\x1b\x21\x10';
																				break;
																			case 'reversed':
																				receipt += '\x1d\x42\x01';
																				break;
																			case 'doubleHeight|reversed':
																				receipt += '\x1b\x21\x10\x1d\x42\x01';
																				break;
																		}
																		receipt += text + '\n';
																	} else
																		receipt += '\n';
																}
																self.mev.print(self.mev.other(receipt + '\n\n\n\x1b\x6d'));
															} else {
																let receipt = '<style>.doubleHeight{transform:scaleY(2);-webkit-transform:scaleY(2);-moz-transform:scaleY(2);}.reversed{color:white;background-color:black;}p{text-align:center;width:100%;}</style>';
																for (let l = 0, lL = lines.length; l < lL; l++) {
																	let format = lines[l][0].key == 'TextFormat' ? lines[l][0].valueText : lines[l][1].valueText;
																	let text = lines[l][0].key == 'TextLine' ? lines[l][0].value : lines[l][1].value;
																	if (text.length) {
																		switch (format) {
																			case 'normal':
																			default:
																				receipt += '<p>';
																				break;
																			case 'doubleHeight':
																				receipt += '<p class="doubleHeight">';
																				break;
																			case 'reversed':
																				receipt += '<p class="reversed">';
																				break;
																			case 'doubleHeight|reversed':
																				receipt += '<p class="doubleHeight reversed">';
																				break;
																		}
																		receipt += text + '</p>';
																	} else
																		receipt += '<br />';
																}
																nw.Window.open('libs/printManager/printWindow/printWindow.html', {
																	title: "EFTPrinting",
																	show: false
																}, function (win1) {
																	win1.on('loaded', function () {
																		win1.window.setContent(receipt, function () {
																			win1.window.print({
																				"autoprint": true,
																				"marginsType": 1,
																				"headerFooterEnabled": false,
																				"printer": localStorage.getItem("default_printer")
																			});
																			win1.close();
																		});
																	});
																});
															}
															break;
														case 'Warnings':
															//console.log(data.fields[f].value);
															break;
													}
											}
										}
										if (app.pathExists(self.eft, 'cfg.comm.provider') == 'GLOBAL' && out.TotalAmount && out.TipAmount)
											out.TotalAmount -= out.TipAmount;
										if (!out.TransStatus)
											out.TransStatus = data.status;
										cback(out);
									}
								});
							};
							_winObj.earlyProcessOrder = function (sale, cback, tags) {
								self.doProcessOrder(sale, tags).then(cback);
							};
							_winObj.processOrder = function (sale_id, cback, tags, skipCloud) {

								if (skipCloud) {
									self.processOrders(sale_id, function (data) {
										if (typeof cback == 'function')
											cback(data);
									}, tags);
								} else {
									self.serverWS.emit({
										module: 'kitchenPrint',
										action: 'printNow',
										data: {
											sale_id: sale_id
										}
									}, function (res) {
										if (cback) cback(res);
										console.log('kitchenPrint.printNow result:', res)
									});
								}
							};

							_winObj.getAgendomBundlePeriod = function (d, cback) {
								app.web.emit({
									module: 'oloWidget',
									action: 'getAgendomBundlePeriod',
									datas: d
								}, cback);
							};

							_winObj.getDeliveryFees = function (d, cback) {
								app.web.emit({
									module: 'oloWidget',
									action: 'getAgendomBundlePeriod',
									datas: d
								}, cback);
							};
							try {
								self.win.window.APPFCTS.accessCard.isSmartCardAuthenticated = self.security.smartcards.isSmartCardAuthenticated();
							} catch (er) { }
						}
						//function is called on each page load
						win.on('loaded', function () {
							win.isLoaded = true;
							_registerWindowFunctions();
							_firstLoad();

						});

						win.on('new-win-policy', self.window_open_policies.validate);
						let newPageLoadedTimer = null;
						win.on('navigation', function (n, u, p) {
							p = u.split('index.php').pop();
							console.info('navigation', p)
							if (self.window_navigate_policies(n, u, p)) {
								_registerWindowFunctions();
								//u is url
								p = u.split('index.php').pop();
								newPageLoadedTimer = setTimeout(function () {
									console.info(p, 'show "page loading..."');
									try {
										_winObj.showLoadingOverlay();
									} catch (er) { }
								}, 1000 * 5);
							}
						});
						win.on('minimize', function () {
							win.hasFocus = false;
							console.info('POS is minimized');
							_checkForFocus();
							self.sendFocusInfo();
						});
						win.on('focus', function () {
							win.hasFocus = true;
							console.info('POS is focussed');
							self.sendFocusInfo();
						});
						win.on('blur', function () {
							win.hasFocus = false;
							console.info('POS is blured');
							_checkForFocus();
							self.sendFocusInfo();
						});
						win.on('close', function () {
							//self.app.exit(0);
							self.isRunning = false;
							win.hide();
							//try{ //called in exit
							//	self.win.window.APPFCTS.signOut();
							//} catch(er){}
							self.setWindowStatus('closed');
							self.kiosk.close();
							if (!self.keepRunningOnClose)
								self.app.exit(0);
						});
						self.security.smartcards.onCardInserted((card) => {
							//console.log('smart card inserted', card);
							self.win.window.APPFCTS.accessCard.cardInserted(card);
							self.security.smartcards.onCardRemoved(card.card, (c) => {
								//console.log('smart card removed', c)
								self.win.window.APPFCTS.accessCard.cardRemoved(c);
							})
						})
						//}
						//catch (er) {
						//	console.error('POS window events error', er)
						//}
					});

				});
			});
		}
		getEnabledDrawers(vars) {
			let _c = app.data.session.configs;
			if (app.pathExists(_c, 'cashDrawers.drawers') && !app.isEmptyObject(_c.cashDrawers.drawers)) {

				let _ids = Object.keys(_c.cashDrawers.drawers).filter(function (a) {
					return app.pathExists(_c, 'cashDrawers.drawers.' + a + '.enabled') == '1';
				})
				let out = [];
				for (let i = 0; i < _ids.length; i++) {
					for (let x = 0; x < _c.location.configs.cashDrawers.drawers.length; x++) {
						if (_c.location.configs.cashDrawers.drawers[x].id == _ids[i])
							out.push(_c.location.configs.cashDrawers.drawers[x]);
					}
				}
				if (vars && vars.id) {
					try {
						return out.filter(function (a) { return a.id == vars.id; })[0];
					} catch (er) {
						console.error('getEnabledDrawers', er.message);
						return null;
					}
				}
				return out;
			}
			return null;
		}
		openDrawer(vars, cback) {
			if (!vars || typeof vars == 'number' || typeof vars == 'string') vars = { drawer: (vars || 0) };
			if (!vars.drawer) vars.drawer = 'default';
			if (!vars.drawer) {
				if (cback) cback({ result: 'error', code: 'no_drawer_selected' });
				return false;
			}
			let _default = self.getEnabledDrawers();
			if (vars.drawer == 'default') {
				if (_default && _default.length) {
					vars.drawer = _default[0] || null;
				}
			}
			else if (typeof vars.drawer == 'number') {
				if (_default && _default.length) {
					vars.drawer = _default[vars.drawer] || _default[0] || null;
				}
			}
			else if (typeof vars.drawer == 'string') {
				let _d = self.getEnabledDrawers({ id: vars.drawer });
				if (_d) {
					vars.drawer = _d;
				}
				else if (_default && _default.length) {
					vars.drawer = _default[vars.drawer] || _default[0] || null;
				}
			}
			if (!vars.drawer) {
				if (cback) cback({ result: 'error', code: 'no_drawer_selected' });
				return false;
			}
			let _opDate = new Date().toISOString(),
				oddata = {
					id: app.system.uuid.get(),
					date: _opDate,
					action: vars.action || '',
					drawer: app.pathExists(vars, 'drawer.id'),
					sale_id: vars.sale_id || '',
					employee: self.lastActivity.employee_id,
					activity: self.lastActivity.id,
				};


			//send data to server, drawer has been opened
			//console.log('Sending', oddata)
			self.serverWS.emit({
				module: 'POS',
				action: 'drawerOpened',
				data: oddata
			}, function () {

			});
			self.security.camera.capture('drawer', function (_data) {
				//per feed
				if (_data) {
					self.serverWS.emit({
						module: 'POS',
						action: 'camera_images_by_action',
						data: {
							id: oddata.id,
							feed: _data.feed,
							type: 'drawer',
							images: _data.images
						}
					}, function () {

					});
				}
			})
			//get printer, get drawer from id
			//app.data.session.configs.cashDrawers.drawers[id].enabled=='1'

			var printer = app.pathExists(vars, 'drawer.device') ? app.printManager.getPrinter(vars.drawer.device) : app.printManager.getDefaultPrinter('receipt');
			if (!printer) {
				console.error('FATAL ERROR, CANNOT OPEN DRAWER. PLEASE CONFIGURE DEFAULT RECEIPT PRINTER FIRST.');
				if (cback) cback({ result: 'error' });
				return;
			}
			var _drawerCode = (app.pathExists(vars, 'drawer.drawer') || '1'), pdata = {
				type: 'mev',
				formatted: true,
				data: app.printManager.getPrinterCode(printer, 'drawer' + _drawerCode) || "\x1b\x70\x30\x37\x79",
				printer: printer.id
			};
			if (app.cfg.env == 'dev' || app.pathExists(app.data.session, 'configs.cashDrawers.debug.enabled')) {
				console.log('Cash drawer "' + _drawerCode + '" open', printer)
			}
			app.printManager.print(pdata, function (res) {
				if (cback) cback({ result: 'success', res: res });
			});
		}

		secureTokenChanged() {

			self.kiosk.secureTokenChanged();
		}
		initializeEFT() {

			if (self?.eft && typeof (self?.eft) == 'object') {
				self.eft.destroy();
				self.eft = null;
			}
			if (app.pathExists(app.data, 'session.configs.eft_device.enabled') == '0') return false;
			var provider = app.pathExists(app.data, 'session.configs.eft_device.provider') || 'NONE';
			var model = app.pathExists(app.data, 'session.configs.eft_device.model') || 'NONE';
			switch (provider) {
				case 'CHASE':
					self.eft = new (require('../eftPayment/providers/chase'))(app.pathExists(app.data, 'session.configs.eft_device') || {}, self);
					break;
				case 'GLOBAL':
					switch (model) {
						case 'DESK5000':
							self.eft = new (require('../eftPayment/providers/global'))(app.pathExists(app.data, 'session.configs.eft_device') || {}, self);
							break;
						case 'VERIFONE':
							self.eft = new (require('../eftPayment/providers/globalJson'))(app.pathExists(app.data, 'session.configs.eft_device') || {}, self);
							break;
					}
					break;
				case 'DESJARDINS':
					self.eft = new (require('../eftPayment/providers/desjardins'))(app.pathExists(app.data, 'session.configs.eft_device') || {}, self);
					break;
				case 'NONE':
					self.eft = new (require('../eftPayment/eftPayment'))({}, self);
					break;
			}
		}

		initializeLiquorControl() {
			if (typeof (self.liquorControl) == 'object') {
				self.liquorControl.destroy();
				self.liquorControl = null;
			}
			var provider = app.pathExists(app.data, 'session.configs.liquor_control_device.provider') || 'NONE';
			switch (provider) {
				case 'AZ200':
					self.liquorControl = new (require('../liquorControl/controllers/az200/az200'))(app.pathExists(app.data, 'session.configs.liquor_control_device') || {}, self);
					break;
				case 'CTRLPLUS':
					//self.liquorControl = new (require('../liquorControl/liquorControl'))(app.pathExists(app.data, 'session.configs.liquor_control_device') || {}, self);
					self.liquorControl = new (require('../liquorControl/controllers/controlPlus/controlPlus'))(app.pathExists(app.data, 'session.configs.liquor_control_device') || {}, self);
					break;
				case 'NONE':
					self.liquorControl = new (require('../liquorControl/liquorControl'))({}, self);
					break;
			}
		}
		setToTop(yn) {
			//console.log('setToTop', yn)
			if (yn) {

				if (['restarting', 'updating'].indexOf(app.status) != -1) return;
				self.isOnTop = true;

				try { self.win.focus(); } catch (e) { }
				if (app.pathExists(app.data, 'session.configs.window.alwaysOnTop') == '1') {

					//try { self.win.enterKioskMode(); } catch (er) { }
					//try { self.win.enterFullscreen(); } catch (er) {
					//	console.error('Unable to enter fullscreen', er.message)
					//}
					self.win.setAlwaysOnTop(true);
				}
				if (app.pathExists(app.data, 'session.configs.window.fullScreen') == '1') {
					//console.log('SET TOP FULLSCREEN')
					setTimeout(function () {
						try { self.win.enterFullscreen(); } catch (er) {
							console.error('Unable to enterFullscreen', er.message)
						}
						try { self.win.enterKioskMode(); } catch (er) {
							console.error('Unable to enterKioskMode', er.message)
						}
					}, 500);
				}
			}
			else {
				self.isOnTop = false;
				//console.log('SET TOP FALSE')
				try { self.win.leaveKioskMode(); } catch (er) { }
				try { self.win.leaveFullscreen(); } catch (er) { }
				try { self.win.setAlwaysOnTop(false); } catch (er) { }
			}

		}
		sendFocusInfo() {
			app.web.emit({
				module: 'pos',
				action: 'windowHasFocus',
				data: self.win.hasFocus
			});
		}
		setWindowStatus(status) {
			if (self.windowState == status) return;
			self.windowState = '' + status;
			app.web.emit({
				module: 'pos',
				action: 'windowStatus',
				data: status
			});
		}
		showWindow() {

			if (['restarting', 'updating'].indexOf(app.status) != -1) return;
			if (!app.pathExists(self, 'kiosk.win.hasFocus')) {
				self.win.show();
				self.win.focus();
			}
			self.setWindowStatus('open');
		}
		unsetWindow() {
			try { self.hideWindow(); } catch (er) { }
			try { if (self.win) self.win.hide(); } catch (er) { }
			//delete window
			self.keepRunningOnClose = true;
			self.win.close();
			setTimeout(function () {
				self.keepRunningOnClose = false;
			}, 1000);
		}
		hideWindow() {
			if (self.win) {
				self.win.hide();
				self.setWindowStatus('close');
			}
		}
		routeEvent(d, cback) {
			//cloud events
			switch (d.action) {
				case 'setAlwaysOnTop':
					setToTop(d.data == '1' ? true : false);
					break;
				case 'screenShot':
					console.log('Doing screenshot', d.data)
					if (self.isRunning) {
						self.win.capturePage(function (image) {
							console.log('captured screenshot', image)
							// do something with the base64string
							//sendToServer
							d.data.image = image;
							if (cback) cback(image);
							else
								app.web.emit({
									module: 'pos',
									action: 'screenShot',
									data: d.data
								});
						}, { format: 'jpeg', datatype: 'datauri' });
					}
					break;
				case 'showWindow':
					self.showWindow();
					break;
				case 'hideWindow':
					self.hideWindow();
					break;
				case 'minimize':

					break;
				case 'message':
					self.win.window.APPFCTS.system.routePOSEvent(d.data);
					break;
				case 'showQRCode':
					self.showQRCode(d.data);
					break;
				case 'notification':
					self.notifications.show(d.data);
					break;
				case 'event':

					try {
						let _data = app._m.xtend.clone(d.data);
						delete d.data;
						d = app._m.xtend.extend(d, _data);
						self[d.module].routeEvent(d, cback);
					} catch (e) {
						console.warn('ERROR module POS.event in app: ' + e.message);
					}
					break;
				default:
					console.warn('Unrouted event:', d.action)
			}
		}
		showQRCode(d) {
			let _options = {
				icon: 'AzimutPOS.png',
				title: "AzimutPOS",
				show: true,
				position: 'center',
				width: 300,
				height: 300,
				frame: true,
			};
			nw.Window.open((app._relativePath || (__dirname.indexOf('/source/') != -1 ? 'source/' : '') || '') + 'libs/pos/qrCode/qrCode.html', _options, function (win) {
				win.setShowInTaskbar(false);
				win.on('loaded', function () {
					win.moveTo(screen.availWidth - win.width - 20, screen.height - win.height - 90);
					win.setAlwaysOnTop(true);
					win.show();
					win.focus();
					win.window.showQR(d);
					setTimeout(() => {
						win.close();
					}, 1000 * (d.time || 30))
				});
				win.on('close', function () {
					win.hide();
				})
			});
		}
		getDefaultSaleFormat() {
			return app.pathExists(app, 'data.session.configs.printer.defaultSaleFormat') || 'receipt';
		}
		routeTPOSEvent(d) {
			switch (d.action) {
				case 'processOrders':
					self.processOrders(d.data.orders, function (data) {
						if (typeof d.cback == 'function')
							d.cback(data);
					});
					break;
				case 'partialConfigUpdate':

					app.data.session.configs = app._m.xtend.extend(app.data.session.configs, d.data);
					try {
						app.pos.win.window.APPFCTS.system.routePOSEvent({ module: 'system', action: 'setRegisterConfig', data: app._m.xtend.clone(app.data.session.configs) });
					} catch (er) { }
					app.localConfig.set();
					break;
				case 'event':

					try {
						let _data = app._m.xtend.clone(d.data);
						delete d.data;
						d = app._m.xtend.extend(d, _data);
						self[d.module].routeTPOSEvent(d);
					} catch (e) {
						console.warn('ERROR module POS.event in app: ' + e.message);
					}
					break;
				default:
					console.log('unrouted event', d.action)
			}
		}
		routePHPServerEvent(d) {
			//console.log('routePHPServerEvent', d)
			switch (d.action) {
				case 'printPDF':
					if (!d.data.type) d.data.type = 'pdf';
					app.printManager.print(d.data, d.cback);
					break;
				case 'printUrl':
					app.printManager.printUrl(d.data).then(d.cback);
					break;
				case 'saveToFile':

					let _fPath = app._m.path.resolve(d.data.file.replace(/^\~/, app.homeDir));
					console.info('saveToFile', _fPath)
					app._m.fs.writeFile(_fPath, Buffer.from(d.data.data, 'base64'), function (e) {
						d.cback({ result: e ? 'error' : 'success', error: e, path: _fPath });
					});
					break;
				case 'event':
					try {
						let _data = app._m.xtend.clone(d.data);
						delete d.data;
						d = app._m.xtend.extend(d, _data);
						self[d.module].routePHPServerEvent(d);
					} catch (e) {
						console.warn('ERROR module POS.event in app: ' + e.message);
					}
					break;
				default:
					console.log('unrouted php server event', d.action)
			}

		}
		routeInterNode(d) {
			if (app.pathExists(self, d.module + '.routeInterNode')) {
				//d.data.socket = d.socket;
				//d.data.cback = d.cback;
				self[d.module].routeInterNode(d);
				return;
			}
			switch (d.action) {
				case 'event':
					if (app.pathExists(self, d.module + '.routeInterNode')) {
						d.data.socket = d.socket;
						d.data.cback = d.cback;
						self[d.module].routeInterNode(d.data);
						return;
					}
					console.warn('module pos.' + d.module + ' has no internode routing (routeInterNode)')
					break;
				default:
					console.log('pos.routeInterNode ' + d.module + '.' + d.action, d.data);
			}
		}

		onReady() {
			setTimeout(function () { app.splashscreen.win.hide(); }, 1000 * 3);
			if (self._cfg.device_type != 'workstation') {
				self.showWindow();
			}
		}

		appReady() {
			this.win.show();
		}
		getSecureTokens() {
			return [app.data.secureAccessToken, app.data.previousSecureAccessToken].filter((a) => a);
		}
		doPOSRequest(vars) {
			return new Promise((resolve) => {
				let _start = new Date().getTime(),
					tries = 0, _token = 0,
					_doTry = function () {
						let
							_tokens = self.getSecureTokens(),
							_tryStart = new Date().getTime();
						if (_token >= _tokens.length) _token = 0;
						let
							_flattenedArgs = vars.qs ? app.flattenObject(vars.qs) : null,
							_qs = _flattenedArgs ? Object.keys(_flattenedArgs).map((a) => a + '=' + encodeURIComponent(_flattenedArgs[a])).join('&') : null;
						let
							_opts = { json: true, options: { maxTries: 1 } },
							_cback = async function (e, r, b) {
								let _now = new Date().getTime();
								if (tries > 1 && _now - _start > 1000 * 3) {
									console.warn(vars.path + ', try #' + tries + ', token ' + _token + ', total time:' + ((_now - _start) / 1000) + ', try time:' + ((_now - _tryStart) / 1000))
								}
								if (b && typeof b == 'string') b = app.JSON.parse(b);
								if (e) {
									if ((b?.error == 'invalid_auth_token' || app.system.networkErrorsRetry.indexOf(e.code) != -1 || e.code == 401 || e.code == 403 && _tokens.length > 1) && tries < (vars.maxTries || 100)) {
										tries++;
										_tokens++;
										console.error(vars.path + ' try #' + tries, e.code);
										if (b?.error == 'invalid_auth_token' || _token >= _tokens.length && [401, 405].indexOf(e.code) != -1) {
											if (b?.error == 'invalid_auth_token' || [3, 5, 8, 10, 13, 15, 18].indexOf(tries) != -1) {
												await new Promise((tknRes) => {
													console.warn('Request server resend access token')
													self.serverWS.emit({
														module: 'POS',
														action: 'resendToken'
													}, (newTkn) => {
														app.data.secureAccessToken = newTkn;
														setTimeout(tknRes, 1000 * 2);
													});
												})
											}
											if (tries === 20) {
												await new Promise((tknRes) => {
													self.serverWS.emit({
														module: 'POS',
														action: 'renewToken'
													}, (newTkn) => {
														_tokens.unshift(app.data.secureAccessToken);
														app.data.secureAccessToken = newTkn;
														setTimeout(tknRes, 1000 * 2);
													});
												})
											}
										}
										setTimeout(_doTry, 1000 * 3);
										return;
									}
									console.error(vars.path, e.code, e.message, b)
									resolve({ result: 'error', message: e.message, code: e.code, runtime: (_now - _start) / 1000 });
									return;
								}
								resolve({ result: 'success', data: b });
							},
							_paramA = vars.method == 'POST' ? vars.fields : _opts,
							_paramB = vars.method == 'POST' ? _opts : _cback,
							_paramC = vars.method == 'POST' ? _cback : undefined;
						//console.log(self.url + 'index.php/' + vars.path + '?' + (_qs ? _qs + '&' : '') + 'secureToken=' + _tokens[_token])
						let _url = (self.url.replace(/\/REG\-([a-zA-Z0-9\-]+)\//, '/REG-' + app.system.id.replace(/^REG\-/, '') + '/') + '/index.php/' + vars.path + '?' + (_qs ? _qs + '&' : '')).replace('//index', '/index');
						//console.info(_url)
						app.system.request[vars.method || 'GET'](_url + 'secureToken=' + _tokens[_token], _paramA, _paramB, _paramC);
					};
				_doTry();
			});
		}
		parseUrlArgv(url) { //app.pos.parseUrlArgv
			let match, _argv = {},
				pl = /\+/g,                   // Regex for replacing addition symbol with a space
				search = /([^&=]+)=?([^&]*)/g,
				_json = function (s) {
					if (typeof s == 'string' && (s.indexOf('[') === 0 || s.indexOf('{') === 0))
						return JSON.parse(s);
					return s;
				},
				decode = function (s) { return s.replace(pl, " "); },
				query = url.split('?').pop();

			//pwm.data.urlParams = {};
			while (match = search.exec(query))
				_argv[decode(match[1])] = _json(decode(match[2]));

			if (_argv && Object.keys(_argv)) {
				let _uk = Object.keys(_argv).filter(function (a) { return a.indexOf('.') != -1; });
				for (let i = 0; i < _uk.length; i++) {
					app.pathToObject(_argv, _uk[i], _argv[_uk[i]]);
					delete _argv[_uk[i]];
				}
			}
			return _argv;
		}
		processOrders(orders, cback, tags = []) {
			if (!self.isRunning) {
				if (cback) cback({ result: 'error', code: 'pos_not_running' })
				return;
			}
			if (typeof orders == 'string')
				orders = [orders];
			if (!tags)
				tags = [];
			var res = 'success',
				stat = {};
			let _allStart = new Date().getTime(), _token = 0;
			app._m.async.eachSeries(orders, function (order, n) {
				let _start = new Date().getTime(), tries = 0, _doTry = async function () {
					let _res = await self.doPOSRequest({
						path: 'pending_sales/process/' + order
					});
					if (_res.result == 'error') {
						stat[order] = { status: 'error', message: _res.message, code: _res.code, runtime: _res.runtime };
						n();
						return;
					}
					_res.data._start = _start;
					stat[order] = await self.doProcessOrder(_res.data);
					n();
				};
				_doTry();
			}, function () {
				let _now = new Date().getTime();
				if (typeof cback == 'function')
					cback({
						result: res,
						orders: stat,
						runtime: (_now - _allStart) / 1000
					});
			});
		}
		async doProcessOrder(o, tags = []) {
			let b = app.entities.decode({ ...o });
			if (!b._start) b._start = new Date().getTime();
			if (b.seats || b.items) {
				b.tags = tags;
				var _processedItems = {};
				//send to KDS
				let peripheralsTimeout = setTimeout(() => {
					console.warn('order proscessing timeout')
				}, 1000 * 60 * 2)
				let [_kds, _printers] = await Promise.all([
					app.pos.kds.sendOrder(b),
					app.printManager.printOrderRAW({ data: b }, (res) => {
						if (res.result == 'success') {
							_processedItems = app._m.xtend.extend(_processedItems, res.processedItems);
						}
					}, tags)
				]);
				clearTimeout(peripheralsTimeout)
				let _now = new Date().getTime();
				//if (app.pathExists(_res, 'result') == 'success')
				return { status: 'success', printers: _printers?.printers || _printers, kds: _kds, processedItems: _processedItems, runtime: (_now - b._start) / 1000 };
			}
			return { status: 'success', warning: 'nothing_to_print', code: 'no_items', runtime: (_now - b._start) / 1000 };
		}

		serverwsEmit(obj, cback) {
			self.serverWS.emit({
				module: 'POS',
				action: 'event',
				data: obj
			}, cback);
		}
		emit(obj, cback) {
			var out = {
				module: 'pos',
				action: 'event',
				data: obj
			};
			app.web.emit(out, cback);
		}
		load_weather(s) {

			s.weather = {
				_latest: null,
				init: function () {

				},
				get: function (d, cback) {
					if (!d.location && app.pathExists(app, 'data.session.configs.branch.address.lat')) d.location = app.data.session.configs.branch.address.lat + ',' + app.data.session.configs.branch.address.lng;
					if (!d.lang) d.lang = app.pathExists(app, 'data.session.configs.branch.language') || 'en_CA';
					d.lang = d.lang.split('_')[0];
					let _return = function (b) {
						s.weather._latest = b;
						try {
							if (!cback) s.win.window.APPFCTS.weather.setLatest(b);
						} catch (er) { console.error(er) }
						try {
							if (!cback) s.win.window.APPFCTS.weather.setLatest(b);
						} catch (er) { console.error(er) }
						setTimeout(function () {
							s.weather.get(d);
						}, 1000 * 60 * 20);
						try {
							if (cback) cback(b);
						} catch (er) { console.error(er); }
					};

					app.web.emit({
						module: 'core',
						action: 'getWeather',
						datas: d
					}, _return);
				},
				bind: function (obj) {
					s.weather.bound = true;
					(obj || self.win.window).getWeather = function (d, cback) {
						if (app.pathExists(s, 'weather._latest.result') && app.pathExists(s, 'weather._latest.result.result') != 'error') {
							s.weather._latest.source = 'cache';
							s.weather._latest.fromCache = true;
							try {
								cback(s.weather._latest);
							} catch (er) { console.error(er); }
							return;
						}
						s.weather.get(d, cback);
					};
				}
			};
		}
	};
module.exports = pos;