var EftPayments = require('../eftPayment');
module.exports = class Chase extends EftPayments {
	constructor(cfg, parent) {
		super(cfg, parent);
		var self = this;
		_m.xtend.extend(self.cfg, {
			transCodeLength: 2,
			fieldsLength: 3,
			prependLength: false
		});
		self.constants = Object.assign(self.constants || {}, {
			'h-b': '\x11',
			TransType: {
				Purchase: '00',
				PreAuth: '01',
				PreAuthCompletion: '02',
				Refund: '03',
				AuthOnly: '07',
				Void: '05',
				IncrementalAuth: '08',
				//Ping: '42',	//Terminal Info
				//PingClose: '990'
			},
			TransStatus: {
				'00': 'Approved',
				'01': 'PApproved',
				'10': 'DAcquired',
				'11': 'CommError',
				'12': 'CancelUser',
				'13': 'TimedOutUser',
				'14': 'NotCompleted',
				'15': 'BatchEmpty',
				'16': 'DeclinedMerc',
				'17': 'RecordNFound',
				'18': 'TransVoided',
				'30': 'InalidReq',
				'31': 'BattLow',
				//'95': 'NotAvail',
				//'99': 'readyPrint'
			},
			fields: {
				ECRTransAmount: '001',
				ECRTenderType: '002',
				ECRClerkId: '003',
				ECRInvoiceNbr: '004',
				ECRAuthCode: '005',
				ECRCustomerId: '010',
				ECRReference: '011',
				ECRTransType: '013',
				TransType: '100',
				TransStatus: '101',
				TransDate: '102',
				TransTime: '103',
				TransAmount: '104',
				TipAmount: '105',
				TotalAmount: '109',
				Reference: '112',
				Sequence: '113',
				ClerkId: '118',
				CustCardType: '300',
				CustCardDesc: '301',
				CustAccNbr: '302',
				CustLang: '303',
				CustName: '304',
				CustCardEntry: '306',
				EMVAID: '308',
				EMVTVR: '309',
				EMVTSI: '310',
				EMVAppLabel: '311',
				CVMResult: '312',
				Auth: '400',
				HostRespCode: '401',
				HostRespText: '402',
				HostRespISO: '403',
				BatchNo: '500',
				Demo: '600',
				TerminalId: '601',
				MerchId: '602',
				ReceiptHeader1: '700',
				ReceiptHeader2: '701',
				ReceiptHeader3: '702',
				ReceiptHeader4: '703',
				ReceiptHeader5: '704',
				ReceiptHeader6: '705',
				ReceiptHeader7: '706',
				ReceiptFooter1: '707',
				ReceiptFooter2: '708',
				ReceiptFooter3: '709',
				ReceiptFooter4: '710',
				ReceiptFooter5: '711',
				ReceiptFooter6: '712',
				ReceiptFooter7: '713',
				Endorse1: '714',
				Endorse2: '715',
				Endorse3: '716',
				CustEndorse1: '720',
				CustEndorse2: '721',
				CustEndorse3: '722',
				EMVRespCOde: '730',
				Record: '900',
			},
			CustCardEntry: {
				'0': 'S',
				'1': 'C',
				'2': 'P',
				'3': 'M',
				'4': 'CS',
				'5': 'CM',
				'6': 'CNP',
			},
			CustCardType: {
				'00': 'Debit',
				'01': 'Visa',
				'02': 'MasterCard',
				'03': 'Amex',
				'04': 'Diners Club',
				'05': 'Discover Card',
				'06': 'JBC',
				'07': 'Union Pay Card',
				'08': 'Other Credit Card',
				'09': 'Gift Card',
				'10': 'Cash',
				'11': 'UnionPay Credit',
				'12': 'UnionPay Debit',
			}
		});
		super.provider = 'Chase';
		self._kA = null;

		//key consts fields values
		var fields = self.constants.fields;
		for (let f in fields)
			self.constants.fields[fields[f]] = f;

		//key consts fields values
		var TransType = self.constants.TransType;
		for (let t in TransType)
			self.constants.TransType[TransType[t]] = t;
	}

	keepAlive() {
		var self = this;
		if (self._kA != null)
			clearTimeout(self._kA);
		self._kA = setTimeout(function () {
			if (self.comm.connected) {
				console.warn('Global Payments keepAlive timeout, disconnect.')
				self.comm.disconnect();
			}
		}, 1000 * 15);
	}

	ping() {
		var self = this;
		super.ping(function (data) {
			if (data && data.status) {
				if (data.status == 'NotAvail') {
					console.warn('Global Payments ping error: REFUSED');
					self.pingStatus.pingBack({ status: 'error', code: 'REFUSED' });
				} else if (data.status == 'readyPrint') {
					self.pingStatus.pingBack({ status: 'success', info: data.fields });
					self.send({ transType: 'PingClose' });
				} else
					self.comm.disconnect();
			} else {
				self.pingStatus.pingBack(data);
			}
		});
	}
	receive(data) {
		var self = this;
		if (data == self.constants['h-b']) {
			self.keepAlive();
			return;
		}
		var trans = super.receive(data);
		trans.status = self.constants.TransStatus[trans.status.substr(0, 2)];
		if (trans.status != 'readyPrint')
			setTimeout(function () { self._busy = false; }, 5000);
		if (typeof self.cback == 'function')
			self.cback(trans);
	}

	send(vars, cback) {
		super.send(vars, cback);
		this.keepAlive();
	}
};