var config,
	logrotate = require('logrotator'),
	fs = require('fs'),
	L = {},
	_Opts = { schedule: '30m', size: '5m', compress: true, count: 5 },
	childProcess = require('child_process'),
	exec = childProcess.exec,
	async = require('async'),
	start = function () {
		fs.readdir(config.path, function (err, files) {
			files.forEach(file => {
				if (/\.log$/.test(file))
					fs.access(config.path + file, fs.constants.F_OK | fs.constants.R_OK, function (err) {
						if (err) {
							console.error(file, err.code);
							try { process.send({ action: 'initError', file: file, error: { code: err.code, message: err.message } }); } catch (er) { }
						}
						else if (L[file]) {

						}
						else {
							try {
								L[file] = logrotate.create();
								L[file].register(config.path + file, _Opts);
								if (L[file])
									L[file].on('rotate', function (file) {
										process.send({ action: 'rotated', file: file });
									});
							} catch (er) {
								console.error(er);
								process.send({ action: 'initError', file: file, error: { code: er.code, message: er.message } });
							}
						}
					});
			});
		})
	};
process.on('uncaughtException', function (err) {
	try {
		process.send({ action: 'error', error: err.message })
	} catch (er) {
		console.error(err)
	}
	//if (app) app.exit(1); else process.exit(1);
});
process.on('message', function (msg) {
	//process.send({ action: 'log', data: msg })
	switch (msg.action) {
		case 'config':
			config = msg.config;
			start();
			break;
		case 'exit':
			//release rotators
			process.exit();
			break;
	}
});
setTimeout(function () {
	try {
		process.send({ action: 'ready' })
	}
	catch (er) {
		console.info('ready')
	}
}, 300);