/***
 * THIS MODULE WILL BE DEPRECATED WITH THE VERSION 2 OF TECHNOPOS
 * PLEASE REFER TO POS.neighbors FOR INTER-REGISTER COMMUNICATIONS
 */


var app, pos,
	pingReset = null,
	_sendPing = null,
	sws = {
		lastPing: {},
		EVENT: 'POS.event',
		PKI: {},
		_onConnected: [],
		_sendQueue: [],
		init: function (parent) {
			pos = parent;
			app = pos.app;
			setInterval(function () {
				if (sws.socket && !app.pathExists(sws.socket, 'io.reconnecting') && (sws.status == 'offline' || !sws.socket.connected) && sws.disconnectDate && new Date(sws.disconnectDate).getTime() < new Date().getTime() - 1000 * 45) {
					console.warn('disconnected', ((new Date().getTime() - new Date(sws.disconnectDate).getTime()) / 1000) + 's ago, sws not connected, reconnecting...');
					sws.socket.connect();
				}
			}, 1000 * 30)
		},
		connect: function (onConnected) {
			let b4 = new Date().getTime();
			console.log('sws.connect')
			if (sws.socket) {
				if (onConnected) onConnected();
				return;
			}
			var _waitRequirements = function (cbk) {
				let _wait = false;
				if (!pos.url) _wait = true;
				if (_wait) {
					setTimeout(function () {
						_waitRequirements(cbk);
					}, 500);
					return;
				}
				cbk();
			}
			app.web.waitForKeys(function () {
				let _time = ((new Date().getTime() - b4) / 1000);
				if (_time > 1)
					console.log('app.web.waitForKeys at ' + _time)

				app.system.update.waitDownloaded(function () {
					app.diag.waitForBasic(function () {
						_time = ((new Date().getTime() - b4) / 1000);
						if (_time > 1)
							console.log('app.diag.waitForBasic at ' + _time)
						_waitRequirements(function () {
							_time = ((new Date().getTime() - b4) / 1000);
							if (_time > 1)
								console.log('_waitRequirements at ' + _time)
							var cfg = app.pathExists(app.data, 'session.configs');
							if (!cfg) {
								console.error('No config from sessions.configs')
								return;
							}
							if (!cfg.branch) {
								console.error('No branch info from sessions.configs')
								return;
							}
							if (!cfg.branch.master) {
								console.error('No branch.master from sessions.configs')
								return;
							}
							var _initSocket = async () => {
								await pos.checkLocalUrl();
								var _iorl = ((pos.socketUrl || pos.url).replace(/\.c(a|om)\//, '.c$1/WS/').replace('.lan/', '.lan/WS/').replace(':9443/', ':9443/WS/'));//.replace('.lan:4202/', '.lan:4202/WS/')
								let _options = {
									path: '/WS/' + _iorl.split('/WS/').pop(),
									reconnectionDelay: 1000,
									reconnectionDelayMax: 10000,
									transports: ['polling', 'websocket'],
									allowUpgrades: true
								};
								_options.path = _options.path.rtrim('/') + '/socket.io';
								if (app.system.vars.isOnFrontCloud) {
									_options.rejectUnauthorized = false;
									_options.verify = false;
									_iorl = 'https://server.azimutpos.lan/WS/' + app.system.id + '/';
									_options.path = '/socket.io';
									console.log('Connect io to local frontcloud'); // + 'POS'
								}
								else if (pos.serverIsSameLan) {
									_options.rejectUnauthorized = false;
									_options.verify = false;
								}
								console.log('connecting', _iorl, 'with options', _options)
								sws.socket = app.io(_iorl, _options);// + 'POS'
								let _connect_error = 0;
								if (onConnected) sws._onConnected.push(onConnected);

								let _doConnect = function () {
									sws.socket.emit('POS.connect', app.system.crypto.AES_PK.encrypt({
										useIV: true,
										branch: cfg.branch,
										macAddress: app.system._data.macAddress,
										uuid: app.system.id,
										hostname: os.hostname(),
										version: app.cfg.version,
										platform: app.cfg.platform,
										appType: 'register',
										encryptCallbacks: true,
										networking: {
											ipAddress: app.diag.basicData.ipAddress,
											cidr: app.diag.basicData.cidr,
											gateway: app.diag.basicData.gateway,
											interfaces: app.diag.basicData.interfaces,
											printersPings: app.printManager._printerPingStatus
										}
									}, sws.PKI.serverPublic, true), function (ack, vars) {
										_time = ((new Date().getTime() - b4) / 1000);
										if (_time > 1)
											console.log(_time, 'POS.connect ack "' + ack + '"')
										if (ack == 'authenticated') {
											sws._sessionInit.setDate = new Date().toISOString();
											sws._sessionInit.took = (new Date(sws._sessionInit.setDate).getTime() - new Date(sws._sessionInit.sentDate).getTime()) / 1000;
											if (sws._sessionInit.took > 1)
												console.log(sws._sessionInit.took, 'serverWS authenticated')
											if (vars && vars.secureToken) {
												if (app.data.previousSecureAccessToken != app.data.secureAccessToken && app.data.secureAccessToken != '' + vars.secureToken) app.data.previousSecureAccessToken = app.data.secureAccessToken;
												app.data.secureAccessToken = '' + vars.secureToken;
												try { app.pos.secureTokenChanged(); } catch (er) { }
											}
											sws.connected();
											clearInterval(_sendPing);
											_sendPing = setInterval(function () {

												let _pingStart = new Date().getTime()
												clearTimeout(pingReset);
												pingReset = setTimeout(function () {
													console.warn('Ping timed out, reconnect');
													sws.socket.disconnect();
													//sws.socket.connect();
												}, 1000 * 60);
												sws.socket.emit('POS.ping', 'pong', function () {
													clearTimeout(pingReset);
													sws.lastPing = {
														ttl: (new Date().getTime() - _pingStart) / 1000,
														date: new Date().toISOString()
													}
												});
											}, 1000 * 10);
											//sws.processSendQueue();
											return;
										}
										if (ack == 'sync_in_progress') {
											app.splashscreen.setMessage('sync_in_progress');
											//setTimeout(function () {
											//	_doConnect();
											//}, 1000 * 5);
											return;
										}
										if (ack == 'unauthorized') {
											app.splashscreen.showError('unauthorized');
										}
										console.error('AzimutPOS Server Returned "' + ack + '" on POS.connect');
									});
								};
								sws.socket.nsp = '/POS';
								sws.socket.
									on('PUBLIC_KEY', function (d) {
										//if (sws.PKI.serverPublic)
										b4 = new Date().getTime();
										sws._sessionInit = {
											sentDate: new Date().toISOString()
										};
										sws.PKI.serverPublic = Buffer.from(d, 'base64').toString();
										sws.socket.emit('PUBLIC_KEY', app.web.PKI.public64, function (ack) {
											console.log(((new Date().getTime() - b4) / 1000), 'PUBLIC KEY RECEIVED');

											//console.log('Connecting fo real')
											sws.socket.sendEncrypted = true;

											_doConnect();
										});
									}).
									on('registerDoneSyncing', function () {
										app.splashscreen.unsetMessage('sync_in_progress');
										b4 = new Date().getTime();
										sws._sessionInit = {
											sentDate: new Date().toISOString()
										};
										_doConnect();
									}).
									on('connect', function () {
										clearTimeout(pingReset);
										sws.connecting = false;
										pos.skipServerSameLan = false;
										_connect_error = 0;
										console.info('Connected to the technopos server');
									}).
									on('connecting', function () {
										sws.connecting = true;
									}).
									on('reconnecting', function () {
										sws.connecting = true;
									}).
									on('reconnect', function () {
										sws.connecting = false;
										//console.log('RE-connected to the technopos server');
									}).

									on('pong', (ms) => {
										//console.log('PING')
										sws.lastPing = {
											ttl: ms / 1000,
											date: new Date().toISOString()
										}
										app.diag.report('pos_status', 'online', (sws?.lastPing?.ttl ?? -1) + 's');
									}).
									on('ping', (ms) => {
										//console.log('PING')
										clearTimeout(pingReset);
										pingReset = setTimeout(function () {
											console.warn('Ping timed out, reconnect');
											sws.socket.disconnect();
											app.diag.report('pos_status', 'offline', '-1 s');
											//sws.socket.connect();
										}, 1000 * 60);
									}).
									on('system', sws.routeEvent).
									on('POS.event.return', sws.routeEvent).
									on('secureTokenChanged', function (d, ack) {
										console.log('TOKEN CHANGED')
										try {
											d = app.system.JSON.parse(app.system.crypto.AES_PK.decrypt(d, app.web.PKI.private));
										}
										catch (er) {
											console.error(er.message, d)
											if (ack) ack('resend');
											return;
										}
										if (app.data.previousSecureAccessToken != app.data.secureAccessToken && app.data.secureAccessToken != '' + d.data) app.data.previousSecureAccessToken = app.data.secureAccessToken;
										app.data.secureAccessToken = '' + d.data;
										app.pos.secureTokenChanged();
										if (ack) ack('received');
									}).
									on('error', function (er) {
										console.error('SOCKET ERROR', er);
									}).
									on('connect_error', function (er) {
										_connect_error++;
										//notify splashscreen
										if (_connect_error == 1 || _connect_error == 10) {
											console.error('CONNECT TO POS SERVER SOCKET ERROR \'connect_error\'', er.message || er);
											if (_connect_error == 10) {
												_initSocket();
												//if(pos.serverIsSameLan) pos.skipServerSameLan=true;
											}
										}
									}).
									on('connect_failed', function (er) {
										console.error('CONNECT TO POS SERVER SOCKET ERROR \'connect_failed\'', er.message || er);
									}).
									on('disconnect', sws.disconnected);
							};
							_initSocket();
						});
					});
				});
			});
		},
		routeEvent: function (d, ack, cback) {
			try {
				d = app.system.JSON.parse(app.system.crypto.AES_PK.decrypt(d, app.web.PKI.private));
			}
			catch (er) {
				console.error(er.message, d)
				if (ack) ack('resend');
				return;
			}
			//console.log('RECEIVED PARSED', d)
			if (d.action == 'ping' && cback) {
				cback({ ping: 'pong' });
				return;
			}
			if (cback && typeof cback == 'function') d.cback = function (data) { cback(sws.socket.sendEncrypted ? app.system.crypto.AES_PK.encrypt(data, sws.PKI.serverPublic, true) : data) };
			if (d.module == 'neighbors') {
				sws.neighbors.routeTPOSEvent(d);
				if (ack) ack('received');
				return;
			}
			if (d.module == 'registerBroadcast') {
				if (ack) ack('received');
				let _bcastData = d.data.data;
				_bcastData.cback = d.cback;
				if (d.data.module == 'ui')
					pos.win.window.APPFCTS.ui.serverEvents.process(_bcastData);
				else
					pos.routePHPServerEvent(_bcastData);
				return;
			}
			if (pos[d.module] && pos[d.module].routeTPOSEvent)
				pos[d.module].routeTPOSEvent(d);
			else if (app[d.module] && app[d.module].routeTPOSEvent)
				app[d.module].routeTPOSEvent(d);
			else {
				console.log('ROUTED FROM SERVER WS', d)
			}
			if (ack) ack('received');
		},
		neighbors: {
			routeTPOSEvent: function (d, ack) {
				if (ack) ack('received');
				let _k;
				switch (d.action) {
					case 'kdsIpUpdate':
						_k = (app.data.session.configs.kds ?? [])?.filter((a) => a.id == d.data.id)?.[0];
						if (_k) _k.ip = d.data.ip;
						break;
					case 'kdsMACUpdate':
						_k = (app.data.session.configs.kds ?? [])?.filter((a) => a.id == d.data.id)?.[0];
						if (_k) _k.macAddress = d.data.macAddress;
						break;
					case 'printerIPUpdate':

						var _p = app.data.session.configs.printers;
						for (let i = 0; i < _p.length; i++) {
							if (_p[i].id == d.data.printer.id && _p[i].deviceUri != d.data.printer.ipAddress) {
								_p[i].deviceUri = d.data.printer.ipAddress;
							}
						}
						break;
					case 'printerStatusUpdate':
						if (sws.neighbors.list && sws.neighbors.list[d.data.device]) {
							if (!sws.neighbors.list[d.data.device].networking.printersPings) sws.neighbors.list[d.data.device].networking.printersPings = {};
							sws.neighbors.list[d.data.device].networking.printersPings[d.data.printer.id] = d.data.printer;
						}
						break;
					case 'list':
						sws.neighbors.list = d.data;
						break;
					case 'connected':
						if (!sws.neighbors.list) sws.neighbors.list = {};
						sws.neighbors.list[d.data.deviceUUID] = d.data;
						//console.info('neighbor connected', d.data.deviceUUID, d.data.hostname)
						break;
					case 'disconnected':
						//console.info('neighbor disconnected', d.data.deviceUUID, app.pathExists(sws.neighbors, 'list.' + d.data.deviceUUID + '.hostname'))
						if (sws.neighbors.list && sws.neighbors.list[d.data.deviceUUID])
							delete sws.neighbors.list[d.data.deviceUUID];
						break;
					default:

						console.info('neighbors.routeTPOSEvent', d.action, d.data)
				}
			},
			kds: {
				kdsIpUpdate: (d) => {
					sws.emit({
						module: 'neighbors',
						action: 'kdsIpUpdate',
						data: d
					});
				},
				kdsMACUpdate: (d) => {
					sws.emit({
						module: 'neighbors',
						action: 'kdsMACUpdate',
						data: d
					});
				}
			},
			printers: {
				printRequest: function (data, cback) { //neighbors.printers.printRequest
					//send a print request to the server since we are not able to communicate with printer or register (roaming)

					let _parent = app.getParentStack();
					sws.emit({
						module: 'neighbors',
						action: 'printRequest',
						data: data
					}, function (res) {
						if (app.tryCatch(function () {
							res.viaServer = 1;
							if (cback) cback(res);
						})) {
							console.warn('printers.printRequest from', _parent)
						}
					});
				},
				printerIPUpdate: function (p) { //neighbors.printers.printerIPUpdate
					sws.emit({
						module: 'neighbors',
						action: 'printerIPUpdate',
						data: p
					});
				},
				statusUpdate: function (p) {
					//send printer status
					sws.emit({
						module: 'neighbors',
						action: 'printerStatusUpdate',
						data: p
					});
				}
			}
		},
		getPR: function () { return pingReset; },
		reconnect: function () {
			if (sws.status == 'online') return false;
			setTimeout(function () {
				if (sws.status != 'online' && !app.pathExists(sws.socket, 'io.reconnecting')) {
					sws.socket.connect();
				}
			}, 1000);
			//clearTimeout(pingReset);
			//pingReset = setTimeout(function () {
			//	//sws.socket.connect();
			//	pingReset = setTimeout(function () {
			//		sws.reconnect();
			//	}, 1000 * 5);
			//}, 500);

		},
		disconnected: function () {
			//console.log('disconnected')
			clearTimeout(pingReset);
			clearInterval(_sendPing);
			console.log('sws.disconnected')
			sws.status = 'offline';
			sws.disconnectDate = new Date().toISOString();
			sws.reconnect();
			app.diag.report('pos_status', 'offline', '-1 s');

		},
		doOnConnectedQueue: function () {
			if (sws._onConnected && sws._onConnected.length) {
				try {
					sws._onConnected[0]();
				} catch (er) { console.error(er.message) }
				sws._onConnected.shift();
				sws.doOnConnectedQueue();
			}
		},
		connected: function () {
			sws.status = 'online';
			sws._sendQueueProcessing = false;
			sws.processSendQueue();
			sws.doOnConnectedQueue();

			console.log((new Date().getTime() - new Date(sws._sessionInit.sentDate).getTime()) / 1000, 'AzimutPOS Server is online')

			app.diag.report('pos_status', 'online', (sws?.lastPing?.ttl ?? -1) + 's');
			//we are connected and ready to go
		},

		processSendQueue: function () {
			if (sws.status != 'online') {
				sws._sendQueueProcessing = false;
				return;
			}
			if (sws._sendQueueProcessing) {

				return;
			}
			sws._sendQueueProcessing = true;
			//console.log('sendQueue', sws._sendQueue.length);
			let _q = sws._sendQueue[0];
			if (!_q) {
				sws._sendQueueProcessing = false;
				return;
			}
			sws.emit(_q.datas, _q.cback, function (ack) {
				if (ack == 'received') {
					if (_q.onAck) _q.onAck('received');
					sws._sendQueue.shift();
					sws.processSendQueue();
				}
			});
		},
		emit: function (datas, cback, onAck) {
			let _parent = app.getParentStack();
			datas.appType = 'register';

			if (sws.status != 'online' || !sws.socket) {
				sws._sendQueue.push({
					datas: datas,
					cback: cback,
					onAck: onAck
				});
				return;
			}
			//if (cback) {
			//	datas.cbackID = app.system.uuid.get();
			//	sws.emitCbacks[datas.cbackID] = cback;
			//}
			try {
				var _retried = 0, _doSend = function () {
					if (!sws.socket) {
						console.warn('cant send data, no socket', datas)
						setTimeout(function () {
							_doSend();
						}, 500);
						return;
					}
					if (_retried < 5 && sws.socket.sendEncrypted && sws.PKI.serverPublic) {
						sws.socket.emit(sws.EVENT, app.system.crypto.AES_PK.encrypt(datas, sws.PKI.serverPublic, true), function (ack) {
							if (ack != 'received')
								console.warn('Received ack for encrypted ' + sws.EVENT, ack)
							if (ack == 'resend') {
								_retried++;
								process.nextTick(_doSend);
							}
							if (onAck) onAck(ack);
						}, cback ? function (d, ack) {
							try {
								d = app.system.JSON.parse(app.system.crypto.AES_PK.decrypt(d, app.web.PKI.private));
							}
							catch (er) {
								console.error(er.message, d)
								if (ack) ack('resend');
								return;
							}
							//console.log('RECEIVED PARSED', d)
							if (app.tryCatch(function () {
								cback(d);
							})) {
								console.warn('Called from', _parent)
							}
							if (ack) ack('received');
						} : undefined);
					}
					else {
						sws.socket.emit(sws.EVENT, datas, function (ack) {
							if (ack != 'received')
								console.warn('Received ack for unencrypted ' + sws.EVENT, ack)
							if (ack == 'resend')
								process.nextTick(_doSend);
							if (onAck) onAck(ack);
						}, cback ? function (d, ack) {
							try {
								d = app.system.JSON.parse(app.system.crypto.AES_PK.decrypt(d, app.web.PKI.private));
							}
							catch (er) {
								console.error(er.message, d)
								if (ack) ack('resend');
								return;
							}
							//console.log('RECEIVED PARSED', d)
							if (app.tryCatch(function () {
								cback(d);
							})) {
								console.warn('Called from', _parent)
							}
							if (ack) ack('received');
						} : undefined);
					}
				};
				_doSend();
			}
			catch (e) {
				_core.log('C', '_core._modules.admin.send: ' + e.message);
			}
		},
		//any id (no need to add location id), ttl in seconds
		getLock: function (id, ttl, cback) {
			sws.emit({ module: 'locks', action: 'getLock', data: { id: id, ttl: ttl } }, function (res) {
				if (res) cback(function () {
					//unlock
					sws.emit({ module: 'locks', action: 'unLock', data: { id: id } }, function (res) {

					});
				});
				else cback();
			})
		}
	};
module.exports = sws;