
var
	_format = (d) => {
		return {
			certificate: {
				CA: d?.certificate?.CA,
				certificate: d?.certificate?.certificate,
				date: d?.certificate?.date,
				fingerprint: d?.certificate?.fingerprint,
				serial: d?.certificate?.serial
			},
			deviceID: d?.deviceID,
			keyPair: {
				date: d?.keyPair?.date,
				private: d?.keyPair?.private,
				public: d?.keyPair?.public
			}
		}
	},
	_compare = (a, b = {}) => {
		let
			_a = { ...a },
			_b = { ...(b || {}) };
		let _c = app.data.session?.configs;
		//if (_c?.mevWeb?.deviceSynced)
		//delete _a.privateKey
		return _b && JSON.stringify(_a, undefined, 4) == JSON.stringify(_b || {}, undefined, 4);
	},
	_getCert = () => {
		return new Promise((gotData) => {
			app._m.fs.exists(_cf, async function (exists) {
				gotData(exists ? await new Promise((gotData) => {
					app._m.fs.readFile(_cf, function (err, data) {
						gotData(_format(app.system.JSON.parse(data.toString().trim())));
					})
				}) : null);
			});
		});
	},
	_unlinkFile = () => {
		if (app._m.fs.existsSync(_cf))
			app._m.fs.unlinkSync(_cf);
	},
	_writeCerts = (d) => {
		let _c = app.data.session?.configs;
		if (_c.mevWeb.deviceSynced) return false;
		if (app.pathExists(app, 'data.session.result') == 'success' && _c?.location?.configs?.mevWeb?.enabled == '1' && d?.certificate) {
			app._m.fs.ensureDir(_cd, function () {
				_skipWatch = true;
				_certIsValid = true;
				app._m.fs.writeFile(_cf, JSON.stringify(d, undefined, 4), async function (err) {
					let _data = await _getCert();
					if (_compare(_format(_c?.mevWeb), _data)) {
						//if (cback) cback();
						_c.mevWeb.deviceSynced = 1;
						MW.emit({ action: 'certificateSynced' })
					}
					else {
						//no moar space available?
					}
					setTimeout(() => {
						_skipWatch = false;
					}, 1000)
				});
			});
			return;
		}
		_certIsValid = false;
		_unlinkFile();
	},

	_certIsValid = false,
	app, pos, _cd, _watch, _skipWatch = false,
	MW = {
		EVENT: 'POS.mevWeb.event',
		init: function (parent) {
			app = parent;
			_cd = app.cacheDir + "mevWeb/";
			_cf = _cd + 'certificate.json';
		},
		certIsValid: () => { return _certIsValid ? true : false; },
		checkConfig: async function () {
			let _c = app.data.session?.configs;
			if (app.pathExists(app, 'data.session.result') == 'success' && _c?.location?.configs?.mevWeb?.enabled == '1') {
				if (_c?.mevWeb?.certificate) {
					console.log('Got mevweb config', { ..._c?.mevWeb })
					let _fData = _format(_c?.mevWeb);
					if (!_watch) {
						_watch = true;
						app.watch(_cf, async function (cur, prev) {
							let evt = 'deleted';
							if ((!cur?.mtime || !cur.mtime.getTime()) && (!prev?.mtime || !prev.mtime.getTime())) evt = 'created';
							else if (!cur?.mtime || !cur.mtime.getTime()) evt = 'deleted';
							else if (cur.mtime.getTime() != prev.mtime.getTime()) evt = 'updated';
							if (evt != 'created') {
								let _data = await _getCert();
								_certIsValid = false;
								if (!_data) {
									evt = 'deleted';
									_unlinkFile();
								}
								if (_compare(_fData, _data)) {
									_certIsValid = true;
								}
								else
									MW.emit({ action: 'certificate' + evt.ucfirst() })
							}
							console.warn('Cert file changed', evt, { isValid: _certIsValid, cur: cur.mtime.getTime() > 0 ? cur.mtime.toISOString() : false, prev: prev.mtime.getTime() > 0 ? prev.mtime.toISOString() : false })
							try {
								//notify pos GUI
								if (_c?.location?.configs?.mevWeb?.enabled == '1')
									app.pos.win.window.APPFCTS.mevWeb.certificate.status(_certIsValid)
							} catch (e) {

							}
							//support._gotConfig();
						});
					}
					let _data = await _getCert();
					_certIsValid = false;
					if (_compare(_fData, _data)) {
						_certIsValid = true;
						if (!_c?.mevWeb?.deviceSynced) {
							_c.mevWeb.deviceSynced = 1;
							console.log('mark certificate as synced with serial', _data?.certificate?.serial)
							MW.emit({ action: 'certificateSynced', data: { serial: _data?.certificate?.serial } })
						}
						return true;
					}
					if (!_c?.mevWeb?.deviceSynced) {
						console.log('Writing file', { ..._c.mevWeb })
						_writeCerts(_fData)
						return true;
					}
				}
			}
			_certIsValid = false;
			_unlinkFile();
			return false;
		},
		emit: (obj, cback) => {
			var out = {
				module: 'mevWeb',
				action: obj.action || 'event',
				data: obj.data
			};
			app.pos.emit(out, cback);
		},

		routeEvent: (d, cback) => {
			//cloud events
			switch (d.action) {
				case 'certificateDeleted':
					_unlinkFile();
					if (cback) cback();
					break;
				case 'certificateChanged':
					_writeCerts(_format(d.datas));
					if (cback) cback();
					break;
			}
		}
	};
module.exports = MW;