var app, self, PORself, _lastSentStatus = {}
_lpStatData = null;
function mmToPt(mm, dpi) {
	let _dv = 1;
	if (dpi) {
		_dv = dpi / 72.0;
		//convert from 72 to x ydpi
	}
	return Math.floor((Math.floor(mm * (dpi ? _dv : 1) * 10) / 10 * 2.83465) * 10) / 10;
}
function pxToPt(px, dpi) {
	let _dv = 1;
	if (dpi) {
		_dv = dpi / 72.0;
		//convert from 72 to x ydpi
	}
	return Math.floor((Math.floor(px * (dpi ? _dv : 1) * 10) / 10 * 0.75) * 10) / 10;
}
var _cmds = {
	init: '\x1B\x40',          		// init
	left: '\x1B\x61\x30', 			// left align
	center: '\x1B\x61\x31', 			// center align
	right: '\x1B\x61\x32', 			// right align
	lineBreak: '\n',//'\x0A',                   // line break
	bold_on: '\x1B\x45\x0D', 			// bold on
	bold_off: '\x1B\x45\x0A', 			// bold off
	doubleFont: '\x1B\x21\x30', 			// double font size
	doubleHeight: '\x1B\x21\x10', 			// double font size
	double: '\x1D\x21\x11', 			// double font size
	big: '\x1b\x21\x59', // text size 59
	bigger: '\x1b\x21\x58', // text size 58
	biggest: '\x1b\x21\x62', // text size 62
	standard: '\x1D\x21\x00', 			// standard font size
	small: '\x1b\x21\x01', 			// small text
	normal: '\x1B\x4D\x30\x1b\x21\x02\x1b\x72' + 0, 			// normal text
	resetTxt: '\x1B\x45\x0A\x1D\x21\x00\x1B\x4D\x30\x1b\x21\x02',
	cut1: '\x1B\x69',          		// cut paper (old syntax)
	cut2: '\x1D\x56\x00', 			// full cut (new syntax)
	cut3: '\x1D\x56\x30', 			// full cut (new syntax)
	cut4: '\x1D\x56\x01', 			// partial cut (new syntax)
	cut5: '\x1D\x56\x31', 			// partial cut (new syntax)
	drawer: '\x10\x14\x01\x00\x05',  	// Generate Pulse to kick-out cash drawer**
	drawer1: '\x10\x14\x01\x00\x05',  	// Generate Pulse to kick-out cash drawer**
	drawer2: '\x10\x14\x01\x00\x02',  	// Generate Pulse to kick-out cash drawer**
	black: "\x1b\x72\x00",
	red: "\x1b\x72\x01",
	qrModel: "\x1D\x28\x6B\x04\x00\x31\x41\x50\x00",
	qrSize: "\x1D\x28\x6B\x03\x00\x31\x43", //+ size in dot (1 to 16) https://reference.epson-biz.com/modules/ref_escpos/index.php?content_id=141
	qrLevel_L: "\x1D\x28\x6B\x03\x00\x31\x45\x48", //https://reference.epson-biz.com/modules/ref_escpos/index.php?content_id=142
	qrLevel_M: "\x1D\x28\x6B\x03\x00\x31\x45\x49",
	qrLevel_Q: "\x1D\x28\x6B\x03\x00\x31\x45\x50",
	qrLevel_H: "\x1D\x28\x6B\x03\x00\x31\x45\x51",
},
	JsBarcode = require('jsbarcode'),
	SVGtoPDF = require('svg-to-pdfkit'),
	iconv = require('iconv-lite'),
	ESCPOS = require('escpos'),
	CMDS = require(__dirname + '/tools/commands.js'),
	//utils = require(__dirname + '/tools/utils.js'),
	PDFDocument = require('pdfkit'),
	_printerCodes = require('./printer_codes.json'),
	mediaSizes = {},
	_checkNetworkPrintersTimer = null;
ESCPOS.USB = require('escpos-usb');
ESCPOS.SERIAL = require('escpos-serialport');
ESCPOS.NETWORK = require('escpos-network');
const { MutableBuffer } = require('mutable-buffer');
const { DOMImplementation, XMLSerializer } = require('xmldom');
//var { createCanvas } = require("canvas");
//PDFDocument.barcode = require(__dirname + '/tools/pdfkit-barcode.js');
//@72DPI
mediaSizes["72mm"] = {
	width_microns: 72000,
	height_microns: 210000,
	custom_display_name: '72mm'
};
mediaSizes["76mm"] = {
	width_microns: 76000,
	height_microns: 297000,
	custom_display_name: '76mm'
};
mediaSizes["80mm"] = {
	width_microns: 80000,
	height_microns: 297000,
	custom_display_name: '80mm'
};
mediaSizes["A5"] = {
	width_microns: 148000,
	height_microns: 210000,
	custom_display_name: 'A5'
};
mediaSizes["A4"] = {
	width_microns: 210000,
	height_microns: 297000,
	custom_display_name: 'A4'
};
mediaSizes["A3"] = {
	width_microns: 297000,
	height_microns: 420000,
	custom_display_name: 'A3'
};
mediaSizes["B5"] = {
	width_microns: 176000,
	height_microns: 250000,
	custom_display_name: 'B5'
};
mediaSizes["B4"] = {
	width_microns: 250000,
	height_microns: 353000,
	custom_display_name: 'B4'
};
mediaSizes["JIS-B5"] = {
	width_microns: 182000,
	height_microns: 257000,
	custom_display_name: 'JIS-B5'
};
mediaSizes["JIS-B4"] = {
	width_microns: 257000,
	height_microns: 364000,
	custom_display_name: 'JIS-B4'
};
mediaSizes["Letter"] = {
	width_microns: 215900, //8.5"x11"
	height_microns: 279400,
	custom_display_name: 'Letter'
};
mediaSizes["Legal"] = {
	width_microns: 215900, //8.5"x14"
	height_microns: 355600,
	custom_display_name: 'Legal'
};
mediaSizes["Ledger"] = {
	width_microns: 279400, //11"x17"
	height_microns: 431800,
	custom_display_name: 'Ledger'
};
var PM = class PrintManager {
	constructor(parent) {
		this.app = parent;
		app = this.app;
		self = this;
		self.mediaSizes = mediaSizes;
		self.deviceUriRegexes = [
			/^(socket\:\/\/|)(\d{2,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/,
			/^(hp\:\/net\/[a-z0-9\-_\s]+)\?ip=(\d{2,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/i
		];

		this.checkPrintersChangesTimer = null;

		this.queue = [];
		this.isProcessing = false;
		this.managerDialog = null;
		this._printerPingStatus = {};
		this.neighbors_printers_status = {};
		self.printOrderRAW = new POR(self);
		//this.printer = require('printer');
		//this.printers = this.printer.getPrinters();
		//console.log(this.printers)
		self.router = app.web.express.Router();
		app.web.router.use('/printManager', self.router);
		self.router.get('/test', function (req, res) {
			res.return({ result: 'Youpelaille' })
		});
		self.router.post('/printPDF', function (req, res) {
			self.printPDF(req.body, function (pres) {
				res.return({ result: 'printed', data: pres });
			});
		});
		self.router.post('/print', function (req, res) {
			console.log('PRINT FROM OTHER', req.body);
			self.print(req.body, function (pres) {
				res.return({ result: 'printed', data: pres });
			});
		});
		setTimeout(self.updatePrintersStatus, 1000 * 30);
		setInterval(self.checkNetworkPrintersIPAddresses, 1000 * 60);
		setInterval(function () {
			self.checkPrintersChanges();
		}, 1000 * 60);
		//setTimeout(function () {
		//	self.testCoupons()
		//}, 1000 * 30)
	}
	testCoupons() {
		let coupons = [{ "id": "42f94f60-8364-11eb-ac35-16215d90fc50", "name": "test", "start_date": "2021-03-16 00:00:00", "end_date": "2021-03-20 23:59:59", "added_on": "2021-03-17 01:27:06", "active": "1", "deleted": "0", "type": "simple_discount", "items_to_buy": "0.0000000000", "items_to_get": "1.0000000000", "percent_off": "5.0000000000", "fixed_off": null, "spend_amount": "0.0000000000", "num_times_to_apply": "0", "coupon_code": "6969", "description": "", "show_on_receipt": "1", "coupon_spend_amount": "80.0000000000", "expire": null }, { "id": "74dfe8a0-7c5b-11eb-82d8-16215d90fc50", "name": "Coupons 10$", "start_date": "2021-03-03 00:00:00", "end_date": "2021-03-27 23:59:59", "added_on": "2021-03-03 03:05:57", "active": "1", "deleted": "0", "type": "simple_discount", "items_to_buy": "0.0000000000", "items_to_get": "1.0000000000", "percent_off": null, "fixed_off": "10.0000000000", "spend_amount": "0.0000000000", "num_times_to_apply": "0", "coupon_code": "Rabais10", "description": "Coupon rabais de 10$", "show_on_receipt": "1", "coupon_spend_amount": "25.0000000000", "expire": null }];
		let _couponsPrinter = app.printManager.getDefaultPrinter('coupons', 'receipt');
		app._m.async.eachSeries(coupons, function (coupon, n) {
			let _coupon = {
				printer: app.pathExists(_couponsPrinter, 'id') || null,
				configs: {
					copies: 1
				},
				data: '',
				type: 'pdf',
				cut: false
			}
			if (app.pathExists(_couponsPrinter, 'configs.is_mev') == 1) {
				_coupon.type = 'mev';
			}
			else if (app.pathExists(_couponsPrinter, 'configs.genericText') == '1') {
				//send cut
				_coupon.type = 'raw';
				_coupon.cut = true;
			}
			if (app.tryCatch(function () {
				app.printManager.formatCoupon({ printer: _couponsPrinter, coupon: coupon, format: _coupon.type }, function (cdat) {
					_coupon.data = cdat;

					if (app.tryCatch(function () {
						app.printManager.print(_coupon, function (res) {
							n();
						});
					})) {
						console.warn(_coupon)
						n();
					}
				});
			})) {
				console.warn(_coupon)
				n();
			}
		}, function () {

		});
	}
	getPrinterCode(p, code) {
		if (typeof p == 'string') {
			p = self.getPrinter(p);
		}
		if (!p) {
			p = self.getDefaultPrinter();
		}
		if (!p) {
			console.error('getPrinterCode', p, code, 'Fatal error, could not get printer.')
			return '';
		}
		if (!p.makeModel) p.makeModel = 'Epson';
		let _o = app.pathExists(_printerCodes, (p.makeModel || '').toUpperCase() + '.' + code),
			_o_gen = app.pathExists(_printerCodes, (p.makeModel?.split('.')?.[0] || '').toUpperCase() + '.GENERIC.' + code),
			_s = (_o || _o_gen || '').split(','), out = null;
		if (_s && _s.length) {
			let _ar = [];
			for (let i = 0; i < _s.length; i++) {
				_ar.push(String.fromCharCode(_s[i]).toString(16));
			}
			out = _ar.join('');
		}
		return out;
	}
	routeTPOSEvent(d) {
		return self.routeEvent(d, d.cback);
	}
	routeEvent(d, cback) {
		switch (d.action) {
			case 'setPrintersNetworkInfo':
				if (!app.pathExists(app.data, 'session.configs.printers')) return false;
				var _p = app.data.session.configs.printers;
				for (let x = 0; x < d.data.printers.length; x++) {
					for (let i = 0; i < _p.length; i++) {
						if (_p[i].id == d.data.printers[x].id) {
							if (d.data.printers[x].macAddress)
								_p[i].macAddress = d.data.printers[x].macAddress;
							if (d.data.printers[x].deviceUri)
								_p[i].deviceUri = d.data.printers[x].deviceUri;
						}
					}
				}

				break;
			case 'printerMACUpdate':
				if (!app.pathExists(app.data, 'session.configs.printers')) return false;
				var _p = app.data.session.configs.printers;
				for (let i = 0; i < _p.length; i++) {
					if (_p[i].id == d.data.id && _p[i].macAddress != d.data.macAddress) {
						_p[i].macAddress = d.data.macAddress;
					}
				}
				break;
			case 'printerURIUpdate':

				if (!app.pathExists(app.data, 'session.configs.printers')) return false;
				var _p = app.data.session.configs.printers;
				for (let i = 0; i < _p.length; i++) {
					if (_p[i].id == d.data.id && _p[i].deviceUri != d.data.deviceUri) {
						_p[i].deviceUri = d.data.deviceUri;
					}
				}
				break;
			case 'printerIPUpdate':

				if (!app.pathExists(app.data, 'session.configs.printers')) return false;
				var _p = app.data.session.configs.printers;
				for (let i = 0; i < _p.length; i++) {
					if (_p[i].id == d.data.id && _p[i].deviceUri != d.data.ipAddress) {
						_p[i].deviceUri = d.data.ipAddress;
					}
				}
				break;
			case 'set_neighbors_printers_status':
				//console.log(d.action, d.data)
				try {
					app.pos.serverWS.neighbors.list[d.data.device].networking.printersPings = d.data;
				} catch (er) { }
				try {
					self.neighbors_printers_status[d.socket.deviceUUID] = d.data || {};
				} catch (er) { }
				break;
			case 'printerStatusUpdate':
				try {
					app.pos.serverWS.neighbors.list[d.data.device].networking.printersPings[d.data.printer.id] = d.data.printer;
				} catch (er) { }
				try {
					if (!self.neighbors_printers_status[d.socket.deviceUUID]) self.neighbors_printers_status[d.socket.deviceUUID] = {};
					self.neighbors_printers_status[d.socket.deviceUUID][d.data.printer.id] = d.data.printer;
				} catch (er) { }
				//console.log('printer status update', d.socket.deviceUUID, d.data);
				break;
			case 'paperStatusUpdate':

				if (!app.pathExists(app.data, 'session.configs.printers')) return false;
				var _p = app.data.session.configs.printers;
				for (let i = 0; i < _p.length; i++) {
					if (_p[i].id == d.data.id && _p[i].paperStatus != d.data.paperStatus) {
						_p[i].paperStatus = d.data.paperStatus;
					}
				}
				break;
			case 'getPrintQueue':
				app._m.exec(app.cfg.platform.indexOf('win') === 0 ? 'wmic printjob get' : 'lpstat -o', function (err, stdout, stderr) {
					if (cback) cback({ err: err, stdout: stdout, stderr: stderr });
					else if (d.cback) d.cback({ err: err, stdout: stdout, stderr: stderr });
				})
				break;
			case 'print':

				//console.log('PRINT', d.data)
				//if (d.data.type == 'mev') d.data.data += '\n\n\n\n%cmd.cut5%'
				self.print(d.data, function (pres) {
					if (cback) cback({ result: 'printed', data: pres });
					else if (d.cback) d.cback({ result: 'printed', data: pres });
				});
				break;
			case 'printPDF':
				self.printPDF(d.data, function (res) {

				});
				break;
			case 'updatePrinterField':
				if (!app.pathExists(app.data, 'session.configs.printers')) return false;
				var _p = app.data.session.configs.printers;
				for (let i = 0; i < _p.length; i++) {

					if (_p[i].id == d.data.id) {
						if (!d.data.fields) {
							d.data.fields = {};
							d.data.fields[d.data.field] = d.data.value;
						}
						let _fields = Object.keys(d.data.fields).map(function (k) { return { field: k, value: d.data.fields[k] }; });
						for (let x = 0; x < _fields.length; x++) {
							if (_p[i][_fields[x].field] != _fields[x].value) {
								console.info('Printer ' + (app.pathExists(_p[i], 'peripheralInfo.deviceName') || _p[i].name) + ' ' + _fields[x].field + ' has been set to ' + _fields[x].value)
								_p[i][_fields[x].field] = _fields[x].value;
							}
						}
					}
				}
				break;
			case 'printerUpdate':
				if (!app.pathExists(app.data, 'session.configs.printers')) return false;
				var _p = app.data.session.configs.printers, up = false;
				for (let i = 0; i < _p.length; i++) {
					if (_p[i].id == d.data.id) {
						console.info('Printer ' + (app.pathExists(_p[i], 'peripheralInfo.deviceName') || _p[i].name) + ' has been updated')
						_p[i] = d.data;
						up = true;
					}
				}
				if (!up) {
					app.data.session.configs.printers.push(d.data);
					console.info('Printer ' + (app.pathExists(d.data, 'peripheralInfo.deviceName') || d.data.name) + ' has been added')
				}
				self.checkPrintersChanges();

				break;
			case 'printerRemoved':

				if (!app.pathExists(app.data, 'session.configs.printers')) return false;
				var _p = app.data.session.configs.printers;
				for (let i = 0; i < _p.length; i++) {
					if (_p[i].id == d.data.id) {
						console.log('Printer ' + (app.pathExists(_p[i], 'peripheralInfo.deviceName') || _p[i].name) + ' has been removed')
						_p.splice(i, 1);
					}
				}
				break;
			case 'cupsPrinterTest':
				//lpr /usr/share/cups/data/testprint
				self.printLocalFile({ path: '/usr/share/cups/data/' + (d.data.type == 'pdf' ? 'default-testpage.pdf' : 'testprint'), type: d.data.type || 'raw', printer_id: d.data.printer_id, cfg: { copies: 0 } }).then(d.cback)
				break;
			case 'printerTest':
				//console.log(d.data)
				console.log('printerTest to ' + (app.pathExists(d.data, 'peripheralInfo.deviceName') || d.data.name) + ' @ ' + (d.data.register == 'NETWORK' ? d.data.deviceUri : d.data.register))
				if (!app.pathExists(_p, 'configs.twoToneCfg') && app.pathExists(_p, 'configs.twoTone') == '1')
					_p.configs.twoToneCfg = { enabled: '1' };
				d.data.objectAsIs = true;
				var test = {
					type: 'raw',
					data: function (_p) {
						let _lines = [
							'%cmds.init%',
							'%cmds.small%',
							'..',
							'%cmds.resetTxt%',
							...Array.from(Array(parseInt(_p?.configs?.kitchenPrint?.paddingTop || 0)).keys()).map((i) => '%cmds.lineBreak%'),
							'%cmds.center%',
							'%cmds.size58%',
							PM.rawPrintFcts._doBold(_p, { bold: '1' }, 'AzimutPOS*TM*') + '%cmds.resetTxt%%cmds.lineBreak%',
							'%cmds.size08%PRINTER TEST' + '%cmds.resetTxt%%cmds.lineBreak%',
							'%cmds.size44%' + (app.pathExists(_p, 'configs.twoToneCfg.enabled') == '1' ? '%cmds.red%' : '') + (app.pathExists(_p, 'peripheralInfo.deviceName') || _p.name) + '%cmds.resetTxt%%cmds.lineBreak%',

							(app.pathExists(_p, 'configs.twoToneCfg.enabled') == '1' ? '%cmds.black%' : ''),
							//device's name (not the printer, the register)
							app.pathExists(app, 'data.session.name') ? '%cmds.lineBreak%' + app.data.session.name + '%cmds.lineBreak%' : '',
							'%cmds.size28%',
							app._m.moment().format('YYYY-MM-DD') + '%cmds.lineBreak%',
							app._m.moment().format('HH:mm:ss') + '%cmds.lineBreak%',
							'%cmds.resetTxt%',
							'---------------------------' + '%cmds.lineBreak%'
						];
						//console.log(_lines)
						if (app.pathExists(d, 'data.testPrintOptions.printTestOrder') == '1') {
							let _base = {
								due_date: app._m.moment().tz(app.data.session.configs.branch.timezone).format('YYYY-MM-DD HH:mm:ss'),
								language: app.data.session.configs.branch.language || 'en_CA',
								invoice_number: 'Inv 1234',
								customer_name: 'Demo Customer',
								activity: 'Take out',
								customer_phone: '1(866) 464-3144',
							};
							_lines = _lines.concat(PM.rawPrintFcts.invoiceBase(_p, _base));
							_lines.push('%cmds.left%');
							_lines = _lines.concat(PM.rawPrintFcts.invoiceItem(_p, _base, {
								quantity: '1',
								name: 'Test Item',
								remarks: [
									'remark #1',
									'remark #2'
								],
								inclusions: {
									SIDE_FULL: [
										{
											quantity: '1',
											name: 'FULL extra 1'
										},
										{
											quantity: '2',
											name: 'FULL extra 2'
										}
									],
									SIDE_LEFT: [
										{
											quantity: '1',
											name: 'LEFT extra 1'
										},
										{
											quantity: '2',
											name: 'LEFT extra 2'
										}
									],
									SIDE_RIGHT: [
										{
											quantity: '1',
											name: 'RIGHT extra 1'
										},
										{
											quantity: '2',
											name: 'RIGHT extra 2'
										}
									]
								}
							}))
						}
						if (app.pathExists(d, 'data.testPrintOptions.printAllSizes') == '1') {
							_lines.push('%cmds.left%');
							for (let i = 0; i < 100; i++) {
								_lines.push('%cmds.size' + app.system.Strings.zeroFill(i, 2) + '%Size: ' + app.system.Strings.zeroFill(i, 2) + ', %cmds.bold_on%bold%cmds.bold_off% %cmds.lineBreak%');
							}
						}
						_lines = _lines.concat([
							'%cmds.resetTxt%',
							'%cmds.black%',
							'%cmds.lineBreak%%cmds.lineBreak%%cmds.lineBreak%',
							'%cmds.center%',
							'%cmds.small%',
							app._m.moment().format('YYYY-MM-DD HH:mm:ss') + '%cmds.lineBreak%',
							'%cmds.resetTxt%',
							'---------------------------' + '%cmds.lineBreak%',
							'%cmds.lineBreak%%cmds.lineBreak%%cmds.lineBreak%%cmds.lineBreak%%cmds.lineBreak%%cmds.lineBreak%%cmds.lineBreak%',
							'%cmds.cut5%'
						])
						return app.entities.removeAccents(_lines);
					}
				};
				self.print({
					noFallback: true,
					printer: d.data,
					configs: {
						copies: 1
					},
					type: test.type,
					data: test.data(d.data)
				}, function (res) {
					//console.log('sending to cback', res);
					if (cback) cback(res);
					else if (d.cback) d.cback(res);
				});
				break;
			default:
				console.warn('Unhandled event for printManager:' + d.action)
				if (cback) cback({ result: 'error', code: 'invalid_action' });
		}
	}
	async checkNetworkPrintersIPAddresses() {
		if (_checkNetworkPrintersTimer) return false;
		let _cupsUris = {};
		if (app.cfg.platform == 'linux64') {
			await new Promise((res) => {
				app._m.exec("lpstat -t", function (e, o, w) {
					if (o) {
						let lines = o.trim().split('\n').filter((a) => a.indexOf('device for ') === 0).map((a) => {
							let _parts = a.trim().match(/device for ([a-zA-Z0-9\-_\@\.]+)\: ([a-zA-Z0-9\-_\@\.\:\/]+)$/)
							return _parts ? { device: _parts[1], uri: _parts[2] } : null;
						}).filter((a) => a)
						for (let i of lines) {
							_cupsUris[i.device] = i.uri;
						}
						//console.log('_cupsUris', _cupsUris)
					}
					res();
				})
			})
		}
		_checkNetworkPrintersTimer = true;
		setTimeout(function () {
			_checkNetworkPrintersTimer = false;
		}, 1000 * 30);
		var v = app.pathExists(app.system, 'net.arp._lastScan.values') || {};
		//find printers by macAddress, compare ip, update if needed
		let _p = app.pathExists(app, 'data.session.configs.printers');
		if (!_p) return;
		app._m.async.eachSeries(_p, function (p, n) {
			if (p.register == app.system.id && p.deviceUri && p.macAddress) {
				//detect already linked printer cups ip change
				let _uri = null;
				for (let i = 0; i < self.deviceUriRegexes.length; i++) {
					if (self.deviceUriRegexes[i].test(p.deviceUri)) {
						_uri = self.deviceUriRegexes[i].exec(p.deviceUri);
						break;
					}
				}
				if (!_uri && _cupsUris[p.peripheralInfo?.printerName]) {
					for (let i = 0; i < self.deviceUriRegexes.length; i++) {
						if (self.deviceUriRegexes[i].test(_cupsUris[p.peripheralInfo?.printerName])) {
							_uri = self.deviceUriRegexes[i].exec(_cupsUris[p.peripheralInfo?.printerName]);
							p.deviceUri = _cupsUris[p.peripheralInfo?.printerName];
							break;
						}
					}
				}
				if (_uri && _uri[2]) {
					if (v?.[p.macAddress] && v[p.macAddress] != _uri[2]) {
						console.warn('LOCAL Printer "' + (p.peripheralInfo?.printerName || p.name) + '" changed ip address from "' + _uri[2] + '" to "' + v[p.macAddress] + '"')
						p.deviceUri = '' + p.deviceUri.replace(_uri[2], v[p.macAddress]);
						//send to others, send to cloud

						app.pos.neighbors.broadcast({
							module: 'printManager',
							action: 'printerURIUpdate',
							data: {
								id: p.id,
								deviceUri: p.deviceUri
							}
						});
						app.web.emit({
							module: 'printManager',
							action: 'printerURIUpdate',
							data: {
								id: p.id,
								deviceUri: p.deviceUri
							}
						});
						//update CUPS
						//lpadmin -v '+p.deviceUri+'
						if (app.system.vars.systemInfo.platform.indexOf('win') != -1) {
							app._m.exec(__dirname + '/tools/changeIP.bat ' + _uri[2] + ' ' + v[p.macAddress], function (err, stdout, stderr) {
								console.log(err, stdout, stderr)
							});
						}
						else {
							app._m.exec('lpadmin -p "' + (p.peripheralInfo?.printerName || p.name) + '" -v ' + p.deviceUri + '', function (err, stdout, stderr) {
								if (err) console.error('Error setting LOCAL Printer "' + (p.peripheralInfo?.printerName || p.name) + '" new IP address')
							});
						}
					}
				}
			}
			else if (p.register == 'NETWORK' && p.deviceUri) {
				let _uri = p.deviceUri.match(/^(socket\:\/\/|)(\d{2,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/);
				if (_uri && _uri[2]) {
					if (p.macAddress && v?.[p.macAddress] && v[p.macAddress] != _uri[2]) {
						console.warn('Network Printer "' + (p.peripheralInfo?.printerName || p.name) + '" changed ip address from "' + _uri[2] + '" to "' + v[p.macAddress] + '"')
						p.deviceUri = '' + p.deviceUri.replace(_uri[2], v[p.macAddress]);
						_uri[2] = '' + v[p.macAddress];

						app.pos.neighbors.broadcast({
							module: 'printManager',
							action: 'printerIPUpdate',
							data: {
								id: p.id,
								ipAddress: v[p.macAddress]
							}
						});
						app.web.emit({
							module: 'printManager',
							action: 'printerIPUpdate',
							data: {
								id: p.id,
								ipAddress: v[p.macAddress]
							}
						});

						try {
							app.pos.serverWS.neighbors.printers.printerIPUpdate({
								id: p.id,
								ipAddress: v[p.macAddress]
							});
						} catch (er) { }
					}

					let
						_tries = 0,
						_checkPingRes = function (pres) {
							//console.log(pres)
							let _s = pres.ttl > 0 ? 'up' : 'down', _return = 0;
							if (self._printerPingStatus[p.id]) {
								if (self._printerPingStatus[p.id].status == 'down' && _s == 'down') _return = 1;
								else if (self._printerPingStatus[p.id].status == 'up' && _s == 'up' && new Date().getTime() - new Date(self._printerPingStatus[p.id].date).getTime() < 1000 * 60 * 5) _return = 1;
							}
							self._printerPingStatus[p.id] = { date: new Date().toISOString(), ttl: pres.ttl, status: _s, ipAddress: _uri[2], macAddress: p.macAddress, errorMessage: pres.code || null };
							self.broadcastPrinterStatus(p);
						},
						_tryPing = function () {
							//console.log('PING PRINTER', _uri[2])
							app.system.net.ping(_uri[2], function (pingRes) {
								//console.log('PING PRINTER RESULT', _uri[2], pingRes)
								if (pingRes && pingRes.result == 'success') {
									//is pignable
									_checkPingRes(pingRes);
									return;
								}
								_tries++;
								if (_tries <= 5) {
									//retry
									setTimeout(_tryPing, 500);
									return;
								}
								//it is not, boooo
								pingRes.ttl = -1;
								_checkPingRes(pingRes);
							});
						}
					_tryPing();
				}
			}
			n();
		}, function () {

		});
	}
	getPrinterMAC(p, n) {
		if (p.deviceUri && !p.macAddress) {
			let _uri = null;
			for (let i = 0; i < self.deviceUriRegexes.length; i++) {
				if (self.deviceUriRegexes[i].test(p.deviceUri)) {
					_uri = self.deviceUriRegexes[i].exec(p.deviceUri);
					break;
				}
			}
			if (_uri && _uri[2]) {
				//printer is remote and no mac
				app.system.net.arp.get(_uri[2], function (arperr, arpres, arptbl) {
					//console.log(p.peripheralInfo.deviceName, p.deviceUri, _uri[2], arperr, arpres, arptbl);
					if (!arperr && arpres && arpres.length == 17) {
						console.log('Found printer mac address "' + arpres + '" from device ip "' + _uri[2] + '"')
						p.macAddress = arpres;
						//send update
						app.pos.neighbors.broadcast({
							module: 'printManager',
							action: 'printerMACUpdate',
							data: {
								id: p.id,
								macAddress: p.macAddress
							}
						});
						app.web.emit({
							module: 'printManager',
							action: 'printerMACUpdate',
							data: {
								id: p.id,
								macAddress: p.macAddress
							}
						});
					}
					n();
				});
			}
			return;
		}
		n();
	}
	checkPrintersChanges() {
		clearTimeout(self.checkPrintersChangesTimer);
		try {
			if (!app.pathExists(app.data, 'session.configs.printers')) return false;
			app._m.async.each(app.data.session.configs.printers, function (p, n) {
				if (p.register == app.system.id) {
					if (p.configs.printerType == 'thermal') self.readPrinterPaperStatus(p.deviceUri).then((res) => {
						p.paperStatus = { date: new Date().toISOString(), status: res };
						self.broadcastPaperStatus({ id: p.id, paperStatus: { ...p.paperStatus } });
						if (_lastSentStatus[p.id]) _lastSentStatus[p.id].paper = p.paperStatus
					})
					try {
						let deleted = true, devUriUpdated = false;
						for (let i = 0; i < app.splashscreen._data.printers.length; i++) {
							//console.log(app.splashscreen._data.printers[i].id, 'VS', p.id)
							if (app.splashscreen._data.printers[i].id == p.id) {
								if (app.splashscreen._data.printers[i].deviceUri && app.splashscreen._data.printers[i].deviceUri != p.deviceUri) {
									devUriUpdated = true;
									p.deviceUri = '' + app.splashscreen._data.printers[i].deviceUri;
									console.warn('Printer "' + (app.pathExists(p, 'peripheralInfo.deviceName') || p.deviceName || p.name) + '" has a new deviceURI:' + p.deviceUri)

									app.pos.neighbors.broadcast({
										module: 'printManager',
										action: 'printerURIUpdate',
										data: {
											id: p.id,
											deviceUri: '' + p.deviceUri
										}
									});
									app.web.emit({
										module: 'printManager',
										action: 'printerURIUpdate',
										data: {
											id: p.id,
											deviceUri: '' + p.deviceUri
										}
									});
								}
								deleted = false;
								break;
							}
						}
						if (deleted) {
							console.warn('Printer "' + (app.pathExists(p, 'peripheralInfo.deviceName') || p.deviceName || p.name) + '" has been removed from system')
							app.web.emit({
								module: 'printManager',
								action: 'printerRemoved',
								data: p.id
							});
						}
						else {
							self.getPrinterMAC(p, function () {

							});
						}
					} catch (er) {
						console.error(er.message);
					}
					n();
					return;
				}
				if (p.register == 'NETWORK' && p.deviceUri) {

					if (p.configs.printerType == 'thermal') self.readPrinterPaperStatus(p.deviceUri).then((res) => {
						p.paperStatus = { date: new Date().toISOString(), status: res };
						self.broadcastPaperStatus({ id: p.id, paperStatus: { ...p.paperStatus } });
						if (_lastSentStatus[p.id]) _lastSentStatus[p.id].paper = p.paperStatus
					})
					try {
						self.getPrinterMAC(p, n);
						return;
					} catch (er) {
						console.error(er.message);
					}
				}
				n();
			}, function () {
				app.diag.printers.set();
			});
		} catch (er) {
			console.error(er.message);
		}
	}
	setPrinterPDFMargins(printer) {

		let _doc = {
			media: 'Letter',
			margins: { // by default, all are 72
				top: 5,
				bottom: 5,
				left: 5,
				right: 5
			}
		};

		var _setMargins = function () {
			let ms = mediaSizes[_doc.media];
			if (app.pathExists(ms, 'margins')) {
				if (typeof ms.margins.left != 'undefined')
					_doc.margins.left = 1 * ms.margins.left;
				if (typeof ms.margins.top != 'undefined')
					_doc.margins.top = 1 * ms.margins.top;
				if (typeof ms.margins.right != 'undefined')
					_doc.margins.right = 1 * ms.margins.right;
				if (typeof ms.margins.bottom != 'undefined')
					_doc.margins.bottom = 1 * ms.margins.bottom;
			}
		}
		_setMargins();

		if (printer.configs) {
			let _pc = printer.configs;
			if (_pc.pageSize) _doc.media = _pc.pageSize;
			_setMargins();
			if (_pc.margins) {
				if (typeof _pc.margins.left != 'undefined')
					_doc.margins.left = 1 * _pc.margins.left;
				if (typeof _pc.margins.top != 'undefined')
					_doc.margins.top = 1 * _pc.margins.top;
				if (typeof _pc.margins.right != 'undefined')
					_doc.margins.right = 1 * _pc.margins.right;
				if (typeof _pc.margins.bottom != 'undefined')
					_doc.margins.bottom = 1 * _pc.margins.bottom;
			}
			if (app.pathExists(_pc, 'custom_margins')) {
				if (typeof _pc.custom_margins.left != 'undefined')
					_doc.margins.left = _pc.custom_margins.left;
				if (typeof _pc.custom_margins.top != 'undefined')
					_doc.margins.top = _pc.custom_margins.top;
				if (typeof _pc.custom_margins.right != 'undefined')
					_doc.margins.right = _pc.custom_margins.right
				if (typeof _pc.custom_margins.bottom != 'undefined')
					_doc.margins.bottom = _pc.custom_margins.bottom;

			}
		}
		_doc.width = mediaSizes[_doc.media].width || mediaSizes[_doc.media].width_microns / 1000;
		_doc.height = mediaSizes[_doc.media].height || mediaSizes[_doc.media].height_microns / 1000;
		_doc.receipt = _doc.width < 120;
		return _doc;
	}
	formatCoupon(vars, done) {
		let
			printer = vars.printer,
			coupon = vars.coupon,
			format = vars.format || 'pdf',

			tmppdf = app.system.uuid.get();
		if (!printer) printer = app.printManager.getDefaultPrinter('coupons', 'receipt');
		if (typeof printer == 'string')
			printer = app.data.session.configs.printers[printer];
		if (app.pathExists(printer, 'configs.genericText') == '1')
			format = 'raw';
		if (app.pathExists(printer, 'configs.is_mev') == '1')
			format = 'mev';

		let _getLocale = function (path) {
			return '' + (
				//app.pathExists(app.locales.invoices.coupons, path + '.' + data.clientInfos.language) || 
				app.pathExists(app.locales.invoices.coupons, path + '.fr_CA'));
		}, _p = PM.rawPrintFcts._getPrinterCfg(printer);
		if (format == 'raw' || format == 'mev') {

			//app.system.qrCode.encode({
			//	data: {
			//		type: 'coupon',
			//		id: coupon.id,
			//		code: coupon.coupon_code
			//	},
			//	//toSVG: 1,
			//	size: 130,
			//
			//	saveToFile: app.tmp_folder + tmppdf + '_QR.png',
			//
			//}, function (qrsvg) {
			let _esc = new ESCPOS();
			[
				'%cmds.init%%cmds.resetTxt%%cmds.black%%cmds.center%' +
				'%cmds.size54%' + PM.rawPrintFcts._doBold(_p, { bold: '1' }, app.data.session.configs.branch.name),
				'%cmds.size12%' + '%cmds.lineBreak%%cmds.lineBreak%',
				(coupon.description ? coupon.description : "") + '%cmds.lineBreak%',
				_getLocale('valid_from') + ' ' + coupon.start_date.split(' ')[0] + ' ' + _getLocale('valid_to') + ' ' + coupon.end_date.split(' ')[0] + '%cmds.lineBreak%%cmds.lineBreak%',
				'%cmds.lineBreak%'
			].forEach(function (l) {
				_esc.print(l);
			});
			//_esc.newLine();
			//_esc.newLine();
			//_esc.barcode('PATATE', 'CODE39', { position: 'OFF', width: 1, height: 30 });
			//_esc.newLine();
			//_esc.newLine();
			//_esc.barcode('patate', 'CODE39', { position: 'OFF', width: 1, height: 30 });
			//_esc.newLine();
			_esc.newLine();
			_esc.barcode(coupon.coupon_code, 'CODE39', { position: 'OFF', width: 1, height: 30 });
			_esc.newLine();
			//_esc.newLine();
			//_esc.barcode(app.system.randomInt(99999999, 99999999999999), 'CODE39', { position: 'OFF', width: 1, height: 30 });
			//_esc.newLine();
			//_esc.newLine();
			//_esc.print('%cmds.lineBreak%' + 'QR:%cmds.lineBreak%');
			//console.log('loading image');
			//ESCPOS.Image.load(app.tmp_folder + tmppdf + '_QR.png', function (image) {
			//	console.log('loaded image');
			//	_esc.image(image, 's24').then(function () {

			//_esc.qrcode(coupon.coupon_code, 2, 'L', 40);
			[
				'%cmds.lineBreak%' +
				'CODE: ' + coupon.coupon_code +
				'%cmds.lineBreak%%cmds.lineBreak%%cmds.small%' +
				app._m.moment().format('YYYY-MM-DD HH:mm:ss') + '%cmds.lineBreak%' +
				'%cmds.resetTxt%' +
				'---------------------------' +
				'%cmds.lineBreak%%cmds.lineBreak%%cmds.lineBreak%%cmds.lineBreak%'
			].forEach(function (l) {
				_esc.print(l);
			});
			//console.log(_esc.buffer._buffer);
			done([_esc.buffer._buffer.toString()])
			//done({ mode: 'escpos', buffer: _esc.buffer._buffer.toString('hex') })
			//	})
			//});
			//});
			return;
		}
		else if (format == 'pdf') {
			let _doc = PM.setPrinterPDFMargins(printer);
			let _dpi = 72;
			_doc.availableWidth = mmToPt(_doc.width - _doc.margins.left - _doc.margins.right, _dpi);
			var _margins = { // by default, all are 72
				top: mmToPt(_doc.margins.top, _dpi),
				bottom: mmToPt(_doc.margins.bottom, _dpi),
				left: mmToPt(_doc.margins.left, _dpi),
				right: mmToPt(_doc.margins.right, _dpi)
			}, pdfOptions = {
				layout: 'portrait',
				size: [mmToPt(_doc.width, _dpi), mmToPt(_doc.height, _dpi)],
				margins: _margins
			}
			var doc = new PDFDocument(pdfOptions);
			var _defaultFont = 'Helvetica';
			doc.font(_defaultFont);
			let qrWidthOrig = 26, qrWidth = 0, qrSVG = 84;

			qrWidth = mmToPt(qrWidthOrig, _dpi);
			app.system.qrCode.encode({
				data: {
					type: 'coupon',
					id: coupon.id,
					code: coupon.coupon_code
				},
				//toSVG: 1,
				size: qrWidth * 2,

				saveToFile: app.tmp_folder + tmppdf + '_QR.png',

			}, function (qrsvg) {
				//console.log(qrsvg)

				var file = app._m.fs.createWriteStream(app.tmp_folder + tmppdf + '.pdf');
				doc.pipe(file);
				//doc.addPage();
				//doc.image(app._appPath + 'www/assets/logos/tech-cl/logo_invoice.png', 40, 35, { width: 80 });
				doc.fontSize(14);
				doc.text('', _margins.left, _margins.top)
					.text(app.data.session.configs.branch.name, {
						width: _doc.availableWidth,
						align: 'center',
						ellipsis: true
					});
				doc.fontSize(9);
				//_doc.availableWidth / 2 - qrWidth / 2 +
				let _y = 1 * doc.y;
				doc.image(app.tmp_folder + tmppdf + '_QR.png', _margins.left, _y, { fit: [qrWidth, qrWidth] });
				//SVGtoPDF(doc, qrsvg, _margins.left, _y);


				doc.text('', _margins.left + qrWidth + 3, _y)

				//doc.text('', pdfOptions.margins.left, doc.y)
				//doc.moveDown();
				if (coupon.description) doc.text(coupon.description, {
					width: _doc.availableWidth - qrWidth - 3,
					align: 'center',
					ellipsis: true
				});
				doc.moveDown();
				doc.text(_getLocale('valid_from') + ' ' + coupon.start_date.split(' ')[0] + ' ' + _getLocale('valid_to') + ' ' + coupon.end_date.split(' ')[0] + '', {
					width: _doc.availableWidth - qrWidth - 3,
					align: 'center',
					ellipsis: true
				})
				doc.moveDown();
				doc.text(coupon.coupon_code, {
					width: _doc.availableWidth - qrWidth - 3,
					align: 'center',
					ellipsis: true
				})
				let opts = { margin: 0, width: 1, height: 15, fontSize: 25, displayValue: false };
				if (parseInt(coupon.coupon_code) > 0 && coupon.coupon_code.toString().length == 12) {
					opts.format = 'UPC';
				}
				//In the PdfDocument use doc.image to print the image
				self.generateBarcode(coupon.coupon_code, opts)
					.then((data) => {
						//console.log(barcode)
						//make pdfdocument
						//rest of the document and returning of document

						SVGtoPDF(doc, data.barcode, _margins.left + _doc.availableWidth / 2 - pxToPt(data.attrs.width.replace('px', ''), _dpi) / 2, _y + qrWidth + 15, { width: _doc.availableWidth / 2, height: 15 });

						doc.text('', _margins.left, _y + qrWidth + 15 + 20);
						doc.fontSize(4);

						doc.text(app._m.moment().format('YYYY-MM-DD HH:mm:ss') + '\n---------------------------------------', {
							width: _doc.availableWidth,
							align: 'center',
							ellipsis: true
						})
						doc.end();
						file.on('finish', function () {
							app._m.fs.unlinkSync(app.tmp_folder + tmppdf + '_QR.png');
							if (done) done(app._m.fs.readFileSync(app.tmp_folder + tmppdf + '.pdf'));
							setTimeout(function () { app._m.fs.unlink(app.tmp_folder + tmppdf + '.pdf', function () { }) }, 1000);
						});
					})
					.catch((reason) => {
						//handle error
						console.error(reason)
					})
			})


		}
	}
	//Generate the barcode
	generateBarcode(data, opts) {
		if (!opts) opts = {};
		console.log('promise');
		return new Promise((resolve, reject) => {
			try {
				console.log('try');
				const xmlSerializer = new XMLSerializer();
				const document = new DOMImplementation().createDocument('http://www.w3.org/1999/xhtml', 'html', null);
				const svgNode = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
				opts.xmlDocument = document;
				JsBarcode(svgNode, data, opts);
				const svgText = xmlSerializer.serializeToString(svgNode);
				let _attrs = {};
				console.log('for');
				for (let i = 0; i < svgNode.attributes.length; i++)
					_attrs[svgNode.attributes[i].name] = svgNode.attributes[i].value;
				console.log('resolve');
				return resolve({ barcode: svgText, attrs: _attrs });
			} catch (er) {
				console.error(er)
				reject(er.message || er);
			}
		})
	}
	getDefaultPrinter(printerType, options) {
		if (!options) options = {};
		if (!printerType)
			printerType = 'receipt';
		var ovr = app._m.xtend.extend({ mev: '' }, self.app.pathExists(app.pos._cfg, 'printers_override.' + printerType) || {});
		var printer = app.pos._cfg.printer[printerType];
		if (!printer || printer == 'none')
			printer = app.pos._cfg.printer[options.fallback || app.pos._cfg.printer.defaultSaleFormat];
		if (!printer || printer == 'none')
			printer = app.pos._cfg.printer[app.pos._cfg.printer.defaultSaleFormat];
		var printers = self.getPrinters({});
		if (printers) {
			for (let p = 0, pL = printers.length; p < pL; p++)
				if (printers[p].id == printer)
					printer = printers[p];
		}
		if (ovr.mev != '' && printer?.configs) {
			if (printer?.configs?.is_mev != ovr.mev)
				console.warn('printer MEV status override!');
			printer.configs.is_mev = ovr.mev;
		}
		self.getPrinterStatus(printer);
		return printer;
	}
	getPrinter(printer) {
		var printers = app.data.session.configs.printers;
		if (typeof printer == 'object' && printer.objectAsIs) {
			self.getPrinterStatus(printer);
			return printer;
		}
		var id = (typeof printer == 'string') ? printer : printer?.id;
		if (printers) {
			for (let p = 0, pL = printers.length; p < pL; p++)
				if (printers[p].id == id) {
					self.getPrinterStatus(printers[p]);
					return printers[p];
				}
		}
		return false;
	}
	getPrinters(vars) {
		let _p = app.data.session.configs.printers;
		if (!_p) {
			return null;
		}
		var _printers = []
		for (let i = 0; i < _p.length; i++)
			_printers.push(app._m.xtend.clone(_p[i]));
		if (vars.localOnly) {
			_printers = _printers.filter(function (a) {
				return a.register == app.system.id;
			});
		}
		if (vars.networkOnly) {
			_printers = _printers.filter(function (a) {
				return a.register == 'NETWORK';
			});
		}
		if (vars.sharedOnly) {
			_printers = _printers.filter(function (a) {
				return a.register != app.system.id;
			});
		}
		if (vars.MEVonly) {
			_printers = _printers.filter(function (a) {
				return a?.peripheralInfo?.is_mev || a?.configs?.is_mev ? true : false;
			});
		}
		if (!vars.noStatus)
			for (let i = 0; i < _printers.length; i++)
				self.getPrinterStatus(_printers[i]);
		return _printers;
	}
	getPrinterStatus(p) {
		if (!p) return;
		if (typeof p == 'object')
			p.latestStatus = _lastSentStatus?.[p?.id] || self.neighbors_printers_status?.[p?.register]?.[p?.id]
		//if (p && p.register == 'NETWORK') {
		//	p.neighborhood = {};
		//	if (app.pathExists(app, 'pos.serverWS.neighbors.list')) {
		//		let r = Object.keys(app.pos.serverWS.neighbors.list).map(function (k) { return app.pos.serverWS.neighbors.list[k]; });
		//		for (let i = 0; i < r.length; i++) {
		//			if (app.pathExists(r[i], 'networking.printersPings.' + p.id + '.status')) {
		//				if (!p.neighborhood) p.neighborhood = {};
		//				p.neighborhood[r[i].deviceUUID] = r[i].networking.printersPings[p.id].status;
		//			}
		//		}
		//	}
		//}
	}
	httpRouter(req, res, next) {
		console.log('printManager route', req.url)

	}
	openPrinterMangagementDialog() {
		//if()
	}
	printViaServer(data, cback) {
		app.pos.serverWS.neighbors.printers.printRequest(data, cback);
	}
	async printLocalFile({ path, type = 'pdf', printer_id = '', cfg = {}, start = new Date().getTime() }) {
		let
			printer = app._m.xtend.clone(self.getPrinter(printer_id));
		if (type == 'raw') return await self.printRAW({ path, configs: cfg, printer })
		return new Promise((resolve) => {
			let
				_copies = cfg?.copies || app.pathExists(printer, 'configs.copies'),
				_pause = cfg?.pauseBetweenCopies || printer?.configs?.pauseBetweenCopies || 0,
				name = app.pathExists(printer, 'peripheralInfo.printerName') || app.pathExists(printer, 'peripheralInfo.deviceName') || app.pathExists(printer, 'deviceName');
			if (_pause) _pause = 1000 * _pause + 1000;
			//return;
			let _printSettings = [];
			if (app.system.vars.systemInfo.platform.indexOf('win') != -1) {
				//if (app.pathExists(data, 'config.copies')) {
				//	if (data.config.copies > 1)
				//		_printSettings.push(data.config.copies + "x");
				//}
				//else if (app.pathExists(data.printer, 'configs.copies') && data.printer.configs.copies > 1)
				//	_printSettings.push(data.printer.configs.copies + "x");

				_printSettings.push("noscale");
				//bin=1 -> select tray #1
				//3x -> 3 copies
				try {
					let _c = '"' + app.baseDir + '\\vendors\\sumatraPDF\\SumatraPDF_' + app.system.vars.systemInfo.platform +
						'.exe" -print-to "' + name + '" -print-settings "' + _printSettings.join(',') + '" "' + path + '"';
					app._m.exec(_c, function (err, stdout, stderr) {
						if (err) console.error('Print error', _c, err.message || err);
						if (stderr) console.warn('Print warn', _c, stderr?.trim());
						let answer = err ? (err.message || err) : (stdout && stdout.trim() ? stdout.trim() : (stderr || '').trim());
						resolve({
							result: err ? 'error' : 'success',
							printerID: '' + printer.id,
							answer: answer || 'no output from SumatraPDF',
							runtime: (new Date().getTime() - start) / 1000
						});

						if (_copies && _copies > 1) {
							_copies--;
							let _doCopies = function () {
								if (_copies > 0) {
									_copies--;
									app._m.exec(_c, function (err, stdout, stderr) {
										setTimeout(function () {
											_doCopies();
										}, _pause || 1000);
									});
									return;
								}
								//fs.unlinkSync(app.tmp_folder + id + '.pdf');
							};
							setTimeout(function () {
								_doCopies();
							}, _pause || 1000);
							return;
						}
						//fs.unlinkSync(app.tmp_folder + id + '.pdf');
					});
				} catch (er) {

					resolve({
						result: 'error',
						message: er.message,
						cmd: _c,
						printerID: '' + printer.id,
						runtime: (new Date().getTime() - start) / 1000
					});
					//fs.unlinkSync(app.tmp_folder + id + '.pdf');
				}
				return;
			}
			//-n copies
			//-o InputSlot=Tray2 tray1, upper, ub, ubin, tray2, lower,lb, lbin, tray3, tray4
			//if (app.pathExists(data, 'config.copies')) {
			//	if (data.config.copies > 1)
			//		_printSettings.push('-n ' + data.printer.configs.copies + ' -o collate=true ');
			//}
			//else if (app.pathExists(data.printer, 'configs.copies') && data.printer.configs.copies > 1)
			//	_printSettings.push('-n ' + data.printer.configs.copies + ' -o collate=true ');

			var _cmd = "lp -o nofitplot -o nopdfAutorotate -o orientation-requested=3 -d '" + name + "' " + _printSettings.join(' ') + path;
			//console.log(_cmd)
			//return;
			app._m.exec(_cmd, function (err, stdout, stderr) {
				if (err) console.error('Print error', _cmd, err.message || err);
				if (stderr) console.warn('Print warn', _cmd, stderr?.trim());
				let answer = err ? (err.message || err) : (stdout && stdout.trim() ? stdout.trim() : (stderr || '').trim());
				let answer_code = null;
				if (answer && answer.indexOf('lp: Unsupported document-format') != -1) answer_code = 'unsupport_document_type';
				resolve({
					result: err ? 'error' : 'success',
					printerID: '' + printer.id,
					code: answer_code,
					answer: answer,
					runtime: (new Date().getTime() - start) / 1000
				});
				if (_copies && _copies > 1) {
					_copies--;
					let _doCopies = function () {
						if (_copies > 0) {
							_copies--;
							app._m.exec(_cmd, function (err, stdout, stderr) {
								setTimeout(function () {
									_doCopies();
								}, _pause || 1000);
							});
							return;
						}
						//fs.unlinkSync(app.tmp_folder + id + '.pdf');
					};
					setTimeout(function () {
						_doCopies();
					}, _pause || 1000);
					return;
				}

				//setTimeout(() => { fs.unlinkSync(app.tmp_folder + id + '.pdf'); }, 1000 * 30);
			});
		});
	}
	print(data, cback) {
		let printer = app._m.xtend.clone(self.getPrinter(data.printer));
		if (typeof data.printer == 'string')
			data.printer = app._m.xtend.clone(printer);
		var done = function (status) {
			if (!data.fromServer && (!status || status.result == 'error' && status.error && ['nothing_to_print', 'no_printer_available'].indexOf(status.error.code) == -1)) {
				//send to server for a 2nd look
				console.warn('Send print request to server')
				self.printViaServer(data, cback);
				return;
			}
			cback(status);
		};
		//self.printViaServer(data, cback);
		//console.warn('OVERRIDEEEEED')
		//return;
		if (printer && printer.register) {
			if (printer.register == 'NETWORK' && printer.deviceUri.indexOf('/dev/usb') !== 0) {
				//if (!app.pathExists(self, '_printerPingStatus.' + printer.id + '.status')){
				//
				//	return;
				//}
				if (app.pathExists(self, '_printerPingStatus.' + printer.id + '.status') != 'up' && !data.noFallback) {
					//can't ping networked printer
					let nblist = app.pathExists(self, 'neighbors_printers_status'), foundMatch = false;
					if (nblist && !app.isEmptyObject(nblist)) {
						let nl = Object.keys(nblist);
						for (let i = 0; i < nl.length; i++) {
							if (!foundMatch && app.pathExists(nblist[nl[i]], printer.id + '.status') == 'up' && app.pos.neighbors.neighborIsConnected(nl[i])) {
								//device x is able to talk to wanted printer, spoof printer's register
								console.log('Sending print via register', nl[i])
								foundMatch = true;
								printer.register = '' + nl[i];
							}
						}
					}
					if (!foundMatch) {
						self.printViaServer(data, cback);
						return false;
					}
				}
			}
			if (printer.register != 'NETWORK' && printer.register != app.system.id) {
				//not me, redirect to ->
				//send print via neighborhood
				//console.log('send print to neighbor', data)
				if (app.pos.neighbors.send(printer.register, { module: 'printManager', action: 'print', data: data }, function (res) {
					done(res);
				})) {
					return;
				}
				if (!app.web.post(printer.register, { path: '/printManager/print', fields: data, opts: {} }, function (e, r, b) {
					if (e) console.error(e, b)
					done(b)
				})) {
					self.printViaServer(data, cback);
				}
				return;
			}
		}
		data.printer = printer;
		//print data.type (text|pdf|raw|mev) on data.printer
		data.type = data.type.toLowerCase();

		if (data.openDrawer) {
			try {
				app.pos.openDrawer(data.openDrawer, function () {
					delete data.openDrawer;
					self._printSwitch(data, done)
				});
				return;
			} catch (er) {
				console.error('cant open drawer', data.openDrawer, er.message || er)
			}
		}
		self._printSwitch(data, done);
	}
	async _printSwitch(data, done) {
		//if (app.isSDK) console.log('printswitch', data)
		switch (data.type) {
			case 'pdf':
				self.printPDF(data, done);
				break;
			case 'url':
				self.printURL(data, done)
				break;
			case 'raw':
			case 'text':
				if (data.printer) {
					let _raw = await self.printRAW(data);
					console.log('RAW', _raw);
					if (_raw?.error != 'not_processed') return done(_raw);
				}
				self.printOrderRAW.init(data, done);
				break;
			case 'mev':
				self.printMEV(data, done);
				break;
			default: console.warn('Unable to print', data)
		}
	}
	printHtml() {

	}
	printURL(data, cback) {
		return new Promise(async (resolve) => {
			let _start = new Date().getTime(), _returned = false, _return = (out) => {
				if (_returned) return false;
				_returned = true;
				resolve(out);
				if (cback) cback(out)
			}

			let url = data.url, _argv = app.pos.parseUrlArgv(url);

			var printer = data.printer || (_argv.usePrinter && _argv.usePrinter != 'default' ? _argv.usePrinter : app.pos.getDefaultSaleFormat());
			printer = self.getDefaultPrinter(printer || _argv?.printer_id);
			//url = 'index.php' + url.split('index.php').pop();

			url = url.split('index.php').pop().split('?')[0].ltrim('/');
			if (printer && printer.id && !_argv?.printer_id) _argv.printer_id = printer.id;

			//more info in AzimutPOS/application/controllers/Sales.php line ~2360
			if (app.pathExists(printer, 'configs.is_mev') == 1)
				url = url.replace('classic', 'MEV');
			else if (app.pathExists(printer, 'configs.genericText') == 1) {
				_argv.RawPrint = 1;
			}
			else {
				_argv.PDF = 1
				_argv.base64output = 1;
				if (app.pathExists(printer, 'configs.pageSize') && app.pathExists(printer, 'configs.printerType') == 'thermal')
					_argv.mediaSize = printer.configs.pageSize;
			}
			_argv.JSON = 1;
			if (/sales\/(print_|)receipt\/([a-z0-9\-]{36})\//.test(url)) {
				_argv.sale_id = url.match(/sales\/(print_|)receipt\/([a-z0-9\-]{36})\//)[2];
			}
			else if (/register_area\/(print_|)receipt\/([a-z0-9\-]{36})\//.test(url)) {
				_argv.sale_id = url.match(/register_area\/(print_|)receipt\/([a-z0-9\-]{36})\//)[2];
			}
			//let _flattenedArgs = app.flattenObject(_argv);
			//url = (url.replace(/\/\/+/g, '/') + '?' + Object.keys(_flattenedArgs).map((a) => a + '=' + encodeURIComponent(_flattenedArgs[a])).join('&')).ltrim('/');
			url = url.
				replace('sales/print_receipt', 'register_area/print_receipt').
				replace('sales/receipt', 'register_area/print_receipt');
			console.info('PRINTING URL', url, _argv)
			let _res = await app.pos.doPOSRequest({
				path: url,
				qs: _argv,
				maxTries: 10
			});
			console.info(_res);
			if (_res.result == 'error') {
				_return(_res);
				return;
			}
			let content = _res.data;
			if (content && content.result == 'success') {
				//console.info('Printing content:', content)
				let _noPrinterError = !printer?.id || printer == 'none';
				let _buffer = content.data ? Buffer.from(content.data, 'base64').toString('binary') : null;
				if (app?.data?.session?.configs?.printer?.no_auto_print == '1' && _argv.autoPrint || _noPrinterError || _argv.invoiceMedia == 'ELE') {
					let _savePDF = false;
					if (app?.data?.session?.configs?.printer?.saveAsPDF?.enabled == '1') {
						//save to folder using invoice number + current date
						_savePDF = true;
						let _path = app._m.path.resolve((app?.data?.session?.configs?.printer?.saveAsPDF?.path || '~/Documents/AzimutPOS/invoices').replace(/^\~/, app.homeDir) + '/' + app._m.moment().format('YYYY-MM-DD'));
						fs.ensureDir(_path, async function (err) {
							if (err) {
								console.warn('error saving', _path, err)
								return false;
							}

							_path = _path + app.pathEnd() + (content?.info?.sale_number ? content?.info?.sale_number + '_' : '') + app._m.moment().format('YYYY-MM-DD_HH-mm-ss') + '.pdf';
							fs.writeFile(_path, _buffer, 'binary', function (err) {
								console.log('Save to file', _path, err)
								_return({
									result: 'success',
									code: 'saved',
									message: 'File locally saved to ' + _path,
									runtime: (new Date().getTime() - _start) / 1000,
									mevWebErrors: content.mevWebErrors || content?.data?.info?.mevWebErrors
								});
							});
							return;
							let _pdf_res = await app.pos.doPOSRequest({
								path: url,
								qs: { ..._argv, singlePage: '1' },
								maxTries: 10
							});
							let _pdfBuffer = _pdf_res?.data?.data ? Buffer.from(_pdf_res.data.data, 'base64').toString('binary') : null;
							_path = _path + app.pathEnd() + (_pdf_res.data?.info?.sale_number ? _pdf_res.data?.info?.sale_number + '_' : '') + app._m.moment().format('YYYY-MM-DD_HH-mm-ss') + '.pdf';
							fs.writeFile(_path, _pdfBuffer, 'binary', function (err) {
								console.log('Save to file', _path, err)
								_return({
									result: 'success',
									code: 'saved',
									message: 'File locally saved to ' + _path,
									runtime: (new Date().getTime() - _start) / 1000,
									mevWebErrors: content.mevWebErrors || _pdf_res.data.data.mevWebErrors || content?.data?.info?.mevWebErrors || _pdf_res.data.data?.info?.mevWebErrors
								});
							});
						});
					}
					if (_argv.invoiceMedia != 'ELE') {
						try {
							var uid = app.system.uuid.get();
							console.info('no printer or printer is none', app.tmp_folder + 'pdf_' + uid + '.pdf')
							app._m.fs.writeFile(app.tmp_folder + 'pdf_' + uid + '.pdf', _buffer, 'binary', function () {
								try {
									nw.Window.open('file://' + app.tmp_folder + 'pdf_' + uid + '.pdf', {
										show: true,
									}, function (win_print) {
										win_print.on('loaded', function () {
											app.pos.win_print = win_print;
											try {
												var
													params = {
														"silent": false,
														"autoprint": false,
														"headerFooterEnabled": false
													};
												win_print.window.print(params);
											} catch (er) {
												console.error(er.message)
											}
											_return({
												result: 'unknown', code: 'fallback',
												mevWebErrors: content.mevWebErrors || content?.data?.info?.mevWebErrors
											});
										});
									});
								} catch (er) {
									console.error(er.message)
								}
							});
						} catch (er) {
							console.error(er.message)
						}
					}
					return;
				}
				let _drawerInfo = {
					drawer: _argv.openDrawer || (content.open_drawer ? 'default' : null),
					sale_id: _argv.sale_id,
					action: 'sale'
				},
					data = {
						printer: app.pathExists(printer, 'id') || null,
						configs: _argv.configs,
						data: content.data,
						type: app.pathExists(printer, 'configs.genericText') == '1' ? 'raw' : 'pdf',
						openDrawer: _drawerInfo.drawer ? _drawerInfo : false
					};
				if (app.pathExists(printer, 'configs.is_mev') == 1) {
					data.type = 'mev';
					data.formatted = true;
				}
				else if (app.pathExists(printer, 'configs.genericText') == '1') {
					//send cut
					data.cut = true;
				}
				if (app.isSDK) {
					let _logData = app._m.xtend.clone(data);
					delete _logData.data;
					console.info('PRINTING DATA', _logData)
				}
				self.print(data, function (res) {
					//console.info('Print result', res)
					if (!res.type) res.type = data.type;
					res.mevWebErrors = content.mevWebErrors || content?.data?.info?.mevWebErrors;
					_return(res);
					//if coupons
					if (content.coupons && content.coupons.length) {
						console.info('COUPONS', content.coupons);
						let _couponsPrinter = self.getDefaultPrinter('coupons', 'receipt');
						app._m.async.eachSeries(content.coupons, function (coupon, n) {
							let _coupon = {
								printer: app.pathExists(_couponsPrinter, 'id') || null,
								data: '',
								type: 'pdf',
								cut: false
							}
							if (app.pathExists(_couponsPrinter, 'configs.is_mev') == 1) {
								_coupon.type = 'mev';
							}
							else if (app.pathExists(_couponsPrinter, 'configs.genericText') == '1') {
								//send cut
								_coupon.type = 'raw';
								_coupon.cut = true;
							}
							if (app.tryCatch(function () {
								self.formatCoupon({ printer: _couponsPrinter, coupon: coupon, format: _coupon.type }, function (cdat) {
									_coupon.data = cdat;

									if (app.tryCatch(function () {
										self.print(_coupon, function (res) {
											console.info('COUPON print result', res);
											n();
										});
									})) {
										console.warn(_coupon)
										n();
									}
								});
							})) {
								console.warn(_coupon)
								n();
							}
						}, function () {

						});
					}
				});
			}
		});
	}
	async printUrl(url) {

		return new Promise(async (resolve) => {
			let
				_argv = app.pos.parseUrlArgv(url),
				_p = _argv.usePrinter && _argv.usePrinter != 'default' ? _argv.usePrinter : (_argv?.printer_id || self.getDefaultPrinter(app.pos.getDefaultSaleFormat()));
			if (!_p?.configs?.is_mev) {
				self.printURL({
					url: url,
					printer: _p
				}, function (res) {
					resolve(res)
				});
				return;
			}
			self.print({
				type: 'url',
				url: url,
				printer: _p
			}, function (res) {
				resolve(res)
			});
		})
	}
	printMEV(data, cback) {
		if (data.printer) {
			if (data.printer.deviceUri && data.printer.register == 'NETWORK') {
				PM.remote.send(data, function (res) {
					cback(res);
				});
				return;
			}
		}
		if (!data.data) {
			console.error('printMEV has no data');
			if (cback) cback({
				result: 'error',
				message: 'printMEV has no data',
				error: 'printMEV has no data'
			});
			return false;
		}
		//Wrap in mev tag if non formatted non transaction (non processed transactions will be processed as other document)
		if (Array.isArray(data.data)) data.data = data.data.join('');
		if (!data.formatted)
			data.data = app.pos.mev.other(data.data);
		let id = app.system.uuid.get(),
			filePath = app.tmp_folder + id + '.txt',
			name = app.pathExists(data.printer, 'peripheralInfo.printerName') || app.pathExists(data.printer, 'peripheralInfo.deviceName') || app.pathExists(data.printer, 'deviceName');
		//format raw slip here...
		data.data = self.replaceCommands(data.data);
		if (!data.data) {
			console.error('printMEV has no data after replaceCommands');
			if (cback) cback({
				result: 'error',
				message: 'printMEV has no data',
				error: 'printMEV has no data'
			});
			return false;
		}
		if (Array.isArray(data.data)) data.data = data.data.join('');
		try {
			fs.writeFileSync(filePath, data.data, { encoding: 'latin1' });
		}
		catch (er) {
			if (cback) cback({
				result: 'error',
				message: 'Unable to save temp file: ' + er.message,
				error: 'Unable to save temp file: ' + er.message,
				printerID: '' + data.printer.id
			});
			return;
		}
		console.log('print MEV', data.data)
		if (app.system.vars.systemInfo.platform.indexOf('win') != -1) {
			let _c = '"' + app.baseDir + '\\vendors\\RawPrint\\RawPrint.exe" "' + name + '" "' + filePath + '"';
			app._m.exec(_c, function (err, stdout, stderr) {
				if (err) console.error('Error printing ' + filePath + ' on ' + name, err.message || err.code || err);
				else if (stderr) console.error('Warning on printing ' + filePath + ' on ' + name, stderr);
				//console.log(err, stdout, stderr);
				setTimeout(() => { fs.unlinkSync(filePath); }, 1000);
				if (cback) cback({
					result: err ? 'error' : 'success',
					error: err,
					printerID: '' + data.printer.id, answer: stdout.trim()
				});
			});
			return;
		}
		app._m.exec("lpr -P '" + name + "' " + filePath + ' -o raw', function (err, stdout, stderr) {
			if (err) console.error('Error printing ' + filePath + ' on ' + name, err.message || err.code || err);
			else if (stderr) console.error('Warning on printing ' + filePath + ' on ' + name, stderr);
			setTimeout(() => { fs.unlinkSync(filePath); }, 1000);
			if (cback) cback({
				result: err ? 'error' : 'success',
				error: err,
				printerID: '' + data.printer.id, answer: (stdout || stderr || '').trim()
			});
		});
	}
	async printPDF(data, cback) {
		let _start = new Date().getTime(), printer;
		if (data.printer) {
			printer = self.getPrinter(data.printer);
			if (!printer?.id)
				printer = self.getDefaultPrinter(data.printer);
		}
		if (!printer?.id)
			printer = self.getDefaultPrinter(app.pos.getDefaultSaleFormat());
		if (printer?.register && printer.register != 'NETWORK' && printer.register != app.system.id) {
			//not me, redirect to ->
			//send print via neighborhood
			//console.log('send print to neighbor', printer.register, data)
			data.printer = '' + printer?.id;
			data.type = 'pdf';
			if (app.pos.neighbors.send(printer.register, { module: 'printManager', action: 'print', data: data, timeout: data.neighbor_timeout }, function (res) {
				cback(res);
			})) {
				return;
			}
			else {
				if (cback) cback({
					result: 'error',
					code: 'unable_to_send',
					message: 'Remote register not available',
					error: 'Remote register not available',
					runtime: (new Date().getTime() - _start) / 1000
				});
			}
			return;
		}
		let id = app.system.uuid.get(),
			name = app.pathExists(printer, 'peripheralInfo.printerName') || app.pathExists(printer, 'peripheralInfo.deviceName') || app.pathExists(printer, 'deviceName'),
			_b = (data.isBuffer ? data.data : Buffer.from(data.data, 'base64')).toString('binary');
		let _hasFileSave = false, _noPrinterError = !printer?.id || !name;
		if (app?.data?.session?.configs?.printer?.saveAsPDF?.enabled == '1') {
			//save to folder using invoice number + current date
			//merge pdf because mevweb
			//https://github.com/coherentgraphics/coherentpdf.js

			let _path = app._m.path.resolve((app?.data?.session?.configs?.printer?.saveAsPDF?.path || '~/Documents/AzimutPOS/invoices').replace(/^\~/, app.homeDir) + '/' + app._m.moment().format('YYYY-MM-DD'));
			fs.ensureDir(_path, function () {
				_path = _path + app.pathEnd() + app._m.moment().format('YYYY-MM-DD_HH-mm-ss') + '.pdf';
				fs.writeFile(_path, _b, 'binary', function () {
					if (_noPrinterError && cback) cback({
						result: 'success',
						code: 'saved',
						message: 'File locally saved to ' + _path,
						runtime: (new Date().getTime() - _start) / 1000
					});
				});
			});
			_hasFileSave = true;
		}
		//console.log(app.tmp_folder + id + '.pdf', _b)
		if (_noPrinterError) {
			if (_hasFileSave) return;
			if (cback) cback({
				result: 'error',
				code: 'no_printer',
				message: 'no printer selected',
				error: 'no printer selected',
				runtime: (new Date().getTime() - _start) / 1000
			});
			return;
		}
		try {
			fs.writeFileSync(app.tmp_folder + id + '.pdf', _b, 'binary');
		}
		catch (er) {
			if (cback) cback({
				result: 'error',
				code: 'file_error',
				message: 'Unable to save temp file: ' + er.message,
				error: 'Unable to save temp file: ' + er.message,
				printerID: '' + data.printer.id,
				runtime: (new Date().getTime() - _start) / 1000
			});
			return;
		}
		await app._asyncWait(300);
		let res = await self.printLocalFile({ path: app.tmp_folder + id + '.pdf', type: 'pdf', printer_id: data.printer.id, cfg: data?.configs || {}, start: _start })
		if (cback) cback(res);
		setTimeout(() => { fs.unlinkSync(app.tmp_folder + id + '.pdf'); }, 1000 * 30);
	}
	replaceCommands(text) {

		if (Array.isArray(text)) {
			let out = [];
			for (let i = 0; i < text.length; i++) {
				//if (text[i].indexOf('%cmd') != -1) {
				let _c = self.replaceCommands(text[i]);
				out = out.concat(Array.isArray(_c) ? _c : [_c]);
				//}
				//out.push()
			}
			return out;
		}
		if (Buffer.isBuffer(text)) return text.toString();
		if (text.indexOf('%cmd') != -1) {
			if (text.indexOf('%%') != -1) {
				let out = [], _t = text.split('%%');
				for (let i = 0; i < _t.length; i++) {
					if (i == 0) _t[i] += '%';
					else if (i == _t.length - 1) _t[i] = '%' + _t[i];
					else _t[i] = '%' + _t[i] + '%';
					let _c = self.replaceCommands(_t[i]);
					out = out.concat(Array.isArray(_c) ? _c : [_c]);
				}
				return out;
			}
			let _cm = null;
			do {
				_cm = text.match(/\%cmd(s|)\.([a-zA-Z0-9_]+)\%/);
				if (_cm && _cm.length > 1) {
					if (_cm[2].indexOf('size') === 0 && /^size([\d]+)$/.test(_cm[2])) {
						let _v = String.fromCharCode(_cm[2].match(/^size([\d]+)$/)[1]).toString(16);
						text = text.replace('%cmd' + (_cm[1] || '') + '.' + _cm[2] + '%', '\x1b\x21' + _v);
					}
					else
						text = text.replace('%cmd' + (_cm[1] || '') + '.' + _cm[2] + '%', _cmds[_cm[2]]);
				}
			} while (_cm && _cm.length > 1);
		}
		return text;
	}
	async readPrinterPaperStatus(uri) {
		return new Promise(async (resolve) => {
			if (!uri) {
				resolve('unsupported');
				return;
			}
			//printer.deviceUri = '/dev/usb/lp2'
			let _type = 'UNKNOWN', _uri = '' + uri, _port;
			if (uri.indexOf('/dev/usb/') != -1)
				_type = 'USB';
			if (uri.indexOf('socket:') === 0 || app.system.net.IP.isPrivate(uri.replace('socket://', '').split(':')[0])) {
				_uri = uri.replace('socket://', '').split(':')[0];
				_port = uri.replace('socket://', '').split(':')[1]
				_type = 'NETWORK';
			}
			if (['USB', 'NETWORK'].indexOf(_type) == -1) {
				resolve('unsupported');
				return;
			}
			//console.log('Get printer paper status', _type, _uri)
			let device = new ESCPOS[_type](_uri, _port),
				_printer = new ESCPOS.Printer(device);
			device.open(function (error) {
				if (error) {
					if (['EHOSTUNREACH', 'ETIMEDOUT'].indexOf(error.code) == -1) console.error(error);
					return;
				}
				//console.log('opened')

				device.device.on('data', function (data) {
					let _result, _status = data.toString('hex');
					//console.log(uri, _status)
					switch (_status) {
						case "12":
						case "16":
							_result = 'OK';
							break;
						case '1e':
							_result = 'near_end';	// Paper near-end is detected by the paper roll near-end sensor
							break;
						case '72':
							_result = 'out_of_paper';	// Paper roll end detected by paper roll sensor
							break;
						case '7e':
							_result = 'out_of_paper';	// Both sensors detect that the printer is out of paper
							break;
					}
					resolve(_result);
					_printer.close();
				});
				device.write(CMDS.DLE);
				device.write(CMDS.EOT);
				device.write(String.fromCharCode(1));
				setTimeout(() => {
					try { _printer.close(); } catch (er) { }
				}, 200);
			})
		})
	}
	printRAW_ESCPOS(data, cback) {
		data.printer.deviceUri = '/dev/usb/lp2'
		console.log('PRINT RAW POS', data)
		let _type = 'USB';
		if (data.printer.deviceUri.indexOf('/dev/usb/') != -1)
			_type = 'SERIAL';
		if (data.printer.deviceUri.indexOf('socket:') === 0)
			_type = 'NETWORK';
		let device = new ESCPOS[_type](data.printer.deviceUri),
			printer = new ESCPOS.Printer(device);
		device.open(function (error) {
			if (error) {
				console.error(error);
				return;
			}
			console.log('opened')
			printer.buffer._buffer = Buffer.from(data.data.buffer, 'hex');
			printer.cut();
			printer.close();
			cback();
		})
	}
	async printRAW(data, cback) {
		return new Promise((resolve) => {
			let
				_done = (res) => {
					resolve(res);
					if (cback) cback(res);
				},
				_copies = data?.configs?.copies || app.pathExists(data.printer, 'configs.copies'),
				_pause = data?.configs?.pauseBetweenCopies || data.printer?.configs?.pauseBetweenCopies || 0;
			if (_pause) _pause = 1000 * _pause + 1000;
			console.log({ ...data, copies: _copies, pause: _pause })
			if (data.printer) {
				if (app.pathExists(data, 'data.mode') && data.data.mode == 'escpos') {
					//is ESC/POS module
					self.printRAW_ESCPOS(data, _done);
					return;
				}
				if (!data?.data?.length && !data.path) {
					_done({
						result: 'error',
						message: 'Nothing to print',
						error: 'Nothing to print',
					});
					return true;
				}
				if (app.pathExists(data, 'printer.configs.is_mev') == '1') {
					//printer is mev, call is_mev
					self.printMEV(data, _done);
					return true;
				}
				if (data.printer.deviceUri && data.printer.register == 'NETWORK') {
					if (data.printer.neighborhood) console.log('NETWORK PRINTER neighbors says:' + JSON.stringify(data.printer.neighborhood))
					data.data = self.replaceCommands(data.data);
					PM.remote.send(data, function (res) {
						//console.log('Result', res)
						_done(res);
					});
					return true;
				}
				//print to normal printer

				let id = app.system.uuid.get(),
					filePath = data.path || app.tmp_folder + id + '.txt',
					name = app.pathExists(data.printer, 'peripheralInfo.printerName') || app.pathExists(data.printer, 'peripheralInfo.deviceName') || app.pathExists(data.printer, 'deviceName');;
				//format raw slip here...
				//console.log(data.data)

				if (!data?.data?.length && !data.path) {
					_done({
						result: 'error',
						message: 'Nothing to print',
						error: 'Nothing to print'
					});
					return true;
				}

				let _dataJoinChar = app.pathExists(data, 'printer.configs.dataJoinChar') == 'none' ? '' : '\n';
				if (data.data && !data.path) {
					if (typeof data.data == 'string') {
						if (data.data.indexOf('HEX:') === 0) {
							data.data = Buffer.from(data.data.replace('HEX:', ''), 'hex').toString();
						}
					}
					else if (Array.isArray(data.data)) {
						for (let i = 0; i < data.data.length; i++) {
							if (data.data[i].indexOf('HEX:') === 0) {
								data.data[i] = Buffer.from(data.data[i].replace('HEX:', ''), 'hex').toString();
							}
						}
					}
					if (data.cut) {
						//_prOut.push('\n\n\n\n\n\n\n\n%cmds.lineBreak%%cmds.lineBreak%');
						try {
							if (typeof data.data == 'string') {
								data.data += '\n\n\n\n' + '%cmds.cut5%';
							}
							else if (Buffer.isBuffer(data.data)) {
								data.data.write('\n\n\n\n' + '%cmds.cut5%')
							}
							else {
								data.data.push('%cmds.lineBreak%');
								data.data.push('%cmds.lineBreak%');
								data.data.push('%cmds.lineBreak%');
								data.data.push('%cmds.lineBreak%');
								data.data.push('%cmds.cut5%');
							}
						} catch (er) {
							console.log(er, typeof data.data, data)
						}
					}
					data.data = self.replaceCommands(data.data);
					try {
						//console.log(data.data)
						let _fileContent = typeof data.data == 'string' ? data.data : data.data.join(_dataJoinChar);
						fs.writeFileSync(filePath, _fileContent);
					}
					catch (er) {
						_done({
							result: 'error',
							message: 'Unable to save temp file: ' + er.message,
							error: 'Unable to save temp file: ' + er.message,
							printerID: '' + data.printer.id
						});
						return true;
					}
				}
				if (!fs.existsSync(filePath)) {

					_done({
						result: 'error',
						message: 'Unable to find temp file: ' + er.message,
						error: 'Unable to find temp file: ' + er.message,
						printerID: '' + data.printer.id
					});
					return;
				}
				//once formatted, send it to printer

				if (app.system.vars.systemInfo.platform.indexOf('win') != -1) {
					var _copiesDone = 0, _doWinRaw = function () {

						let _c = '"' + app.baseDir + '\\vendors\\RawPrint\\RawPrint.exe" "' + name + '" "' + filePath + '"';
						app._m.exec(_c, function (err, stdout, stderr) {
							if (err) console.error('Print error', _c, err.message || err);
							if (stderr) console.warn('Print warn', _c, stderr?.trim());
							_copiesDone++;
							if (_copies > _copiesDone) {
								setTimeout(function () {
									_doWinRaw();
								}, _pause || 1000);

								return;
							}
							if (!data.path) fs.unlinkSync(filePath);
							_done({
								result: err ? 'error' : 'success',
								error: err,
								printerID: '' + data.printer.id, answer: stdout.trim()
							});
						});
					};
					_doWinRaw();
					return true;
				}
				app._m.exec("lpstat -p '" + name + "'", function (err, stdout, stderr) {
					if (err) console.error('Print error', "lpstat -p '" + name + "'", err.message || err);
					if (stderr) console.warn('Print warn', "lpstat -p '" + name + "'", stderr?.trim());
					if (stderr && stderr.indexOf('Invalid destination name') != -1) {
						setTimeout(function () {
							if (!data.path) fs.unlinkSync(filePath);
						}, 1000 * 10);
						console.log(data.printer)
						_done({
							result: 'error',
							error: 'Printer unavailable on this system',
							printerID: '' + data.printer.id,
							answer: (stdout || stderr || '').trim()
						});
						return;
					}
					let _doPrint = function (cbk) {
						app._m.exec("lp -d '" + name + "' " + filePath, cbk || function (err, stdout, stderr) {
							if (err) console.error('Print error', "lp -d '" + name + "' " + filePath, err.message || err);
							if (stderr) console.warn('Print warn', "lp -d '" + name + "' " + filePath, stderr?.trim());
						});
					}
					_doPrint(function (err, stdout, stderr) {
						_done({
							result: err ? 'error' : 'success',
							error: err,
							printerID: '' + data.printer.id, answer: (stdout || stderr || '').trim()
						});
						setTimeout(function () {
							let _copiesArr = [];
							if (_copies > 1) {
								for (let i = 1; i < _copies; i++)
									_copiesArr.push('');
							}
							app._m.async.eachSeries(_copiesArr, function (c, n) {
								_doPrint(function () {
									setTimeout(function () {
										n();
									}, _pause || 1000);
								})
							}, function () {
								setTimeout(function () {
									if (!data.path) fs.unlinkSync(filePath);
								}, 1000 * 5);
							})
						}, _pause || 1000);
					});
				})
				return true;
			}
			_done({
				result: 'error',
				error: 'not_processed'
			});
			return false;
		});
	}

	broadcastPaperStatus(p) {
		let _data = { id: p.id, paperStatus: p.paperStatus };
		app.pos.neighbors.broadcast({
			module: 'printManager',
			action: 'paperStatusUpdate',
			data: _data
		});
		try {
			app.diag.printers.paperStatusUpdate(_data);
		} catch (er) { }
		try {
			app.pos.win.window.APPFCTS.printing.routePOSEvent({ module: 'printing', action: 'paperStatusUpdate', data: _data });
		} catch (er) { }
		app.web.emit({
			module: 'printManager',
			action: 'paperStatusUpdate',
			data: _data
		});
	}
	broadcastPrinterStatus(p) {
		//send to pos server, send to cloud, send to device webview, send to other devices
		let _ping = self._printerPingStatus[p.id];
		let _newStatus = _ping?.status || p.printerStatus;
		if (_newStatus == _lastSentStatus?.[p.id]?.status && new Date().getTime() - _lastSentStatus?.[p.id]?.date < 1000 * 60 * 2) return;
		_lastSentStatus[p.id] = {
			status: '' + _newStatus, ttl: _ping?.ttl, date: new Date().getTime(),
			errorMessage: _ping?.errorMessage || p.printerStatusMessage || null,
			ipAddress: _ping?.ipAddress,
			macAddress: _ping?.macAddress,
			paper: p.paperStatus
		};
		let _data = {
			id: p.id,
			date: _ping?.date ?? new Date().toISOString(),
			ttl: _ping?.ttl,
			status: _newStatus,
			ipAddress: _ping?.ipAddress,
			macAddress: _ping?.macAddress,
			errorMessage: _ping?.errorMessage || p.printerStatusMessage || null,
			paper: p.paperStatus
		};
		app.pos.neighbors.broadcast({
			module: 'printManager',
			action: 'printerStatusUpdate',
			data: _data
		});

		try {
			app.pos.serverWS.neighbors.printers.statusUpdate(_data);
		} catch (er) { }
		try {
			app.diag.printers.statusUpdate(_data);
		} catch (er) { }
		try {
			app.pos.win.window.APPFCTS.printing.routePOSEvent({ module: 'printing', action: 'printerStatusChanged', data: _data });
		} catch (er) { }
		app.web.emit({
			module: 'printManager',
			action: 'printerStatusUpdate',
			data: _data
		});
	}
	printerAdded(p) {
		self.getPrinterMAC(p, function () {
			console.log('PRINTER ADDED!', p.printerName)
			app.web.emit({
				module: 'printManager',
				action: 'printerAdded',
				data: p
			});
		});
	}
	updatePrintersStatus() {

		app.splashscreen.getPrinters().then((printers) => {
			//if (printers.length > 1) { console.warn('PRINTERS', printers) }
			if (printers.length) {
				if (!app.splashscreen._data.printers) app.splashscreen._data.printers = [];
				for (let i = 0; i < printers.length; i++) {
					let _exists = app.splashscreen._data.printers.filter(function (a) {
						return a.id == printers[i].id;
					});
					if (!_exists.length) {
						//new printer
						self.printerAdded(printers[i]);
					}
				}

				for (let i = 0; i < app.splashscreen._data.printers.length; i++) {
					let p = app.splashscreen._data.printers[i];
					let _exists = printers.filter(function (a) {
						return a.id == p.id;
					});
					//console.log(app.splashscreen._data.printers[i].id, 'VS', p.id)
					if (!_exists.length) {
						console.warn('Printer "' + p.printerName + '" has been removed from system')

						//app.web.emit({
						//	module: 'printManager',
						//	action: 'printerRemoved',
						//	data: p.id
						//});
					}
				}
				app.splashscreen._data.printers = printers;
			}
			//app.splashscreen._data.printers = printers;
			if (app.pathExists(app, 'utilities.printers') && app.utilities.printers.length) {
				app._m.async.each(Object.keys(app.utilities.printers), function (i, n) {
					let
						_p = app.utilities.printers[i],
						_s = '' + _p.printerStatus;
					//disabled cauz laser printers....
					//self.readPrinterPaperStatus(_p.printerOptions['device-uri']).then((res) => {
					//	_p.paperStatus = res;
					//})
					if (app.system.vars.systemInfo.platform.indexOf('win') != -1) {
						app._m.exec('Cscript %WINDIR%\\System32\\Printing_Admin_Scripts\\en-US\\Prncnfg.vbs -g -p "' + _p.deviceName + '"', function (err, stdout, stderr) {
							//console.log(err, stdout, stderr)
							if (!err) {
								_p.printerStatus = 'error';
								_p.printerStatusMessage = stderr?.trim() || stdout?.trim();
								if (stdout) {
									stdout = stdout.trim();
									if (stdout.indexOf('Printer status Idle') != -1)
										_p.printerStatus = 'ready';
									if (stdout.indexOf('disabled') != -1)
										_p.printerStatus = 'disabled';
									try {
										_p.printerStatusMessage = _p.printerStatusMessage.
											split('\n').map((a) => a.trim()).filter((a) => a && (a.indexOf('Extended') === 0 || a.indexOf('Detected') === 0 || a.indexOf('Printer status') === 0)).join('\n');
									} catch (er) { }
								}
								if (_s != _p.printerStatus) self.broadcastPrinterStatus(_p);
							}
							n();
						});
						return;
					}

					app._m.exec('lpstat -p "' + _p.deviceName + '"', function (err, stdout, stderr) {
						//console.log(err, stdout, stderr)
						if (!err) {
							_p.printerStatus = 'error';
							_p.printerStatusMessage = stderr?.trim() || stdout?.trim();
							if (stdout) {
								stdout = stdout.trim();
								if (stdout.indexOf('is idle') != -1)
									_p.printerStatus = 'ready';
								if (stdout.indexOf('is not responding') != -1)
									_p.printerStatus = 'unreachable';
								if (stdout.indexOf('disabled') != -1)
									_p.printerStatus = 'disabled';
							}
							if (_s != _p.printerStatus) self.broadcastPrinterStatus(_p);
						}
						n();
					});
				}, function () {

				});
			}
			setTimeout(self.updatePrintersStatus, 1000 * 30);
		});
	}
	generateLabel(data) {
		var item = data.data.item;
		var format = data.data.formats[data.data.template.format]
		var cols = format.type == 'sheet' ? format.cols : 1;
		var rows = format.type == 'sheet' ? format.rows : 1;
		var offsetIncrementY = (mmToPt(mediaSizes[format.media_size].height_microns / 1000) - (format.margins.top + format.margins.bottom + (format.height * rows)) * 72) / rows + format.height * 72;
		var offsetIncrementX = (mmToPt(mediaSizes[format.media_size].width_microns / 1000) - (format.margins.left + format.margins.right + (format.width * cols)) * 72) / cols + format.width * 72;

		var i = 0;
		var firstPage = true;

		var tmppdf = app.system.uuid.get();
		var qrFile = false;
		var qrPath = app.tmp_folder + 'qr_' + tmppdf + '.png';
		var barcodeFile = false;

		var _margins = { // in = 72pt
			top: format.margins.top * 72,
			bottom: format.margins.bottom * 72,
			left: format.margins.left * 72,
			right: format.margins.right * 72,
		}, pdfOptions = {
			layout: format.orientation,
			size: format.mediaSize,
			margins: _margins
		}

		var file = app._m.fs.createWriteStream(app.tmp_folder + tmppdf + '.pdf');
		var doc = new PDFDocument(pdfOptions);
		doc.pipe(file);

		app._m.async.eachSeries(Array(parseInt(data.data.qty) || 1), (_, next_1) => {
			app._m.async.eachSeries(Object.values(data.data.template.elements), (element, next_2) => {

				doc.y = Math.floor(i / format.cols) * offsetIncrementY + format.margins.top * 72;
				doc.x = (i % format.cols) * offsetIncrementX + format.margins.left * 72;
				doc.fontSize(10);
				doc.font('Helvetica')

				switch (element.type) {
					case "text":
						var text;
						switch (element.text) {
							case 'unit_price':
								text = parseFloat(item[element.text]).toFixed(2) + '$';
								break;
							case 'cost_price':
								text = parseFloat(item[element.text]).toFixed(2) + '$';
								break;
							case 'item_name':
								text = item.name;
								break;
							default:
								text = item[element.text];
								break;
						}
						console.log('adding (' + text + ') to PDF');
						doc.text(text, element.x * 72 + doc.x, element.y * 72 + doc.y, {
							width: element.width * 72,
							height: element.height * 72,
							align: element.halign || 'left'
						});
						next_2();
						break;
					case "textCustom":
						doc.text(element.text, element.x * 72 + doc.x, element.y * 72 + doc.y, {
							width: element.width * 72,
							height: element.height * 72,
							align: element.halign || 'left'
						});
						next_2();
						break;
					case "qrcode":
						var addQr = () => {
							qrFile = qrPath;
							doc.image(qrPath, element.x * 72 + doc.x, element.y * 72 + doc.y, {
								width: element.width * 72,
								height: element.height * 72,
								align: element.halign || 'left',
							})
							next_2()
						}
						if (!qrFile) {
							app.system.qrCode.encode({
								saveToFile: qrPath,
								data: {
									item_id: item.item_id,
									variation_id: item.variation_id,
									inventory_batch_id: item.inventory_batch_id,
								}
							}, addQr)
						} else addQr();
						break;
					case "barcode":
						var addBarcode = () => {
							console.log(element.width * 72 + "x" + element.height * 72)
							SVGtoPDF(doc, barcodeFile, element.x * 72 + doc.x, element.y * 72 + doc.y, { assumePt: true, preserveAspectRatio: element.width * 72 + "x" + element.height * 72, height: element.height * 72, width: element.width * 72 })
							next_2();
						}
						try {
							console.log(data.data)
							if (!barcodeFile) {
								self.generateBarcode(item.item_number, { text: ' ', margin: 0, fontSize: 0, fontMargin: 0, width: element.width / element.height }).then(barcode => {
									barcodeFile = barcode.barcode;
									addBarcode();
								});
							} else addBarcode();
						} catch (e) {
							console.error(e);
						}
						break;
				}
			}, () => {
				i++;
				if (i % (format.cols * format.rows) == 0 && !firstPage) {
					doc.addPage();
					i = 0;
				}
				firstPage = false;
				next_1()
			})
		}, () => {
			doc.end();
			file.on('finish', function () {
				console.log(app.tmp_folder + tmppdf + '.pdf')
				if (typeof data.cb === 'function') data.cb(app._m.fs.readFileSync(app.tmp_folder + tmppdf + '.pdf'))
				if (qrFile)
					setTimeout(function () { app._m.fs.unlink(app.tmp_folder + 'qr_' + tmppdf + '.png', () => { }) }, 1000);
				setTimeout(function () { app._m.fs.unlink(app.tmp_folder + tmppdf + '.pdf', () => { }) }, 1000);
			})
		});
	}
};
const POR = class printOrderRAW {
	constructor(parent) {
		this.app = parent;
		//app = this.app;
		PORself = this;
	}
	async init(data, cback, tags = []) {
		return new Promise(async (resolve) => {
			const done = (res) => {
				resolve(res);
				if (cback) cback(res);
			};
			const debug = app.isSDK || data?.data?.debug || data?.debug || (app.data.session.configs.printers || [])?.filter((p) => p?.configs?.advanced?.save_trace_data == '1')?.length ? true : false;
			// MEV
			if (app.pathExists(data, 'printer.configs.is_mev') != '1') {
				let raw = await self.printRAW(data);
				if (raw?.error !== 'not_processed') return done(raw);
			}

			const printers = app.data.session.configs.printers || [];
			if (!printers.length) {
				return done({ result: 'error', code: 'no_printer_available' });
			}

			const d = { ...data.data };
			if (!d.seats) d.seats = [d.items];

			if (debug) console.log('printOrderRaw.processPrinter got data', d)
			// Process chaque imprimante
			const results = await Promise.all(
				printers.map((p) => PORself.processPrinter(d, p, tags, debug))
			);

			if (debug) console.log('printOrderRaw.processPrinter results', results)
			// Garder seulement celles qui ont généré du contenu
			const valid = results.filter((r) => r !== null);

			if (!valid.length) {
				return done({
					result: 'error',
					code: 'nothing_to_print',
				});
			}

			if (debug) console.log('printOrderRaw.processPrinter valid results', valid)
			// Envoi aux imprimantes
			const responses = {};
			let globalResult = 'success';

			await Promise.all(
				valid.map(async ({ payload, printer, saleIds }) => {
					const sent = { ...payload };
					delete sent.printer;

					const res = await self.printRAW(
						app.entities.removeAccents(payload)
						//{ data: app.entities.removeAccents(payload), printer },
					);
					if (debug) console.log('printOrderRaw.processPrinter self.printRAW result', printer.id, res)

					PORself.saveTraceData(d, sent, res, printer);

					if (res?.printerID) {
						responses[res.printerID] = res;
						if (res.status === 'error') globalResult = 'error';
					}
				})
			);

			return done({
				result: globalResult,
				printers: responses,
				processedItems: Object.assign({}, ...valid.map(v => v.processedItems)),
			});
		});
	}
	processPrinter(orderData, printer, tags = [], debug = false) {
		const self = this;
		if (['fb3d8680-4704-11f0-aa4e-2a08945ba9bc', '8b865b50-9ae2-11f0-8e14-2a08945ba9bc'].includes(printer.id)) debug = true;
		if (debug) console.log('printOrderRaw.processPrinter', { orderData, printer, tags });

		const cfg = PM.rawPrintFcts._getPrinterCfg(printer);
		let prOut = ['%cmds.init%'];
		let processedItems = {};
		let prSales = [];
		let orItem = false;
		for (let i of orderData.seats) {
			i.groupSeats = orderData.groupSeats ? true : false;
		}
		if (orderData.groupSeats) {
			// --- Mode regroupé ---
			let seatBlocks = [];

			orderData.seats.forEach((seat) => {
				let seatOut = [];
				let hasPrintedItem = false;

				(seat.items || []).forEach((item) => {
					if (PORself.shouldPrintItem(item, printer, tags, debug)) {
						if (!processedItems[seat.sale_id]) processedItems[seat.sale_id] = [];
						processedItems[seat.sale_id].push(item.sale_item_id);
						prSales.push(seat.sale_id);
						orItem = true;
						hasPrintedItem = true;

						seatOut.push(...PM.rawPrintFcts.invoiceItem(cfg, seat, item));
					}
				});

				if (hasPrintedItem && seat.seat !== undefined) {
					seatBlocks.push(`%cmds.lineBreak%Siège ${seat.seat}%cmds.lineBreak%`, ...seatOut);
				}
			});

			if (orItem) {
				// En-tête global une seule fois
				prOut.push(...PM.rawPrintFcts.invoiceBase(cfg, orderData.seats[0]));
				// Tous les sièges regroupés
				prOut.push(...seatBlocks);
				// Footer global
				prOut.push(...PORself.footerBlock());
			}
		} else {
			// --- Mode normal (non groupé) ---
			orderData.seats.forEach((seat, seatIndex) => {
				let seatOut = [];
				let hasPrintedItem = false;

				(seat.items || []).forEach((item) => {
					if (PORself.shouldPrintItem(item, printer, tags, debug)) {
						if (!processedItems[seat.sale_id]) processedItems[seat.sale_id] = [];
						processedItems[seat.sale_id].push(item.sale_item_id);
						prSales.push(seat.sale_id);
						orItem = true;
						hasPrintedItem = true;

						if (seat.seat !== undefined) {//orderData.groupSeats && 
							seatOut.push(`%cmds.lineBreak%Siège ${seat.seat}%cmds.lineBreak%`);
						}

						seatOut.push(...PM.rawPrintFcts.invoiceItem(cfg, seat, item));
					}
				});

				if (hasPrintedItem) {
					if (!orderData.groupSeats || seatIndex === 0) {
						prOut.push(...PM.rawPrintFcts.invoiceBase(cfg, seat));
					}
					prOut.push(...seatOut, ...PORself.footerBlock());
				}
			});
		}

		if (!orItem) return null;

		return {
			payload: {
				data: prOut,
				sale_ids: prSales,
				printer,
			},
			printer,
			saleIds: prSales,
			processedItems,
		};
	}
	shouldPrintItem(item, printer, tags, debug = false) {
		if (!item?.tags?.length) {
			if (debug) console.warn('printOrderRAW.shouldPrintItem has no tags', item);
			return false;
		}

		const
			printerTags = app.pathExists(printer, 'configs.tags') || [],
			hasPrinterTag = item.tags.some((t) => printerTags.includes(t)),
			matchesFilter = !tags.length || item.tags.some((t) => tags.includes(t));
		if (debug) console.log('printOrderRAW.shouldPrintItem', { printerTags, hasPrinterTag, matchesFilter, itemTags: item.tags })
		return hasPrinterTag && matchesFilter;
	}
	footerBlock() {
		return [
			'%cmds.resetTxt%%cmds.black%',
			'\n\n\n%cmds.lineBreak%%cmds.lineBreak%',
			'%cmds.center%',
			'---------------------------%cmds.lineBreak%',
			'%cmds.small%',
			app._m.moment().format('YYYY-MM-DD HH:mm:ss') + '%cmds.lineBreak%',
			'%cmds.resetTxt%',
			'\n\n\n\n\n\n\n\n%cmds.lineBreak%%cmds.lineBreak%',
			'%cmds.cut5%',
		];
	}

	saveTraceData(raw, sent, received, printer) {
		return printer?.configs?.advanced?.save_trace_data == '1' ? app.pos.doPOSRequest({
			method: 'POST',
			path: 'peripherals/save_trace_data',
			fields: {
				register: app.system.id,
				peripheral: { type: 'printer', id: printer.id, data: printer },
				data: { raw, sent, received },
			},
		}) : null;
	}
};
PM.rawPrintFcts = {
	_getPrinterCfg: function (p) {
		if (!app.pathExists(p, 'configs.twoToneCfg') && app.pathExists(p, 'configs.twoTone') == '1')
			p.configs.twoToneCfg = { enabled: '1', remarks: { enabled: '1' } };
		let _pTT = app.pathExists(p, 'configs.twoToneCfg.enabled') == '1' ? p.configs.twoToneCfg : null,
			_txtSize = app.pathExists(p, 'configs.textSizes') || {},
			_defaultSize = _txtSize && _txtSize.default && _txtSize.default != 'default' ? '%cmds.size' + _txtSize.default + '%' : '%cmds.biggest%';
		return {
			twoTone: _pTT,
			txtSize: _txtSize,
			defaultSize: _defaultSize,
			kitchenPrint: p.configs.kitchenPrint
		};
	},
	_doColor: function (p, f, v) { //called by doSize
		const _p = p && p.defaultSize && p.txtSize ? p : PM.rawPrintFcts._getPrinterCfg(p);
		if (app.pathExists(_p.twoTone, f + '.enabled') == '1') {
			return '%cmds.red%' + v + '%cmds.black%';
		}
		//app.pathExists(_txtSize, 'fields.
		return v;
	},
	_doSize: function (p, f, v) {
		const _p = p && p.defaultSize && p.txtSize ? p : PM.rawPrintFcts._getPrinterCfg(p);
		let _tfs_o = app.pathExists(_p.txtSize, 'fields.' + f + '.size') !== false ? app.pathExists(_p.txtSize, 'fields.' + f) : null;
		let out = '';

		if (_tfs_o && _tfs_o.size != 'default') out += '%cmds.size' + _tfs_o.size + '%';// else out += _p.defaultSize;
		out += '' + PM.rawPrintFcts._doBold(_p, _tfs_o, v);
		if (_tfs_o && _tfs_o.size != 'default') out += '' + _p.defaultSize;
		return PM.rawPrintFcts._doColor(_p, f, out);
	},
	_doBold: function (p, o, v) { //called by doSize
		const _p = p && p.defaultSize && p.txtSize ? p : PM.rawPrintFcts._getPrinterCfg(p);
		let out = '';
		if (app.pathExists(o, 'bold') == '1') out += '%cmds.bold_on%';
		out += '' + v;
		if (app.pathExists(o, 'bold') == '1') out += '%cmds.bold_off%';
		return out;
	},
	invoiceBase: function (p, d) {
		const _p = p && p.defaultSize && p.txtSize ? p : PM.rawPrintFcts._getPrinterCfg(p);
		let _prOut = [
			'%cmds.center%',
			'%cmds.small%',
			'.',
			'%cmds.resetTxt%',
			...Array.from(Array(parseInt(_p?.kitchenPrint?.paddingTop || _p?.configs?.kitchenPrint?.paddingTop || 0)).keys()).map((i) => '%cmds.lineBreak%'),
			_p.defaultSize,
			'%cmds.lineBreak%'
		];
		//console.log('invoicebase', d)
		let _dueDate = '' + d.due_date;
		try {
			if (_dueDate.split(' ')[0] == app._m.moment().tz(app.data.session.configs.branch.timezone).format('YYYY-MM-DD')) _dueDate = _dueDate.split(' ')[1];
		} catch (er) { }
		let _baseItems = ['invoice_number', 'activity', 'due_date', 'customer_phone', 'customer_name'];//order_date
		for (let i = 0; i < _baseItems.length; i++) {
			let _line = '', _value = '' + (d[_baseItems[i]] || '');
			switch (_baseItems[i]) {
				case 'due_date':
					_value = '' + _dueDate;
					break;
				case 'customer_name':
					_value = '' + (d.customer_name || d.employee);
					break;
			}
			if (!_value) continue;
			_line += PM.rawPrintFcts._doSize(_p, _baseItems[i], _value);
			switch (_baseItems[i]) {
				case 'invoice_number':
				case 'due_date':
					_line += '%cmds.lineBreak%';
					break;
			}
			_line += '%cmds.lineBreak%';
			_prOut.push(_line);
		}
		//let _ts = [
		//	d.table ? 'Table ' + d.table : null,
		//	!d.groupSeats && d.seat ? 'Siege ' + d.seat : null
		//].filter((a) => a);
		//if (_ts?.length)
		//	_prOut.push('%cmds.lineBreak%' + _ts.join(', ') + '%cmds.lineBreak%');

		_prOut = _prOut.concat(['%cmds.resetTxt%',
			(app.isSDK ? `%cmds.lineBreak%groupSeats: ${d.groupSeats ? 'oui' : 'non'}%cmds.lineBreak%` : '') +
			'---------------------------' + '%cmds.lineBreak%',
			'%cmds.left%',
			_p.defaultSize]);

		return _prOut;
	},
	invoiceItem: function (_p, d, _it) {
		let _prOut = [],
			_line = '',
			_sloc = {
				SIDE_LEFT: {
					en_CA: '<-- LEFT',
					es_ES: '<-- IZQUIERDO',
					fr_CA: '<-- GAUCHE'
				},
				SIDE_RIGHT: {
					en_CA: 'RIGHT -->',
					es_ES: 'DERECHO -->',
					fr_CA: 'DROITE -->'
				},

			};
		if (_it.qty && !_it.quantity) _it.quantity = _it.qty;

		_line += PM.rawPrintFcts._doSize(_p, 'items.qty', _it.quantity) + ' ';
		_line += PM.rawPrintFcts._doSize(_p, 'items.name', _it.name);
		_line += '%cmds.lineBreak%';
		_prOut.push(_line);
		_line = '';
		let _lineStart = '  ';
		if (_it.remarks && _it.remarks.length) {
			_prOut.push(_lineStart + '%cmds.lineBreak%');
			let _remarks = '';
			for (let r of _it.remarks) {
				_remarks += _lineStart + '* ' + r + '%cmds.lineBreak%';
			}
			_prOut.push(PM.rawPrintFcts._doSize(_p, 'remarks', _remarks));
		}
		if (_it.inclusions && !app.isEmptyObject(_it.inclusions) && Object.keys(_it.inclusions).filter((a) => _it.inclusions[a]?.length)?.length) {
			let _sides = ['SIDE_FULL', 'SIDE_LEFT', 'SIDE_RIGHT'];
			for (let sn of _sides) {
				if (_it.inclusions[sn] && _it.inclusions[sn].length) {
					//--SIDE-- message
					_prOut.push(_lineStart + '%cmds.lineBreak%');
					if (sn != 'SIDE_FULL') {
						_prOut.push('%cmds.' + (sn == 'SIDE_RIGHT' ? 'right' : 'left') + '%');
						_prOut.push(_lineStart + PM.rawPrintFcts._doSize(_p, 'inclusions.' + sn.toLowerCase() + '.title', _sloc[sn][d.language] + '%cmds.lineBreak%'));
						_prOut.push('%cmds.left%');
					}
					let _incl = '';
					for (let inc of _it.inclusions[sn]) {
						if (typeof inc.qty !== 'undefined' && !inc.quantity) inc.quantity = inc.qty;
						if (typeof inc.quantity_purchased !== 'undefined' && !inc.quantity) inc.quantity = inc.quantity_purchased;
						if (inc.quantity != 0)
							_incl += _lineStart + inc.quantity + ' ' + inc.name + '%cmds.lineBreak%';
					}
					_prOut.push(PM.rawPrintFcts._doSize(_p, 'inclusions.' + sn.toLowerCase() + '.items', _incl));
				}
			}
			_prOut.push(_lineStart + '%cmds.lineBreak%');

		}
		return _prOut;
	}
}
PM.remote = {
	send: function (d, c) {
		if (!c) c = function () { };

		if (app.pathExists(d, 'data.mode') && d.data.mode == 'escpos') {
			//is ESC/POS module

			return;
		}

		//print directly to shared printer (network)
		if (d.printer.deviceUri.indexOf('ipp:') === 0) {
			//cups managed printer

			PM.remote.protocols.ipp(d, c);
			return;
		}
		// standard network capable printer
		PM.remote.protocols.net(d, c);

	},
	protocols: {
		ipp: function (d, c) {
			let id = app.system.uuid.get(),
				ipp = require('ipp');
			var printer = ipp.Printer(d.printer.deviceUri);
			var msg = {
				"operation-attributes-tag": {
					"requesting-user-name": app.system.id,
					"job-name": "" + id,
					"document-format": "application/octet-stream"
				},
				"job-attributes-tag": {
					//"print-color-mode": "monochrome",
					//"sides": "one-sided",
					"copies": app.pathExists(d.printer, 'configs.copies') || 1,
					//"orientation-requested": "landscape",
					//"page-ranges": "1-2",
					//"number-up": 2
				},
				data: Buffer.from(d.data.join(''))
			};
			printer.execute("Print-Job", msg, function (err, res) {
				//console.log(err, res);
				if (err) console.error(err);
				if (app.pathExists(res, 'statusCode') == 'successful-ok') {
					var msg = {
						"operation-attributes-tag": {
							'job-uri': res['job-attributes-tag']['job-uri']
						}
					};
					let go = function () {
						printer.execute("Get-Job-Attributes", msg, function (err, res) {
							//console.log(res);
							if (app.pathExists(res, 'statusCode') == 'successful-ok' && res['job-attributes-tag']['job-state'] == 'completed') {
								c({
									result: err ? 'error' : 'success',
									printerID: '' + d.printer.id,
									error: err ? { code: err.code, message: err.message } : stderr,
									job_id: res['job-attributes-tag']['job-id']
								});
								return;
							}
							setTimeout(go, 0);
						});
					};
					go();
					return;
				}
				c({
					result: 'error',
					printerID: '' + d.printer.id
				});
			});
		},
		net: function (d, c) {
			//console.log('PRINT', d.data);
			//return;
			var net = require('net');
			let _tries = 0, _doTry = () => {
				_tries++;
				var
					client = new net.Socket(),
					waitStatus = false,
					timedOut = false,
					t = setTimeout(() => {
						timedOut = true;
						try {
							client.end();
						} catch (er) { }
						try {
							client.destroy();
						} catch (er) { }
						if (_tries < 3) {
							setTimeout(() => {
								_doTry();
							}, 500);
							return;
						}
						if (c) c({
							result: 'error',
							printerID: '' + d.printer.id,
							error: {
								code: 'ETIMEDOUT',
								message: 'ETIMEDOUT'
							}
						});
					}, 1000 * 10);
				client.connect(9100, d.printer.deviceUri, function () {
					console.log('Connected, copies:', d.printer?.config?.copies || 'not set');
					for (let c = 0; c < (app.pathExists(d.printer, 'configs.copies') || 1); c++) {
						for (let i = 0; i < d.data.length; i++) {
							client.write(d.data[i]);
						}
					}
					waitStatus = true;
					client.write('\x10\x04\x01');
					clearTimeout(t);
				});

				client.on('data', function (data) {
					let res = Buffer.from(data).toString('hex').trim();
					if (waitStatus && res == '16') {
						console.log('Print to ' + d.printer.deviceUri + ' succesful');
						if (c) c({
							result: 'success',
							printerID: '' + d.printer.id,
							job_id: ''
						});
						try {
							client.end();
						} catch (er) { }
						client.destroy();
						return;
					}
					console.log('Status received from ' + d.printer.deviceUri + ':"' + res + '"');
				});
				client.on('error', function (err) {
					console.log("Error with printer " + d.printer.deviceUri + ": " + err.message);
					try {
						client.end();
					} catch (er) { }
					try {
						client.destroy();
					} catch (er) { }
					if (['ECONNREFUSED', 'ETIMEDOUT', 'ECONNRESET'].indexOf(err?.code) != -1 && _tries < 3) {
						setTimeout(() => {
							_doTry();
						}, 500);
						return;
					}
					if (c) c({
						result: 'error',
						printerID: '' + d.printer.id,
						error: {
							code: err.code,
							message: err.message
						}
					});
				})

				client.on('close', function () {
					console.log('Connection to ' + d.printer.deviceUri + ' closed');
					try {
						client.destroy();
					} catch (er) { }
				});
			};
			_doTry();
		},
		netcat: function (d, c) {

			let id = app.system.uuid.get(),
				filePath = app.tmp_folder + id + '.txt';
			//format raw slip here...
			fs.writeFileSync(filePath, d.data);
			let cmd = 'cat "' + filePath + '" | netcat -w 1 ' + d.printer.deviceUri + ' 9100';// && echo -e "\x1B@\x1DV1" | nc ' + d.printer.deviceUri + ' 9100
			app._m.exec(cmd, function (err, stdout, stderr) {
				console.log(err, stdout, stderr)
				c({
					result: err ? 'error' : 'success',
					error: err ? err : stderr,
					job_id: ''
				});
			});
		}
	}
};

module.exports = PM;