let app, LED = {
	_enabled: false,
	_init: function (core, cback) {
		app = core;
		LED._queue = core.queueProc.init('blink', 1);
		app._m.fs.ensureDirSync(app.libsHome + 'blink/');
		let blink_src = 'https://d2vh72iz1x8zfl.cloudfront.net/AzimutPOS/libs/blink/blink1-tool-v2.2.0-' +
			(app.cfg.platform.indexOf('win') != -1 ? 'windows' : 'linux') + '-' + (app.isPi ? 'armv7l' : 'x86_64') + '.zip';
		app._m.fs.exists(app.libsHome + 'blink/blink1-tool', function (e) {
			if (!e) {
				//download
				app.system.request.GET(blink_src, { encoding: null }, function (e, r, b) {
					//b is buffer, save to zip
					if (b) {
						app._m.fs.writeFile(app.libsHome + 'blink/blink.zip', b, function () {
							app._m.exec('unzip blink.zip', { cwd: app.libsHome + 'blink' }, function () {
								LED.initialize();
							})
						})
					}

				})
				return;
			}
			try {
				if (app.isPi) {
					app._m.exec('sudo ./blink1-tool --add_udev_rules', { cwd: app.libsHome + 'blink' }, function () { })
				}
			} catch (er) { }
			LED.initialize();
		});
		if (cback) cback();
	},
	initialize: function () {
		app.system.sudo({ cmd: './blink1-tool --add_udev_rules', options: { cwd: app.libsHome + 'blink' } }, function (a, b, c) {
			app._m.exec('./blink1-tool --list | grep serialnum', { cwd: app.libsHome + 'blink' }, function (e, o, w) {
				if (o) {
					if (o.trim().split('\n').filter((a) => a)?.length) {
						LED.solid('blue');
						LED._enabled = true;
					}
				}
			})
		})
	},
	routeGUIaction: function (d, cback) {
		if (!LED._enabled) {
			if (cback) cback({ result: 'error', error: 'unavailable' })
			return;
		}
		switch (d.action) {
			case 'blink':
				LED.blink(d.data.color, d.data.pattern, d.data.ttl, d.data.colorAfter);
				break;
			case 'cycle':
				LED.cycle(d.data.colors, d.data.fade, d.data.ttl, d.data.alternate);
				break;
			case 'off':
				LED.off(d.data.fade);
				break;
			case 'solid':
				LED.solid(d.data.color, d.data.fade, d.data.ttl, d.data.colorAfter);
				break;
			default:
				if (cback) cback({ result: 'error', error: 'invalid_action' })
				return;
		}
		if (cback) cback({ result: 'success' });
	},
	_colors: {
		red: { r: 255, g: 0, b: 0 },
		green: { r: 0, g: 255, b: 0 },
		orange: { r: 255, g: 118, b: 25 },
		blue: { r: 3, g: 22, b: 253 },
		pink: { r: 255, g: 0, b: 255 },
		purple: { r: 132, g: 0, b: 156 },
		teal: { r: 0, g: 255, b: 255 }
	},
	_patterns: {
		fast: [150, 200],
		medium: [400, 600],
		slow: [700, 1100]
	},
	_getBackTimer: null,
	_cycleTimer: null,
	_blinkTimer: null,
	blink: async function (color, p, ttl = false, after = false) {
		if (!LED._enabled) return false;
		//console.log('blink',color,p,ttl,after)
		await LED.off();
		if (!p || typeof LED._patterns[p] == 'undefined')
			p = 'medium';
		var pat = LED._patterns[p];
		var vars = app._m.xtend.extend(app._m.xtend.clone(LED._colors[color]), { m: pat[0] });
		var _current = true;
		LED._send(vars);
		LED._blinkTimer = setInterval(function () {
			_current = !_current;
			if (_current)
				LED._send(vars);
			else
				LED._send({ br: 0, r: 0, g: 0, b: 0, m: pat[0] });
		}, pat[1]);
		if (ttl) {
			LED._getBackTimer = setTimeout(async function () {
				clearInterval(LED._blinkTimer)
				await LED.off();
				if (after) {
					LED.set(after, 300);
				}
			}, 1000 * ttl);
		}
	},
	off: async (fade) => {
		if (!LED._enabled) return false;
		clearInterval(LED._blinkTimer);
		clearTimeout(LED._getBackTimer);
		clearInterval(LED._cycleTimer);
		return await LED._send({ br: 0, r: 0, g: 0, b: 0, m: fade || 0 });
	},
	solid: function (color, fade, ttl, colorafter) {
		if (!LED._enabled) return false;
		//clearInterval(LED._blinkTimer);
		//clearTimeout(LED._getBackTimer);
		//clearInterval(LED._cycleTimer);
		LED.set(color, fade, ttl, colorafter);
	},
	set: async function (color, fade, ttl, colorafter) { //LED.set
		if (!LED._enabled) return false;
		try {
			var c;
			fade = (fade) ? fade : 300;
			if (typeof color == 'object' && color.r && color.g && color.b) {
				c = color;
			}
			else if (typeof LED._colors[color] != 'undefined') {
				c = LED._colors[color];
			}
			else {
				console.log('Wrong color name:' + color);
				return;
			}
			await LED.off();
			var vars = app._m.xtend.extend(app._m.xtend.clone(c), { m: fade });
			LED._send(vars);
			if (ttl && colorafter) {
				LED._getBackTimer = setTimeout(function () {
					LED.set(colorafter, fade);
				}, ttl)
			}
		}
		catch (e) {
			console.log(e);
		}
	},
	cycle: async function (colors, fade, ttl = 500, alternate = false) { //LED.cycle()
		if (!LED._enabled) return false;
		try {

			await LED.off();
			let

				setLed = async (ledNum, colorIndex) => {
					// éteindre l’autre LED
					let otherLed = (ledNum === 0) ? 1 : 0;
					if (alternate) LED._send({ n: otherLed, m: fade, r: 0, g: 0, b: 0 }); // OFF

					// allumer la LED courante
					let vars = app._m.xtend.extend(
						app._m.xtend.clone(LED._colors[_colors[colorIndex]]),
						{ n: ledNum, m: fade }
					);
					return await LED._send(vars);
				},
				curLed = 0,
				curIndex = 0,
				_colors = [];
			for (var i = 0; i < colors.length; i++) {
				if (typeof LED._colors[colors[i]] == 'undefined')
					continue;
				_colors.push(colors[i]);
			}
			// allume la première LED au départ
			setLed(curLed, curIndex);

			// cycle d’alternance
			LED._cycleTimer = setInterval(function () {
				if (alternate) {
					curLed = (curLed === 0) ? 1 : 0; // alterne LED 0 et LED 1
				}
				curIndex++;
				if (curIndex >= _colors.length) {
					curIndex = 0;
				}
				setLed(curLed, curIndex);
			}, ttl);
		}
		catch (e) {
			console.log(e);
		}
	},
	_send: function (vars) {
		if (!LED._enabled) return false;
		return new Promise((resolve) => {
			vars = app._m.xtend.extend(app._m.xtend.clone({
				br: 255,      // brightness
				r: 0,
				g: 255,
				b: 0,
				n: 'all',    // led #
				m: 300       // fade
			}), vars);
			//console.log('blink1-tool -'+(vars.n=='all'?'d':'l')+' '+vars.n+' --rgb '+vars.r+','+vars.g+','+vars.b+' -b '+vars.br)
			app._m.exec('./blink1-tool -' + (vars.n == 'all' ? 'd' : 'l') + ' ' + vars.n + ' --rgb ' + vars.r + ',' + vars.g + ',' + vars.b + ' -b ' + vars.br, { cwd: app.libsHome + 'blink' }, function () {
				resolve();
			});
		});
	},
	shutdown: function () {
		if (!LED._enabled) return false;
		LED.off();
	}
};
module.exports = LED;