var
	_DB_DISABLED = false,
	_loadingCompletedRunCback = {},
	_subscriptions = [],
	oreo = JSON.parse(Buffer.from("eyJrdHkiOiJvY3QiLCJraWQiOiJDVlhUNnV3O" +
		"DV2bGFWTGxHUjVMVlFQWWd2c05yY1k5X3JmU0RWWkhXcFhNIiwidXNlIjoi" +
		"ZW5jIiwiYWxnIjoiQTI1NkdDTSIsImsiOiJRNC1zaHcwUG9OVU5ROTJMMT" +
		"ZHRXZrWGlBQzNEYmV1MmFnQThKRjlSdmZnIn0=", 'bas' + 'e6' + '4').toString()),
	alwaysIndexedFields = ['_id', 'id', 'brand', 'branch', 'register', 'employee', 'customer', 'product', 'date', 'deleted', 'createdAt', 'updatedAt', 'updated'],
	tables_configs = require('./tables.json'),
	//linvodb3 stuff
	//encryptdown, LevelDown, Schemas, LinvoDB, 
	pos, dbPath,
	_tblIndexStatus = {},
	app, NestDB, storage, db = {
		jobs: {},
		_dbs: {},
		_version: 0,
		_lastTxn: '',
		_isConnectedToCloud: false,
		init: function (parent, cback) {
			app = parent.app;
			pos = parent;
			//Schemas = require(__dirname + '/schemas.js');
			NestDB = require('nestdb');
			storage = require('nestdb/lib/storage.js');
			//encryptdown = require('@adorsys/encrypt-down')
			db.transactions.saveQueue = app.queueProc.init('pos.database.transactions.saveQueue', 1);
			//sqlite3 = require('@journeyapps/sqlcipher').verbose();//app.cfg.platform.indexOf('win') != -1 ? 'cross-sqlcipher' : '@journeyapps/sqlcipher'
			//LinvoDB = require("linvodb3");
			//LevelDown = require('leveldown');
			//LinvoDB.defaults.store = { db: LevelDown };
			//encryptdown(LevelDown, { jwk: oreo })
			dbPath = app.cacheDir + 'ds/';
			//LinvoDB.dbPath = app.cacheDir + 'ds/';
			storage.initJRE(oreo).then(function () {
				if (cback) cback();
			});
			setInterval(() => {
				db._isConnectedToCloud = app.web.status == 'online' && app.web.socket.connected && app.web.lastPing.ttl < 1 && new Date(app.web.lastPing.date).getTime() > new Date().getTime() - 1000 * 60;

			}, 1000);
		},
		emit: function (obj, cback) {
			obj.module = 'database';
			pos.emit(obj, cback);
		},
		call_subscriptions: function (table, entity_id, action, data, stack) {
			if (table.indexOf('TRANSACTIONS') != -1) return false;
			if (app.tryCatch(function () {
				let candidates = _subscriptions.filter(function (s) {
					let a = s.matching;
					return (typeof a == 'string') ?
						(a == table || a == table + '.*' ||
							a == table + '.' + entity_id || a == table + '.' + entity_id + '.' + action ||
							a == table + '.*.' + action || a == table + '.' + entity_id + '.*' ||
							a == '*.' + action || a == '*.*' || a == '*') : a.test(table + '.' + entity_id + '.' + action);
				})
				if (candidates.length) {
					for (let i = 0; i < candidates.length; i++) {
						try {
							candidates[i].fct(table, entity_id, action, data);
						} catch (er) {
							console.warn('Error in subscribed', er.message || er, candidates[i].stack);
						}
					}
				}
			})) console.warn(stack);
		},
		insert: function (table, vars, options, cback) {
			let _parent = app.getParentStack({ exclude: [/\/queueproc\.js/, /pos\/database\.js/] });
			console.log('Inserting', table, vars, options)
			return new Promise((resolve) => {
				let _return = (err, doc) => {
					resolve({ err, doc });
					if (cback) cback(err, doc);
				}
				db.manage.open(table, function () {
					console.log('table opened')
					if (app.tryCatch(function () {
						if (typeof options == 'function' && !cback) {
							cback = options;
							options = {};
						}
						if (!vars.indexes && !vars.data) {
							vars = { data: vars };
						}
						if (!vars.data._id) {
							vars.data._id = '' + app.system.uuid.get();
						}



						//console.log('INSERT, raw data for', table, vars)
						vars.data.createdAt = new Date().toISOString();
						vars.data.updatedAt = '' + vars.data.createdAt;
						let values = app._m.xtend.clone(vars.data || {}); //filter with indexes
						delete values.data;

						let _indexed = {};
						let _indexes = app.pathExists(tables_configs, table + '.indexes') || [];
						if (_indexes != '*' && vars.indexes && vars.indexes.length) {
							_indexes = _indexes.concat(vars.indexes.filter(function (a) { return _indexes.indexOf(a) == -1; }));
						}
						if (!_indexes || _indexes == '*' || !_indexes.length) {
							//all
							_indexed = app._m.xtend.extend(_indexed, values);
						}
						else {
							_indexes = _indexes.slice(0).concat(alwaysIndexedFields.slice(0));
							//filter values
							for (let i = 0; i < _indexes.length; i++) {
								let _a = app.pathExists(vars.data, _indexes[i]);
								if (typeof _a != 'undefined')
									app.pathToObject(_indexed, _indexes[i], _a);
							}
						}
						console.log('Indexes', _indexes)

						console.log('indexing', table, _indexed)
						db._dbs[table].insert(_indexed, function (err, doc) {
							console.log('inserted', err, doc)
							if (app.tryCatch(function () {
								if (err) {
									_return(err, doc);
									console.error(table, vars.data._id, err.message, _indexed)
									return false;
								}
								if (table == 'TRANSACTIONS_BCAST_QUEUE') {
									//broadcast to all nodes vs broadcast to X% of the nodes.... to quorum or not to quorum...
								}
								if (options.forceDataFile || table.indexOf('TRANSACTIONS') == -1) { //forceDataFile is for receiver only
									let _opts = app._m.xtend.clone(options);
									_opts.skipTrans = 1;
									db.saveData(table, vars.data, _opts, function (err, numr, sum, _update) {
										//console.log('DATA SAVED', err, numr, sum, _update)
										if (_update) {
											//console.warn('update', _update)
											vars.data = app._m.xtend.extend(vars.data, _update);
										}
										_parent = 'from db.saveData\n' + _parent;
										db.call_subscriptions(table, vars.data._id, 'insert', vars.data, _parent);
										if (!options.skipTrans) {
											db.transactions.save({ table: '' + table, type: 'insert', data: vars }, function () {
												if (!options.skipWaitTxnSaved) _return(err, doc);
											});
											if (!options.skipWaitTxnSaved) return;
										}
										_return(err, doc);
									});
									return;
								}
								_return(err, doc);
								db.call_subscriptions(table, vars.data._id, 'insert', vars.data, _parent);
							})) console.warn(_parent);
						});
					})) console.warn(_parent);

					//transaction will be saved with .on('inserted') event
				});
				return true;
			});
		},
		update: function (table, query, update, options, cback) {
			let _parent = app.getParentStack({ exclude: [/\/queueproc\.js/, /pos\/database\.js/] });

			return new Promise((resolve) => {
				let _return = (err, numReplaced, affectedDocs) => {
					resolve({ err, numReplaced, affectedDocs });
					if (cback) cback(err, numReplaced, affectedDocs);
				}
				if (!Object.keys(update).filter(function (a) { return a.indexOf('$') == 0; }).length)
					update = { $set: update };
				db.manage.open(table, function () {
					if (typeof options == 'function' && !cback) {
						cback = options;
						options = {};
					}
					let _skipWaitAllSaved = options.skipWaitAllSaved ? 1 : 0;
					delete options.skipWaitAllSaved;
					options.returnUpdatedDocs = true;

					let _indexed = {};
					let _indexes = app.pathExists(tables_configs, table + '.indexes') || [];
					if (_indexes != '*' && update.indexes && update.indexes.length) {
						_indexes = _indexes.concat(update.indexes.filter(function (a) { return _indexes.indexOf(a) == -1; }));
					}
					if (!_indexes || _indexes == '*' || !_indexes.length) {
						//all
						_indexed = app._m.xtend.extend(_indexed, update.$set);
					}
					else {
						_indexes = _indexes.slice(0).concat(alwaysIndexedFields.slice(0));
						//filter values
						for (let i = 0; i < _indexes.length; i++) {
							let _a = app.pathExists(update.$set, _indexes[i]);
							if (typeof _a != 'undefined')
								app.pathToObject(_indexed, _indexes[i], _a);
						}
					}
					let _indexedUpdate = app._m.xtend.clone(update);
					_indexedUpdate.$set = _indexed;
					delete _indexedUpdate.$set._id;
					//console.info(table, 'update', query, update)
					db._dbs[table].update(query, _indexedUpdate, options, function (err, numReplaced, affectedDocs) {
						if (err) {
							console.error(err.message || err, query, _indexedUpdate);
						}
						else {
							if (table == 'TRANSACTIONS_BCAST_QUEUE') {
								//broadcast to all nodes vs broadcast to X% of the nodes.... to quorum or not to quorum...
							}
							if (affectedDocs && table.indexOf('TRANSACTIONS_BCAST_QUEUE') == -1 && !options.skipData) {
								if (!Array.isArray(affectedDocs))
									affectedDocs = [affectedDocs];

								app._m.async.each(affectedDocs, function (d, n) {
									//console.log(table, 'update data')
									db.updateData(table, app._m.xtend.extend({ _id: d._id }, update.$set), app._m.xtend.extend(app._m.xtend.clone(options), { skipTrans: 1 }), function (err, numr, replaced, _update) {
										update = app._m.xtend.extend(update, { $set: _update });
										_parent = 'from db.updateData\n' + _parent;
										db.call_subscriptions(table, d._id, 'update', update, _parent);
										if (table.indexOf('TRANSACTIONS') == -1 && !options.skipTrans) {
											//save transaction
											let _opts = app._m.xtend.clone(options);
											delete _opts.returnUpdatedDocs;
											delete _opts.multi;
											delete _opts.upsert;
											delete _opts.skipTrans;
											db.transactions.save({ table: '' + table, type: 'update', data: { _id: d._id, update: update, options: _opts } }, function () {
												n();
											});
											return;
										}
										n();
									});
								}, function () {
									if (!_skipWaitAllSaved) _return(err ? err.message || err : null, numReplaced, affectedDocs);
								})
								if (_skipWaitAllSaved) _return(err ? err.message || err : null, numReplaced, affectedDocs);
								return;
							}
						}
						_return(err ? err.message || err : null, numReplaced, affectedDocs);
					});
				});
				return true;
			});
		},
		//https://github.com/JamesMGreene/nestdb#counting-documents
		count: (table, filters, cback) => {
			return new Promise((resolve) => {
				let _return = (err, res) => {
					resolve({ err, res });
					if (cback) cback(err, res);
				}
				db.manage.open(table, function () {
					db._dbs[table].count(filters, _return);
				});
			});
		},
		remove: function (table, id, options, cback) {
			return new Promise((resolve) => {
				let _return = (err, res) => {
					resolve({ err, res });
					if (cback) cback(err, res);
				}
				if (typeof options == 'function' && !cback) {
					cback = options;
					options = {};
				}
				db.manage.open(table, function () {
					db._dbs[table].remove({ _id: id }, {}, function (err, numrem) {
						console.log(err, numrem);
						_return(err, numrem);
						if (numrem) {
							db.removeData(table, id, function () {
								console.log('data removed')
							})
						}
						if (table.indexOf('TRANSACTIONS') == -1 && !options.skipTrans)
							db.transactions.save({ table: '' + table, type: 'remove', data: { _id: id } });
					});
				});
			});
		},
		find: function (table, query = {}, options = {}, cback) {
			return new Promise((resolve) => {
				if (typeof options == 'function' && !cback) {
					cback = options;
					options = {};
				}
				let _return = (err, res) => {
					resolve({ err, res });
					if (cback) cback(err, res);
				}
				let _includeData = options.includeData ? (typeof options.includeData == 'boolean' ? {} : options.includeData) : {},
					_getFromCloud = function (opts, fback) {
						if (typeof opts == 'function') {
							fback = opts;
							opts = {};
						}
						if (table == 'table_index' || table.indexOf('TRANSACTION') != -1 || options.noCloud) {
							fback();
							return false;
						}
						if (options.getFromCloud || opts.force) {// || db._isConnectedToCloud to force cloud first
							if (db._isConnectedToCloud) {
								db.emit({
									action: 'db.find',
									data: {
										table: table,
										query: query,
										options: options
									}
								}, function (res) {
									//console.log(res)
									if (res) {
										if (res.data && res.data) {
											_return(null, res.data);//Array.isArray(res.data) ? res.data[0] : res.data)
											return;
										}
										console.warn('db.find from cloud', table, query, res)
									}
									fback();
								});
								return true;
							}
							console.warn('NOT CONNECTED TO CLOUD!')
						}
						fback();
						return false;
					};
				_getFromCloud(function () {
					db.manage.open(table, function () {
						if (query._id) {
							db._dbs[table].findOne({ _id: query._id }, function (err, doc) {
								if (err || !doc) {
									_getFromCloud({ force: 1 }, function () {
										_return(err, doc)
									});
								}
								else if (!options.includeData) {
									_return(err, doc)
								} else {
									db.getData(table, query._id, _includeData, function (data) {
										if (data && data.data) {
											doc = app._m.xtend.extend(data.data, doc);
										}
										else
											doc.data = data;
										_return(null, doc);
									});
								}
							});
							return;
						}
						let _f = db._dbs[table].find(query);
						if (!query._id && options.sort) _f.sort(options.sort);
						if (!query._id && options.skip) _f.skip(options.skip);
						if (!query._id && options.limit) _f.limit(options.limit);
						_f.exec(function (er, documents) {
							if (er || !documents || !documents.length) {

								_getFromCloud({ force: 1 }, function () {
									_return(er, documents)
								});
							}
							else if (!options.includeData) {
								_return(er, documents)
							} else {
								app._m.async.eachSeries(documents, function (d, n) {
									db.getData(table, d._id, _includeData, function (data, err) {
										//console.log('DATA', data, err)
										if (data && data.data) {
											d = app._m.xtend.extend(d, data.data);
										}
										else
											d.data = data;
										n();
									});

								}, function () {
									_return(er, documents);
								})
							}
						});
					});
				})
			})
		},

		getDataFileNameAndPath: function (table, id) {
			let _f = db.getDataFolderPath(table, id),
				_fn = (id == 'main' ? 'obe.lix' : app.system.crypto.hash(table + id, 'sha1') + '.tar.bz2');
			return (_f + '/' + _fn).replace(/\/\//, '/');
		},
		getDataFolderPath: function (table, id) {
			let _fp = db.manage.getFolderPath(table),
				_s = id.split('-');
			return _fp + (id == 'main' ? '' : 'obi.wan/' + _s[2] + '.iso/' + _s[3] + '.lbr/' + _s[1] + '.sbx');
		},
		getFileChecksum: function (table, id, options, cback) {
			if (typeof options == 'function' && !cback) {
				cback = options;
				options = {};
			}
			if (options.getFromNeighbors) {
				let keys, _out = {};
				if (options.registers) keys = options.registers.slice(0);
				if (!keys || !keys.length) {
					let _keys = pos.neighbors.getNeighbors({ connectedIdsOnly: 1 });
					if (_keys && _keys.ids && _keys.ids.length)
						keys = _keys.ids.slice(0);
				}
				if (keys && keys.length) {
					app._m.async.each(keys, function (i, n) {
						pos.neighbors.send(i, {
							module: 'pos',
							action: 'event',
							data: {
								module: 'database',
								action: 'getFileChecksum',
								data: {
									table: table,
									id: id
								}
							}
						}, function (data) {
							_out[i] = data;
							n();
						});
					}, function () {
						cback(options.asArray ? Object.keys(_out).map(function (k) { if (_out[k]) _out[k].register = k; return _out[k]; }).filter(function (a) { return a; }) : _out);
					});
					return;
				}
				cback(null);
				return;
			}
			let f = db.getDataFileNameAndPath(table, id);
			app._m.fs.exists(f, function (exists) {
				if (!exists) {
					cback(null);
					return;
				}
				let
					_out = {},
					_fcts = [
						function (n) {
							app._m.fs.stat(f, function (e, s) {
								_out = app._m.xtend.extend(_out, {
									mtime: s.mtime.toISOString(),
									ctime: s.ctime.toISOString(),
									size: s.size
								});
								n();
							});
						},
						function (n) {
							app.hash.File(f, 'sha1', function (h) {
								_out.checksum = h;
								n();
							});
						}
					];
				app._m.async.each(_fcts, function (f, n) {
					f(n);
				}, function () {
					cback(_out);
				});
			});
		},
		//get entry data, stored as encrypted file
		getData: function (table, id, options, cback) {
			return new Promise((resolve) => {
				let _return = (res, err) => {
					resolve({ err, res });
					if (cback) cback(res, err);
				}
				if (typeof options == 'function' && !cback) {
					cback = options;
					options = {};
				}
				let _f = db.getDataFileNameAndPath(table, id);
				//console.log('get data from file', _f)
				if (options.getFilePathOnly) return _f;
				if (options && options.getFromNeighbor && typeof options.getFromNeighbor == 'string' && db.getDatabaseFromNeighbor(table, id, {
					skipChecksums: options.skipChecksums,
					getFrom: options.getFromNeighbor
				}, _return)) {
					return;
				}
				app._m.fs.exists(_f, function (exists) {
					if (exists) {
						let _out = {}, _fcts = [
							function (n) {
								app.hash.File(_f, 'sha1', function (h) {
									_out.checksum = h;
									n();
								});
							},
							function (n) {
								storage.read(_f, function (err, data) {
									if (err) console.error('Error reading database record', table, id, err.message || err)
									//console.log('storage read file data', _f, err, data);
									if (/\}\n\{/.test(data)) {
										//multiline json appended
										_out.data = id == 'main' ? [] : {};
										let _dat = data.split('}\n{');
										for (let i = 0; i < _dat.length; i++) {
											if (i == 0) _dat[i] = _dat[i] + '}';
											else if (i == _dat.length - 1) _dat[i] = '{' + _dat[i];
											else _dat[i] = '{' + _dat[i] + '}';
											if (id == 'main') {
												_out.data.push(JSON.parse(_dat[i]));
											}
											else {
												//console.log('appending', _dat[i])
												app._m.xtend.extend(_out.data, JSON.parse(_dat[i]));
											}
										}
										if (id == 'main')
											_out.data = _out.data.join('\n')
									}
									else
										_out.data = data.indexOf('{') === 0 ? JSON.parse(data) : data;

									delete _out.data.checksum;
									delete _out.data.updatedAt;
									n();
								})
							}
						];
						app._m.async.each(_fcts, function (f, n) {
							f(n);
						}, function () {
							if (options.expectedChecksum && _out.checksum != options.expectedChecksum) {
								if (options && options.getFromNeighbor && db.getDatabaseFromNeighbor(table, id, _return)) {
									return;
								}
								if (!options.allowStaleData) {
									_return(null, { error: 'stale_data_now_allowed' });
									return;
								}
								_out.is_stale = true;
							}
							_return(_out);
						})
						return;
					}
					//get from other reg?
					if (options && options.getFromNeighbor && db.getDatabaseFromNeighbor(table, id, _return)) {
						return;
					}
					_return(null, { error: 'not_found' });
				})
			});
		},
		removeData: function (table, id, cback) {
			return new Promise((resolve) => {
				let _return = () => {
					resolve();
					if (cback) cback();
				}

				let _f = db.getDataFileNameAndPath(table, id);
				console.log('remove data from file', _f)
				app._m.fs.exists(_f, function (exists) {
					if (exists) {
						fs.unlink(_f, function (err) {
							_return();
						})
						return;
					}
					_return();
				});
			});
		},
		saveData: function (table, data, options, cback) {
			return new Promise((resolve) => {
				let _return = (err, numReplaced, sums, _update) => {
					resolve({ err, numReplaced, sums, _update });
					if (cback) cback(err, numReplaced, sums, _update);
				}
				if (typeof options == 'function' && !cback) {
					cback = options;
					options = {};
				}
				//console.log('SAVE DATA', data);
				app.queueProc.init('pos.saveData_' + table + '_' + data._id, 1).add({}, function (_, done) {

					//_isSaving[table]=true;
					let _f = db.getDataFileNameAndPath(table, data._id);
					if (!options.fromTransaction) {
						delete data.checksum;
						delete data.mtime;
						delete data.updatedAt;
					}
					app._m.fs.ensureDir(app._m.path.dirname(_f), function () {
						app._m.fs.exists(_f, function (exists) {
							app.tryCatch(function () {
								storage[options.isAppend ? 'append' : 'write'](_f, JSON.stringify(data), function (err) {
									if (err) {
										_return(err);
										done();
									}
									else {
										if (options.fromTransaction) {
											_return(null);
											done();
											return;
										}
										data.updatedAt = new Date().toISOString();
										//get file checksum
										db.getFileChecksum(table, data._id, {}, function (sums) {
											//console.info(table, 'saveData update', data._id, sums)
											let _update = { updatedAt: data.updatedAt, checksum: sums.checksum, mtime: sums.mtime };
											db._dbs[table].update({ _id: data._id }, { $set: _update }, function (err, numReplaced) {
												if (err) {
													console.error(err);
												}
												else {
													//console.info(table, 'saveData updated', data._id)
													//save transaction
													if (!options.fromTransaction && !options.skipTrans && table.indexOf('TRANSACTIONS') == -1 && exists) {
														db.transactions.save({ table: '' + table, type: 'update', data: { _id: data._id, update: { $set: _update }, options: {} } }, function () {
															_return(err, numReplaced, sums, _update);
															done();
														});
														return;
													}
												}
												_return(err, numReplaced, sums, _update);
												done();
											});
										})
									}
								})
							})
						})
					})
				});
			});
		},
		updateData: function (table, d, options, cback) {
			return new Promise((resolve) => {
				let _return = (err, numReplaced, sums, _update) => {
					resolve({ err, numReplaced, sums, _update });
					if (cback) cback(err, numReplaced, sums, _update);
				}
				if (typeof options == 'function' && !cback) {
					cback = options;
					options = {};
				}
				//lock process
				//console.log('updating data', table, d._id)
				db.getData(table, d._id, options, function (data, error) {
					if (app.tryCatch(function () {
						if (!data) data = { data: {} };
						if (!data.data) data.data = {};
						data.data = app._m.xtend.extend(data.data, d);
						//console.log('DATA', data)
						let opt = app._m.xtend.clone(options || {});
						opt.isFromUpdate = true;
						db.saveData(table, data.data, opt, function (err, numReplaced, sums, _update) {
							_return(err, numReplaced, sums, _update);
						})
					})) {
						console.warn(error ? error.message || error : null, data, d)
					}
				});
			});
		},
		getNeighbors: function () {
			return app.pathExists(app.data, 'session.configs.registers') ? Object.keys(app.data.session.configs.registers).filter(function (a) { return a != app.system.id; }).slice(0) : [];
		},

		/**
		 * 
		 * Get data file from connected neighbor. Data file is a single record complete data stored on disk.
		 * For id:'main', you get the full stored index
		 * @param {String} table 
		 * @param {String} id record uuid or "main" for full db index
		 * @param {Object} options
		 * 					@param {String} getFrom register id to get data from
		 * 
		 * @param {Function} cback 
		 */
		getDatabaseFromNeighbor: function (table, id, options, cback) {
			if (typeof options == 'function' && !cback) {
				cback = options;
				options = {};
			}
			let _getData = function (data) {
				//save to local file
				cback(data);
			}
			let keys = pos.neighbors.getNeighbors({ connectedIdsOnly: 1 });
			if (keys && keys.ids && keys.ids.length) {
				keys = keys.ids.slice(0);
				if (options && typeof options.getFrom == 'string') {
					//filter for selected register.
					let _filtered = keys.filter(function (a) { return a == 'REG-' + options.getFrom || a == options.getFrom; });
					if (!_filtered.length) {
						//the requested register is not available
						if (!options.tryOthers) {
							cback(null);
							return;
						}
					}
					else keys = _filtered.slice(0);
				}
				let _getCheckSums = function (_c) {
					if (options.skipChecksums) {
						_c();
						return;
					}
					db.getFileChecksum(table, id, { getFromNeighbors: 1, registers: keys, asArray: 1 }, function (sums) {
						console.log('sums', sums)
						if (sums && sums.length) {
							sums = sums.sort(function (a, b) {
								return a.mtime > b.mtime ? -1 : 1;
							});
							for (let i = 0; i < sums.length; i++) {
								registers.push(sums[i].register);
							}
						}
						_c();
					});

				}

				let registers = [];
				_getCheckSums(function () {
					for (let i = 0; i < keys.length; i++) {
						registers.push(keys[i]);
					}
					let
						_index = 0,
						_tries = 0,
						_doGet = function () {
							//add timer to go next
							if (_index == registers.length) {
								_index = 0;
								_tries++;
								if (_tries == 5) {
									//ask cloud for data
									console.warn('Failed to get data from neighbors 5 times, asking the cloud...')
									return;
								}
							}

							let _timedOut = false, _timedOutFct = function () {
								_timedOut = true;
								console.warn('failed to receive database data from register ' + registers[_index])
								_index++;
								_doGet();
							},
								_timer = setTimeout(_timedOutFct, 1000 * 10);

							pos.neighbors.send(registers[_index], {
								module: 'pos',
								action: 'event',
								data: {
									module: 'database',
									action: 'getData',
									data: {
										//file: _f.replace(dbPath, '')
										table: table,
										id: id
									}
								}
							}, function (data) {
								clearTimeout(_timer);
								clearTimeout(_timedOutFct);
								if (_timedOut) return;
								if (!data) {
									_index++;
									_doGet();
									return;
								}
								console.log('got remote data (from ' + registers[_index] + ') for ' + table + ' ' + id);
								_getData(data);
							}, function () {
								//ack
								clearTimeout(_timer);
								_timer = setTimeout(_timedOutFct, 1000 * 10);
							})
						};
					_doGet();
				});
				return true;
			}

			return false;
		},
		/**
		 * 
		 * MANAGEMENT FUNCTIONS
		 * 
		 */

		transactions: {
			broadCast: function (t, cback) {
				if (app.pathExists(tables_configs, t.table + '.local_only')) {
					if (cback) cback();
					return false;
				}
				//loop each branchs
				let _notifies = [], _sendToCloud = function () {
					if (!_notifies.length) _notifies = db.getNeighbors();
					//send to cloud, eventually
					db.transactions.queue.cloudSync.init();
					if (cback) cback();
				};
				if (app.pathExists(app.data, 'session.configs.registers')) {
					let ids = pos.neighbors.getNeighbors({ connectedIdsOnly: 1 }).ids;
					let keys = db.getNeighbors();

					app._m.async.each(keys, function (k, n) {
						//open branch's queue db and insert
						let _obj = {
							txn_id: t._id,
							_id: '' + app.system.uuid.get(),
							entity_id: t.entity_id,
							register: {
								origin: t.register,
								recipient: k
							},
							date: t.date,
							table: t.table,
							type: t.type,
							received: false,
							processed: false
						};
						db.insert('TRANSACTIONS_BCAST_QUEUE', _obj, function () {
							let _r = app.data.session.configs.registers[k];
							//insert into DB,
							//send event if connected
							if (ids.indexOf(k) != -1) {
								db.transactions.queue.outgoing.init(k);
								//sent directly or via alternate route
							}
							else if (app.pathExists(_r, 'online')) {
								//will be send via cloud
								_notifies.push(k);
							}
							n();
						})
					}, function () {
						_sendToCloud();
					});
					return;
				}
				_sendToCloud();
				//send to cloud

			},
			get: function (query, options, cback) {
				//select transactions matching query
				if (options.register) {
					pos.neighbors.send(options.register, {
						module: 'pos',
						action: 'event',
						data: {
							module: 'database',
							action: 'getTransaction',
							data: {
								id: query._id,
								options: options.options || null
							}
						}
					}, function (d) {
						console.log('getTransaction result', d)
						cback(d.error, d.data);
					}, function (ack) {

					});
					return;
				}

				db.manage.open('TRANSACTIONS', function (tbl) {
					let _includeData = options.includeData;
					delete options.includeData;
					if (!options.sort) options.sort = { date: 1 };
					tbl.find(query, options, function (err, rows) {
						if (err) {
							console.error(err)
							cback(err);
							return;
						}
						if (rows && _includeData) {
							if (Array.isArray(rows) && rows.length) {
								app._m.async.eachSeries(rows, function (r, n) {
									db.getData(r.type == 'insert' ? r.table : 'TRANSACTIONS', r.type == 'insert' ? r.entity_id : r._id, function (data) {
										console.log('tx get data', data);
										r.data = r.type == 'insert' ? data : app.pathExists(data, 'data.data') || app.pathExists(data, 'data') || data;
										delete r.incoming;
										delete r.processed;
										delete r.received;
										n();
									})
								}, function () {
									cback(null, rows);
								});
								return;
							}
							else if (!app.isEmptyObject(rows)) {
								db.getData(rows.type == 'insert' ? rows.table : 'TRANSACTIONS', rows.type == 'insert' ? rows.entity_id : rows._id, function (data) {
									console.log('tx get data', data);
									rows.data = rows.type == 'insert' ? data : app.pathExists(data, 'data.data') || app.pathExists(data, 'data') || data;
									delete rows.incoming;
									delete rows.processed;
									delete rows.received;
									cback(null, rows);
								})
								return;
							}
						}
						cback(null, rows);
					})
				});
			},
			save: function (vars, onSaved) {
				if (app.pathExists(tables_configs, vars.table + '.local_only') || app.pathExists(tables_configs, vars.table + '.local_no_transactions')) {
					if (onSaved) onSaved();
					return false;
				}
				let _t = {
					_id: '' + app.system.uuid.get(),
					branch: '' + pos._cfg.branch.id,
					register: '' + app.system.id,
					employee: app.pathExists(app.pos, 'lastActivity.employee_id') || null,
					date: new Date().toISOString(),
					cloud_synced: false,
					table: '' + vars.table,
					type: '' + vars.type,
					entity_id: '' + (app.pathExists(vars, 'data.data._id') || app.pathExists(vars, 'data._id') || app.pathExists(vars, '_id') || '')
				};
				//console.info('adding transaction to the saveQueue', _t._id)
				db.transactions.saveQueue.add(_t, function (d, n, stack) {
					// note: d = _t
					db.manage.open('TRANSACTIONS', function (tbl) {
						//console.log('Saving transaction', d, 'From:', stack);
						tbl.insert(d, { skipTrans: 1 }, function (err, doc) {
							if (err) console.error(err)
							d.createdAt = doc.createdAt;
							d.updatedAt = doc.updatedAt;
							if (vars.type == 'insert') {
								if (onSaved) onSaved();
								db.transactions.broadCast(d);
								n();
								return;
							}
							let _d = app._m.xtend.extend(app._m.xtend.clone(d), { data: app._m.xtend.clone(app.pathExists(vars, 'data.data') || app.pathExists(vars, 'data')) });
							//console.log('TRANSACTION ' + vars.type, _d)
							db.saveData('TRANSACTIONS', _d, { skipTrans: 1 }, function (err, numr, checksum) {
								d.checksum = checksum;
								if (err) console.error(err);
								if (onSaved) onSaved();
								//send to others and cloud
								db.transactions.broadCast(d);
								n();
							});
						})
					});
				});
			},
			queue: {
				_memQueue: {},//used when register is connected to skip read from db
				_processing: {},
				incoming: { //db.transactions.queue.incoming
					_pendingLoaded: false, //db.transactions.queue.incoming._pendingLoaded
					_queue: {},
					_endNotif: {},
					_processing: {},
					_isProcessing: function (t) {
						return db.transactions.queue.incoming._processing[t] && db.transactions.queue.incoming._processing[t] > new Date().getTime() - 1000 * 60;
					},
					add: function (vars, cback) {
						if (app.status == 'shutdown') return false;
						if (!db.manage.init_completed) return false;
						//check if exists,save to db and answer, call init
						console.log('Incoming transaction queue add', vars);
						//check if exists
						let _return = function (res) {
							if (cback) cback(res);
							//schedule an "end of queue" notification to stimulate the economy
							//db.transactions.queue.incoming._endNotif[table]=setTimeout(function(){
							//
							//},1000*30);
						}

						app.queueProc.init('pos.db.incoming' + vars.table, 1).add({}, function (_, done) {
							db.manage.addToTableIndex(vars.table);
							db.find('TRANSACTIONS', { _id: vars._id }, function (err, exists) {
								if (err) console.error(err, vars._id);
								if (exists) {
									//console.log('exists', exists)
									_return({ result: 'saved', status: 'exists', received: exists.received, processed: exists.processed });
									done();
									return;
								}
								let _gotData = function (tdata) {
									//console.log('New transaction data', tdata)
									try {
										tdata.incoming = true;
										tdata.processed = false;
										tdata.received = new Date().toISOString();
										db.insert('TRANSACTIONS', { data: tdata }, { skipTrans: 1, forceDataFile: 1, fromTransaction: 1 }, function (er, res) {
											console.log('transaction saved', err, res)
											_return({ result: 'saved', status: 'new', received: tdata.received });
											//send to processing
											db.transactions.queue.incoming.init(vars.table);
											done();
										})
									}
									catch (er) {
										console.error(er.message || er, vars)
									}
								}
								if (vars.dataIsIncluded) {
									if (vars.data || vars.type == 'remove') {
										console.log('transaction', vars._id, 'not found, data is included. from:', vars.register);
										delete vars.dataIsIncluded;
										_gotData(vars)
										return;
									}
								}
								console.log('transaction', vars._id, 'not found, request origin', vars.register);
								db.transactions.get({ _id: vars._id }, { register: vars.register, options: { includeData: 1 } }, function (e, tdata) {
									console.log('tdata', tdata)
									if (app.pathExists(tdata, 'checksum') != vars.checksum) {
										console.warn('TRANSACTION CHECKSUM MISMATCH!', vars._id, 'from', vars.register);
									}
									_gotData(tdata);
								})
							})
						});
					},
					_preload: function (ready) {

						db.find('table_index', {}, function (err, list) {
							if (list && list.length) {
								app._m.async.each(list, function (t, n) {
									if (!_tblIndexStatus[t._id]) _tblIndexStatus[t._id] = { status: 'init' }
									db.transactions.queue.incoming._getPending(t._id, { limit: 1 }, function (err, rows) {
										if (rows && rows.length) {
											console.log('PRELOAD ' + rows.length + ' TRANSACTIONS TO PROCESS FOR TABLE ' + t._id)
											db.transactions.queue.incoming.init(t._id);
										}
										n();
									});
								}, function () {
									//start cloud sync
									if (ready) ready();
								})
								return;
							}
							//start cloud sync
							if (ready) ready();
						});
					},
					_getPending: function (t, options, cback) {
						if (app.status == 'shutdown' || !db.manage.init_completed) return false;
						if (typeof options == 'function' && !cback) {
							cback = options;
							options = {};
						}
						options = app._m.xtend.extend({ sort: { date: 1 }, limit: 5 }, options);
						db.find('TRANSACTIONS', {
							$not: {
								register: '' + app.system.id
							},
							table: '' + t,
							incoming: true,
							processed: false
						}, options, function (err, rows) {
							cback(err, rows);
						});
					},
					init: function (t, done) {
						if (app.status == 'shutdown' || !db.manage.init_completed) return false;
						//push to queue
						//if (!db.transactions.queue.incoming._queue[t]) db.transactions.queue.incoming._queue[t] = [];
						//db.transactions.queue.incoming._queue[t].push(d);
						if (db.transactions.queue.incoming._isProcessing(t)) {
							console.info('incoming transactions "' + t + '" already processing');//, db.transactions.queue.incoming._queue[t].length)
							return false;
						}
						db.transactions.queue.incoming._processing[t] = new Date().getTime();
						setTimeout(function () { //wait 5s as new data may arrive from other node
							db.transactions.queue.incoming._loop(t, function () {
								db.transactions.queue.incoming._processing[t] = false;
								if (done) done();
							})
						}, 1000 * 5);
					},
					_loop: function (t, done) {
						if (app.status == 'shutdown' || !db.manage.init_completed) {
							db.transactions.queue.incoming._processing[t] = false;
							return false;
						}
						//if (!db.transactions.queue.incoming._queue[t] || !db.transactions.queue.incoming._queue[t].length) {
						//	db.transactions.queue.incoming._processing[t] = false;
						//	if (done) done();
						//	return false;
						//}
						db.transactions.queue.incoming._processing[t] = new Date().getTime();
						//save to transactions db, execute, update status, answer to sender
						//console.log('processing incoming transaction', t)
						db.transactions.queue.incoming._getPending(t, { limit: 10 }, function (err, rows) {
							if (rows && rows.length) {
								app._m.async.eachSeries(rows, function (r, n) {
									if (app.status == 'shutdown' || !db.manage.init_completed) {
										db.transactions.queue.incoming._processing[t] = false;
										return false;
									}
									db.transactions.queue.incoming._processing[t] = new Date().getTime();
									db.getData('TRANSACTIONS', r._id, function (data) {
										r.data = app.pathExists(data, 'data.data') || app.pathExists(data, 'data');
										console.log('PROCESS TRANSACTION:', t, r, data);
										let _done = function () {
											db.transactions.queue.incoming._processing[t] = new Date().getTime();
											let _date = new Date().toISOString();
											db.update('TRANSACTIONS', { _id: r._id }, { $set: { processed: _date } }, { skipWaitAllSaved: 1, skipTrans: 1, fromTransaction: 1 }, function () {
												//shall we replay all transactions younger than this?
												//send to all, we processed it.

												db.transactions.queue.incoming._processing[t] = new Date().getTime();
												pos.neighbors.broadcast({
													module: 'pos',
													action: 'event',
													data: {
														module: 'database',
														action: 'transactionProcessed',
														data: {
															id: r._id,
															register: app.system.id,
															processed: _date
														}
													}
												});
												n();
											})
										};
										if (r.txtype && !r.type) {
											r.type = r.txtype;
											delete r.txtype;
										}
										switch (r.type) {
											case 'insert':
												db.insert(r.table, { data: r.data }, { skipTrans: 1, fromTransaction: 1 }, function (er, res) {
													if (er) console.error('Error inserting data from transaction ' + t + '.' + r._id, er.message);
													_done();
												})
												break;
											case 'update':

												db.update(r.table, { _id: r.entity_id }, r.data.update || r.data, { skipTrans: 1, fromTransaction: 1 }, function (er, res) {
													if (er) console.error('Error updating data from transaction ' + t + '.' + r._id, er.message);
													else _done();
												})
												break;
											case 'remove':
												db.remove(r.table, r.entity_id, { skipTrans: 1, fromTransaction: 1 }, function (er, res) {
													if (er) console.error('Error removing data from transaction ' + t + '.' + r._id, er.message);
													else _done();
												})
												break;
										}
									})
								}, function () {
									db.transactions.queue.incoming._loop(t, done);
								});
								return;
							}
							db.transactions.queue.incoming._processing[t] = false;
							if (done) done();
						});
					}
				},
				cloudSync: {
					_processing: null,
					_isProcessing: function () {
						return db.transactions.queue.cloudSync._processing && db.transactions.queue.cloudSync._processing > new Date().getTime() - 1000 * 60 * 3;
					},
					init: function (done) {
						try {
							if (app.status == 'shutdown' || !app.sessions.sessionIsSet) return false;
							if (db.transactions.queue.cloudSync._isProcessing()) return false;
							db.transactions.queue.cloudSync._processing = new Date().getTime();

							setTimeout(function () { //wait 5s as new data may arrive
								db.transactions.queue.cloudSync._loop(function () {
									db.transactions.queue.cloudSync._processing = false;
									if (done) done();
								})
							}, 1000 * 5);
						} catch (e) { console.warn('[WIP] Error while starting transactions.queue.cloudSync') }
					},
					_loop: function (done) {
						db.transactions.queue.cloudSync._processing = new Date().getTime();
						db.find('TRANSACTIONS', {
							cloud_synced: false
						}, { sort: { date: 1 }, limit: 100 }, function (err, rows) {
							if (!rows || !rows.length) {
								db.transactions.queue.cloudSync._processing = false;
								if (done) done();
								return;
							}
							app._m.async.eachSeries(rows, function (r, n) {
								r = app._m.xtend.clone(r);
								//check with the cloud if it exists...
								console.info('init sending transaction to cloud', r)
								db.emit({
									action: 'txnExists',
									data: {
										//printQuery: 1,
										//printAnswer: 1,
										//logRawSearchResult: 1,
										source: ["received", "updatedAt"],
										id: r._id
									}
								}, function (res) {
									//console.log('txnExists result', res)

									if (!res) {
										//not found, send it!
										db.transactions.get({ _id: r._id }, { includeData: 1 }, function (e, tdata) {
											delete r.cloud_synced;
											delete r.incoming;
											delete r.processed;
											delete r.received;
											r.id = r._id;
											delete r._id;
											r.data = tdata.data;
											console.info('sending transaction to cloud', r)
											db.emit({
												action: 'newTransaction',
												data: r
											}, function (ans) {
												console.log('CLOUD SYNC newTransaction answer:', ans)
												if (ans && ans.result == 'success') {
													db.transactions.queue.cloudSync.txDoneBcast({ _id: r._id, cloud_synced: ans.received, updatedAt: ans.updatedAt })
													db.update('TRANSACTIONS', { _id: r._id }, { $set: { cloud_synced: ans.received, updatedAt: ans.updatedAt } }, { skipData: r.type == 'insert', skipTrans: 1 }, function () {
														n();
													})
													return;
												}
												setTimeout(function () {
													n();
												}, 1000 * 30)
											});
										});
										return;
									}
									console.log('Cloud sync txnExists:', res);
									db.transactions.queue.cloudSync.txDoneBcast({ _id: r._id, cloud_synced: res.received, updatedAt: res.updatedAt })
									db.update('TRANSACTIONS', { _id: r._id }, { $set: { cloud_synced: res.received, updatedAt: res.updatedAt } }, { skipData: r.type == 'insert', skipTrans: 1 }, function () {
										n();
									})
								})
							}, function () {
								db.transactions.queue.cloudSync._loop(done);
							})
						});
						//
						//if (!_tblIndexStatus[t._id]) _tblIndexStatus[t._id] = { status: 'init',date:new Date().toISOString() }
						//_tblIndexStatus[t._id].status='syncing';
						//_tblIndexStatus[t._id].date=new Date().toISOString();

						//_tblIndexStatus[t._id].status='idle';
						//_tblIndexStatus[t._id].date=new Date().toISOString();
					},
					txDoneBcast: function (d) {
						pos.neighbors.broadcast({
							module: 'pos',
							action: 'event',
							data: {
								module: 'database',
								action: 'cloudSynced',
								data: d
							}
						});
					}
				},
				outgoing: {
					processMissingFromReg: {
						_processing: {}
					},
					_isProcessing: function (id) {
						return db.transactions.queue.outgoing.processMissingFromReg._processing[id] && db.transactions.queue.outgoing.processMissingFromReg._processing[id] > new Date().getTime() - 1000 * 60;
					},
					calculatePending: function () {
						if (app.status == 'shutdown' || !db.manage.init_completed) return false;

						app._m.async.each(db.getNeighbors(), function (r, n) {
							app.pos.db.count('TRANSACTIONS_BCAST_QUEUE', {
								"register.origin": '' + app.system.id,
								"register.recipient": '' + r,
								received: false
							}, function (er, data) {
								_outboundTransactionsCounts[r] = data;
								n();
							});
						}, function () {
							db.emit({
								action: 'pendingOutboundTransactionsCount',
								data: _outboundTransactionsCounts
							})
						});
					},
					init: function (id, done) {
						try {
							if (app.status == 'shutdown') return false;
							if (db.transactions.queue.outgoing._isProcessing(id)) return false;
							db.transactions.queue.outgoing.processMissingFromReg._processing[id] = new Date().getTime();
							db.transactions.queue.outgoing._loop(id, function () {
								db.transactions.queue.outgoing.processMissingFromReg._processing[id] = false;
								if (done) done();
							})
						} catch (e) { console.warn('[WIP] Error while starting transactions.processOutgoing', e.message) }
					},
					_loop: function (id, done) {
						db.transactions.queue.outgoing.processMissingFromReg._processing[id] = new Date().getTime();
						db.find('TRANSACTIONS_BCAST_QUEUE', {
							//"register.origin": '' + app.system.id,
							"register.recipient": id,
							received: false
						}, { sort: { date: 1 }, limit: 10 }, function (err, rows) {
							//console.log(id, err, rows)
							if (!rows || !rows.length) {
								db.transactions.queue.outgoing.processMissingFromReg._processing[id] = false;
								if (done) done();
								return false;
							}

							app._m.async.eachSeries(rows, function (r, n) {
								db.transactions.queue.outgoing.processMissingFromReg._processing[id] = new Date().getTime();
								db.find('TRANSACTIONS', { _id: r.txn_id }, function (err, exists) {
									if (err) console.error(err.message, 'retreiving transaction info for id', r.txn_id);
									if (!exists) {
										console.warn('transaction', r.txn_id, 'has vanished!');
										return;
									}
									//console.log(id, r.txn_id, exists)
									db.transactions.queue.outgoing.processMissingFromReg._processing[id] = new Date().getTime();
									pos.neighbors.send(id, {
										module: 'pos',
										action: 'event',
										data: {
											module: 'database',
											action: 'newTransaction',
											data: {
												_id: exists._id,
												checksum: exists.checksum,
												register: exists.register,
												table: r.table,
												type: r.type
											}
										}
									}, function (res) {
										db.transactions.queue.outgoing.processMissingFromReg._processing[id] = new Date().getTime();
										//cback
										console.log('Sent transaction', id, r.txn_id, res)
										if (res && res.result == 'saved') {
											let _dat = {
												received: res.received || new Date().toISOString()
											};
											if (res.processed) _dat.processed = res.processed;

											db.update('TRANSACTIONS_BCAST_QUEUE', { _id: r._id }, { $set: _dat }, { skipTrans: 1 }, function (err, aff, docs) {
												db.transactions.queue.outgoing.processMissingFromReg._processing[id] = new Date().getTime();
												n();
											});
											return;
										}
										//n();
									}, function () {
										//ack
									})
								});
							}, function () {

								db.transactions.queue.outgoing._loop(id, done);
							});
						})
					}

				}
			}
		},
		manage: {
			addToTableIndex: function (table, options) {
				if (['table_index'].indexOf(table) != -1 || table.indexOf('TRANSACTION') != -1) return false;
				db.find('table_index', { _id: table }, function (err, exists) {
					if (err) console.error(err.message)
					if (!exists) {
						db._dbs.table_index.insert({ _id: '' + table, options: options }, function (err, doc) {
							if (err) console.error('add to table_index:' + table, err.message)

						})
					}
				});
			},
			backup: function (done) {
				db.backupInProgress = true;

			},
			close: function (table) {
				if (!table) {
					//loop all tables and close
				}
				//save and close
				db._dbs[table] = null;
				delete db._dbs[table];
				_tables[table] = null;
				delete _tables[table];
			},
			init: function (options, cback) {
				if (typeof options == 'function') {
					cback = options;
					options = {};
				}
				//console.info('database init')
				try {
					app.splashscreen.win.window.setProgress(85);
					app.splashscreen.setMessage('initialize_database', app.parseLocales('splash.startup_steps.initialize_database'));
				} catch (er) {

				}
				try {
					if (app.pathExists(options, 'useNotifications.setMessage'))
						options.useNotifications.setMessage(app.parseLocales('splash.startup_steps.initialize_database'))
				} catch (er) {

				}
				if (db.manage.init_done) {
					if (!db.manage.init_completed) {
						setTimeout(function () {
							db.manage.init(cback);
						}, 1000 * 30)
						return;
					}
					//console.info('database init already completed')
					if (cback) cback();
					return;
				}
				db.manage.init_completed = 0;
				db.manage.init_done = 1;
				if (_DB_DISABLED) {
					/**
					 * OVERRIDE DB INIT
					 */
					db.manage.init_completed = 1;
					if (cback) cback();
					app.splashscreen.unsetMessage('initialize_database');
					db.transactions.queue.cloudSync.init();
					db.transactions.queue.outgoing.calculatePending();
					return;
				}

				let
					_waitStart = new Date().getTime(),
					_gotDatabase = function () {
						console.info('database init: got database')
						app._m.async.each(Object.keys(tables_configs), function (t, n) {
							if (tables_configs[t].preload)
								db.manage.open(t, { force_init: 1 }, n);
							else n();
						}, function () {
							//app.sessions.doWhenInit(function () {
							//	db.transactions.queue.cloudSync.init();
							//});
							db.manage.init_completed = 1;
							console.info('database init: preload incoming queue')
							db.transactions.queue.incoming._preload(function () {
								console.info('database init: preload done, callback')
								if (cback) cback();
								db.transactions.queue.cloudSync.init();
								db.transactions.queue.outgoing.calculatePending();

								clearInterval(db.jobs.calculatePendingTxns);
								db.jobs.calculatePendingTxns = setInterval(db.transactions.queue.outgoing.calculatePending, 1000 * 60 * 5);
								clearInterval(db.jobs.checkOutgoing);
								db.jobs.checkOutgoing = setInterval(function () {
									if (app.status == 'shutdown' || !db.manage.init_completed) return false;
									let ids = pos.neighbors.getNeighbors({ connectedIdsOnly: 1 }).ids;
									let keys = db.getNeighbors();
									for (k = 0; k < keys.length; k++) {
										if (ids.indexOf(keys[k]) != -1)
											db.transactions.queue.outgoing.init(keys[k])
									}

									db.transactions.queue.cloudSync.init();
								}, 1000 * 30);
								console.info('database init completed')
							});
						})
					},
					_getDbFromCloud = () => {
						app._m.fs.ensureDir(app.cacheDir + 'ds');
						//console.info('database init: download from cloud')
						try {
							app.splashscreen.win.window.setProgress(88);
							app.splashscreen.win.window.setMessage(app.parseLocales('splash.startup_steps.initialize_database_downloading_from_cloud'));
						} catch (er) {

						}
						app._m.async.eachSeries(
							["employees", "production_tasks", "production_qualifications", "production_employee_qualifications", "production_tasks_devices", "production_tasks_qualifications"], function (i, n) {
								db.emit({
									action: 'db.find',
									data: {
										table: i,
										query: {},
										options: { includeData: true }
									}
								}, async (res) => {
									//console.log('table', i, res)
									if (!res?.data) {
										n();
										return;
									}
									db.manage.open(i, { force_init: 1 });
									for (let x of res.data) {
										await db.insert(i, x?.data || x, { skipTrans: 1 });
									}
									n();
								});
							}, function () {
								//console.log('all basic tables loaded');
								_gotDatabase();
							})

						return;
						_gotDatabase();
					},
					_isWaitingForNeighbors = 0,
					_waitNeighbors = function () {
						if (db.manage.init_completed) {
							_gotDatabase();
							return;
						}
						if (!_isWaitingForNeighbors) {
							_isWaitingForNeighbors = 1;
							console.info('database init: wait for neighbors')
							try {
								app.splashscreen.win.window.setProgress(87);
								app.splashscreen.win.window.setMessage(app.parseLocales('splash.startup_steps.initialize_database_waiting_neighbor'));
							} catch (er) {

							}
							try {
								if (app.pathExists(options, 'useNotifications.setMessage'))
									options.useNotifications.setMessage(app.parseLocales('splash.startup_steps.initialize_database_waiting_neighbor'))
							} catch (er) {

							}
						}
						if (app.pathExists(app, 'data.session.result') == 'success') {
							let regs = db.getNeighbors();
							if (regs.length) {
								//console.log('registers', regs)
								//select the lowest ping, maybe lowest cpu usage...
								regs = regs.filter(function (a) { return app.pathExists(app.data, 'session.configs.registers.' + a + '.online'); })
								if (regs && regs.length) {
									console.log('Online registers:', regs.length)
									console.log(pos.neighbors.getNeighbors({ connectedIdsOnly: 1 }))
									let ids = pos.neighbors.getNeighbors({ connectedIdsOnly: 1 }).ids;
									if (ids && ids.length) {
										console.log('Connected registers:', ids.length)
										regs = regs.filter(function (a) { return ids.indexOf(a) != -1; });
										if (regs && regs.length) {
											//regs = ["REG-6C626D4D2278"]
											//regs=regs.sort(function(a))
											let _doTryReg = function () {
												if (!regs?.length) {
													//get db from cloud
													_getDbFromCloud();
													return;
												}
												let _selected = app.pathExists(app.data, 'session.configs.registers.' + regs[0]);
												try {
													app.splashscreen.win.window.setProgress(88);
													app.splashscreen.win.window.setMessage(app.parseLocales('splash.startup_steps.initialize_database_downloading_from') + (_selected.name || _selected.hostname));
												} catch (er) {

												}
												try {
													if (app.pathExists(options, 'useNotifications.setMessage'))
														options.useNotifications.setMessage(app.parseLocales('splash.startup_steps.initialize_database_downloading_from') + (_selected.name || _selected.hostname))
												} catch (er) {

												}
												console.info('Requesting database from', (_selected.name || _selected.hostname))
												pos.neighbors.send(regs[0], {
													module: 'pos',
													action: 'event',
													data: {
														module: 'database',
														action: 'getFullDatabase',
														data: {
														}
													}
												}, function (data) {
													console.log('getFullDatabase result from', (_selected.name || _selected.hostname), data.result)
													if (data.result == 'success' && data.data) {
														app._m.fs.writeFile(app.cacheDir + 'incoming_db.zip', data.data, function (er) {
															if (!er) {

																app.system.unzip({ zip_in: app.cacheDir + 'incoming_db.zip', cwd: app.cacheDir }, function (code) {
																	_gotDatabase();
																});
															}
														})
														return;
													}
													regs.shift();
													_doTryReg();
												});
											};
											_doTryReg();


											return;
										}
									}
								}
								if (new Date().getTime() < _waitStart + 1000 * 60 * 5) {
									//retry
									setTimeout(function () {
										_waitNeighbors();
									}, 1000);
									return;
								}
							}
							_getDbFromCloud();
							return;
						}
						setTimeout(function () {
							_waitNeighbors();
						}, 1000);
					};
				app._m.fs.exists(dbPath, function (exists) {
					if (!exists) {
						_waitNeighbors()
						return;
					}
					_gotDatabase();
				});
			},

			getFolderPath: function (table) {
				let _fn = app.system.crypto.hash(pos._cfg.branch.id + '_' + table, 'sha1'),
					_fp = dbPath + _fn.slice(0, _fn.length / 2) + '.ace/' + _fn.slice(_fn.length / 2, _fn.length) + '.deb/';
				return _fp;
			},

			/**
			 * 
			 * @param {string} table 
			 * @param {function} cback 
			 * 
			 * @returns {object} exposed db functions
			 */
			open: function (table, options, cback) {
				if (typeof options == 'function' && !cback) {
					cback = options;
					options = {};
				}
				if (app.pathExists(tables_configs, table + '.memory_only')) options.inMemoryOnly = true;
				return new Promise(function (resolve, reject) {

					let _doCback = function () {
						//console.info('db.manage.open', table, '_doOpen _doCback')
						/**
						 * 
						 * USAGE FUNCTIONS
						 */
						let _out = {
							close: function () {
								db.manage.close(table);
							},
							/**
							 * 
							 * @param {Object} query see nestdb documentation: https://github.com/JamesMGreene/nestdb#counting-documents
							 * @param {Function} cback returns count
							 */
							count: function (query, cback) {
								db._dbs[table].count(query, cback);
							},
							/**
							 * 
							 * @param {Object} query see nestdb documentation: https://github.com/JamesMGreene/nestdb#finding-documents
							 * @param {Object} options 
							 * 				@param {object} sort sort by, sort asc or desc
							 * 				@param {Int} skip skip X first results
							 * 				@param {Int} limit limit to X results
							 * 				@param {Boolean | Object} includeData fetch stored content from disk. See getData options for more
							 * @param {Function} cback returns object if _id provided in query, array of results otherwise
							 */
							find: function (query, options, cback) {
								db.find(table, query, options, cback)
							},

							/**
							 * 
							 * @param {uuid} id 
							 * @param {Object} options
							 * 		@param {Mixed} getFromNeighbor Boolean to get from any if no local data is found, register id to fetch from specific. `skipChecksums` is recommended for the last one
							 * 		@param {String} expectedChecksum for checksum compare
							 * 		@param {Boolean} allowStaleData wether or not checksum compare can fail and stale data can be served
							 * @param {Function} callback 
							 */
							getData: function (id, options, callback) {
								db.getData(table, id, options, callback);
							},
							/**
							 * 
							 * @param {Object} vars {indexes:["fields","to","be","indexed"],data:{field:value}}
							 * 			@param {Array} indexes List of fields to index, indexed fields values can be objects too. If none, every "data" field will be indexed except data.data
							 * 			@param {Object} data raw data containing indexed fields and non indexed fields. Data will be stored as-is doc: https://github.com/JamesMGreene/nestdb#inserting-documents
							 * @param {Object} options 
							 * @param {function} cback 
							 * 		@returns error if any, saved document
							 */
							insert: function (values, options, callback) {
								db.insert(table, values, options, callback)
							},
							//https://github.com/JamesMGreene/nestdb#removing-documents
							remove: function (id, options, callback) {
								db.remove(table, id, options, callback);
							},
							/**
							 * 
							 * @param {String} table 
							 * @param {Object} query see nestdb documentation https://github.com/JamesMGreene/nestdb#updating-documents
							 * @param {Object} update  see nestdb documentation
							 * @param {Object} options 
							 * 				@param {bool} waitAllSaved wait until all data files saved. If not set, callback will occur once indexed.
							 * @param {Function} cback returns err,numReplaced,affectedDocs
							 */
							update: function (query, update, options, callback, append) {
								db.update(table, query, update, options, callback, append)
							}
						};
						if (table.indexOf('TRANSACTIONS') == -1 && !_tables[table]) _tables[table] = _out;
						if (cback) cback(_out);
						if (_loadingCompletedRunCback[table] && _loadingCompletedRunCback[table].length) {
							setTimeout(function () {
								let _doProcessPending = function () {
									if (_loadingCompletedRunCback[table] && _loadingCompletedRunCback[table].length) {
										try {
											_loadingCompletedRunCback[table][0](_out);
										} catch (er) {
											console.error(er.message);
										}
										_loadingCompletedRunCback[table].shift();
										_doProcessPending();
									}
								};
								_doProcessPending();
							}, 1);
						}
						resolve(_out);
						return _out;
					},
						_doOpen = function () {
							//console.log('db.manage.open', table, '_doOpen')
							if (!db.manage.init_done) {
								//console.log('db.manage.open', table, '_doOpen !init_done')
								setTimeout(_doOpen, 500);
								return;
							}
							if (db._dbs[table] && db._dbs[table] == 'loading') {
								//console.log('table "' + table + '" is loading')
								if (!_loadingCompletedRunCback[table]) _loadingCompletedRunCback[table] = [];
								_loadingCompletedRunCback[table].push(cback);
								return;
							}
							if (db._dbs[table]) {
								//console.log('db.manage.open', table, '_doOpen already loaded')
								return _doCback();
							}
							if (!db.manage.init_completed && !options.force_init) {
								//console.log('db.manage.open', table, '_doOpen !init_completed')
								setTimeout(_doOpen, 500);
								return;
							}
							db._dbs[table] = 'loading';
							//splashscreen init database
							let
								_fp = db.getDataFileNameAndPath(table, 'main');
							//console.log('db.manage.open', table, '_doOpen init DB', _fp)
							app._m.fs.ensureDir(app._m.path.dirname(_fp), function () {
								app._m.fs.exists(_fp, function (exists) {
									//if (!exists && db.getNeighbors().length) {
									//	//load from neighbor or cloud
									//	console.log('ask neighbors')
									//	return;
									//}
									//console.log('db.manage.open', table, '_doOpen folder created')
									db.manage.addToTableIndex(table, { inMemoryOnly: options.inMemoryOnly });
									//init nestDB
									db._dbs[table] = new NestDB({
										encrypt: oreo,
										filename: _fp,
										autoload: true,
										inMemoryOnly: options.inMemoryOnly || false,
										timestampData: true,
										idGenerator: function () {
											return app.system.uuid.get();
										},
										dateGenerator: function () {
											return new Date().toISOString();
										},
										onload: function (err) {
											//console.log(table, 'onload')
											if (err) {
												console.error('Failed to load the datastore "' + table + '":', err);
												reject('Failed to load the datastore "' + table + '":', err)
												return;
											} else {
												//console.log('Loaded the datastore "' + table + '"!');
												//if (!exists) {
												//	//load data from others
												//	//request table from neighbor
												//
												//	return false;
												//}
											}
											if (table == 'TRANSACTIONS') {
												//db.transactions.queue.incoming.loadPending();
											}
											resolve(_doCback());
										}
									});
									db._dbs[table].once('encryptionReady', function () {
										//console.log(table, 'encryption ready')
									})
									db._dbs[table].on('created', function () {
										//	console.log('created')
									});
									db._dbs[table].on('loaded', function () {
										//	console.log('loaded');
									});
									db._dbs[table].on('removed', function (oldDoc) {
										//console.log('document removed', oldDoc)
										//db.removeData(table, oldDoc._id, function () {
										//	console.log('data removed')
										//})
									});
								});

								//if (table.indexOf('TRANSACTIONS') == -1) {
								//	db._dbs[table].on('inserted', function (newDoc) {
								//		//console.log('INSERTED', newDoc);
								//		db.saveData(table, newDoc, function (err, numr) {
								//			//console.log('DATA SAVED', err, numr)
								//			//db.transactions.save({ table: '' + table, type: 'insert', data: newDoc });
								//		});
								//	});
								//}
							})
						};
					_doOpen();
				});

			}
		}
	};
var _outboundTransactionsCounts = {}, _tables = {}, TechnoDB = class TechnoDB {
	constructor(parent, cback) {
		db.init(parent, cback);
		var self = this;

		//dev only
		this._tables = _tables;
		this._dev_dbs = db._dbs;

		//methods
		this.open = db.manage.init;
		this.openTable = db.manage.open;
		this.createDatabase = function () {
			console.warn('Create Databse')
			app._m.fs.ensureDir(dbPath, function () { })
		}
		this.dropDatabase = function () {
			console.warn('Drop Databse')
			app._m.fs.rmdir(dbPath, { recursive: true }, function (er) {
				if (er) console.error(er);

			});
		}
		this.insert = db.insert;
		this.count = db.count;
		this.update = db.update;
		this.find = db.find;
		this.remove = db.remove;
		this.findOne = db.find;
		this.getData = db.getData;
		this.getFileChecksum = db.getFileChecksum;
		this.close = db.manage.close;
		this.transactions = {
			outgoingCounts: _outboundTransactionsCounts,
			get: db.transactions.get, //dev only
			processOutgoing: db.transactions.queue.outgoing.init,
			incomingProcessing: db.transactions.queue.incoming._processing
		}
		this._redownloadDatabase = function () {
			db.manage.init_completed = 0;
			let notif = app.pos.notifications.show({
				title: app.parseLocales('database.maintenance.in_progress.title'),
				message: app.parseLocales('database.maintenance.in_progress.message'),
				timeout: -1,
				closeBtn: 0
			});
			try {
				app.pos.hideWindow();
			} catch (er) { }
			let _waitReady = function () {
				let _procTbls = Object.keys(db.transactions.queue.incoming._processing);
				if (_procTbls && _procTbls.length && _procTbls.filter(function (a) {
					return db.transactions.queue.incoming._processing[a] &&
						new Date(db.transactions.queue.incoming._processing[a]).getTime() > new Date().getTime() - 1000 * 60
				}).length) {
					//wait...
					setTimeout(_waitReady, 1000 * 10);
					return;
				}
				app._m.fs.rmdir(dbPath, { recursive: true }, function () {
					//restart app

					db.manage.init_done = 0;
					db.manage.init_completed = 0;
					db.manage.init({ useNotifications: notif }, function () {

						try { notif.remove(); } catch (er) { }
						try {
							app.pos.showWindow();
						} catch (er) { }
					});
				})
			};
			_waitReady();
		}
		/**
		 * 
		 * @param {string|array} matching 
		 * @param {function} fct 
		 */
		this.subscribe = function (matching, fct) {
			let _parent = app.getParentStack({ exclude: [/\/queueproc\.js/, /pos\/database\.js/] });
			if (Array.isArray(matching)) {
				matching = matching.filter(function (a) { return a.indexOf('TRANSACTION') == -1 });
			}
			_subscriptions.push({
				matching: matching,
				fct: fct,
				stack: _parent
			});
		}
		return this;
	}
	status() {
		//let out = {};
		//for (let k of Object.keys(db._dbs)) {
		//	for (let y of Object.keys(db._dbs[k])) {
		//		if (!out[k]) out[k] = {};
		//		out[k][y] = { version: db._dbs[k][y]._version, status: db._dbs[k][y].status };
		//	}
		//}
		//return out;
	}
	//init: db.init,
	routeEvent(d, cback) {
		switch (d.action) {
			case 'newTransaction':
				db.transactions.queue.incoming.add(d.data, function (addRes) {
					(d.cback || cback)(addRes);
				})
				break;
			case 'transactionData':
				db.transactions.queue.incoming.saveData(d.data, function (saveRes) {
					(d.cback || cback)(saveRes);
				})
				break;
			case 'getData':
				db.getData(d.data.table, d.data.id, app._m.xtend.extend(d.data.options || {}, { noCloud: 1 }), d.cback || cback);
				break;
			case 'db.find':
				db.find(d.data.table, d.data.query, app._m.xtend.extend(d.data.options || {}, { noCloud: 1 }), d.cback || cback);
				break;
			case 'db.remove':
				db.remove(d.data.table, d.data.id, d.data.options || {}, d.cback || cback);
				break;

			case 'createDatabase':
				console.warn('Create Databse')
				app._m.fs.ensureDir(dbPath, function () { if (d.cback || cback) (d.cback || cback)() })
				break;
			case 'dropDatabase':
				console.warn('Drop Databse')
				app._m.fs.rmdir(dbPath, { recursive: true }, function (er) { if (er) console.error(er); if (d.cback || cback) (d.cback || cback)() })
				break;
		}
	}
	routeInterNode(d) {
		//console.info('INTERNODE pos.database.' + d.action, 'from ' + d.socket.deviceUUID, d.data)
		switch (d.action) {
			case 'newTransaction':
				db.transactions.queue.incoming.add(d.data, function (addRes) {
					d.cback(addRes);
				})
				break;
			case 'cloudSynced':
				db.update('TRANSACTIONS', { _id: d.data._id || d.data.id }, { $set: { cloud_synced: d.data.received, updatedAt: d.data.updatedAt } }, { fromTransaction: 1, skipTrans: 1 }, function (err, aff, docs) {

				});
				break;
			case 'transactionProcessed':
				db.update('TRANSACTIONS_BCAST_QUEUE', { txn_id: d.data.id, "register.recipient": d.data.register }, { $set: { processed: d.data.processed } }, { fromTransaction: 1 }, function (err, aff, docs) {

				});
				break;
			case 'getFileChecksum':
				db.getFileChecksum(d.data.table, d.data.id, d.cback);
				break;
			case 'getTransaction':
				db.transactions.get({ _id: d.data.id }, d.data.options || {}, function (e, data) {
					console.log('getTransaction result', e, data)
					d.cback({ error: e, data: data })
				});
				break;
			case 'getData':
				db.getData(d.data.table, d.data.id, d.cback);
				break;
			case 'getFullDatabase':
				app._m.fs.exists(dbPath, function (exists) {
					if (exists) {
						app._m.exec("/bin/bash " + __dirname + "/scripts/zipdb.sh ", { cwd: app.cacheDir }, function (err, stdout, stderr) {
							console.log('zipdb.sh result', err, stdout, stderr)
							if (err) {

								d.cback({ result: 'error', error: err.message || err })
								return;
							}
							app._m.fs.exists(app.cacheDir + 'database_backup.zip', function (exists) {
								if (exists) {
									console.log('DB ZIP CREATED')
									d.cback({ result: 'success', data: app._m.fs.readFileSync(app.cacheDir + 'database_backup.zip') });
									return;
								}
								d.cback({ result: 'error', debug: { stdout: stdout, stderr: stderr } })
							});
						})
						return;
					}
					d.cback({ result: 'error', code: 'ENOTFOUND' })
				})
				break;
			case 'db.find':
				db.find(d.data.table, d.data.query, d.data.options, d.cback);
				break;
			default:
				console.warn('UNMANAGED INTERNODE pos.database.' + d.action, 'from', d.socket.deviceUUID)
		}
	}
	testUpdate(cback) {
		let _a = app.system.randomInt(1, 50000);
		app.pos.db.insert('test', { a: _a }, {}, function (er, res) {
			console.log(er, res);
			app.pos.db.transactions.get({}, { includeData: 1 }, function (er, rows) {
				if (app.tryCatch(function () {
					if (rows[0].data.data.a == _a) console.log('First transaction MATCH', rows); else console.warn('MISMATCH with 1st transaction', rows);
					let _newA = app.system.randomInt(1, 50000);
					app.pos.db.update('test', { _id: res._id }, { $set: { a: _newA, b: 'patate' } }, {}, function (er, num, docs) {
						app.pos.db.transactions.get({}, { includeData: 1 }, function (er, rows) {
							console.log('TRANSACTIONS', rows)
							let _last = app._m.xtend.clone(rows[rows.length - 1]);
							if (app.tryCatch(function () {
								if (_last.data.update.$set.a == _newA) console.log('Last transaction MATCH', _last || rows); else console.warn('MISMATCH with last transaction', _last || rows);
								app.pos.db.getData('test', res._id, function (data) {
									if (data.data.a == _newA && data.data.b == 'patate') console.log('MATCH'); else console.warn('NO MATCH', data.data.a, _newA, data.data.b)
									console.log('FINAL DATA', data)
									if (cback) cback(data);
								})
							})) {
								console.warn(_last)
							}
						})
					})
				})) {
					console.warn(rows[0])
				}
			});
		});
	}
	testConcurrence() {
		let cnt = 1000, ids = [], start = new Date().getTime(), _doneTimer = null, _doneCalled = false, _done = function () {
			if (_doneCalled) { console.warn('done already called', ids.length); return; }
			_doneCalled = true;
			let _found = 0, _missing = 0;
			console.log('done insert');
			db.find('test_c', {}, function (err, list) {
				if (err) { console.error(err); return false; }

				console.log('Got list from DB', list.length)
				for (let i = 0; i < ids.length; i++) {
					if (!list.filter(function (a) { return a._id == ids[i] }).length) {
						_missing++;
						console.warn(ids[i] + ' is missing from DB')
					}
					else {
						_found++;
					}
				}
				console.log('Found:' + _found, 'missing:' + _missing, 'runtime:' + ((new Date().getTime() - start) / 1000))
				ids = null;
			})
		}, _q = app.queueProc.init('pos.database.test_concurrence', 20);
		for (let i = 0; i < cnt; i++) {
			_q.add(i, function (x, n) {
				clearTimeout(_doneTimer);
				db.insert('test_c', { increment: x, randVal: app.system.randomInt(1, 50000) }, function (er, res) {
					ids.push(res._id);
					console.log(ids.length, 'insertions')
					n();
					clearTimeout(_doneTimer);
					_doneTimer = setTimeout(_done, 1000);
				})
			})
		}
	}

};
module.exports = TechnoDB;