var EftPayments = require('../eftPayment');
module.exports = class Desjardins extends EftPayments {
	constructor(cfg, parent) {
		super(cfg, parent);
		var self = this;
		_m.xtend.extend(self.cfg, {
			transCodeLength: 3,
			fieldsLength: 2,
			prependLength: false
		});
		self.cfg.notPrependType = true;
		self.cfg.prependLength = true;
		self.cfg.sharedAmountField = true;
		self.ServiceReqNum = 0;
		self.constants = Object.assign(self.constants, {
			TransType: {
				Purchase: '01',
				PurchaseTip: '03',
				Refund: '05',
				Ping: '99',	//Terminal Info
				PingClose: '',
				Void: '06',
				CloseBatch: '31'
			},
			TransStatus: {
				'000': 'Approved',
				'L97': 'Busy',
				'P01': 'Ping', 				//Keep-alive
				'P02': 'IncompleteData',		//(Data is chunked)
				'P03': 'IncompleteDataset'	//(Data is chunked)
			},
			fields: {
				ECRTransAmount: '01', //SPSI_AMOUNT1
				TipAmount: '02', //SPSI_AMOUNT2
				ECRTenderType: '',
				ECRClerkId: '',
				ECRInvoiceNbr: '',
				ECRCustomerId: '',
				TransType: '13', //SPSI_SERVICE_ID
				TransStatus: '11',	//SPSI_RESPONSE_CODE 
				TransDate: '',
				TransTime: '',
				TransAmount: '',
				TotalAmount: '',
				Reference: '75',	//SPSI_TRX_REF_NUM
				Sequence: '12', //SPSI_SEQ_NUM
				ClerkId: '',
				CustCardType: '07',
				CustCardDesc: '',
				CustAccNbr: '06', //SPSI_CARD_NUM
				CustLang: '',
				CustName: '',
				CustCardEntry: '',
				EMVAID: '',
				EMVTVR: '',
				EMVTSI: '',
				EMVAppLabel: '',
				CVMResult: '',
				Auth: '03',	//SPSI_AUTHOR_NUM
				HostRespCode: '',
				HostRespText: '',
				HostRespISO: '',
				BatchNo: '43',	//SPSI_BATCH_NUM
				Demo: '',
				TerminalId: '37',	//SPSI_POS_NUM
				MerchId: '',
				ReceiptHeader1: '',
				ReceiptHeader2: '',
				ReceiptHeader3: '',
				ReceiptHeader4: '',
				ReceiptHeader5: '',
				ReceiptHeader6: '',
				ReceiptHeader7: '',
				ReceiptFooter1: '',
				ReceiptFooter2: '',
				ReceiptFooter3: '',
				ReceiptFooter4: '',
				ReceiptFooter5: '',
				ReceiptFooter6: '',
				ReceiptFooter7: '',
				Endorse1: '',
				Endorse2: '',
				Endorse3: '',
				CustEndorse1: '',
				CustEndorse2: '',
				CustEndorse3: '',
				EMVRespCode: '',
				Record: '',
				ServiceReqNum: '15', //SPSI_SERVICE_REQ_NUM
				ProtocolVersion: '09', //SPSI_PROTOCOL_VERSION
				PrintingOptions: '40',
				DisplayText: '31',	//SPSI_DISPLAY_TEXT
				TextLine: '63',	//SPSI_TEXT_LINE_FORMAT
				TextFormat: '62',	//SPSI_TEXT_LINE,
				MustPrintCust: '79',	//SPSI_PRINT_CUSTOMER_RECEIPT
				CustomerReceipt: '39',	//SPSI_CUSTOMER_RECEIPT
				MerchantReceipt: '64',	//SPSI_MERCHANT_RECEIPT
				AppVersion: '81', //SPSI_APP_VERSION
				Warnings: '49',	//SPSI_WARNINGS
				WarningCode: '47',	//SPSI_WARN_CODE
				warningMsg: '48',	//SPSI_WARN_MESSAGE
				PrintTrx: '08', //SPSI_PRINT_TRX_LIST,
				Report: '65', //SPSI_ADMIN_REPORT
			},
			/*CustCardEntry:{
				'0'	: 'S',
				'1'	: 'C',
				'2'	: 'P',
				'3'	: 'M',
				'4'	: 'CS',
				'5'	: 'CM',
				'6'	: 'CNP',
			},*/
			CustCardType: {
				'P ': 'Debit',
				'PI': 'Debit',
				'V ': 'Visa',
				'M ': 'MasterCard',
				'AM': 'Amex',
				//''	: 'Diners Club',
				'DI': 'Discover Card',
				'JC': 'JBC',
				//'07'	: 'Union Pay Card',
				//'08'	: 'Other Credit Card',
				//'09'	: 'Gift Card',
				'CA': 'Cash',
				//'11'	: 'EBT Food Stamp',
				//'12'	: 'EBT Cash Benefit',
			},
			ProtocolVersion: {
				'01': '02',
				'03': '02',
				'06': '02',
				'31': '02',
				'99': '02'
			},
			TextFormat: {
				'0': 'normal',
				'1': 'doubleHeight',
				'2': 'reversed', //white on black
				'3': 'doubleHeight|reversed'
			}
		});
		super.provider = 'Desjardins';
		self._kA = null;
		self.reply = [];
		self.replyStatus = '';
		//key consts fields values
		var fields = self.constants.fields;
		for (let f in fields)
			self.constants.fields[fields[f]] = f;

		//key consts fields values
		var TransType = self.constants.TransType;
		for (let t in TransType)
			self.constants.TransType[TransType[t]] = t;

		_m.xtend.extend(self.features, {
			closeBatch: true,
		});
	}
	disconnected() {
		var self = this;
		super.disconnected();
		clearTimeout(self._kA);
		self._kA = null;
		self.reply = [];
		self.replyStatus = '';
	}

	keepAlive() {
		var self = this;
		if (self._kA != null) {
			clearTimeout(self._kA);
			self.send({ fields: { TransStatus: 'R01' } });
		}
		self._kA = setTimeout(function () {
			if (typeof self.cback == 'function')
				self.cback({ status: 'timeout' });
			if (self.comm.connected)
				self.comm.disconnect();
		}, 30000);
	}

	ping() {
		var self = this;
		super.ping(function (data) {
			if (data && typeof data.status == 'string') {
				if (data.status == 'NotAvail') {
					self.pingStatus.pingBack({ status: 'error', code: 'REFUSED' });
				} else if (data.status == 'Approved') {
					self.pingStatus.pingBack({ status: 'success', info: data.fields });
				}
			} else {
				self.pingStatus.pingBack(data);
			}
			self.comm.disconnect();
		});
	}

	receive(data) {
		var self = this;
		var trans = super.receive(data);

		if (trans.status == 'P01') {
			self.keepAlive();
			return;
		}
		if (self.replyStatus == 'P02' || self.replyStatus == 'P03') {
			trans.fields.shift();
			trans.fields.shift();
			trans.fields.shift();
			var status = trans.fields.shift();
			if (self.replyStatus == 'P03') { // PO3 means last packet is incomplete 
				let incomplete = trans.fields.shift();
				if (typeof incomplete == 'string')
					self.reply[self.reply.length - 1].value += incomplete.value;
				else
					self.reply[self.reply.length - 1].value = self.reply[self.reply.length - 1].value.concat(incomplete.value);
			}
			self.reply = self.reply.concat(trans.fields);
			for (let r = 0, rL = self.reply.length; r < rL; r++)
				if (self.reply[r].key == 'TransStatus')
					self.reply[r] = status;
		} else
			self.reply = trans.fields;

		if (trans.status == 'P02' || trans.status == 'P03') {
			self.replyStatus = trans.status;
			self.send({ fields: { TransStatus: 'R01' } });
			return;
		}
		setTimeout(function () { self._busy = false; }, 1000);
		if (typeof self.constants.TransStatus[trans.status] == 'string')
			trans.status = self.constants.TransStatus[trans.status];
		else {
			console.warn('Error code', trans.status, 'is not handled in response');
			trans.status = 'Error';
		}

		trans.fields = self.reply;
		if (typeof self.cback == 'function')
			self.cback(trans);
		else
			console.log('warning no cback');
		self.comm.disconnect();
		delete self._query;
		clearTimeout(self._kA);
		self._kA = null;
		self.reply = [];
		self.replyStatus = '';
	}

	send(vars, cback) {
		var self = this;
		if (!vars.fields)
			vars.fields = {};
		vars.fields.TransType = self._query.TransType;
		vars.fields.ProtocolVersion = self._query.ProtocolVersion;
		vars.fields.ServiceReqNum = self._query.ServiceReqNum;
		if (['01', '03', '05', '06', '31'].indexOf(vars.fields.TransType) != -1) {
			if (!self.devices[self.cfg.comm.model].canPrint)
				vars.fields.PrintingOptions = '010';
		}
		super.send(vars, cback);
		if (self._kA == null)
			this.keepAlive();
	}

	startOperation(vars, cback) {
		var self = this;
		if (++self.ServiceReqNum > 99)
			self.ServiceReqNum = 1;
		self._query = {
			TransType: self.constants.TransType[vars.transType],
			ProtocolVersion: self.constants.ProtocolVersion[self.constants.TransType[vars.transType]],
			ServiceReqNum: self.ServiceReqNum < 10 ? '0' + self.ServiceReqNum : self.ServiceReqNum
		};
		super.startOperation(vars, cback);
	}

	/*************************
	 *		 FEATURES		 *
	 *************************/

	closeBatch(cback) {
		var self = this;
		cback({
			modal: 'show', buttons: '[data-action="cancel"],[data-action="no"],[data-action="yes"]', body: { class: 'info', message: 'CLOSE BATCH<br />PRINT?' }, cback: function (print) {
				switch (print) {
					case 'cancel':
						cback({ modal: 'hide' });
						return;
					case 'no':
						print = false;
						break;
					case 'yes':
						print = true;
						break;
				}
				self.startOperation({
					transType: 'CloseBatch',
					fields: {
						PrintTrx: print ? "1" : '0'
					}
				}, function (data) {
					var text = '';
					if (data && data.fields) {
						for (let f = 0, fL = data.fields.length; f < fL; f++)
							switch (data.fields[f].key) {
								case 'DisplayText':
									let display = data.fields[f].value;
									for (let l = 0, lL = display.length; l < lL; l++)
										text += display[l][0].value + '<br />';
									break;
								case 'Report':
									let lines = data.fields[f].value;
									if (1 * localStorage.getItem("default_printer_is_mev")) {
										let receipt = '';
										for (let l = 0, lL = lines.length; l < lL; l++) {
											let format = lines[l][0].key == 'TextFormat' ? lines[l][0].valueText : lines[l][1].valueText;
											let text = lines[l][0].key == 'TextLine' ? lines[l][0].value : lines[l][1].value;
											if (text.length) {
												switch (format) {
													case 'normal':
													default:
														receipt += '\x1b\x21\x00\x1d\x42\x00';
														break;
													case 'doubleHeight':
														receipt += '\x1b\x21\x10';
														break;
													case 'reversed':
														receipt += '\x1d\x42\x01';
														break;
													case 'doubleHeight|reversed':
														receipt += '\x1b\x21\x10\x1d\x42\x01';
														break;
												}
												receipt += text + '\n';
											} else
												receipt += '\n';
										}
										self.pos.mev.print(self.pos.mev.other(receipt + '\n\n\n\x1b\x6d'));
									} else {
										let receipt = '<style>.doubleHeight{transform:scaleY(2);-webkit-transform:scaleY(2);-moz-transform:scaleY(2);}.reversed{color:white;background-color:black;}p{text-align:center;width:100%;}</style>';
										for (let l = 0, lL = lines.length; l < lL; l++) {
											let format = lines[l][0].key == 'TextFormat' ? lines[l][0].valueText : lines[l][1].valueText;
											let text = lines[l][0].key == 'TextLine' ? lines[l][0].value : lines[l][1].value;
											if (text.length) {
												switch (format) {
													case 'normal':
													default:
														receipt += '<p>';
														break;
													case 'doubleHeight':
														receipt += '<p class="doubleHeight">';
														break;
													case 'reversed':
														receipt += '<p class="reversed">';
														break;
													case 'doubleHeight|reversed':
														receipt += '<p class="doubleHeight reversed">';
														break;
												}
												receipt += text + '</p>';
											} else
												receipt += '<br />';
										}
										nw.Window.open(app._relativePath + 'libs/printManager/printWindow/printWindow.html', {
											title: "EFTPrinting",
											show: false
										}, function (win) {
											win.on('loaded', function () {
												win.window.setContent(receipt, function () {
													win.window.nw.Window.get().print({
														"autoprint": true,
														"marginsType": 1,
														"headerFooterEnabled": false,
														"printer": localStorage.getItem("default_printer")
													});
													win.close();
												});
											});
										});
									}
									break;
							}
					}
					var body = {};
					body.class = data.status == 'Approved' ? 'success' : 'warning';
					body.message = text || 'NO TEXT TO DISPLAY';
					cback({ buttons: '[data-action="close"]', body: body, cback: function () { cback({ modal: 'hide' }); } });
				});
			}
		});
	}
};