var app = {
    init: () => {
        console.info('workstation init')
        $('#loadingOverlay').hide()
        $(document).off();
        window.getRegisterConfig((config) => {
            var reg = /^.*\/(REG\-[A-Z0-9]+)/
            app.registerId = config.server.url.local.match(reg)[1]
            app.branch = config.branch
            app.mediaBaseUrl += app.branch.id + '/'
            app.ws.getRegisterTasks(app.registerId, (err, tasks) => {
                app.registerTasks = tasks;
                app.ws.getLabels((labels, formats) => {
                    app.labels = labels;
                    app.labelFormats = formats;
                })
            })
        });
    },
    load: (that, path, cb = null, params = {}) => {
        console.log('loading: ' + path)
        if (typeof cb !== 'function' && cb !== null && !params.length) {
            params = cb
        }
        $.get(app.basePath() + path, (data) => {
            try {
                if (params.append) that.append(data.toString())
                else if (params.replaceContent) that.html(data.toString())
                else that.replaceWith(data.toString())
                $('#keyboard_modal, #numpad_modal').hide()
                $('#loadingOverlay').show()
                //This is the only way I could think of to implement a dynamic lang from the frontend
                $('[lang]').each(function (element) {
                    $(this).html('');
                    var locales = $(this).attr('lang').split('|')
                    var lang = '';

                    locales.forEach((locale) => {
                        lang += app.lang(locale);
                    })

                    if ($(this).prop('tagName') == 'INPUT')
                        that.prop('placeholder', lang)
                    else
                        $(this).append(lang)
                });

                $('[dynamicLang]').each(function (element) {
                    $(this).html('');
                    var lang = app.getObjProperty($(this).attr('dynamicLang'))

                    if ($(this).prop('tagName') == 'INPUT')
                        $(this).prop('placeholder', lang)
                    else
                        $(this).append(lang)
                })
                $('#loadingOverlay').hide()
                if (cb !== null && typeof cb === 'function') cb()
            } catch (err) {
                console.error('error during callback: ' + err)
            }
        })
    },
    getObjProperty: (path, obj = app.currentJob) => {
        var paths = path.split('.');
        var property;

        while (paths.length > 0) {
            if (obj == undefined) return '';
            path = paths.shift();
            if (path == 'i') property = obj[app.currentJob.currentStep];
            else property = obj[path];
            obj = property;
            if (paths.length == 0) return property;
        }
    },
    pushNextStep: () => {
        app.currentJob.jobProgress[app.currentJob.currentStep].status = 1;
        app.currentJob.jobProgress[app.currentJob.currentStep].user = app.user;
        var jobFinished = false;
        if (app.currentJob.currentStep + 1 != app.currentJob.steps.length) {
            app.currentJob.currentStep++;
            var jobProgress = {
                inputs: app.currentJob.steps[app.currentJob.currentStep].inputs ? [] : false,
                outputs: app.currentJob.steps[app.currentJob.currentStep].outputs ? [] : false,
                task: app.currentJob.steps[app.currentJob.currentStep].task,
                sort: app.currentJob.steps[app.currentJob.currentStep].sort,
                totalElapsedTime: 0,
                actualElapsedTime: 0,
            }
            app.currentJob.jobProgress.push(jQuery.extend(true, {}, jobProgress))

        } else {
            app.ws.broadcastStatus({ status: 'available' })
            jobFinished = true;
            app.currentJob.production.status = 'completed';
        }
        app.ws.saveJob(app.currentJob, { jobFinished: jobFinished }, (err, res) => {
            console.log(jobFinished);
            if (err) console.error(err)
            if (jobFinished) {
                app.currentJob = {};
                app.currentJob.currentStep = 0;
            }
            app.load($('.wrapper'), 'workstation.html')
        });
    },
    basePath: () => {
        var url = window.location;
        return url.protocol + "//" + url.host + "/libs/pos/production/workstation/";
    },
    currentStep: 0,
    user: {},
    units: {
        lengths: {
            m: 1,
            dm: 10,
            cm: 100,
            mm: 1000,
            yd: 1.09361,
            ft: 3.28084,
            in: 39.3701,
        },
        masses: {
            t: 0.001,
            kg: 1,
            g: 1000,
            lb: 2.20462,
            oz: 35.274,
        },
        volumes: {
            m3: 1,
            ft3: 35.3147,
            dm3: 1000,
            l: 1000,
            galGB: 219.969,
            galUS: 264.172,
            pntGB: 1759.75,
            pntUS: 2113.38,
            in3: 61023.7,
            ml: 1000000,
            cm3: 1000000,
            mm3: 1000000000
        }
    },
    locales: {
        'fr': {
            submit: 'Soumettre',
            user: 'Utilisateure',
            password: 'Mot de passe',
            pin: 'Nip',
            completeTask: 'Compléter le tâche',
            couldNotGetQualifications: 'Erreur lors de l\'obtention des qualifications',
            task: 'Tâche',
            estimated: 'Estimé: ',
            total: 'Total: ',
            instructions: 'Instructions',
            videoImage: 'Vidéo/Image',
            input: 'Entrée',
            output: 'Sortie',
            inputOutput: 'Entrée/Sortie',
            lengths: 'dimensions',
            masses: 'Masses',
            volumes: 'Volumes',
            unit: 'Unité',
            yd: 'Verge',
            ft: 'Pied',
            in: 'Pouce',
            m: 'Mètre',
            dm: 'Décimètre',
            cm: 'Centimètre',
            mm: 'Millimètre',
            lb: 'Livre',
            oz: 'Once',
            t: 'Tonne',
            kg: 'Kilogramme',
            g: 'Gramme',
            ft3: 'Pied cube',
            in3: 'Pouce cube',
            m3: 'Mètre cube',
            dm3: 'Décimètre cube',
            cm3: 'Centimètre cube',
            mm3: 'Millimètre cube',
            l: 'Litre',
            ml: 'Millilitre',
            pntGB: 'Pinte impériale',
            galGB: 'Gallon impérial',
            pntUS: 'Pinte US',
            galUS: 'Gallon US',
            pinInvalid: 'Nip invalid',
            unexpectedErr: 'Erreur inconnu',
            initTime: '00:00:00',
            required: 'Ce champ est requis',
            notTypeFloat: 'Un nombre valide est requis',
            errRetrievingJobs: 'Une erreur est survenue lors de la recherche des tâches disponibles.',
            redirectTo: 'Veuillez vous diriger vers la station de production: ',
            couldNotSaveIO: 'Une erreur est survenue lors de la sauvegarde des Entrées/Sorties',
            InvalidQr: 'Code QR invalide',
            scanQr: 'Scanner un code QR',
            availableJobs: 'Travaux disponibles',
            qualifs: 'Qualifications',
            tasks: 'Tâches',
            item: 'Article',
            quantity: 'Quantité',
            batch: 'Lot',
            scanAndSet: 'Scanner et définir',
            scanAndAdd: 'Scanner et ajouter',
            delete: 'Supprimer',
            invalidInputs: 'Entrées invalides',
            missingQty: 'Quantité manquante: ',
            excessQty: 'Quantité en trop: ',
            batchQtyExceededBy: 'Quantité de lot dépassé de ',
            stopJob: 'Demande d\'arrêt de l\'opération en cours',
            reason: 'Raison',
            noJobAval: 'Aucun travail disponible présentement',
            registerMissingTask: 'La station de travail ne possède pas les prérequis pour effectuer ce travail. Veuillez vous reconnecter afin d\'être assigné à un autre travail.',
            employeeMissingTask: 'Vous ne possèdez pas les qualifications requises pour effectuer ce travail. Veuillez vous reconnecter afin d\'être assigné à un autre travail.',
            registerReservedForUser: 'Cette station de travail a été réservé par: ',
            invalidReservedUser: 'Vous ne correspondez pas à l\'utilisteur qui a réservé ce poste de travail.',
            noRegCanDoTask: 'Aucun poste de travail peut effectuer cette cette tâche. Veuillez choisir un autre travail.',
            totalEstimatedTime: 'Temps total estimé',
            quantityToPrint: 'Quantité à imprimer',
            done: 'Terminer',
            print: 'Imprimer',
            error: 'Erreur!',
            warning: 'Attention!',
            insufficientInventoryQty: 'Quantité en inventaire insuffisante',
            outputInsufficient: 'Quantité sortie insuffisante',
            expectedQty: 'Quantité attendue',
            jobStopped: 'Travail en arrêt',
            missingOutputReason: 'Justification pour la quantité sortante insufisante',
            jobNoLongerAvailable: 'Ce travail n\'est plus disponible, veuillez en choisir un autre.',
        },
        'en': {
            submit: 'Submit',
            user: 'User',
            password: 'password',
            pin: 'Pin',
            completeTask: 'Complete Task',
            couldNotGetQualifications: 'Error while retrieving qualifications',
            task: 'Task',
            estimated: 'Estimated: ',
            total: 'Total: ',
            instructions: 'Instructions',
            videoImage: 'Video/Image',
            input: 'Input',
            output: 'Output',
            inputOutput: 'Input/Output',
            lengths: 'dimensions',
            masses: 'Masses',
            volumes: 'Volumes',
            unit: 'Unit',
            yd: 'Yard',
            ft: 'Feet',
            in: 'Inch',
            m: 'Meter', errRetrievingJobs: 'An error occured while retreving available jobs.',
            lb: 'Pound',
            oz: 'Ounce',
            t: 'Ton',
            kg: 'Kilogram',
            g: 'Gram',
            ft3: 'Cubic foot',
            in3: 'Cubic inch',
            m3: 'Cubic meter',
            dm3: 'Cubic decimeter',
            cm3: 'Cubic centimeter',
            mm3: 'Cubic millimeter',
            l: 'Litre',
            ml: 'Millilitre',
            pntGB: 'Imperial pint',
            galGB: 'Imperial gallon',
            pntUS: 'US pint',
            galUS: 'US gallon',
            pinInvalid: 'Invalid pin',
            unexpectedErr: 'UnknownError',
            initTime: '00:00:00',
            required: 'This field id required',
            notTypeFloat: 'A valid number is required',
            errRetrievingJobs: 'An error occured while retreving available jobs.',
            redirectTo: 'Please head to workstation: ',
            couldNotSaveIO: 'An error occured while saving Inputs/Outputs',
            InvalidQr: 'Invalid QR code',
            scanQr: 'Scan a QR code',
            availableJobs: 'Available jobs',
            qualifs: 'Qualifications',
            tasks: 'Tasks',
            item: 'Item',
            quantity: 'Quantity',
            batch: 'Batch',
            scanAndSet: 'Scan and set',
            scanAndAdd: 'Scan and add',
            delete: 'Delete',
            invalidInputs: 'Invalid inputs',
            missingQty: 'Missing quantity: ',
            excessQty: 'Excess quantity: ',
            batchQtyExceededBy: 'Exceeded batch quantity by ',
            stopJob: 'Ask to stop current operation',
            reason: 'Reason',
            noJobAval: 'No job avalable at the moment',
            registerMissingTask: 'This workstation can not do this job. Please login to be assigned to another job.',
            employeeMissingTask: 'You do not have the required qualifications. Please login to be assigned to another job.',
            registerReservedForUser: 'This workstation has been reserved by: ',
            invalidReservedUser: 'You do not correspond to the user who reserved this workstation.',
            noRegCanDoTask: 'No workstation can do this task. Please chose another job.',
            totalEstimatedTime: 'Total estimated time',
            quantityToPrint: 'Quantity to print',
            done: 'Done',
            print: 'Print',
            error: 'Error!',
            warning: 'Warning!',
            insufficientInventoryQty: 'Insufficient inventory quantity',
            outputInsufficient: 'Insufficient output quantity',
            expectedQty: 'Expected output',
            jobStopped: 'Job stopped',
            missingOutputReason: 'Justification for insufficient output quantity',
            jobNoLongerAvailable: 'This job is no longer available, please choose a different one.',
        },
    },
    currentJob: {},
    qualifiedTasks: [],
    branch: {},
    lang: (lang) => {
        var locale = app.user.language !== undefined ? app.user.language : navigator.language.substring(0, 2);
        switch (locale) {
            case 'french':
                locale = 'fr'
                break;
            case 'english':
                locale = 'en'
                break;
        }
        return app.locales[locale][lang];
    },
    getElapsedTime: (int) => {
        var date = new Date((int + new Date(0).getTimezoneOffset() * 60) * 1000);
        var hours = ('0' + date.getHours()).slice(-2);
        var minutes = ('0' + date.getMinutes()).slice(-2);
        var seconds = ('0' + date.getSeconds()).slice(-2);
        return hours + ':' + minutes + ':' + seconds;
    },
    generateQr: (itemId, variationId, batchId) => {
        APPFCTS.qrCode.encode({
            data: {
                item_id: itemId,
                variation_id: variationId,
                inventory_batch_id: batchId,
                type: 'type',
                id: 'id',
            },
            element: $('.io-modal-body .qr')
        })
    },
    mediaBaseUrl: 'https://d34tzna3yk3e5q.cloudfront.net/'
};

APPFCTS.onDocumentReady(() => {
    app.ws = window.ws;
    app.init();
    app.load($('body'), 'workstation.html', { append: true })
    app.load($('body'), 'assets/keyboard.html', { append: true });
});