var
	version = '1.1.9',
	rustCfg = {
		defaultPass: '46dnsd2023',
		ip: '146.190.244.106',
		pk: 'gX6ujzW7lWbwfcIda5czRL5m1q2iO4wzB16pryGDMSk='
	},
	app, support = {
		_init: function (a, cback) {
			app = a;
			if (cback) cback();
			//if not installed, download binary
			//https://github.com/rustdesk/rustdesk/releases/download/1.1.9/rustdesk-1.1.9.deb
			//https://github.com/rustdesk/rustdesk/releases/download/1.1.9/rustdesk-1.1.9-windows_x64-portable.zip

			support._setConfig();
			support._gotConfig();
			//monitor rustdesk file for changes ~/.config/rustdesk/RustDesk.toml
			app.watch(support.configPath + 'RustDesk.toml', function (rusty) {
				support._gotConfig();
			});
		},
		_setConfig: async function () { //support=app.system.support,version='1.1.9',app.system.support._setConfig=function () {
			return new Promise(async (resolve) => {
				support.configPath = process.env.HOME + '/.config/rustdesk/';
				support.executable = '/usr/bin/rustdesk';

				if (app.cfg.platform.indexOf('win') != -1) {
					support.configPath = 'C:\\Windows\\ServiceProfiles\\LocalService\\AppData\\Roaming\\RustDesk\\config\\';
					support.executable = 'C:\\Program Files\\RustDesk\\RustDesk.exe';
				}
				app._m.fs.ensureDirSync(support.configPath)
				//public key 
				let
					_cfgFile =
						"id 			= '0'\n" +
						"password 		= '" + rustCfg.defaultPass + "'\n" +
						"salt 			= '" + app.system.password.generate(6, false) + "'\n" +
						"key_pair 		= [\n" +
						"	[\n" +
						"		80,235,36,87,102,186,185,161,197,156,111,206,71,183,164,226,197,121,42,139,5,7,231,126,28,119,222,163,157,58,107,211,115,108,157,193,9,201,168,113,50,127,58,69,121,34,99,183,31,65,68,39,209,197,240,81,17,119,51,207,158,79,97,67,\n" +
						"	],[\n" +
						"		115,108,157,193,9,201,168,113,50,127,58,69,121,34,99,183,31,65,68,39,209,197,240,81,17,119,51,207,158,79,97,67,\n" +
						"	],\n" +
						"]\n" +
						"key_confirmed 	= true\n" +
						"\n" +
						"[keys_confirmed]\n" +
						"\"146.190.244.106\" 	= true\n" +
						"",
					_optsFile = "rendezvous_server = '" + rustCfg.ip + "'\n" +
						"nat_type = 2\n" +
						"serial = 3\n" +
						"\n" +
						"[options]\n" +
						"key = 'VhbgfO4ILhFBbY53O83RXZ2mNuaZPxxBd1LWg2aLJG4='\n" +
						"rendezvous-servers = '" + rustCfg.ip + "'\n" +
						"allow-remote-config-modification = 'Y'\n" +
						//"enable-tunnel = 'Y'\n" +
						//"enable-keyboard = 'Y'\n" +
						//"enable-file-transfer = 'Y'\n" +
						//"enable-clipboard = 'Y'\n" +
						"custom-rendezvous-server = '" + rustCfg.ip + "'\n" +
						"relay-server = '" + rustCfg.ip + "'\n";
				let _stopRequired = []; //!app._m.fs.existsSync(support.executable)
				if (!app._m.fs.existsSync(support.configPath + 'RustDesk2.toml') || app._m.fs.readFileSync(support.configPath + 'RustDesk2.toml').toString() != _optsFile) {
					_stopRequired.push(function () { app._m.fs.writeFileSync(support.configPath + 'RustDesk2.toml', _optsFile); });
				}
				if (!app._m.fs.existsSync(support.configPath + 'RustDesk.toml')) {
					_stopRequired.push(function () { app._m.fs.writeFileSync(support.configPath + 'RustDesk.toml', _cfgFile); });
				}
				else {
					let rdat = app._m.fs.readFileSync(support.configPath + 'RustDesk.toml').toString();
					if (!/146\.190\.244\.106/.test(rdat)) {
						_stopRequired.push(function () { app._m.fs.writeFileSync(support.configPath + 'RustDesk.toml', _cfgFile); });
					}
					else if (/password = \'\'\n/.test(rdat)) {
						_stopRequired.push(function () { app._m.fs.writeFileSync(support.configPath + 'RustDesk.toml', "password = '" + rustCfg.defaultPass + "'\n" + rdat.toString().replace(/password(.*)\n/, '')); });
					}
				}
				if (_stopRequired?.length) {
					console.info('Rustdesk stop required')
					await app.system.pkill('rustdesk', { sudo: 1 });
					app.system.stopProcessesByGrep('rustdesk', function () {
						for (let i of _stopRequired) {
							try {
								i();
							} catch (er) { console.error('Cant execute fct', er.message) }
						}
						support._setConfig().then(resolve);
					});
					return;
				}
				if (app.cfg.platform.indexOf('win') === 0) {
					if (!app._m.fs.existsSync(support.executable)) {
						let wdir = app._m.path.dirname(support.executable),
							_pFile = wdir + '\\RustDesk-portable.exe';
						if (!app._m.fs.existsSync(_pFile)) {
							//download
							console.log(support.executable + ' NOT FOUND')
							app._m.fs.ensureDirSync(wdir);
							support.isDownloading = true;
							app.system.request.GET('https://github.com/rustdesk/rustdesk/releases/download/' + version + '/rustdesk-' + version + '-windows_x64-portable.zip', { encoding: null }, function (e, r, b) {
								//b is buffer, save to zip
								if (b) {
									app._m.fs.writeFile(wdir + '\\rustdesk-' + version + '-windows_x64-portable.zip', b, function () {
										let
											zip_out = '' + wdir + '',
											_args = ['x', '-y', '' + wdir + '\\rustdesk-' + version + '-windows_x64-portable.zip' + '', '-o' + zip_out],
											szip, _7za = app.baseDir + '\\vendors\\SevenZip\\7za.exe';
										console.log('7za', _args)
										szip = app._m.spawn('' + _7za,
											_args);
										szip.stdout.on('data', (data) => {
											console.log('UNZIP', data.toString());
										});

										szip.stderr.on('data', (data) => {
											console.log('UNZIP stderr', data.toString());
										});

										szip.on('exit', (code) => {
											console.log(`szip exited with code ${code}`);
											app._m.fs.unlinkSync(wdir + '\\rustdesk-' + version + '-windows_x64-portable.zip')
											app._m.fs.rename(wdir + '\\rustdesk-' + version + '.exe', wdir + '\\RustDesk-portable.exe', function () {
												//install
												app._m.exec('RustDesk-portable.exe --silent-install', { cwd: wdir }, function (a, b, c) {

													support.isDownloading = false;
													try { app.deleteFolderRecursive('C:\\ProgramData\\Microsoft\\Windows\\Start Menu\\Programs\\RustDesk', function () { }); } catch (er) { }
													try { app._m.fs.unlinkSync('C:\\Users\\Public\\Desktop\\RustDesk.lnk'); } catch (er) { }
												});
											})
										});
									})
									return;
								}
								support.isDownloading = false;

							})
							return;
						}
						//install
						app._m.exec('RustDesk-portable.exe --silent-install', { cwd: wdir }, function (a, b, c) {
							//remove start entry
							support.isDownloading = false;
							try { app.deleteFolderRecursive('C:\\ProgramData\\Microsoft\\Windows\\Start Menu\\Programs\\RustDesk', function () { }); } catch (er) { }
							try { app._m.fs.unlinkSync('C:\\Users\\Public\\Desktop\\RustDesk.lnk'); } catch (er) { }
						});
					}
					try { app.deleteFolderRecursive('C:\\ProgramData\\Microsoft\\Windows\\Start Menu\\Programs\\RustDesk', function () { }); } catch (er) { }
					try { app._m.fs.unlinkSync('C:\\Users\\Public\\Desktop\\RustDesk.lnk'); } catch (er) { }
				}
				else if (['technopos', 'azimutpos'].indexOf(app._m.os.userInfo().username) != -1) {

					if (!app._m.fs.existsSync(support.executable)) {
						//download
						support.isDownloading = true;
						app.system.request.GET('https://github.com/rustdesk/rustdesk/releases/download/' + version + '/rustdesk-' + version + '.deb', { encoding: null }, function (e, r, b) {
							//b is buffer, save to zip
							if (b) {
								app._m.fs.writeFile(app.cacheDir + 'rustdesk-' + version + '.deb', b, function () {
									let _fcts = [
										'apt update',
										'apt install ./rustdesk-' + version + '.deb -y',
										'systemctl enable rustdesk',
										'systemctl start rustdesk',
									];
									app._m.async.eachSeries(_fcts, function (f, n) {

										app.system.sudo({ cmd: f, options: { cwd: app.cacheDir } }, function (a, b, c) {
											console.log('RUSTDESK', f, a, b, c)
											n();
										})
									}, function () {
										support.isDownloading = false;
										app._m.fs.unlinkSync(app.cacheDir + 'rustdesk-' + version + '.deb')
									})
								})
								return;
							}
							support.isDownloading = false;

						})
					}
					else {
						app.system.sudo({ cmd: "systemctl status rustdesk | grep 'active (running)'" }, function (a, b, c) {
							if (!b) {
								let _fcts = [
									'systemctl start rustdesk',
									'systemctl enable rustdesk',
								];
								app._m.async.eachSeries(_fcts, function (f, n) {

									app.system.sudo({ cmd: f, options: { cwd: app.cacheDir } }, function (a, b, c) {
										console.log('RUSTDESK ENABLE', f, a, b, c)
										n();
									})
								}, function () {
								})
							}
						});
					}
				}
				resolve();
			})
		},
		_gotConfig: function () {
			app._m.fs.exists(support.configPath + 'RustDesk.toml', function (exists) {
				if (!exists) return false;
				app._m.fs.readFile(support.configPath + 'RustDesk.toml', function (err, rdat) {
					if (err) console.error('Error reading RustDesk.toml: ' + err.message)
					if (rdat) {
						let
							_d = rdat.toString().split("\n").filter(function (a) { return a.indexOf('id =') != -1 || a.indexOf('password =') != -1; }),
							credz = {};
						for (let i of _d) {
							credz[i.split('=')[0].trim()] = i.split('=')[1].trim().replace(/\'/g, '');
						}
						if (!credz.password) {
							console.warn('Rust has no password, kill all and replace')
							app.system.support._setConfig();
						}
						if (!credz.id || credz.id == '0') return;
						support.credz = credz;
						console.log('Rustdesk credentials', credz)
						app.web.emit({
							module: 'status',
							action: 'updateSupport',
							datas: credz
						});
						//console.log(credz)
						return;
					}

					console.log('rustcheck no data')
				})
			});
		},
		routeEvent: function (d) {
			console.log('support route event', d)
			switch (d.action) {
				case 'startSupport':
					support.startRust(d.data, d.cback);
					break;
				case 'getNewID':
					app.system.stopProcessesByGrep('rustdesk', function (matches) {
						app._m.fs.writeFileSync(support.configPath + 'RustDesk.toml', "");
						support._setConfig().then(() => {

							if (matches && matches.length) {
								support.startRust({}, d.cback);
							}
						})
					});
					break;
			}
		},
		startRust: function (vars, cback) { //app.system.support.startRust=function () {
			if (support.isDownloading) {
				setTimeout(function () {
					support.startRust(vars, cback)
				}, 1000);
				return false;
			}
			let _e = '' + support.executable;
			if (!app._m.fs.existsSync(support.executable) && app.cfg.platform.indexOf('win') != -1) {
				_e = _e.replace('.exe', '-portable.exe');
			}

			if (app._m.fs.existsSync(_e)) {
				//start rustdesk
				console.info('Starting RustDesk at "' + _e + '"')
				let _p = app._m.path.parse(_e),
					s = app._m.spawn(_p.base, null, { cwd: _p.dir, detached: true, shell: true });
				s.unref();
				if (cback) cback({ result: 'success' })
				return;
			}
			console.warn('RustDesk executable not found.')
			if (cback) cback({ result: 'error', code: 'executable_not_found' })
		},
		startVNC: function (code) {
			//start old support
			let
				vnc_cwd = '',
				vnc_cmd = '/bin/bash',
				vnc_args = ['etc/scripts/support/support.sh', '--code=', code];
			if (app.cfg.platform.indexOf('win') != -1) {
				vnc_cwd = 'etc\\scripts\\support';
				vnc_cmd = 'support.bat';
				vnc_args = [code];
			}
			let _s = _m.spawn(vnc_cmd, vnc_args, { cwd: app.baseDir + vnc_cwd });
			let _parse = function (data) {
				data = data.toString();
				console.log(data);
				if (data.indexOf('FAILED TO START SUPPORT')) {
					//error
					if (cback) cback({ result: 'error' });
				}
			};
			_s.stdout.on('data', _parse);
			_s.stderr.on('data', _parse);
		}
	};
module.exports = support;
