#!/bin/bash

SOURCE="${BASH_SOURCE[0]}"
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
  DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
  SOURCE="$(readlink "$SOURCE")"
  [[ $SOURCE != /* ]] && SOURCE="$DIR/$SOURCE" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
done
DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
DIR=${DIR/etc\/scripts\/update/}
cd $DIR

sleep 1
echo "`date`"
rm -Rf $DIR/updater
rm -Rf $DIR/libs
rm -Rf $DIR/etc/scripts
echo "STEP:UNZIP"
if [[ "$OSTYPE" == "darwin"* ]]; then
	cd /Applications
	unzip -o -q $DIR/updates/$1
	touch /Applications/AzimutPOS.app
	touch /Applications/AzimutPOS.app/Contents/Info.plist
	killall Dock
else
	unzip -o -q $DIR/updates/$1
fi
echo "STEP:UNZIP_DONE"
sleep 2
echo "POS_UPDATE_DONE_NOW_RESTART"
exit 0