(function(){var slang={};if(typeof module!=="undefined"&&module.exports){module.exports=slang}else{this.slang=slang}slang.version="0.2.0";slang.isString=function isString(input){return Object.prototype.toString.call(input)==="[object String]"};slang.capitalize=function capitalize(input){return input.charAt(0).toUpperCase()+input.slice(1)};slang.uncapitalize=function uncapitalize(input){return input.charAt(0).toLowerCase()+input.slice(1)};slang.capitalizeWords=function capitalizeWords(input){return input.replace(/\w+/g,function(word){return slang.capitalize(word)})};slang.uncapitalizeWords=function uncapitalizeWords(input){return input.replace(/\w+/g,function(word){return slang.uncapitalize(word)})};slang.isUpperCaseAt=function isUpperCaseAt(input,index){return input.charAt(index).toUpperCase()===input.charAt(index)};slang.isLowerCaseAt=function isLowerCaseAt(input,index){return input.charAt(index).toLowerCase()===input.charAt(index)};slang.swapcase=function swapcase(input){return input.replace(/([a-z]+)|([A-Z]+)/g,function(match,lower,upper){return lower?match.toUpperCase():match.toLowerCase()})};slang.camelize=function camelize(input){return input.replace(/\W+(.)/g,function(match,letter){return letter.toUpperCase()})};slang.uncamelize=function uncamelize(input,separator){return input.replace(/([a-z\d])([A-Z])/g,"$1"+(separator||" ")+"$2")};slang.dasherize=function dasherize(input){return input.replace(/\W+/g,"-").replace(/([a-z\d])([A-Z])/g,"$1-$2").toLowerCase()};slang.repeat=function repeat(input,count){return count<1?"":new Array(count+1).join(input)};slang.insert=function insert(input,string,index){return input.slice(0,index)+string+input.slice(index)};slang.remove=function remove(input,start,end){return input.slice(0,start)+input.slice(end)};slang.chop=function chop(input){return input.slice(0,-1)};slang.trim=function strip(input){return input.trim?input.trim():input.replace(/^\s+/,"").replace(/\s+$/,"")};slang.trimLeft=function trimLeft(input){return input.trimLeft?input.trimLeft():input.replace(/^\s+/,"")};slang.trimRight=function trimRight(input){return input.trimRight?input.trimRight():input.replace(/\s+$/,"")};slang.truncate=function truncate(input,args){var limit=args&&args.limit||10,omission=args&&args.omission||"...";return input.length<=limit?input:input.slice(0,limit)+omission};slang.join=function join(array,last){var lastItem=array.pop(),last=last||"and";return array.join(", ")+" "+last+" "+lastItem};slang.humanize=function humanize(number){if(number%100>=11&&number%100<=13)return number+"th";switch(number%10){case 1:return number+"st";case 2:return number+"nd";case 3:return number+"rd"}return number+"th"};slang.contains=function contains(input,string){return input.indexOf(string)>-1};slang.startsWith=function startsWith(input,string){return input.indexOf(string)===0};slang.endsWith=function endsWith(input,string){var index=input.length-string.length;return index>=0&&input.indexOf(string,index)>-1};slang.isBlank=function isBlank(input){return/^\s*$/.test(input)};slang.successor=function successor(input){var alphabet="abcdefghijklmnopqrstuvwxyz",length=alphabet.length,result=input,i=input.length;while(i>=0){var last=input.charAt(--i),next="",carry=false;if(isNaN(last)){index=alphabet.indexOf(last.toLowerCase());if(index===-1){next=last;carry=true}else{var isUpperCase=last===last.toUpperCase();next=alphabet.charAt((index+1)%length);if(isUpperCase){next=next.toUpperCase()}carry=index+1>=length;if(carry&&i===0){var added=isUpperCase?"A":"a";result=added+next+result.slice(1);break}}}else{next=+last+1;if(next>9){next=0;carry=true}if(carry&&i===0){result="1"+next+result.slice(1);break}}result=result.slice(0,i)+next+result.slice(i+1);if(!carry){break}}return result};slang.guid=function guid(length){var buf=[],chars="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",charlen=chars.length,length=length||32;for(var i=0;i<length;i++){buf[i]=chars.charAt(Math.floor(Math.random()*charlen))}return buf.join("")};slang.lang="en";slang.languages={};function Language(){this.plural=[];this.singular=[];this.uncountable=[];this.irregular={plural:{},singular:{}}}slang.Language=Language;Language.prototype.addIrregular=function(irregular){for(var i=0,len=irregular.length;i<len;i++){var item=irregular[i];this.irregular.plural[item[0]]=item[1];this.irregular.singular[item[1]]=item[0]}};Language.prototype.inflect=function(word,type){if(~this.uncountable.indexOf(word.toLowerCase()))return word;var irregular=this.irregular[type][word];if(irregular)return irregular;var rules=this[type];for(var i=0,len=rules.length;i<len;i++){var regexp=rules[i][0];if(regexp.test(word))return word.replace(regexp,rules[i][1])}return word};slang.pluralize=function(word,lang){lang||(lang=slang.lang);lang=slang.languages[lang];if(!lang)return word;return lang.inflect(word,"plural")};slang.singularize=function(word,lang){lang||(lang=slang.lang);lang=slang.languages[lang];if(!lang)return word;return lang.inflect(word,"singular")};slang.addToPrototype=function addToPrototype(){for(key in slang){if(key==="guid"||key==="lang"||key==="languages"||key==="Language"||key==="humanize"||key==="isString"||key==="version"||key==="addToPrototype"){continue}(function(key){String.prototype[key]=function(){var args=Array.prototype.slice.call(arguments);return slang[key].apply(slang,[this].concat(args))}})(key)}};var en=slang.languages["en"]=new slang.Language;en.plural=[[/(todo)$/i,"$1s"],[/(matr|vert|ind)(?:ix|ex)$/i,"$1ices"],[/(octop|vir)us$/i,"$1i"],[/(alias|status)$/i,"$1es"],[/(cris|ax|test)is$/i,"$1es"],[/(s|ss|sh|ch|x|o)$/i,"$1es"],[/y$/i,"ies"],[/(o|e)y$/i,"$1ys"],[/([ti])um$/i,"$1a"],[/sis$/i,"ses"],[/(?:([^f])fe|([lr])f)$/i,"$1$2ves"],[/([^aeiouy]|qu)y$/i,"$1ies"],[/([m|l])ouse$/i,"$1ice"],[/^(ox)$/i,"$1en"],[/(quiz)$/i,"$1zes"],[/$/,"s"]];en.singular=[[/(bu|mis|kis)s$/i,"$1s"],[/([ti])a$/i,"$1um"],[/((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$/i,"$1$2sis"],[/(^analy)ses$/i,"$1sis"],[/([^f])ves$/i,"$1fe"],[/([lr])ves$/i,"$1f"],[/([^aeiouy]|qu)ies$/i,"$1y"],[/ies$/i,"ie"],[/(x|ch|ss|sh)es$/i,"$1"],[/([m|l])ice$/i,"$1ouse"],[/(bus)es$/i,"$1"],[/(shoe)s$/i,"$1"],[/(o)es$/i,"$1"],[/(cris|ax|test)es$/i,"$1is"],[/(octop|vir)i$/i,"$1us"],[/(alias|status)es$/i,"$1"],[/^(ox)en/i,"$1"],[/(vert|ind)ices$/i,"$1ex"],[/(matr)ices$/i,"$1ix"],[/(quiz)zes$/i,"$1"],[/s$/i,""]];en.addIrregular([["i","we"],["person","people"],["man","men"],["child","children"],["move","moves"],["she","they"],["he","they"],["myself","ourselves"],["yourself","ourselves"],["himself","themselves"],["herself","themselves"],["themself","themselves"],["mine","ours"],["hers","theirs"],["his","theirs"],["its","theirs"],["theirs","theirs"],["sex","sexes"],["this","that"]]);en.uncountable=["advice","enegery","excretion","digestion","cooperation","health","justice","jeans","labour","machinery","equipment","information","pollution","sewage","paper","money","species","series","rain","rice","fish","sheep","moose","deer","bison","proceedings","shears","pincers","breeches","hijinks","clippers","chassis","innings","elk","rhinoceros","swine","you","news"]})();