#!/bin/bash

SOURCE="${BASH_SOURCE[0]}"
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
  DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
  SOURCE="$(readlink "$SOURCE")"
  [[ $SOURCE != /* ]] && SOURCE="$DIR/$SOURCE" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
done
DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
DIR=${DIR/etc\/scripts\/restart/}
cd $DIR
sleep 3
if [[ "$OSTYPE" == "darwin"* ]]; then
	cd /Applications
	PID=""
	doMacKill() {
		PID=`ps aux | grep '/AzimutPOS.app/Contents' | grep -v grep | grep -v updater | head -n 1 | awk -F " " '{print $2}'`
		kill -9 $PID
		sleep 2
	}
	doMacKill
	while [ "$PID" !="" ]; do
   		doMacKill # Loop execution
	done
	sleep 2
	open AzimutPOS.app
	exit 0
fi
killall TechnoPOS
killall AzimutPOS
sleep 5
./AzimutPOS &
exit 0