var app;
var fs = require("fs"), self, _foundMacs = {};
module.exports = class EftPayment {
	constructor(cfg, parent) {
		self = this;
		if (parent)
			this.pos = parent;
		app = parent.app;
		self.cfg = {
			comm: cfg
		};
		if (!cfg.provider || cfg.provider == 'NONE') {
			self.pingStatus = {
				current: 'disabled',
			};
			return;
		}
		self.cback = null;
		self.constants = {
			stx: '\x02',
			etx: '\x03',
			ack: '\x06',
			nak: '\x15',

			fs: '\x1C',
			gs: '\x1D',
			rs: '\x1E'

		};
		self.devices = {
			'DESK5000': {
				canPrint: true,
			},
			'iPP320': {
				canPrint: false
			}
		};
		self.features = {
			closeBatch: false
		};
		switch (cfg.mode) {
			case 'ip':
				this.comm = require('../communication/ip');
				break;
			case 'COM':
				this.comm = require('../communication/serial');
				break;
			default:
				console.error('Undefined communication protocol', cfg.mode);
		}

		this.comm._init(cfg, this);
		self._busy = false;
		self._ping = setInterval(function () { self.ping(); }, 60000);
		self.pingStatus = {
			current: null,
			changed: false,
			missed: 0,
			refused: 0,
			pingBack: function (data) {
				if (data.status == 'success') {
					if (self.pingStatus.current != 'up') {
						self.pingStatus.current = 'up';
						self.pingStatus.changed = true;
					}
					self.pingStatus.missed = 0;
					self.pingStatus.refused = 0;
				} else if (data.status == 'error') {
					if (data.code == 'REFUSED') {
						self.pingStatus.refused++;
						if (self.pingStatus.current == null || (self.pingStatus.current == 'up' && self.pingStatus.refused > 10)) {
							self.pingStatus.current = 'warn';
							self.pingStatus.changed = true;
						} else if (['up', 'warn'].indexOf(self.pingStatus.current) != -1 && self.pingStatus.refused > 15) {
							self.pingStatus.current = 'down';
							self.pingStatus.changed = true;
						}
					} else if (data.code == 'UNREACH' || data.code == 'unreachable') {
						self.pingStatus.missed++;
						if (self.pingStatus.current == null || (self.pingStatus.current == 'up' && self.pingStatus.missed > 5)) {
							self.pingStatus.current = 'warn';
							self.pingStatus.changed = true;
						} else if (['up', 'warn'].indexOf(self.pingStatus.current) != -1 && self.pingStatus.missed > 10) {
							self.pingStatus.current = 'down';
							self.pingStatus.changed = true;
						}
					}
					else {
						console.warn('EFT UNKNOWN PING RESULT:', data)
					}
				}
				if (self.pingStatus.changed) {
					self.pos.win.updateEFTNotification(self.pingStatus.current);
					//send info to cloud olo, so we can display info in console
					self.pingStatus.changed = false;
				}
			}
		};
	}
	destroy() {
		clearInterval(self._ping);
	}

	manage() {

		if (!self.dialog) {
			self.dialog = new (require('./dialog/dialog'))(self);
			self.dialog.initialize();
		} else
			self.dialog.win.focus();
	}

	disconnected(timedout) {
		if (typeof self.cback == 'function') {
			self.cback({ status: 'timedout' });
			delete self.cback;
		}
	}

	receive(data) {
		var parse = function (field) {
			var key = field.substr(0, self.cfg.fieldsLength);
			if (key == self.constants.fields.Record) {
				let data = field.split(self.constants.gs);
				data.shift();
				let fields = [];
				for (let d in data)
					fields.push(parse(data[d]));
				return fields;
			} else if (field.indexOf(self.constants.rs) != -1) {
				let fields = [];
				let records = field.split(self.constants.rs);
				records.shift();
				for (let r = 0, rL = records.length; r < rL; r++) {
					let groups = [];
					let record = records[r].split(self.constants.gs);
					record.shift();
					for (let g = 0, gL = record.length; g < gL; g++)
						groups.push(parse(record[g]));
					fields.push(groups);
				}
				return {
					key: self.constants.fields[key],
					code: key,
					value: fields
				};
			} else {
				var out;
				if (self.cfg.sharedAmountField && key == self.constants.fields.ECRTransAmount)
					out = {
						key: 'TransAmount',
						code: key,
						value: field.substr(self.cfg.fieldsLength)
					};
				else
					out = {
						key: self.constants.fields[key],
						code: key,
						value: field.substr(self.cfg.fieldsLength)
					};
				if (self.constants[out.key] && self.constants[out.key][out.value])
					out.valueText = self.constants[out.key][out.value];
				if (out.key == 'TransStatus')
					transStatus = out.value;
				return out;
			}
		};

		var trans = data.split(self.constants.fs);
		var transStatus = trans.shift();
		var fields = [];
		for (let t in trans) {
			fields.push(parse(trans[t]));
		}
		return {
			status: transStatus,
			fields: fields
		};
	}

	startOperation(vars, cback) {

		if (self._busy) {
			cback({ status: 'Busy' });
			return;
		}
		self._busy = true;
		self.send(vars, cback);
	}

	send(vars, cback) {

		var message = '';
		if (!self.cfg.notPrependType) {
			if (!self.constants.TransType[vars.transType]) {
				self._busy = false;
				cback({ status: 'error', message: 'unhandled transaction' + vars.transType + ' for ' + self.provier });
				return;
			}
			message += self.constants.TransType[vars.transType];
		}
		for (let f in vars.fields) {
			message += self.constants.fs;
			message += self.constants.fields[f] + vars.fields[f];
		}
		if (typeof cback == 'function')
			self.cback = cback;
		self.comm.send(message);
	}

	test(cfg, cback) {
		const net = require('net'),
			PORT = cfg.port,
			IP = cfg.ip;
		app.system.net.ping(IP, function (pingRes) {
			if (!pingRes || pingRes.result != 'success') {
				if (cback) cback(pingRes);
				return;
			}
			var socket = new net.Socket();
			socket.on('error', function (err) {
				if (cback) cback({ result: 'error', code: err.code });
			});
			socket.on('connect', () => {
				if (cback) cback({ result: 'success' });
				socket.end();
			});

			socket.on('end', () => {

			});
			socket.connect(PORT, IP);
		});
	}
	ping(cback) {

		if (typeof cback != 'function')
			cback = function (data) {
				self.pingStatus.pingBack(data);
				self.comm.disconnect();
			};
		let
			ip = app.pathExists(app.data.session.configs, 'eft_device.ip'),
			mac = app.pathExists(app.data.session.configs, 'eft_device.macAddress');
		app.system.net.ping(ip, function (pingRes) {
			if (pingRes && pingRes.result != 'success') {
				pingRes.status = pingRes.result;
				if (cback) cback(pingRes);
				return;
			}
			return;

			if (!self.comm.connected && self.constants.TransType.Ping) {
				self.startOperation({ transType: 'Ping' }, cback);
			}
		});
	}

	findDeviceByIP(ip, cback) {
		if (!ip) {
			if (cback) cback(null);
			return;
		}
		app.system.net.arp.get(ip, function (arperr, arpres, arptbl) {
			//console.log('PING EFT', arperr, arpres, arptbl)
			if (!arperr && arpres && arpres.length == 17) {
				try {
					_foundMacs[ip] = '' + arpres;
					if (app.pathExists(app, 'data.session.configs')) {
						app.data.session.configs.eft_device.macAddress = '' + arpres;
						app.sessions.updateCfg({
							eft_device: app.data.session.configs.eft_device
						}, function (data) {
							if (data.result == 'success') {

							}
						});
					}
				} catch (e) { console.error(e.message) }
				if (cback) cback(arpres);
				console.info('Found EFT mac address "' + arpres + '" for ip "' + ip + '"');
				return;
			}
			console.log('PING EFT', arperr, arpres, arptbl)
			if (cback) cback(null);
		});
	}
	manageIPChange() {
		//eft_device
		let
			ip = app.pathExists(app.data.session.configs, 'eft_device.ip'),
			mac = app.pathExists(app.data.session.configs, 'eft_device.macAddress');
		if (!ip) return false;
		if (!mac) {
			app.pos.eft.findDeviceByIP(ip, function (mac) {
				//console.info('found eft mac', ip, mac)
				//if (mac) self.cfg.eft_device.macAddress = '' + mac;
			});
			return;
		}

		var v = app.pathExists(app.system, 'net.arp._lastScan.values');
		if (v && !app.isEmptyObject(v) && v[mac] && v[mac] != ip) {
			console.warn('EFT changed ip address from "' + ip + '" to "' + v[mac] + '"')
			app.data.session.configs.eft_device.ip = '' + v[mac];
			try { self.comm.disconnect(); } catch (er) { }
			self.test(app.data.session.configs.eft_device, function (res) {
				//console.log('EFT SELF TEST', res)
				if (res.result == 'success') {
					console.log('EFT device connected successfully. Updating configs...')
					app.sessions.updateCfg({
						eft_device: app.data.session.configs.eft_device
					}, function (data) {
						//console.log('Update config res', data)
						if (data.result == 'success') {

						}
					});
				} else {
					console.warn('Unable to connect to EFT for self test.')
				}
			});
		}
	}
};