var self,svr;
module.exports = class LiquorControl{
	constructor(cfg,parent){
		self = this;
		if (parent)
			this.pos = parent;
		self.dialogs = {};
		self.cfg = cfg;
		self.constants = {
			stx	: '\x02',
			etx	: '\x03',
			ack	: '\x06',
			nak	: '\x15'
		};
	}

	destroy(){
	}

	manage(restart){
		if(!self.dialogs.manager){
			self.dialogs.manager = new (require('./dialogs/manage/manage'))(self);
			self.dialogs.manager.initialize(restart);
		}else
			self.dialogs.manager.win.focus();
	}

	read(vars,cback){
		if(!self.pos.win.window.APPFCTS.liquorControl.canPour()){
			cback(self.constants.nak);
			return;
		}
		self.pos.win.window.APPFCTS.liquorControl.pourDrink(vars,function(data){
			if(data.result == 'success')
				cback(self.constants.ack);
			else
				cback(self.constants.nak);
		});	
	}
	calculateLRC(str) {
		var bytes = [];
		var lrc = 0;
		for (let i = 0; i < str.length; i++) {
			bytes.push(str.charCodeAt(i));
		}
		for (let i = 0; i < str.length; i++) {
	 		lrc ^= bytes[i];
		}
		return String.fromCharCode(lrc);
	}
};