var app, ws = {
	init: function (parent, cback) {

		app = parent;
		if (cback) cback();
	},
	convertLess: function (cback) {

	},
	start: function (vars) { //app.pos.notifications.show=function (vars) {
		if (ws.win) {
			ws.win.show();
			ws.win.focus();
			return;
		}
		if (!vars) vars = {};
		let id = app.system.uuid.get(),
			file = 'libs' + __dirname.split('/libs').pop() + '/workstation_header.html';
		if (!vars.icon) vars.icon = 'http://localhost:4202/AzimutPOS.png';
		if (!vars.width) vars.width = screen.availWidth;
		if (!vars.height) vars.height = screen.availHeight;
		nw.Window.open(file, {
			title: vars.title,
			show: false,
			position: 'center',
			width: vars.width,
			height: vars.height,
			transparent: false,
			show_in_taskbar: true,
			frame: true,
		}, function (win) {
			if (win) {
				ws.broadcastInterval;
				ws.openTime = new Date().getTime();
				//win.setShowInTaskbar(false);
				ws.win = win;
				let _winObj = win.window;
				//win.setAlwaysOnTop(true);
				win.focus();
				win.on('blur', function () {
					if (vars.focusOnBlur) {
						win.focus();
					}
				});
				win.on('loaded', function () {

					app.tryCatch(function () { app.pos.weather.bind(_winObj); });
					_winObj.getRegisterConfig = function (cback) {
						app.data.session.configs.hardware = {
							screens: app.utilities.screens
						};
						cback(app.data.session.configs);
						try { app.pos.neighbors.updateGUI(win); } catch (er) { }
						try { app.pos.weightScale.getData(win); } catch (er) { }
					};
					clearInterval(ws.broadcastInterval);
					_winObj.async = app._m.async;
					_winObj.uuid = app.system.uuid;
					_winObj.APPFCTS.db = app.pos.db;
					_winObj.coreFunction = function (d, cback) {
						app.web.emit({
							module: 'core',
							action: d.action || 'event',
							datas: d.datas
						}, function (res) {
							cback(res);
						});
					};
					_winObj.cloud = {
						emit: function (d, cback) {
							if (app.web.status != 'online') {
								if (cback) {
									cback({ result: 'error', status: 'offline' });
									return;
								}
							}
							app.pos.production.emit({ module: 'workstation', action: d.action, data: d.data }, function (res) {
								cback(res);
							});
						}
					};
					_winObj.svr = {
						db: {
							query: function (query, fields, cback) {
								if (typeof fields == 'function' && !cback) {
									cback = fields;
									fields = [];
								}
								_winObj.svr.emit({
									action: 'db_query',
									data: {
										query: query,
										fields: fields
									}
								}, function (res) {
									cback(res.error, res.rows)
								})
							}
						},
						emit: function (d, cback) {
							if (app.pos.serverWS.status != 'online') {
								if (cback) {
									cback({ result: 'error', status: 'offline' });
									return;
								}
							}
							app.pos.production.serverwsEmit({ module: 'workstation', action: d.action, data: d.data }, function (res) {
								cback(res);
							});
						}
					};
					_winObj.neighbors = {
						broadcast: function (d) {
							app.pos.neighbors.broadcast(d);
						},
						send: function (node, d, cback) {
							app.pos.neighbors.send(node, d, function (res) {
								cback(res);
							});
						}
					};
					_winObj.ws = {
						registers: {},
						registerId: app.data.session.configs.server.url.local.match(/^.*\/(REG\-[A-Z0-9]+)/)[1],
						logout: (job, options, cb) => {
							if (!cb && typeof options === 'function') {
								cb = options
								options = {}
							}
							_winObj.ws.broadcastStatus({ status: 'available' })
							if (job && job.hasOwnProperty('production')) {
								if (!options.skipJobSave) {
									job.production.status = 'pending';
									_winObj.ws.saveJob(job, cb)
								} else cb()
							} else cb()
						},
						login: (nip, reservedUser, cb) => {
							_winObj.APPFCTS.crypto.sha1(nip, (hashedNip) => {
								_winObj.svr.db.query('SELECT hourly_pay_rate, username, language, is_lefty, person_id FROM employees WHERE password_nip=\'' + hashedNip + '\' AND deleted=\'0\'', (err, rows) => {
									if (!err && rows.length == 1) {
										if (!reservedUser || rows[0].person_id == reservedUser) {
											try {
												_winObj.APPFCTS.db.find('production_employee_qualifications', { $and: [{ employee: rows[0].person_id }, { qualified: "1" }] }, (err, employeeQualifDocs) => {
													console.log(employeeQualifDocs)
													_winObj.APPFCTS.db.find('production_qualifications', { $and: [{ _id: { $in: Array.from(employeeQualifDocs, employeeQualifDoc => employeeQualifDoc.qualification_id) } }, { deleted: 0 }] }, (err, qualifDocs) => {
														console.log(qualifDocs)
														_winObj.APPFCTS.db.find('production_tasks_qualifications', { qualification_id: { $in: Array.from(employeeQualifDocs, employeeQualifDoc => employeeQualifDoc.qualification_id) } }, (err, tasksQualifsDocs) => {
															console.log(tasksQualifsDocs)
															_winObj.APPFCTS.db.find('production_tasks', { $and: [{ _id: { $in: Array.from(tasksQualifsDocs, tasksQualifsDoc => tasksQualifsDoc.task_id) } }, { deleted: 0 }] }, (err, taskDocs) => {
																console.log(taskDocs)
																if (err) {
																	console.error(err)
																	cb('couldNotGetQualifications', docs)
																} else {
																	tasks = taskDocs == null ? [] : Array.from(taskDocs.hasOwnProperty(length) ? taskDocs : [taskDocs], task => task._id)
																	qualifs = qualifDocs == null ? [] : Array.from(qualifDocs.hasOwnProperty(length) ? qualifDocs : [qualifDocs], qualif => qualif._id)

																	cb(err, {
																		user: {
																			...rows[0],
																			tasks: tasks,
																			qualifs: qualifs,
																		},
																	})
																}
															});
														});
													});
												})
											} catch (e) {
												console.error(1);
												cb('couldNotGetQualifications', doc)
											}
										} else {
											cb('invalidReservedUser', rows)
										}
									} else {
										cb('pinInvalid', rows)
										if (err) console.error(err);
									}
								})
							})
						},
						getLabels: (cb) => {
							_winObj.APPFCTS.db.find('print_labels', {}, (err, docs) => {
								if (err) console.error(err);
								cb(docs || [], require('./constants/labelFormats.json'));
							});
						},
						getTaskQualif: (taskId, cb) => {
							_winObj.APPFCTS.db.find('production_tasks_qualifications', { $and: [{ taskId: taskId }, { deleted: 0 }] }, (err, doc) => {
								cb(err, doc)
							});
						},
						getItem: (item, options, cb) => {
							if (!cb && typeof options === 'function') {
								cb = options
								options = {}
							}
							app.system.request.GET(ws.posApiBaseUrl() + 'items/get_item_info?' +
								'itemId=' + item.item_id + '&' +
								'variationId=' + (item.variation_id || 0) + '&' +
								'locationId=' + _winObj.APPFCTS.registerConfig.branch.id + '&' +
								'getInventory=' + (options.getInventory ?? 1) + '&' +
								'x-api-key=' + app.data.session.configs.server.apiKey,
								(e, r, b) => {
									if (e) cb({ err: e })
									else {
										try {
											b = JSON.parse(b);
											cb(b);
										} catch (e) { cb({ err: e }) }
									}
								});
						},
						haveQtyRequired: (stepInputs, runRequired, cb) => {
							if (!stepInputs) {
								cb(null, true);
								return;
							}
							var items = Array.from(stepInputs, itemGroup => {
								if (app.pathExists(itemGroup, 'items')) {
									item = itemGroup.items[0];
									return {
										itemId: item.item_id,
										variationId: item.variation_id || 0,
										qty: parseFloat(item.quantity) * runRequired,
										locationId: _winObj.APPFCTS.registerConfig.branch.id,
										source: 'batches',
									}
								}
							})
							app.system.request.POST(ws.posApiBaseUrl() + 'items/have_qty_required', {
								items: items,
								source: 'batches',
								'x-api-key': app.data.session.configs.server.apiKey
							}, (e, r, b) => {
								if (e) console.error(e);
								cb(e, b);
							});
						},
						editItemQty: (type, job, user, ioObj, cb) => {
							var now = new Date(Date.now());
							var year = now.getFullYear();
							var month = ('0' + now.getMonth()).slice(-2);
							var date = ('0' + now.getDate()).slice(-2);
							var hours = ('0' + now.getHours()).slice(-2);
							var minutes = ('0' + now.getMinutes()).slice(-2);
							var dateReadable = year + '-' + month + '-' + date + ' ' + hours + ':' + minutes;

							var editsList = [];

							ioObj.forEach((io) => {
								var log = {
									trans_items: io.itemId,
									trans_user: user.person_id,
									trans_date: now,
									trans_comment: 'Production: ' + job.name + ' (' + dateReadable + ')',
									trans_log: {
										type: 'job_' + type,
										target_id: type == 'inputs' ? job.job_id : 0,
										source_id: type == 'inputs' ? 0 : job.job_id,
									},
									trans_inventory: type == 'inputs' ? io.quantity * -1 : io.quantity,
									location_id: _winObj.APPFCTS.registerConfig.branch.id,
								}
								if (io.variationId) log.item_variation_id = io.variationId;
								editsList.push({
									itemId: io.itemId,
									variationId: io.variationId,
									batchId: io.batchId,
									locationId: _winObj.APPFCTS.registerConfig.branch.id,
									log: log,
									args: {
										createBatch: type == 'outputs' ? {
											name: dateReadable,
											cost_price: io.costPrice
										} : 0,
										orderProduced: io.targets || 0,
										reserve: io.targets || 0 ? 0 : 0
									},
								});
							});
							app.system.request.POST(ws.posApiBaseUrl() + 'items/save_item_qty',
								{ edits: editsList, 'x-api-key': app.data.session.configs.server.apiKey },
								{ json: true, options: { maxTries: 1 } },
								function (e, r, b) {
									console.log(b);
									cb(b);
								});
						},
						//jobs are filtered by tasks only after the query due to limitations regarding indexes
						getAvalJobs: (qualifiedTasks, cb, options) => {
							if (!options) options = {};
							var offset = options.offset || 0
							var skipLocalJob = options.skipLocalJob || false

							var getJobs = (qualifiedTasks, cb, options) => {
								if (!options) options = {};
								var offset = options.offset || 0
								var force_id = options.force_id || false;
								var query = {
									$and: [{ 'production.status': { $in: ['pending', 'notStarted'] } }, { deleted: 0 }, { 'production.location_ids': _winObj.APPFCTS.registerConfig.branch.id }]
								};
								if (force_id) query = {
									$and: [{ _id: force_id }, { 'production.status': { $nin: ['stopped', 'completed'] } }, { deleted: 0 }, { 'production.location_ids': _winObj.APPFCTS.registerConfig.branch.id }]
								}

								_winObj.APPFCTS.db.find('production_workorder_jobs',
									query,
									{ includeData: true, sort: { dueDate: 1, currentStep: 1 }, skip: offset, limit: 10 },
									(err, docs) => {
										console.log(docs);
										var avalJobs = [];
										if (!docs.length && !force_id) {
											cb(docs);
											return;
										}
										if (!(docs instanceof Array)) docs = [docs];
										app._m.async.eachSeries(docs, (doc, next) => {
											console.log(doc)
											var currentStep = doc.currentStep || 0;
											if (qualifiedTasks?.includes(doc.steps[currentStep].task) && !Array.from(_winObj.ws.registers)?.includes(doc.workOrderJob_id)) {
												if (doc.jobProgress && (doc.jobProgress[currentStep].inputsDone || !doc.jobProgress[currentStep].inputs)) {
													avalJobs.push(doc);
													next()
												} else {
													_winObj.ws.haveQtyRequired(doc.steps[currentStep].inputs, Math.min(parseFloat(doc.production.runRequired), parseFloat(doc.prodMax)),
														(err, haveQtyRequired) => {
															if (haveQtyRequired)
																avalJobs.push(doc);
															next()
														})
												}
											} else next()
										}, () => {
											console.log('cb');
											if (!avalJobs.length) {
												_winObj.ws.getAvalJobs(qualifiedTasks, cb, { skipLocalJob: true, offset: force_id ? 0 : offset + 10 })
											} else {
												_winObj.ws.broadcastStatus({ status: 'selectingJob' })
												cb(avalJobs, force_id)
											}
										})
									});
							}
							if (offset == 0 && !skipLocalJob) {
								_winObj.ws.getLocalJob((jobs) => {
									if (jobs.length && qualifiedTasks?.includes(jobs[0].steps[jobs[0].currentStep || 0].task) && !Array.from(_winObj.ws.registers, register => register.workOrderJob_id)?.includes(jobs[0].workOrderJob_id)) {
										getJobs(qualifiedTasks, cb, { force_id: jobs[0]._id })
									}
									else
										getJobs(qualifiedTasks, cb)
								})
							} else getJobs(qualifiedTasks, cb, { offset: offset })
						},
						getWorkOrderJobTasks: (job, cb) => {
							var taskList = Array.from(job.steps, step => step.task);
							_winObj.APPFCTS.db.find('production_tasks', { $and: [{ _id: { $in: taskList } }, { deleted: 0 }] }, (err, taskDocs) => {
								console.log(taskDocs)
								cb(taskDocs ? (taskDocs.hasOwnProperty(length) ? taskDocs : [taskDocs]) : [])
							})
						},
						getRegisterTasks: (registerId, cb) => {
							_winObj.APPFCTS.db.find('production_tasks_devices', { $and: [{ device: registerId }, { enabled: '1' }] }, (err, taskDocs) => {
								console.log(taskDocs);
								cb(err, Array.from(taskDocs, task => task.task_id))
							})
						},
						selectJob: (data, cb) => {
							var user = data.user;
							var register = data.register;
							var registers = app.data.session.configs.registers;
							var job = data.job;

							var saveAndSplit = (job, cb, skipLocalSaveAndSplit) => {
								job.production.status = 'inProgress';
								if (skipLocalSaveAndSplit === undefined) skipLocalSaveAndSplit = false
								_winObj.ws.saveJob(job, { skipLocalSave: skipLocalSaveAndSplit }, (err, editsNum, affectedDocs) => {
									var selectedJob = affectedDocs
									if (skipLocalSaveAndSplit) {
										if (typeof cb === 'function') cb(selectedJob)
									} else {
										_winObj.ws.splitJob(selectedJob, (job) => {
											if (typeof cb === 'function') cb(job)
										})
									}
								})
							}
							try {
								var registerCanDoTask = register.tasks.includes(job.steps[job.currentStep || 0].task);
								if (registerCanDoTask && (!job.production.hasOwnProperty('workstation') || job.production.workstation == register.id)) {
									saveAndSplit(data.job, (job) => {
										_winObj.ws.pushJob(job, user, cb);
									})
								} else {
									var continueLoop = true;
									app._m.async.eachOf(registers, (register, register_id, next) => {
										var deviceType = app.data.session.configs.registers[register_id].configs.device_type;
										var isWorkStation = _winObj.ws.registers.hasOwnProperty(register_id) && _winObj.ws.registers[register_id].status == 'available'
										if (continueLoop && register.online == 1 && isWorkStation && deviceType == 'workstation') {
											_winObj.ws.getRegisterTasks(register_id, (err, tasks) => {
												var registerCanDoTask = tasks.includes(job.steps[job.currentStep || 0].task);

												if (registerCanDoTask && (!job.production.hasOwnProperty('workstation') || ((!job.jobProgress || (job.jobProgress && job.jobProgress.length == 1)) && job.production.workstation == key))) {
													_winObj.neighbors.send(register_id, {
														module: 'workstation',
														action: 'reserveRegister',
														data: {
															person_id: user.person_id,
															username: user.username,
															workOrderJob_id: job.workOrderJob_id,
														}
													})
													saveAndSplit(job, () => {
														cb({ redirect: _winObj.APPFCTS.registerConfig.registers[register_id].name })
													}, true)
													continueLoop = false;
													next()
												} else
													next()
											});
										} else if (!isWorkStation) {
											_winObj.ws.broadcastStatus(register_id, true)
										} else next();
									}, () => {
										if (continueLoop) {
											console.warn('no reg can do task');
											cb({ err: 'noRegCanDoTask' })
										}
									})
								}
							} catch (e) {
								console.error(e);
								_winObj.APPFCTS.db.update('production_workorder_jobs', { _id: data.job._id }, { $set: { 'production.status': 'pending' } }, (err, editsNum, affectedDocs) => { });
							}
						},
						//Split job into 2 jobs if runRequired > maxProd
						//Save one of them in DB, return the other
						//else return job
						splitJob: (job, cb) => {
							if (parseInt(job.production.runRequired) > parseInt(job.prodMax)) {
								var jobs = { 'inProgress': app._m.xtend.clone(job), 'toStore': app._m.xtend.clone(job) };
								app._m.async.eachSeries(Object.keys(jobs), (key, next_1) => {
									var jobClone = jobs[key];
									var runRequired = key == 'inProgress' ? parseFloat(job.prodMax) : parseFloat(job.production.runRequired) - parseFloat(job.prodMax);
									app._m.async.eachSeries(['inputsRequired', 'outputExpected', 'outputs'], (ioType, next_2) => {
										if (jobClone.production[ioType] instanceof Array) {
											app._m.async.eachSeries(jobClone.production[ioType], (io, next_3) => {
												io.unitsTotal = parseFloat(io.quantity) * runRequired;
												next_3()
											}, () => next_2())
										} else {
											app._m.async.eachSeries(Object.values(jobClone.production[ioType]), (outputs, next_3) => {
												app._m.async.eachSeries(Object.keys(outputs.orders), (orderId, next_4) => {
													outputs.orders[orderId] = parseFloat(outputs.orders[orderId]) / parseFloat(job.production.runRequired) * runRequired;
													next_4()
												}, () => next_3())
												outputs.inventory = parseFloat(outputs.inventory) / parseFloat(job.production.runRequired) * runRequired
											}, () => next_2())
										}
									}, () => {
										if (key == 'toStore') {
											delete jobClone._id;
											jobClone.workOrderJob_id = app.system.uuid.get()
											jobClone.production.status = 'notStarted'
										}
										jobClone.production.runRequired = runRequired;
										next_1()
									})
								}, () => {
									_winObj.APPFCTS.db.find('production_workorder_jobs', { workOrder_id: job.workOrder_id }, (err, docs) => {
										jobs['toStore'].workNumber = jobs['toStore'].workOrderNumber + '-' + (docs.length + 1)
										_winObj.ws.saveJob(jobs['inProgress'], (err, numDocs, affectedDocs) => {
											if (err) console.error(err);
											_winObj.APPFCTS.db.insert('production_workorder_jobs', jobs['toStore'], (err, doc) => {
												if (err) console.error(err);
												cb(jobs['inProgress']);
											});
										});
									})
								})
							} else cb(job);
						},
						pushJob: (job, user, cb) => {
							//get next job step || last pending job step && broadcast
							var setUserAndSave = (job, user, cb) => {
								job.jobProgress[job.jobProgress.length - 1].user = user;
								_winObj.ws.saveJob(job, (err, editsNum, affectedDocs) => {
									cb({ job: job });
								})
							}
							_winObj.ws.broadcastStatus({ status: 'occupied', workOrderJob_id: job.workOrderJob_id });
							if (!job.jobProgress || job.jobProgress[job.jobProgress.length - 1].status == 1) {
								currentStep = job.steps[job.jobProgress ? job.jobProgress.length - 1 : 0]
								job.currentStep = job.jobProgress ? job.jobProgress.length - 1 : 0;
								if (!job.jobProgress) job.jobProgress = [];

								var jobProgress = {
									inputs: currentStep.inputs ? [] : false,
									outputs: currentStep.outputs ? [] : false,
									task: currentStep.task,
									sort: currentStep.sort,
									totalElapsedTime: 0,
									actualElapsedTime: 0,
									step_id: currentStep.step_id
								}
								job.jobProgress.push(jobProgress);
								setUserAndSave(job, user, cb)
							} else setUserAndSave(job, user, cb)
						},
						saveJob: (job, options, cb) => {
							if (!cb && typeof options === 'function') {
								cb = options;
								options = {};
							} else if (!options) {
								options = {}
							}
							if (job.jobProgress && typeof job.currentStep === 'number') {
								if (job.jobProgress[job.currentStep].outputExpected) delete job.jobProgress[job.currentStep].outputExpected;
								if (job.jobProgress[job.currentStep].inputsRequired) delete job.jobProgress[job.currentStep].inputsRequired;
							}
							_winObj.APPFCTS.db.update('production_workorder_jobs', { _id: job._id }, { $set: job }, (err, numDocs, affectedDocs) => {
								if (options.jobFinished) {
									_winObj.APPFCTS.db.find('production_workorder_jobs', { workOrder_id: job.workOrder_id }, (err, docs) => {
										var allJobsDone = true;
										app._m.async.eachSeries(docs, (workOrderJob, next) => {
											if (allJobsDone && workOrderJob.production.status != 'completed') allJobsDone = false;
											next()
										}, () => {
											if (allJobsDone) {
												_winObj.ws.saveJobLocally(job, allJobsDone, () => {
													_winObj.APPFCTS.db.find('production_workorders', { workOrder_id: job.workOrder_id }, (err, docs) => {
														_winObj.APPFCTS.db.update('production_workorders', { _id: docs[0]._id }, { $set: { status: 'completed' } }, (err, numDocs, affectedDocs) => {
															if (err) console.error(err)
															cb()
														})
													})
												})
											} else _winObj.ws.saveJobLocally(job, allJobsDone, cb)
										})
									})
								}
								else if (!options.skipLocalSave)
									_winObj.ws.saveJobLocally(job, false, cb)
								else if (typeof cb === 'function')
									cb(err, numDocs, affectedDocs)
							});
						},
						deleteLocalJobs: () => {
							_winObj.ws.getLocalJob((jobs) => {
								if (jobs !== null && jobs.length) {
									jobs.forEach((job) => {
										_winObj.APPFCTS.db.remove('production_current_job', job._id, (err, numDocs) => {
											console.log(numDocs);
										})
									})
								}
							})
						},
						saveJobLocally: (job, completed, cb) => {
							if (completed) job.done = true;
							_winObj.ws.getLocalJob((docs) => {
								if (docs !== null && docs.length) {
									_winObj.APPFCTS.db.remove('production_current_job', docs[0]._id, (err, numDocs, affectedDocs) => {
										if (job['production.status']) delete job['production.status']
										_winObj.APPFCTS.db.insert('production_current_job', job, (err, doc) => {
											if (err) console.error(err);
											if (typeof cb === 'function') cb(err, 1, doc)
										})
									})
								} else {
									if (job['production.status']) delete job['production.status']
									_winObj.APPFCTS.db.insert('production_current_job', job, (err, doc) => {
										if (err) console.error(err);
										if (typeof cb === 'function') cb(err, 1, doc)
									})
								}
							})
						},
						getLocalJob: (cb) => {
							_winObj.APPFCTS.db.find('production_current_job', {}, (err, docs) => {
								if (typeof cb === 'function') cb(docs);
							})
						},
						stopJob: (data, cb) => {
							data.job.production.status = 'stopped';
							alert = {
								user: { name: data.user.username, id: data.user.person_id },
								message: data.message,
								title: data.title,
								alertLevel: 3
							}
							_winObj.ws.pushWoAlert(alert, data.job.workOrder_id, () => {
								_winObj.ws.saveJob(data.job, () => {
									cb()
								})
							})
						},
						getJob: (workOrderJob_id, cb) => {
							_winObj.APPFCTS.db.find('production_workorder_jobs', { workOrderJob_id: workOrderJob_id }, { includeData: true }, (err, docs) => {
								cb(err, docs[0])
							})
						},
						printLabels: (data, cb) => {
							app.printManager.generateLabel({
								data: data,
								qty: data.qty,
								cb: (label) => {
									app.printManager.print({
										printer: '' + app.pos._cfg.printer.labels[data.formats[data.template.format].type == 'sheet' ? 'label_sheet' : 'label_printer'],
										type: 'pdf',
										data: label,
									}, function (res) {
										console.log(res);
									});
								}
							})
						},
						pushWoAlert: (alert, workOrder_id, cb) => {
							alert.register = { id: _winObj.ws.registerId, name: app.data.session.configs.registers[_winObj.ws.registerId].name }
							alert.createdAt = new Date(Date.now()).toISOString()
							alert.dismissed = 0

							_winObj.APPFCTS.db.find('production_workorders', { workOrder_id: workOrder_id }, { includeData: true }, (err, docs) => {
								var alertLevel = alert.alertLevel
								console.log(docs);
								app._m.async.eachSeries(docs[0].alerts ?? [], (woAlert, next) => {
									console.log(woAlert);
									if (alertLevel < woAlert.alertLevel) alertLevel = woAlert.alertLevel
									next()
								}, () => {
									alert.index = (docs[0].alerts ?? []).length
									console.log({ alertLevel: alertLevel, alerts: [...(docs[0].alerts ?? []), alert] });
									_winObj.APPFCTS.db.update('production_workorders',
										{ _id: docs[0]._id },
										{ $set: { alertLevel: alertLevel, alerts: [...(docs[0].alerts ?? []), alert] } },
										(err, numDocs, affectedDocs) => {
											console.log(affectedDocs);
											if (err) console.error(err)
											if (typeof cb === 'function') cb()
										})
								})
							})
						},
						neighborsStatusReq: () => {
							var continueLoop = true;
							app._m.async.eachOf(app.data.session.configs.registers, (register, register_id, next) => {
								if (continueLoop && register.online == 1 && register.configs.device_type == 'workstation') {
									_winObj.neighbors.send(register_id, {
										module: 'workstation',
										action: 'neighborsStatusReq',
										data: _winObj.ws.registerId
									})
									continueLoop = false;
									next();
								} else next();
							}, () => {
								if (continueLoop) {
									console.warn('Nobody could give me there status :(')
									_winObj.ws.registers[_winObj.ws.registerId] = {
										status: 'available'
									}
									setTimeout(() => {
										_winObj.ws.neighborsStatusReq()
									}, 10000)
								}
							})
						},
						setNeighborsStatus: (data, cb) => {
							if (data.remove) {
								delete _winObj.ws.registers[data.data];
							} else if (data.registerId)
								_winObj.ws.registers[data.registerId] = data.data
							else {
								data[_winObj.ws.registerId] = { status: 'available' }
								_winObj.ws.registers = data;
								_winObj.ws.broadcastStatus({ status: 'available' });
							}
							if (typeof cb === 'function') cb();
						},
						emitNeighborsStatus: (registerId) => {
							_winObj.neighbors.send(registerId, {
								module: 'workstation',
								action: 'neighborsStatusRes',
								data: _winObj.ws.registers
							})
						},
						broadcastStatus: (registerData, remove) => {
							_winObj.ws.registers[_winObj.ws.registerId] = registerData;
							_winObj.neighbors.broadcast({
								module: 'workstation',
								action: 'updateStatus',
								data: {
									data: registerData,
									registerId: _winObj.ws.registerId,
									remove: remove || false
								},
								filterIds: Array.from(Object.keys(_winObj.ws.registers), registerId => registerId)
							})
						}
					};
					_winObj.ws.neighborsStatusReq()
					ws.broadcastInterval = setInterval(() => {
						_winObj.ws.broadcastStatus(_winObj.ws.registers[_winObj.ws.registerId]);
					}, 15000);
					win.show();
				});
				win.onExit = function () {
					if (vars.preventClose) {
						win.show();
						win.focus();
						return false;
					}
				};
				win.on('close', function () {
					if (vars.preventClose) {
						win.show();
						return;
					}
				});
			}
		});
		return ws;
	},
	posApiBaseUrl: () => { return app.pos.url + '/index.php/api/v2/' },
	routeInterNode: (d) => {
		if (!app.pathExists(ws, 'win.window.ws')) {
			setTimeout(() => {
				ws.routeInterNode(d);
			}, 1000)
		} else {
			switch (d.action) {
				case 'reserveRegister':
					ws.win.window.APPFCTS.call('reserveRegister')(d.data);
					break;
				case 'neighborsStatusReq':
					ws.win.window.ws.emitNeighborsStatus(d.data)
					break;
				case 'neighborsStatusRes':
					ws.win.window.ws.setNeighborsStatus(d.data, () => {
						ws.win.window.ws.broadcastStatus({
							status: 'available',
						})
					})
					break;
				case 'updateStatus':
					ws.win.window.ws.setNeighborsStatus(d.data)
					break;
			}
		}
	},
	exit: function () {
		if (ws.win) {
			try {
				ws.win.close(true);
			} catch (er) { }
		}
	},
};
module.exports = ws;