var app, self;
module.exports = class accessControl {
	constructor(parent) {
		app = parent;
		self = this;
		this.isRunning = false;
		this.keepRunningOnClose = false;
		self.windowState = 'closed';
	}
	initialize(cback) {
		if (cback) cback();
	}
	start() {
		self.apiUrl = '' + app.pos.url + 'index.php/&secureToken=' + app.data.secureAccessToken;

		if (['restarting', 'updating'].indexOf(app.status) != -1) return;
		if (self.isInitializing) return;
		self.isInitializing = true;
		if (self.isRunning) {

			if (self.win) {
				self.isInitializing = false;
				//console.log('POS already runnin')
				self.isRunning = true;
				self.win.show();
				return;
			}
		}

		let _options = {
			icon: 'AzimutPOS.png',
			title: "AzimutPOS",
			show: false,
			position: 'center',
			width: screen.availWidth,
			height: screen.availHeight,
			min_width: 1024,
			min_height: 768,
			//frame: false,
		};

		nw.Window.open(app._appPath + 'libs/pos/security/accessControl/assets/accessControl.html', _options, function (win) {
			//console.log('POS Window opened', win)
			//console.logRaw(win)
			//try {
			self.isRunning = true;
			self.win = win;
			let _winObj = win.window;
			let _registerWindowFunctions = function () {
				_winObj.getRegisterConfig = function (cback) {
					app.data.session.configs.hardware = {
						screens: app.utilities.screens
					};
					cback(app.data.session.configs);
				};

				_winObj.onExit = function () {
					console.log('accessControl EXIT')
					self.isRunning = false;
					//self.setWindowStatus('closed');
					win.hide();
					//if (!self.keepRunningOnClose)
					//    self.app.exit(0);
				};
				_winObj.coreFunction = function (d, cback) {
					app.web.emit({
						module: 'core',
						action: d.action || 'event',
						datas: d.datas
					}, function (res) {
						cback(res);
					});
				};
			},
				_firstLoadDone = false, _firstLoad = function () {
					if (_firstLoadDone) return;
					_firstLoadDone = true;
					win.show();
				};
			win.on('loaded', function () {
				_registerWindowFunctions();
				_firstLoad();

			});
			win.on('minimize', function () {
				win.hasFocus = false;
				//console.log('POS is minimized');
				win.show();
				win.focus();
				//_checkForFocus();
				//self.sendFocusInfo();
			});
			win.on('focus', function () {
				win.hasFocus = true;
				//console.log('POS has focus');
				//self.sendFocusInfo();
			});
			win.on('blur', function () {
				win.hasFocus = false;
				//win.show();
				//win.focus();
			});
			win.on('close', function () {
				win.show();
				win.focus();
			});

		});
	}
};