//list all IPs from subnet, then ping all of them to force arp discovery
var
	imgsCnt = 0,
	config = null,
	intv = null,
	_stream = null,
	events = {},
	fs = require('fs'),
	request = require('request'),
	images = [],
	isEmptyObject = function (obj) {
		for (var prop in obj) {
			if (obj.hasOwnProperty(prop))
				return false;
		}
		return true;
	},
	pathExists = function (o, p) {
		if (!o || !p) return false;
		p = p + '';
		var m = (p.indexOf('.') != -1) ? p.split(".") : [p];
		if (m.length > 1 && !m[0])
			m.shift();
		var cm = o;
		for (var i = 0; i < m.length; i++) { // Here we need to take special care of possible method calls and arrays, but I am too lazy to write it down.
			if (cm == null)
				return false;
			if (typeof cm[m[i]] !== 'undefined')//if(currentMember.hasOwnProperty(members[i]))
				cm = cm[m[i]];
			else
				return false;
		}
		return cm;
	},
	gotImage = function (mime, img) {
		let _d = new Date().toISOString();
		images.push({
			date: _d,
			data: img.toString('base64')
		});
		//fs.writeFileSync(config.tmp_folder + 'imgtest_' + _d + (mime.indexOf('/png') != -1 ? '.png' : '.jpg'), img);
		if (images.length > imgsCnt)
			images.shift();
		//loop pending events
		if (events && !isEmptyObject(events)) {
			let e = Object.keys(events);
			for (i = 0; i < e.length; i++) {
				if (events[e[i]] && !events[e[i]].cbacked) {
					if (images.filter(function (a) {
						return new Date(a.date).getTime() >= new Date(events[e[i]].date).getTime();
					}).length >= (events[e[i]].toCapture || 0)) {
						//send it!
						events[e[i]].cback();
					}
				}
			}
		}
	},
	startStream = function () {
		var rtsp = require('./rtsp/rtsp-ffmpeg');
		_stream = new rtsp.FFMpeg({ input: config.camera.url });//, resolution: '320x240', quality: 3
		_stream.on('start', function () {
			process.send({ action: 'stream_started' });
			//console.log('stream started');
		});
		if (pathExists(config, 'camera.debug') == '1') _stream.send('debug', '1');
		_stream.on('stream_stderr', function (data) {
			process.send({ action: 'stream_stderr', data: data });
		})
		_stream.on('error', function (error) {
			process.send({ action: 'stream_error', error: { code: error.code, message: error.message } });
			//console.log('stream stopped');
		});
		_stream.on('stop', function () {
			process.send({ action: 'stream_stopped' });
			//console.log('stream stopped');
		});
		let _throttle = null;
		_stream.on('data', function (data) {
			let fps = 1000 / (config.camera.fps || 1);
			if (_throttle) return;
			_throttle = setTimeout(function () {
				_throttle = null;
			}, fps);
			gotImage('image/jpeg', data);
		});
	},
	doCap = function () {
		if (!config.camera.url) return false;
		if (config.camera.url.indexOf('rtsp:') === 0) {
			if (!_stream) startStream();
			return;
		}
		request({
			method: 'GET',
			url: config.camera.url,
			headers: {
				'User-Agent': config.cfg.userAgent + '/' + config.cfg.version
			},
			encoding: null,
			followAllRedirects: true,
			timeout: 500
		}, function (er, res, body) {
			if (pathExists(config, 'camera.debug') == '1') process.send({ action: 'captureDebug', data: { er: er, res: res, body: body } });
			if (body && body.length) {
				gotImage(res.headers['content-type'], body);
			}
		});
	},
	start = function () {
		imgsCnt = 0;
		if (pathExists(config, 'camera.enabled') == '1') {
			imgsCnt += 1;
			imgsCnt += 1 * (pathExists(config, 'camera.capture_on_drawer.images.before') || 0);
			imgsCnt += 1 * (pathExists(config, 'camera.capture_on_drawer.images.after') || 0);

			imgsCnt += 1 * (pathExists(config, 'camera.capture_on_login.images.before') || 0);
			imgsCnt += 1 * (pathExists(config, 'camera.capture_on_login.images.after') || 0);
			if (pathExists(config, 'camera.enabled') == '1') {
				clearInterval(intv);
				process.send({ action: 'capturing' })
				doCap();
				let fps = 1000 / (pathExists(config, 'camera.fps') || 1);
				intv = setInterval(doCap, fps - 20);
				return;
			}
			process.send({ action: 'not_enabled' });
			process.exit(0);

		}
	};

process.on('uncaughtException', function (err) {
	process.send({ action: 'error', error: err.message })
	//if (app) app.exit(1); else process.exit(1);
});
process.on('message', function (msg) {
	//process.send({ action: 'log', data: msg })
	switch (msg.action) {
		case 'config':
			config = msg.data;
			start();
			break;
		case 'exit':
			if (_stream) {
				try { _stream.stop(); } catch (er) { }
			}
			process.exit();
			break;
		case 'capture':
			let _cnt = 1;
			_cnt += 1 * (pathExists(config, 'camera.capture_on_' + msg.data.type + '.images.before') || 0);
			_cnt += 1 * (pathExists(config, 'camera.capture_on_' + msg.data.type + '.images.after') || 0);
			events[msg.data.id] = {
				type: msg.data.type,
				toCapture: pathExists(config, 'camera.capture_on_' + msg.data.type + 'images.after') || 0,
				date: new Date().getTime(),
				cback: function () {
					if (events[msg.data.id].cbacked) return false;
					events[msg.data.id].cbacked = true;
					msg.data.images = images.slice(-1 * _cnt);
					process.send({ action: 'captureResult', data: msg.data });
					setTimeout(function () { delete events[msg.data.id]; }, 1000);
				}
			};
			break;
	}
});
setTimeout(function () {
	process.send({ action: 'ready' })
}, 300);