var wop = {
	_windows: {},
	app: null,
	pos: null,
	validate: function (frame, url, policy) {
		console.log("Open :", frame, url.split('index.php').pop(), policy);

		if (url.includes("/sales/customer_display/")) {
			console.log("Customer Facing Display : Opened");

			policy.ignore();

			// Get screens
			let screens = wop.app.utilities.screens;
			if (screens.length < 2) {
				wop.app.pos.win.window.alert("You don't have enough screens to open the customer facing display.");
				return;
			}
			if (wop._windows.customer_display) {
				wop.closeWindow(wop._windows.customer_display);
				delete wop._windows.customer_display;
			}

			// Open window in screen #2
			nw.Window.open(url, {}, function (win_cfd) {
				win_cfd.moveTo(screens[1].bounds.x, screens[1].bounds.y);
				win_cfd.enterKioskMode();
				try { app.pos.win.focus(); } catch (er) { }
				wop._windows.customer_display = win_cfd;
				let isClosed = false;
				win_cfd.on('close', function () {
					if (isClosed) return;
					isClosed = true;
					console.log("Customer Facing Display : Closed");
					wop.closeWindow(win_cfd);
					delete wop._windows.customer_display;
				});
			});

		}
	},
	closeWindow: function (w) {
		if (!w) w = wop._windows.customer_display

		try { w.hide(); } catch (er) { }
		try { w.close(); } catch (er) { }
		try { w.exit(); } catch (er) { }

		delete wop._windows.customer_display;
	},
	closeWindows: function () {
		let _k = Object.keys(wop._windows);
		if (_k.length) {
			for (let i = 0; i < _k.length; i++) {
				wop.closeWindow(wop._windows[_k[i]]);
			}
		}
	}
};

module.exports = wop;