var microtime;
try {
	microtime = require('microtime');
} catch (er) {
	microtime = {
		now: function () {
			return new Date().getTime() * 1000;
		}
	}
}
var crypto = require('crypto'),
	xtend = require(__dirname + '/cloneextend.js'),

	uuid = require('uuid'),
	jose = require('node-jose'),
	hydra = require('hydration'),
	C = {
		_alg: 'aes-256-cbc',
		hash: function (string, alg) {
			return crypto.createHash(alg || 'sha256').update(string).digest('hex');
		},
		helpers: {
			byteArraytoHex: function (byteArray) { //C.helpers.byteArraytoHex
				return Array.prototype.map.call(byteArray, function (byte) {
					return ('0' + (byte & 0xFF).toString(16)).slice(-2);
				}).join('');
			},
			hexToByteArray(hexString) { //C.helpers.hexToByteArray
				var result = [];
				for (var i = 0; i < hexString.length; i += 2) {
					result.push(parseInt(hexString.substr(i, 2), 16));
				}
				return result;
			}
		},
		jose: {
			createKey: function (type, size, props, cback) {
				if (typeof props == 'function' && !cback) {
					cback = props;
					props = {};
				}
				props = xtend.extend({
					alg: 'A256GCM',
					use: 'enc'
				}, props || {});
				jose.JWK.createKey(type || "oct", size || 256, props).
					then(function (result) {
						cback(result)
					});
			}
		},
		jwe: async function (jwk) {
			const key = await jose.JWK.asKey(jwk)
			async function encrypt(value) {
				const dehydratedData = hydra.dehydrate({ value })
				const cipher = await jose.JWE.createEncrypt({ format: 'compact' }, key).final(
					JSON.stringify(dehydratedData),
					'utf8'
				)
				return cipher
			}
			async function decrypt(cipher) {
				const { value } = await jose.JWE.createDecrypt(key.keystore)
					.decrypt(cipher)
					.then(res => res.payload.toString())
					.then(payload => hydra.hydrate(JSON.parse(payload)))
				return value
			}
			return {
				encrypt,
				decrypt
			}
		},
		decrypt: function (encrypted, pass) {
			var decipher = crypto.createDecipher(C._alg, pass);
			return decipher.update(encrypted) + decipher.final();
		},
		encrypt: function (text, pass) { // C.encrypt
			var cipher = crypto.createCipher(C._alg, pass);
			return Buffer.concat([cipher.update(Buffer.from(text)), cipher.final()]);
		},
		decryptIV: function (encrypted, pass, iv) {
			var decipher = crypto.createDecipheriv(C._alg, pass, Buffer.from(iv, 'base64'));
			return decipher.update(encrypted) + decipher.final();
		},
		encryptIV: function (text, pass, iv) { // C.encrypt
			var cipher = crypto.createCipheriv(C._alg, Buffer.from(pass), iv);
			return Buffer.concat([cipher.update(text), cipher.final()]);
		},
		AES_PK: {
			decrypt: function (data, privKey) { // C.AES_PK.decrypt
				if (typeof data != 'string' || data.indexOf('AES:') !== 0)
					return data;
				let
					d = JSON.parse(data.replace('AES:', '')),
					_k = crypto.privateDecrypt(privKey, Buffer.from(d.key, 'base64')).toString("utf8");
				return d.iv ? C.decryptIV(Buffer.from(d.value, 'base64'), _k, d.iv) : C.decrypt(Buffer.from(d.value, 'base64'), _k);
			},
			encrypt: function (data, pubKey, useIV) { // C.AES_PK.encrypt
				if (typeof useIV == 'undefined' || useIV == true) useIV = 16;
				try {
					let
						iv = crypto.randomBytes(useIV),
						pass_str = crypto.createHash('sha256').update(microtime.now() + '.' + uuid.v1()).digest('base64').substr(0, 32),
						pass_enc = crypto.publicEncrypt(pubKey, Buffer.from(pass_str)).toString("base64");
					let
						_d = typeof data == 'object' ? JSON.stringify(data) : data,
						_e = C.encryptIV(_d, pass_str, iv);
					return 'AES:' + JSON.stringify({
						"iv": iv ? iv.toString('base64') : null,
						"key": pass_enc,
						"value": _e.toString("base64")
					});
				}
				catch (er) {
					if (er.message.indexOf('Invalid IV length') != -1) {
						if (useIV != 0) {
							if (useIV == 32) useIV = 0;
							if (useIV == 8) useIV = 32;
							if (useIV == 16) useIV = 8;
							return C.AES_PK.encrypt(data, pubKey, useIV);
						}
					}
					console.error(er.message)
					return null;
				}
			}
		}
	};
module.exports = C;