@echo off
setlocal
SET mypath=%~dp0
SET mypath=%mypath:~0,-1%

set arg2=%1
CALL SET "scripts=%%mypath:\update=%%"
CALL SET "azimutpos=%%mypath:\etc\scripts\update=%%"

cd "%azimutpos%"
set LOGFILE="logs\update.log"
set "SAY=echo %date% %time%"
call :LOG > %LOGFILE%
:LOG

%SAY% "Updating AzimutPOS..."

%SAY% "Wait for processes to terminate"
%SAY% "Killing remaining processes"


@taskkill /f /im TechnoPOS.exe >NUL 2>&1
@taskkill /f /im AzimutPOS.exe >NUL 2>&1

%SAY% "Wait for processes to terminate"

:WAITTPOS
TASKLIST | FIND /i "AzimutPOS" >NUL 2>&1
IF ERRORLEVEL 1 (
  GOTO CONTINUE
) ELSE (
  %SAY% AzimutPOS is still running
  CALL "etc\scripts\timeout.bat" 1
  GOTO WAITTPOS
)
:CONTINUE


%SAY% "All processes terminated, processing the update."
%SAY% "updates\%arg2%"

if not exist "updates\%arg2%" (
	for /f "delims=" %%a in ('dir /b /a-d "updates\*.zip" ') do set arg2=%%a
)

%SAY% "Apply update: %arg2%"
CALL "etc\scripts\timeout.bat" 5
if exist "%temp%\SevenZip\" del /f /q "%temp%\SevenZip"
if not exist "%temp%\SevenZip\" mkdir "%temp%\SevenZip\"
xcopy "vendors\SevenZip\*" "%temp%\SevenZip\" /E /Y /q

CALL "etc\scripts\timeout.bat" 3
rmdir package.nw /s /q >NUL 2>&1
%SAY% "Unzipping %arg2%"
CALL "%temp%\SevenZip\7za.exe" x -y "updates\%arg2%" -bse1 > "updates\update_7z.log"

%SAY% "Updated successfully!"
%SAY% "Starting AzimutPOS"
START AzimutPOS.exe
%SAY% "AzimutPOS is starting, please wait."
CALL "etc\scripts\timeout.bat" 10
exit 0