
var register_loading = false;
if (typeof _onDocReady == 'undefined') _onDocReady = [];
function pe(o, p) {
    if (!p || !o)
        return false;
    p = p + '';
    var m = (p.indexOf('.') != -1) ? p.split(".") : [p];
    if (m.length > 1 && !m[0])
        m.shift();
    var cm = o;
    for (var i = 0; i < m.length; i++) {
        if (cm == null)
            return false;
        if (typeof cm[m[i]] !== 'undefined') //http://andrew.hedges.name/experiments/in/
            cm = cm[m[i]];
        else return false;
    }
    return cm;
}
function showLoadingOverlay() {
    console.log('Page is taking longer to load, show loading overlay...')
}
var APPFCTS = {
    _w: typeof nw != 'undefined' && pe(nw, 'Window.get') ? nw.Window.get() : null,
    isSet: function (fct) {
        return pe(APPFCTS._w, fct) || pe(APPFCTS._w, 'window.' + fct) || pe(window, fct) || false;
    },
    call: function (fct) {
        return pe(APPFCTS._w, fct) || pe(APPFCTS._w, 'window.' + fct) || pe(window, fct) || function () { throw 'Function "' + fct + '" not found'; };
    },
    set: function (k, v) {
        if (pe(APPFCTS._w, 'window')) APPFCTS._w.window[k] = v;
        else if (APPFCTS._w) APPFCTS._w[k] = v;
        else window[k] = v;
    },
    onDocumentReady: function (fct) {
        if (APPFCTS._docIsReady) {
            try {
                fct();
            } catch (er) { console.error('Document ready', er); }
            return;
        }
        _onDocReady.push(fct);
    },
    block: function (vars) { // APPFCTS.block=function(vars){
        let e = vars.e || null;
        delete vars.e;
        if (!e) {
            if ($('.blockUI.blockMsg.blockPage').length) {
                $('.blockUI.blockMsg.blockPage').html(vars.message);
                if (vars.onBlock) vars.onBlock();
            }
            else
                $.blockUI($.extend(true, { baseZ: 99999999999999 }, vars));
        }
        else e.block($.extend(true, { baseZ: 99999999999999 }, vars));
    },
    core: {
        checkEmail: function (email, cback) {
            if (APPFCTS._w) {
                APPFCTS.call('coreFunction')({
                    action: 'emailCheck',
                    datas: {
                        value: '' + email
                    }
                }, function (res) {
                    try {
                        cback(res);
                    } catch (err) { console.error(err); }
                })
                return;
            }
            cback(null);
        },
        checkEmailField: function (e) {
            APPFCTS.core.checkEmailField
            //console.log('Please validate email against our intelligence database',e.val())

            //e is the field (jquery selector)
            //check syntax
            //check with cloud intelligence (database + disposable + banned + smtp validation)

        },
        getTime: function (cback) { //APPFCTS.core.getTime(console.log);
            if (APPFCTS._w) {
                APPFCTS.call('coreFunction')({
                    action: 'getTime',
                    datas: {
                    }
                }, function (res) {
                    try {
                        cback(res);
                    } catch (err) { console.error(err); }
                })
                return;
            }
            cback(null);
        },
        parseAddress: function (a, cback) {

            if (APPFCTS._w) {
                APPFCTS.call('coreFunction')({
                    action: 'event',
                    datas: {
                        module: 'geocoding',
                        action: 'getPlace',
                        datas: {
                            formattedAddress: '' + a
                        }

                    }
                }, function (res) {
                    try {
                        cback(res);
                    } catch (err) { console.error(err); }
                })
                return;
            }
            cback(null);
        }
    },
    crypto: {
        ab2str: function (buf) { // APPFCTS.crypto.ab2str=function(buf){
            return String.fromCharCode.apply(null, new Uint8Array(buf));
        },
        sha1: function (message, cback) { // APPFCTS.crypto.sha1=function(message,cback){
            let msgUint8 = new TextEncoder().encode(message);                           // encode as (utf-8) Uint8Array
            crypto.subtle.digest('SHA-1', msgUint8).then(function (hashBuffer) {
                let hashArray = Array.from(new Uint8Array(hashBuffer));                     // convert buffer to byte array
                let hashHex = hashArray.map(b => b.toString(16).padStart(2, '0')).join(''); // convert bytes to hex string
                cback(hashHex);
            });

        },
        sha256: function (message, cback) { // APPFCTS.crypto.sha256=function(message,cback){
            let msgUint8 = new TextEncoder().encode(message);                           // encode as (utf-8) Uint8Array
            crypto.subtle.digest('SHA-256', msgUint8).then(function (hashBuffer) {
                let hashArray = Array.from(new Uint8Array(hashBuffer));                     // convert buffer to byte array
                let hashHex = hashArray.map(b => b.toString(16).padStart(2, '0')).join(''); // convert bytes to hex string
                cback(hashHex);
            });

        },
        sha512: function (message, cback) { // APPFCTS.crypto.sha512=function(message,cback){
            let msgUint8 = new TextEncoder().encode(message);                           // encode as (utf-8) Uint8Array
            crypto.subtle.digest('SHA-512', msgUint8).then(function (hashBuffer) {
                let hashArray = Array.from(new Uint8Array(hashBuffer));                     // convert buffer to byte array
                let hashHex = hashArray.map(b => b.toString(16).padStart(2, '0')).join(''); // convert bytes to hex string
                cback(hashHex);
            });

        },
        str2AB: function (str) { // APPFCTS.crypto.str2AB=function(str){
            var bytes = new Uint8Array(str.length);
            for (var iii = 0; iii < str.length; iii++) {
                bytes[iii] = str.charCodeAt(iii);
            }
            return bytes;
        }
    },
    exit: function () {
        try { updateRegisterActivity('unload'); } catch (er) { }
        if (APPFCTS._w) {
            APPFCTS.call('onExit')();
        }
        else if (navigator.app) {
            navigator.app.exitApp();
        } else if (navigator.device) {
            navigator.device.exitApp();
        }
    },
    accessCard: {
        locales: {
            cancel: {
                fr: 'Annuler',
                en: 'Cancel',
                es: ''
            },
            cardError: {
                confirmationMismatch: {
                    fr: 'Les deux lectures ne concordent pas. Veuillez essayer de nouveau',
                    en: 'The two readings doesn\'t match. Please try again'
                },
                exists: {
                    fr: 'Cette carte à déjà été enregistrée.',
                    en: 'This card has already been registered'
                },
                invalid: {
                    fr: 'Les données de cette carte sont invalides. Veuillez essayer de nouveau.',
                    en: 'This card data is invalid. Please try again.'
                }
            },
            close: {
                fr: 'Fermer',
                en: 'Close',
                es: ''
            },
            error: {
                fr: 'Cette carte ne peut être ajoutée',
                en: 'This card couldn\'t be registered',
                es: ''

            },
            registering: {
                fr: 'Enregistrement en cours, veuillez patienter',
                en: 'Registering your card, please wait',
                es: ''
            },
            registered: {
                fr: 'Votre carte a été enregistrée avec succès',
                en: 'Your card has been added successfully',
                es: ''
            },
            scanAgain: {
                fr: 'Présentez votre carte à nouveau au lecteur pour confirmer',
                en: 'Swipe or scan your card again to confirm',
            },
            scannow: {
                fr: 'Présentez votre carte au lecteur maintenant',
                en: 'Swipe or scan your new card now',
                es: ''
            },
            table: {
                name: {
                    fr: 'Nom',
                    en: 'Name'
                },
                delete: {
                    btn: {
                        fr: 'Supprimer cette carte',
                        en: 'Delete this card',
                        es: ''
                    },
                    title: {
                        fr: 'Êtes-vous certain de vouloir supprimer cette carte',
                        en: 'Are you sure you want to delete this card',
                        es: ''
                    }
                }
            },
            waitsync: {
                fr: 'Synchronisation des données en cours...',
                en: 'Data synchronization in progress',
                es: ''
            }
        },
        register: function (d, cback) {
            APPFCTS.block({ message: '<h1 class="text-center">' + APPFCTS.accessCard.locales.registering[LOCALE] + '...</h1>' });

            let _getHash = function () {
                if (!d.hash) {
                    APPFCTS.crypto.sha512(d.value, function (val) {
                        d.hash = val;
                        _getHash();
                    });
                    return;
                }
                d.value = d.hash;
                delete d.hash;
                let _handle = function (res) {
                    //console.log('activity record returned',res)

                    if (res.result == 'insert') {
                        APPFCTS.block({ message: '<h1 class="text-center">' + APPFCTS.accessCard.locales.registered[LOCALE] + '!</h1>' });
                        //setTimeout(function(){$.unblockUI();},1000*3);
                        //return;
                    }
                    else {
                        APPFCTS.block({
                            message: '<h1 class="text-center">' + APPFCTS.accessCard.locales.error[LOCALE] + '.<br/>' +
                                '<button type="button" class="btn btn-default btnDismissCardError">' + APPFCTS.accessCard.locales.close[LOCALE] + '</button></h1>'
                        });
                        $('.btnDismissCardError').click(function () {
                            $.unblockUI();
                        })
                    }
                    cback(res);

                };
                if (APPFCTS._w) {
                    APPFCTS.call('registerAccessCard')(d, _handle);
                    return;
                }
                APPFCTS.msgApi.send({
                    module: 'accessCard',
                    action: 'register',
                    data: d
                }, _handle)
            }
            _getHash();
        }
    },
    activity: {
        employeeLoggedIn: function (data) {
            //employee_logged_in
            try {
                APPFCTS.call('employee_logged_in')(data)
            } catch (er) { }
        },
        routePOSEvent: function (d) {
            switch (d.action) {
                case 'unLockSession':
                    if (typeof EMPLOYEE_PERSON_ID == 'undefined' || !EMPLOYEE_PERSON_ID) return false;
                    $('body').removeClass('sessionLocked');
                    APPFCTS.activity.timeout.init();
                    try { updateRegisterActivity(); } catch (er) { }
                    break;
                case 'lockSession':
                    if (typeof EMPLOYEE_PERSON_ID == 'undefined' || !EMPLOYEE_PERSON_ID) return false;
                    clearTimeout(APPFCTS.activity.timeout._t);
                    APPFCTS.activity.timeout.lockSession({ forceLock: 1 });
                    try { updateRegisterActivity(); } catch (er) { }
                    break;
                case 'logOutUser':
                    if (typeof EMPLOYEE_PERSON_ID == 'undefined' || !EMPLOYEE_PERSON_ID) return false;
                    let _new = document.location.href.split('/index.php')[0] + '/index.php/home/logout';
                    console.log('CURRENT', document.location.href)
                    console.log('NEW', _new)
                    document.location.href = '' + _new;
                    break;
            }
        },
        timeout: {
            _locked: false,
            _t: null,
            init: function () { //APPFCTS.activity.timeout.init=function(){
                if (typeof EMPLOYEE_PERSON_ID == 'undefined' || !EMPLOYEE_PERSON_ID) return false;
                //if no activity for X seconds, logout
                if (!pe(APPFCTS, 'registerConfig.branch')) {
                    setTimeout(APPFCTS.activity.timeout.init, 100);
                    return;
                }
                if (pe(APPFCTS, 'registerConfig.advanced.session_idle.disabled') == '1') return;
                clearTimeout(APPFCTS.activity.timeout._t);
                APPFCTS.activity.timeout._sessionLocked = false;
                APPFCTS.activity.timeout._locked = false;
                var _t = 1 * (pe(APPFCTS, 'registerConfig.advanced.session_idle.warmuptime') || 30),
                    _idlt = pe(APPFCTS, 'registerConfig.advanced.session_idle.time') || 0;
                if (_idlt && pe(APPFCTS, 'registerConfig.advanced.session_idle.time_unit')) {
                    switch (APPFCTS.registerConfig.advanced.session_idle.time_unit) {
                        case 'M':
                            _idlt = _idlt * 60;
                            break;
                        case 'H':
                            _idlt = _idlt * 60 * 60;
                            break;
                    }
                }
                if (!_idlt) _idlt = 1 * INACTIVITY_TIME_LOGOUT;
                APPFCTS.activity.timeout._t = setTimeout(function () {
                    //hey there, your session is about to expire, do you want to continue?
                    APPFCTS.activity.timeout.preLockTimer();
                }, 1000 * _idlt - _t * 1000);
            },
            preLockTimer: function () {
                if (typeof EMPLOYEE_PERSON_ID == 'undefined' || !EMPLOYEE_PERSON_ID) return false;
                try { APPFCTS._w.window.focus() } catch (er) { }
                try { APPFCTS._w.focus() } catch (er) { }
                $('body').addClass('sessionLocked');
                var
                    slw = $('#sessionTimedoutLockScreen .locked_wrapper');
                $('.session_preLock_timer', slw).show();
                $('.session_is_locked', slw).hide();

                slw.removeClass('passwordError passwordErrorMaxTriesReached');
                $('.employee_photo img', slw).show();
                $('.employee_photo .icon', slw).remove();


                var actionClicked = false;
                var _t = 1 * (pe(APPFCTS, 'registerConfig.advanced.session_idle.warmuptime') || 30);
                $('.session_preLock_timer .countDownSeconds', slw).html(_t);
                $({ sv: _t }).animate({ sv: 0 }, {
                    duration: _t * 1000,
                    easing: 'linear', // can be anything
                    step: function () { // called on every step
                        if (actionClicked) return false;
                        // Update the element's text with rounded-up value:
                        $('.session_preLock_timer .countDownSeconds', slw).html(Math.round(this.sv));
                    },
                    complete: function () {
                        //lock session
                        if (actionClicked) return false;
                        APPFCTS.activity.timeout.lockSession();
                    }
                });
                var plt = $('.session_preLock_timer', slw);
                $('.btnContinue', plt).unbind('click').click(function () {
                    actionClicked = true;
                    $('.session_preLock_timer', slw).hide();
                    $('.session_is_locked', slw).hide();
                    $('body').removeClass('sessionLocked');
                });
                $('.btnSignout', plt).unbind('click').click(function () {
                    actionClicked = true;
                    document.location.href = document.location.href.split('/index.php')[0] + '/index.php/home/logout';
                    $('body').removeClass('sessionLocked');
                });
            },
            lockSession: function (vars) {
                if (typeof EMPLOYEE_PERSON_ID == 'undefined' || !EMPLOYEE_PERSON_ID) return false;
                if (!vars) vars = {};
                if (!vars.forceLock && !PREVENT_SESSION_TIMEOUT && pe(APPFCTS, 'registerConfig.advanced.session_idle.action') != 'lock') {
                    document.location.href = document.location.href.split('/index.php')[0] + '/index.php/home/logout';
                    return false;
                }
                try { APPFCTS._w.window.focus() } catch (er) { }
                try { APPFCTS._w.focus() } catch (er) { }
                $('body').addClass('sessionLocked');
                var slw = $('#sessionTimedoutLockScreen .locked_wrapper');
                APPFCTS.activity.timeout._sessionLocked = true;
                try { updateRegisterActivity(); } catch (er) { }
                slw.removeClass('passwordError passwordErrorMaxTriesReached');
                $('.employee_photo img', slw).show();
                $('.employee_photo .icon', slw).remove();
                $('.session_preLock_timer', slw).hide();
                $('.session_is_locked', slw).show();
                $('.locked_inner [name="unlock_sessison_password"]', slw).focus();
                try { slw.effect('shake'); } catch (er) { }
                //send info to console

                var
                    _p = $('.locked_inner [name="unlock_sessison_password"]', slw),
                    _normalClasses = 'ti-angle-right', _workingClasses = 'disabled ti-reload animated infinite rotateIn';
                $('.locked_inner [name="unlock_sessison_password"]', slw).unbind('keypress').keypress(function (e) {
                    if ($(this).attr('disabled')) return false;
                    slw.removeClass('passwordError');
                    if (e.keyCode == 13) {
                        _submit();
                    }
                })

                _p.removeAttr('disabled').removeClass('disabled');
                $('.employee_enter_nip .btn', slw).removeAttr('disabled', 'disabled');
                $('.employee_enter_nip .icon', slw).removeClass(_workingClasses).addClass(_normalClasses);
                _p.val('');
                _p.focus();
                var _maxTries = 4, _tries = 0,
                    _success = function () {
                        $('body').removeClass('sessionLocked');

                        APPFCTS.activity.timeout._sessionLocked = false;
                        APPFCTS.activity.timeout._locked = false;
                        try { updateRegisterActivity(); } catch (er) { }
                    },
                    _submit = function () {
                        var
                            _v = _p.val();
                        if (_p.attr('disabled')) return false;
                        _p.attr('disabled', 'disabled').addClass('disabled');
                        $('.employee_enter_nip .btn', slw).attr('disabled', 'disabled');
                        $('.employee_enter_nip .icon', slw).removeClass(_normalClasses).addClass(_workingClasses);
                        APPFCTS.crypto.sha1(_v, function (h) {
                            if (EMPLOYEE_INFO.password == h) {
                                _success();
                                return;
                            }
                            if (EMPLOYEE_INFO.password_nip == h) {
                                _success();
                                return;
                            }
                            _tries++;
                            let _left = _maxTries - _tries;
                            if (_left <= 0) {
                                _left = 0;
                                $('.employee_photo img', slw).hide();
                                $('.employee_photo', slw).append('<i class="icon ti-lock"></i>');
                                slw.addClass('passwordError passwordErrorMaxTriesReached');
                                APPFCTS.activity.timeout._sessionLocked = true;
                                APPFCTS.activity.timeout._locked = true;
                                try { updateRegisterActivity(); } catch (er) { }
                                return;
                            }
                            $('.passwordIsInvalid .triesLeft', slw).html(_left);
                            slw.addClass('passwordError');
                            try { slw.effect('shake'); } catch (er) { }
                            _p.removeAttr('disabled').removeClass('disabled');
                            $('.employee_enter_nip .btn', slw).removeAttr('disabled', 'disabled');
                            $('.employee_enter_nip .icon', slw).removeClass(_workingClasses).addClass(_normalClasses);
                            _p.val('');
                            _p.focus();
                        });
                    };
            }
        },
        record: function (d, cback) {
            if (APPFCTS._w) {
                cback(APPFCTS.call('recordActivity')(d));
                return;
            }
            APPFCTS.msgApi.send({
                module: 'activity',
                action: 'record',
                data: d
            }, function (res) {
                //console.log('activity record returned',res)
                cback(res);
            })
        },
        update: function (d) {
            if (APPFCTS._w) {
                APPFCTS.call('updateActivity')(d)
                return;
            }
            APPFCTS.msgApi.send({
                module: 'activity',
                action: 'update',
                data: d
            }, function (res) {
                //console.log('activity update returned',res)
            })
        }
    },
    kiosk: {
        _configs: null,
        getConfigs: function (cbk) {
            APPFCTS.call('getKioskConfigs')(function (kfc) {
                APPFCTS.kiosk._configs = kfc;
                try {
                    if (cbk) cbk(kfc);
                } catch (er) { console.error(er.message); }
            })
        }
    },
    liquorControl: {
        canPour: function () {
            return false;
        },
        pourDrink: function (vars, cback) {
            if ((whitelist = $('#myModalDisableClose:visible .liquor-control-whitelist')).length) {
                if (whitelist.attr('data-product') == parseInt(vars.plu) && whitelist.attr('data-portion') == vars.portion)
                    $.post('index.php/sales/drink_poured/' + vars.plu + '/' + vars.portion, function (res) {
                        $('#myModalDisableClose').html(res);
                        cback({ result: 'success' });
                        $.get('index.php/sales/reload', function (response) {
                            $('#register_container').html(response);
                        });
                    });
                else
                    cback({ result: 'error' });
            } else {
                $.post('index.php/items/get_by_liquor_control_product_number/' + parseInt(vars.plu) + '/' + vars.portion, function (data) {
                    if (data.result == 'success')
                        $.post('index.php/sales/add', {
                            item: data.item_id + '|FORCE_ITEM_ID|',
                            quantity: 1,
                            format_id: data.format_id,
                            status: 'ready',
                            actions: ['poured']
                        }, function (response, res, req) {
                            $('#register_container').html(response);
                            if (typeof cback == 'function') {
                                if (req.getResponseHeader('X-status') == 'success') {
                                    cback({ result: 'success' });
                                } else
                                    cback({ result: 'error' });
                            }
                        });
                    else
                        cback({ result: 'error' });
                }, 'json');
            }
        }
    },
    neighbors: {
        status: null
    },
    NFC: {
        routeMsg: function (d, cback) {
            switch (d.action) {
                case 'scan':
                    if (cback) cback('received');
                    APPFCTS.crypto.sha512(d.data.serial, function (val) {
                        if ($('#password_nip_card') && $('#password_nip_card').length) {
                            $('#password_nip_card').val(val);
                            $('#loginformpin').submit();
                        }
                        else if (typeof doEmployeeAddCardResult != 'undefined') {
                            APPFCTS.accessCard.register({
                                employee: EMPLOYEE_PERSON_ID,
                                type: 'nfc',
                                hash: val
                            }, doEmployeeAddCardResult);
                        }
                    });
                    break;

                default:
                    console.log('GOT NFC FROM ANDROID', d);
                    if (cback) cback('UNHANDLED');
            }
        }
    },
    printing: {
        getDefaultPrinter: function (printer) {
            if (APPFCTS._w && typeof APPFCTS.call('getDefaultPrinter') == 'function')
                return APPFCTS.call('getDefaultPrinter')(printer);
        },
        getDefaultSaleFormat: function () {
            if (APPFCTS._w && typeof APPFCTS.call('getDefaultSaleFormat') == 'function')
                return APPFCTS.call('getDefaultSaleFormat')();
        }
    },
    openDrawer: function (vars, cback) { //vars.drawer= default | 0,1,2... (# of the drawer), vars.sale_id, vars.action
        if (APPFCTS._w) {
            APPFCTS.call('openDrawer')(vars, cback);
            return;
        }

    },
    orders: {
        printAddition: function (ids) {
            if (ids && ids.length)
                ids.forEach(function (id) {
                    if (APPFCTS._w)
                        APPFCTS.call('printUrl')('index.php/sales/print_receipt/' + id + '/classic?printOnly=true');
                });
        },
        process: function (sale_id) {
            if (APPFCTS._w)
                APPFCTS.call('processOrder')(sale_id);
        }
    },
    print: function (options) {
        if (APPFCTS._w) {
            APPFCTS.call('printCustom')(options);
            return;
        }
        window.print();
    },
    qrCode: {
        encode: function (d, cback) {
            //basic usage:
            //d={
            //    element: $('jquery selector'),
            //    text:'https://your url.com',
            //    size:200,//or use width & height for specific
            //    level:'L|M|H|Q'
            //}

            //technoPOS standardized QR codes usage:
            //d={
            //    element: $('jquery selector'),
            //    data:{ //QR code data to be encoded
            //          type:'invoice', //invoice,product,device,container,production_lot, etc...
            //          id:'id of the entity', // uuid
            //          brand:'brand uuid', //if you want to specify the branch, recommended
            //          branch:'branch uuid',//if you want to specify the branch, could be useful
            //          //... anything that need to be included
            //    }
            //    size:200,//or use width & height for specific
            //    level:'L|M|H|Q'
            //}

            //documentation https://github.com/ushelp/EasyQRCodeJS#options
            // except for technoPOS, requires `data` as an object. data.type & data.id are mandatory
            if (!d.text && d.data && !d.data.type) throw new Error('You must specify data.type');
            if (!d.text && d.data && !d.data.id) throw new Error('You must specify data.id');
            var size = 1 * (d.size || d.width || d.height || 256);
            if (size + 30 > $(document).width())
                size = $(document).width() - 30;

            if (cback) {
                d.onRenderingEnd = function (a, b) {
                    cback(b)
                    $('#qrCodeGenericRenderingElement').remove();
                };
                if (!d.element) {
                    $('#qrCodeGenericRenderingElement').remove();
                    $('body').append('<div id="qrCodeGenericRenderingElement" class="hidden"></div>');
                    d.element = $('#qrCodeGenericRenderingElement');
                }
            }
            d.element.html('');
            var qrcode = new QRCode(d.element[0], $.extend(true, d, {
                text: d.text || 'TPOS:' + btoa(JSON.stringify(d.data)),
                width: d.width || d.height || size,
                height: d.height || d.width || size,
                colorDark: "#" + (d.colorDark || '000'),
                colorLight: "#" + (d.colorLight || 'fff'),
                correctLevel: QRCode.CorrectLevel[d.level || 'H']
            }));
            return qrcode;
        },
        decode: function (data) {
            if (data && data.indexOf('TPOS:') === 0) {
                json = JSON.parse(atob(data.replace(/^TPOS\:/, '')));
                return json;
            }
            return data;
        }
    },
    weightScale: {
        _status: null,
        _last: null,
        _monitor: [],
        _onUpdate: [],
        _statusChanged: function (s) {
            //console.log('WeightScale status changed',s);
            if (APPFCTS.weightScale._status && new Date(APPFCTS.weightScale._status.date).getTime() > new Date(s.date).getTime()) return;

            APPFCTS.weightScale._status = s;
        },
        _updated: function (data) {
            if (APPFCTS.weightScale._last && new Date(APPFCTS.weightScale._last.date).getTime() > new Date(data.date).getTime()) return;
            APPFCTS.weightScale._last = data;
            setTimeout(APPFCTS.weightScale._notify, 1);
            if (APPFCTS.weightScale._monitor.length) {
                for (let i = 0; i < APPFCTS.weightScale._monitor.length; i++) {
                    try {
                        (function (x) {
                            APPFCTS.weightScale._monitor[x]($.extend(true, {}, APPFCTS.weightScale._last), function () {
                                //delete me
                                APPFCTS.weightScale._monitor.splice(x, 1);
                            });
                        })(i);
                    } catch (er) { console.error(er); }
                }
            }
        },
        _notify: function () {
            if (APPFCTS.weightScale._onUpdate.length) {
                try {
                    APPFCTS.weightScale._onUpdate.shift()($.extend(true, {}, APPFCTS.weightScale._last));
                } catch (er) { console.error(er); }
                APPFCTS.weightScale._notify();
            }
        },
        enabled: function () {
            return pe(APPFCTS, 'registerConfig.weightScale.enabled') == '1' && pe(APPFCTS, 'registerConfig.weightScale.device') && pe(APPFCTS, 'weightScale._status');
        },
        monitor: function (fct) {
            APPFCTS.weightScale._monitor.push(fct);
        },
        neighbors: {
            _data: null,
            _monitor: {},
            _changed: function (id, type) {
                if (pe(APPFCTS.weightScale.neighbors, '_monitor.' + id + '.' + type)) {

                    if (APPFCTS.weightScale.neighbors._monitor[id][type].length) {
                        for (let i = 0; i < APPFCTS.weightScale.neighbors._monitor[id][type].length; i++) {
                            try {
                                (function (x) {
                                    APPFCTS.weightScale.neighbors._monitor[id][type][x]($.extend(true, {}, APPFCTS.weightScale.neighbors._data[id][type]), function () {
                                        //delete me
                                        APPFCTS.weightScale.neighbors._monitor[id][type].splice(x, 1);
                                    });
                                })(i);
                            } catch (er) { console.error(er); }
                        }
                    }
                }
            },
            monitor: function (id, type, fct) {
                if (!APPFCTS.weightScale.neighbors._monitor[id]) APPFCTS.weightScale.neighbors._monitor[id] = {};
                if (!APPFCTS.weightScale.neighbors._monitor[id][type]) APPFCTS.weightScale.neighbors._monitor[id][type] = [];
                APPFCTS.weightScale.neighbors._monitor[id][type].push(fct);

            }
        },
        onUpdate: function (fct) {
            APPFCTS.weightScale._onUpdate.push(fct);
        }
    },
    secureTokenChanged: function (t) {
        console.log('new secure token')

    },
    system: { //APPFCTS.system={
        getUUID: function (cback) { //APPFCTS.system.getUUID

            if (APPFCTS._w) {
                let _uuid = APPFCTS.call('uuid.get')();
                try {
                    if (cback) cback(uuid);
                } catch (err) { console.error(err); }
                return _uuid;
            }
            if (cback) cback(null);
            return null;
        },
        getRegisterConfig: function (cback) {
            //try{
            APPFCTS.call('getRegisterConfig')(function (d) {
                APPFCTS.registerConfig = d;
                if (cback) cback(d);
            })
            //} catch(er){}
        },
        clearCache: function () {
            window.nw.App.clearCache();

            // this one will cause significantly increase the
            // shutdown duration if run during app exit
            window.chrome.browsingData.remove({
                since: 0
            }, {
                appcache: true,
                cache: true,
                downloads: true,
                fileSystems: true,
                formData: true,
                history: true,
                indexedDB: true,
                localStorage: true,
                pluginData: true,
                passwords: true,
                serverBoundCertificates: true,
                serviceWorkers: true,
                webSQL: true
            });
            console.log('cache cleared');
        },
        routePOSEvent: function (d) {
            console.log('RECEIVED MESSAGE', d)
            if (d.module) {
                if (d.module == 'system') {
                    switch (d.action) {
                        case 'setRegisterConfig':
                            APPFCTS.registerConfig = d.data;
                            break;
                    }
                    return;
                }
                if (APPFCTS[d.module] && APPFCTS[d.module].routePOSEvent) {
                    try {
                        APPFCTS[d.module].routePOSEvent(d);
                    } catch (er) {
                        console.error(er)
                    }
                }
            }
        }
    },
    weather: {
        _latest: null,
        setLatest: function (l) {
            APPFCTS.weather._latest = l;
        },
        get: function (opts, cback) { //APPFCTS.weather.get
            if (APPFCTS.weather._latest && APPFCTS.weather._latest.date) {
                let c = APPFCTS.weather._latest.date;
                if (c && new Date(c).getTime() > new Date().getTime() - 1000 * 60 * 20) {
                    cback(APPFCTS.weather._latest.result);
                    return;
                }
            }
            var p = {
                location: typeof BRANCH_DATA != 'undefined' && pe(BRANCH_DATA, 'address.lat') && pe(BRANCH_DATA, 'address.lng') ? BRANCH_DATA.address.lat + ',' + BRANCH_DATA.address.lng : null,
                lang: '',
                user: typeof EMPLOYEE_PERSON_ID != 'undefined' ? EMPLOYEE_PERSON_ID : null
            };
            if (opts) $.extend(true, p, opts);
            if (APPFCTS._w) {
                APPFCTS.call('getWeather')(p, function (res) {
                    APPFCTS.weather._latest = res;
                    try {
                        cback(res.result);
                    } catch (err) { console.error(err); }
                })
                return;
            }

            APPFCTS.msgApi.send({
                module: 'weather',
                action: 'get',
                data: p
            }, function (res) {
                console.log('got weather', res)
                APPFCTS.weather._latest = res;
                try {
                    cback(res.result);
                } catch (err) { console.error(err); }
            })
        }
    },
    getParentStack: function () {
        return null;
    },
    tryCatch: function (c) {
        c();
    },
    queueProc: {
        _queues: {},
        test: function () {
            var todo = 20, done = 0;
            APPFCTS.queueProc.init('queueProcTEST', 3);
            var _fct = function (d, n) {
                done++;
                console.log(d);
                setTimeout(n, 500);
                if (done >= todo) {
                    console.log('all done!')
                }
            };
            for (var i = 0; i < todo; i++) {
                APPFCTS.queueProc.add('queueProcTEST', 'I am number ' + i, _fct);
            }
            setTimeout(function () {
                for (var i = 0; i < todo; i++) {
                    APPFCTS.queueProc.add('queueProcTEST', 'I am number ' + (todo + i), _fct);
                }
            }, 1000);
        },
        init: function (id, maxChan) {
            if (!APPFCTS.queueProc._queues[id])
                APPFCTS.queueProc._queues[id] = {
                    processing: false,
                    queue: [],
                    channels: [],
                    maxChan: maxChan || 1,
                    onEmpty: []
                };
        },
        setMaxChan: function (id, maxChan) {
            if (!APPFCTS.queueProc._queues[id]) return false;
            APPFCTS.queueProc._queues[id].maxChan = maxChan || 1;
        },
        add: function (qid, data, fct) {
            var parent = APPFCTS.getParentStack();
            if (Array.isArray(data)) {
                for (var i = 0; i < data.length; i++)
                    APPFCTS.queueProc._queues[qid].queue.push({ fct: fct, data: data[i], parent: parent });
            }
            else
                APPFCTS.queueProc._queues[qid].queue.push({ fct: fct, data: data, parent: parent });
            APPFCTS.queueProc._process(qid);
        },
        onQueueEmpty: function (id, cback) {
            APPFCTS.queueProc._queues[id].onEmpty.push(cback);
        },
        _runQueueEmpty: function (id) {
            if (APPFCTS.queueProc._queues[id].onEmpty && APPFCTS.queueProc._queues[id].onEmpty.length) {
                if (APPFCTS.tryCatch(function () {
                    APPFCTS.queueProc._queues[id].onEmpty[0]();
                })) {
                    console.warn('Queue ID ' + qid);
                }
                APPFCTS.queueProc._queues[id].onEmpty.shift();
                //process.nextTick(function(){
                APPFCTS.queueProc._runQueueEmpty(id);
                //});
                if (typeof process != 'undefined') process.nextTick(function () {
                    APPFCTS.queueProc._runQueueEmpty(id);
                });
                else setTimeout(function () {
                    APPFCTS.queueProc._runQueueEmpty(id);
                }, 1);
            }
        },
        _process: function (qid) {
            if (APPFCTS.queueProc._queues[qid].processing)
                return;
            APPFCTS.queueProc._queues[qid].processing = true;
            var _proc = function () {
                if (!APPFCTS.queueProc._queues[qid].queue.length) {
                    APPFCTS.queueProc._queues[qid].processing = false;
                    APPFCTS.queueProc._runQueueEmpty(qid);
                    return;
                }
                var _f = APPFCTS.queueProc._queues[qid].queue[0];
                for (var i = 0; i < APPFCTS.queueProc._queues[qid].maxChan; i++) {
                    if (!APPFCTS.queueProc._queues[qid].channels[i]) {
                        //console.log(''+qid+', started channel #',i)
                        //APPFCTS.queueProc._queues[qid].totalChans++;
                        APPFCTS.queueProc._queues[qid].channels[i] = function (x, f) {
                            if (APPFCTS.tryCatch(function () {
                                f.fct(f.data, function () {
                                    //console.log(''+qid+', ended channel #',x)
                                    APPFCTS.queueProc._queues[qid].channels[x] = null;
                                    if (typeof process != 'undefined') process.nextTick(_proc);
                                    else setTimeout(_proc, 1);
                                })
                            })) {
                                console.warn(_f.parent);
                                //console.log('ERROR ON '+qid+', CHANNEL #'+x);
                                APPFCTS.queueProc._queues[qid].channels[x] = null;
                                if (typeof process != 'undefined') process.nextTick(_proc);
                                else setTimeout(_proc, 1);
                            }
                        };
                        APPFCTS.queueProc._queues[qid].channels[i](i, _f);
                        APPFCTS.queueProc._queues[qid].queue.shift();
                        if (typeof process != 'undefined') process.nextTick(_proc);
                        else setTimeout(_proc, 1);
                        return;
                    }
                }
            };
            if (typeof process != 'undefined') process.nextTick(_proc);
            else setTimeout(_proc, 1);
        }
    }
};

APPFCTS.msgApi = { send: function () { } };
if (typeof iframeApi != 'undefined') {

    APPFCTS.msgApi = {
        _child: {
            msg: function (msg) {
                return new Promise((resolve, reject) => {
                    console.log('MESSAGE FROM PARENT', msg)
                    try {
                        //data=JSON.parse(msg);
                        if (msg && msg.module && msg.action) {
                            APPFCTS.msgApi.routeEvent(msg, resolve);
                        }
                    }
                    catch (e) {
                        console.error(e);
                        reject(e);
                    }
                    //resolve("done");
                });
            }
        },
        routeEvent: function (arg, cback) {
            //var evt=arg.module+'.'+arg.action;
            console.log('APPFCTS.msgapi,route', arg)
            if (pe(APPFCTS, arg.module + '.routeMsg'))
                APPFCTS[arg.module].routeMsg(arg, cback);
            else {
                console.warn('POS, UNHANDLED PARENT EVENT', arg);
                if (cback) cback('UNHANDLED');
            }
        },
        send: function (msg, cback) { //APPFCTS.msgApi.send()
            //console.log('APPFCTS.msgApi.send',msg)
            if (pe(APPFCTS.msgApi, '_main')) {
                //if(typeof msg!='string')
                //	msg=JSON.stringify(msg);
                APPFCTS.msgApi._main.msg(msg).then(function (res) {
                    if (cback) cback(res);
                });
                return;
            }
            setTimeout(function () {
                APPFCTS.msgApi.send(msg, cback);
            }, 100);
        }
    };
    try {
        iframeApi(APPFCTS.msgApi._child, { debug: false }).then(function (externalApi) {
            APPFCTS.msgApi._main = externalApi;
            APPFCTS.msgApi.send({
                module: 'system',
                action: 'init'
            }, function (res) {
                console.log('system.init res', res)
            });

        });
    }
    catch (er) {
        console.error(er);
    }
}

$(document).ready(function () {
    let _docIsReady = function () {
        APPFCTS._docIsReady = true;
        if (typeof _onDocReady != 'undefined' && _onDocReady && _onDocReady.length) {
            for (let i = 0; i < _onDocReady.length; i++) {
                try {
                    _onDocReady[i]();
                } catch (er) { console.error(er); }
            }
            _onDocReady = [];
        }
    };
    if (!APPFCTS._w) {
        _docIsReady();
    }
    else {
        let _waitLoaded = function () {
            try {
                //if(APPFCTS.system.getUUID()){
                APPFCTS.system.getRegisterConfig(function () {
                    _docIsReady();
                });
                return;
                //}
                setTimeout(_waitLoaded, 100);
            } catch (er) {
                //console.error(er)
                setTimeout(_waitLoaded, 100);
                return;
            }
        };
        _waitLoaded();
    }

    setInterval(function () {
        if ($('.clock') && $('.clock').length)
            $('.clock').html(moment().format('hh:mm:ss a'));
    }, 300);
    try {
        if ($('.clock') && $('.clock').length)
            $('.clock').html(moment().format('hh:mm:ss a'));
    } catch (er) { }
});